/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.api.datastore.dev.PseudoKind;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import org.jspecify.annotations.Nullable;

abstract class KeyFilteredPseudoKind
implements PseudoKind {
    private final LocalDatastoreService localDatastore;

    KeyFilteredPseudoKind(LocalDatastoreService localDatastore) {
        this.localDatastore = localDatastore;
    }

    LocalDatastoreService getDatastore() {
        return this.localDatastore;
    }

    @Override
    public List<OnestoreEntity.EntityProto> runQuery(DatastorePb.Query query) {
        DatastorePb.Query.Order order;
        Key startKey = null;
        Key endKey = null;
        boolean startInclusive = false;
        boolean endInclusive = false;
        for (DatastorePb.Query.Filter filter : query.filters()) {
            DatastorePb.Query.Filter.Operator op = filter.getOpEnum();
            Utils.checkRequest(filter.propertySize() == 1 && filter.getProperty(0).getName().equals("__key__") && (op == DatastorePb.Query.Filter.Operator.LESS_THAN || op == DatastorePb.Query.Filter.Operator.LESS_THAN_OR_EQUAL || op == DatastorePb.Query.Filter.Operator.GREATER_THAN || op == DatastorePb.Query.Filter.Operator.GREATER_THAN_OR_EQUAL || op == DatastorePb.Query.Filter.Operator.EQUAL), "Only comparison filters on __key__ supported");
            Object filterVal = DataTypeTranslator.getPropertyValue((OnestoreEntity.Property)filter.getProperty(0));
            Utils.checkRequest(filterVal instanceof Key, "__key__ must be compared to a key");
            Key keyLimit = (Key)filterVal;
            if (op == DatastorePb.Query.Filter.Operator.LESS_THAN) {
                if (endKey == null || keyLimit.compareTo(endKey) <= 0) {
                    endKey = keyLimit;
                    endInclusive = false;
                }
            } else if (!(op != DatastorePb.Query.Filter.Operator.LESS_THAN_OR_EQUAL && op != DatastorePb.Query.Filter.Operator.EQUAL || endKey != null && keyLimit.compareTo(endKey) >= 0)) {
                endKey = keyLimit;
                endInclusive = true;
            }
            if (op == DatastorePb.Query.Filter.Operator.GREATER_THAN) {
                if (startKey != null && keyLimit.compareTo(startKey) < 0) continue;
                startKey = keyLimit;
                startInclusive = false;
                continue;
            }
            if (op != DatastorePb.Query.Filter.Operator.GREATER_THAN_OR_EQUAL && op != DatastorePb.Query.Filter.Operator.EQUAL || startKey != null && keyLimit.compareTo(startKey) <= 0) continue;
            startKey = keyLimit;
            startInclusive = true;
        }
        query.clearFilter();
        if (query.orderSize() > 0 && (order = query.getOrder(0)).getDirectionEnum() == DatastorePb.Query.Order.Direction.ASCENDING && "__key__".equals(order.getProperty())) {
            query.removeOrder(0);
        }
        Utils.checkRequest(query.orderSize() == 0, "Only ascending order on __key__ supported");
        return this.runQuery(query, startKey, startInclusive, endKey, endInclusive);
    }

    abstract List<OnestoreEntity.EntityProto> runQuery(DatastorePb.Query var1, Key var2, boolean var3, Key var4, boolean var5);

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.EntityProto get(@Nullable LocalDatastoreService.LiveTxn txn, LocalDatastoreService.Profile.EntityGroup eg, OnestoreEntity.Reference key, boolean eventualConsistency) {
        return null;
    }
}

