/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.CompositeIndexManager;
import com.google.appengine.api.datastore.CompositeIndexUtils;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableBiMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.io.Closeables;
import com.google.appengine.tools.development.Clock;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.apphosting.utils.config.IndexYamlReader;
import com.google.apphosting.utils.config.IndexesXml;
import com.google.apphosting.utils.config.XmlUtils;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;

class LocalCompositeIndexManager
extends CompositeIndexManager {
    private static final OnestoreEntity.Index.Property.Direction DEFAULT_DIRECTION = OnestoreEntity.Index.Property.Direction.ASCENDING;
    private static final ImmutableBiMap<String, OnestoreEntity.Index.Property.Direction> DIRECTION_MAP = ImmutableBiMap.of((Object)"asc", (Object)OnestoreEntity.Index.Property.Direction.ASCENDING, (Object)"desc", (Object)OnestoreEntity.Index.Property.Direction.DESCENDING);
    private static final ImmutableBiMap<String, OnestoreEntity.Index.Property.Mode> MODE_MAP = ImmutableBiMap.of((Object)"geospatial", (Object)OnestoreEntity.Index.Property.Mode.GEOSPATIAL);
    private static final Logger logger = Logger.getLogger(LocalCompositeIndexManager.class.getName());
    private static IndexConfigurationFormat indexConfigurationFormat;
    private static LocalCompositeIndexManager instance;
    private final IndexFileManager fileManager;
    private final Map<IndexComponentsOnlyQuery, AtomicInteger> queryHistory = Collections.synchronizedMap(Maps.newLinkedHashMap());
    private final IndexCache indexCache = new IndexCache();
    private boolean storeIndexConfiguration = true;

    private static OnestoreEntity.Index.Property.Mode toMode(String configMode) {
        OnestoreEntity.Index.Property.Mode mode = (OnestoreEntity.Index.Property.Mode)MODE_MAP.get((Object)configMode);
        if (mode == null) {
            throw new IllegalArgumentException("Unrecognized mode: " + configMode);
        }
        return mode;
    }

    private static OnestoreEntity.Index.Property.Direction toDirection(String configDirection) {
        OnestoreEntity.Index.Property.Direction direction = (OnestoreEntity.Index.Property.Direction)DIRECTION_MAP.get((Object)configDirection);
        if (direction == null) {
            throw new IllegalArgumentException("Unrecognized direction: " + configDirection);
        }
        return direction;
    }

    LocalCompositeIndexManager(IndexFileManager fileManager) {
        this.fileManager = fileManager;
    }

    static synchronized void init(IndexConfigurationFormat indexConfigurationFormat) {
        if (LocalCompositeIndexManager.indexConfigurationFormat == null) {
            LocalCompositeIndexManager.indexConfigurationFormat = indexConfigurationFormat;
        } else {
            Preconditions.checkState((LocalCompositeIndexManager.indexConfigurationFormat == indexConfigurationFormat ? 1 : 0) != 0, (Object)("Cannot change index configuration format from " + String.valueOf((Object)LocalCompositeIndexManager.indexConfigurationFormat) + " to " + String.valueOf((Object)indexConfigurationFormat)));
        }
    }

    public static synchronized LocalCompositeIndexManager getInstance() {
        if (instance == null) {
            if (indexConfigurationFormat == null) {
                indexConfigurationFormat = IndexConfigurationFormat.DEFAULT;
            }
            switch (indexConfigurationFormat.ordinal()) {
                case 0: {
                    instance = new LocalCompositeIndexManager(new XmlIndexFileManager());
                    break;
                }
                case 1: {
                    instance = new LocalCompositeIndexManager(new YamlIndexFileManager());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized index configuration format: " + String.valueOf((Object)indexConfigurationFormat));
                }
            }
        }
        return instance;
    }

    public void processQuery(DatastorePb.Query query) {
        IndexComponentsOnlyQuery indexOnlyQuery = new IndexComponentsOnlyQuery(query);
        boolean isNewQuery = this.updateQueryHistory(indexOnlyQuery);
        if (isNewQuery) {
            this.maybeUpdateIndexFile(indexOnlyQuery);
        }
    }

    private boolean updateQueryHistory(IndexComponentsOnlyQuery query) {
        boolean newQuery = false;
        AtomicInteger count = this.queryHistory.get((Object)query);
        if (count == null) {
            count = this.newAtomicInteger(0);
            AtomicInteger overwrittenCount = this.queryHistory.put(query, count);
            if (overwrittenCount != null) {
                count.addAndGet(overwrittenCount.intValue());
            } else {
                newQuery = true;
            }
        }
        count.incrementAndGet();
        return newQuery;
    }

    void clearQueryHistory() {
        this.queryHistory.clear();
    }

    AtomicInteger newAtomicInteger(int i) {
        return new AtomicInteger(i);
    }

    Map<IndexComponentsOnlyQuery, AtomicInteger> getQueryHistory() {
        return this.queryHistory;
    }

    private void maybeUpdateIndexFile(IndexComponentsOnlyQuery query) {
        CompositeIndexes compositeIndexes = this.fileManager.read();
        if (compositeIndexes.isAutoGenerationDisabledInFile()) {
            this.indexCache.verifyIndexExistsForQuery(query, compositeIndexes);
            logger.fine("Skipping index file update because auto generation is disabled.");
            return;
        }
        if (this.storeIndexConfiguration) {
            this.updateIndexFile(compositeIndexes);
        }
    }

    Set<OnestoreEntity.Index> getIndexes() {
        Set<Object> generatedIndexes;
        ImmutableList<OnestoreEntity.Index> manualIndexes;
        CompositeIndexes compositeIndexes = this.fileManager.read();
        if (compositeIndexes.isAutoGenerationDisabledInFile()) {
            manualIndexes = compositeIndexes.getAllIndexes();
            generatedIndexes = Collections.emptySet();
        } else {
            manualIndexes = compositeIndexes.getManualIndexes();
            generatedIndexes = this.buildIndexMapFromQueryHistory().keySet();
        }
        LinkedHashSet combined = Sets.newLinkedHashSetWithExpectedSize((int)(manualIndexes.size() + generatedIndexes.size()));
        combined.addAll(generatedIndexes);
        combined.addAll(manualIndexes);
        return combined;
    }

    Collection<OnestoreEntity.Index> getIndexesForKind(String kind) {
        LinkedHashSet indexes = Sets.newLinkedHashSet();
        for (OnestoreEntity.Index index : this.getIndexes()) {
            if (!index.getEntityType().equals(kind)) continue;
            indexes.add(index);
        }
        return indexes;
    }

    private void updateIndexFile(CompositeIndexes compositeIndexes) {
        Map<OnestoreEntity.Index, Integer> indexMap = this.buildIndexMapFromQueryHistory();
        indexMap.keySet().removeAll((Collection<?>)compositeIndexes.getManualIndexes());
        try {
            this.fileManager.write(indexMap);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to write " + this.fileManager.getGeneratedIndexFilename(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<OnestoreEntity.Index, Integer> buildIndexMapFromQueryHistory() {
        LinkedHashMap indexMap = Maps.newLinkedHashMap();
        Map<IndexComponentsOnlyQuery, AtomicInteger> map = this.queryHistory;
        synchronized (map) {
            for (Map.Entry<IndexComponentsOnlyQuery, AtomicInteger> entry : this.queryHistory.entrySet()) {
                OnestoreEntity.Index index = this.compositeIndexForQuery(entry.getKey());
                if (index == null) continue;
                Integer count = (Integer)indexMap.get(index);
                if (count == null) {
                    count = 0;
                }
                count = count + entry.getValue().intValue();
                indexMap.put(index, count);
            }
        }
        return indexMap;
    }

    public List<OnestoreEntity.Index> queryIndexList(DatastorePb.Query query) {
        IndexComponentsOnlyQuery indexOnlyQuery = new IndexComponentsOnlyQuery(query);
        OnestoreEntity.Index index = this.compositeIndexForQuery(indexOnlyQuery);
        List<Object> indexList = index != null ? Collections.singletonList(index) : Collections.emptyList();
        return indexList;
    }

    public void setAppDir(File appDir) {
        this.fileManager.setAppDir(appDir);
    }

    public void setClock(Clock clock) {
        this.fileManager.setClock(clock);
    }

    public void setStoreIndexConfiguration(boolean storeIndexConfiguration) {
        this.storeIndexConfiguration = storeIndexConfiguration;
    }

    protected OnestoreEntity.Index compositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery) {
        return super.compositeIndexForQuery((CompositeIndexManager.IndexComponentsOnlyQuery)indexOnlyQuery);
    }

    protected OnestoreEntity.Index minimumCompositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery, Collection<OnestoreEntity.Index> indexes) {
        return super.minimumCompositeIndexForQuery((CompositeIndexManager.IndexComponentsOnlyQuery)indexOnlyQuery, indexes);
    }

    private final class IndexCache {
        private Set<OnestoreEntity.Index> indexCache = null;

        private IndexCache() {
        }

        private synchronized void verifyIndexExistsForQuery(IndexComponentsOnlyQuery query, CompositeIndexes compositeIndexes) {
            OnestoreEntity.Index minimumIndex;
            OnestoreEntity.Index index;
            if (this.indexCache == null) {
                this.indexCache = Sets.newHashSet(compositeIndexes.getAllIndexes());
            }
            if ((index = LocalCompositeIndexManager.this.compositeIndexForQuery(query)) != null && !this.indexCache.contains(index) && (minimumIndex = LocalCompositeIndexManager.this.minimumCompositeIndexForQuery(query, this.indexCache)) != null) {
                OnestoreEntity.Index minimumIndexForMessage = minimumIndex.equals(index) ? null : minimumIndex;
                String message = LocalCompositeIndexManager.this.fileManager.getMissingCompositeIndexMessage(query, minimumIndexForMessage);
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.NEED_INDEX.getValue(), message);
            }
        }
    }

    static interface IndexFileManager {
        public CompositeIndexes read();

        public void write(Map<OnestoreEntity.Index, Integer> var1) throws IOException;

        public String getMissingCompositeIndexMessage(IndexComponentsOnlyQuery var1, // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable OnestoreEntity.Index var2);

        public String getGeneratedIndexFilename();

        public void setAppDir(File var1);

        public void setClock(Clock var1);
    }

    static enum IndexConfigurationFormat {
        XML,
        YAML;

        static final IndexConfigurationFormat DEFAULT;

        static {
            DEFAULT = XML;
        }
    }

    static class XmlIndexFileManager
    extends BaseIndexFileManager {
        private static final String DATASTORE_INDEXES_ELEMENT_FORMAT = "<datastore-indexes autoGenerate=\"true\"%s>\n\n";
        private static final String DATASTORE_INDEXES_ELEMENT_EMPTY = String.format("<datastore-indexes autoGenerate=\"true\"%s>\n\n", "/");
        private static final String DATASTORE_INDEXES_ELEMENT_NOT_EMPTY = String.format("<datastore-indexes autoGenerate=\"true\"%s>\n\n", "");
        private static final String DATASTORE_INDEXES_ELEMENT_CLOSE = "</datastore-indexes>\n";
        private static final String FREQUENCY_XML_COMMENT_FORMAT = "    <!-- Used %d time%s in query history -->\n";
        private static final String TIMESTAMP_XML_COMMENT_FORMAT = "<!-- Indices written at %s -->\n\n";

        XmlIndexFileManager() {
        }

        @Override
        public synchronized CompositeIndexes read() {
            InputStream indexFileInputStream = this.getIndexFileInputStream();
            if (indexFileInputStream == null) {
                return new CompositeIndexes(false);
            }
            Element datastoreIndexesElement = XmlUtils.parseXml((InputStream)indexFileInputStream, (String)this.getIndexFile().getPath()).getDocumentElement();
            CompositeIndexes compositeIndexes = new CompositeIndexes(!XmlIndexFileManager.isAutoGenerateIndexes(datastoreIndexesElement));
            XmlIndexFileManager.addIndexes(datastoreIndexesElement, compositeIndexes);
            InputStream generatedIndexFileInputStream = this.getGeneratedIndexFileInputStream();
            if (generatedIndexFileInputStream != null) {
                Element generatedDatastoreIndexesElement = XmlUtils.parseXml((InputStream)generatedIndexFileInputStream, (String)this.getGeneratedIndexFilename()).getDocumentElement();
                XmlIndexFileManager.addIndexes(generatedDatastoreIndexesElement, compositeIndexes);
            }
            return compositeIndexes;
        }

        @Override
        public synchronized void write(Map<OnestoreEntity.Index, Integer> generatedIndexMap) throws IOException {
            SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
            Writer fw = this.newGeneratedIndexFileWriter();
            try (BufferedWriter out = new BufferedWriter(fw);){
                out.append(String.format(TIMESTAMP_XML_COMMENT_FORMAT, format.format(new Date(this.clock.getCurrentTime()))));
                if (generatedIndexMap.isEmpty()) {
                    out.append(DATASTORE_INDEXES_ELEMENT_EMPTY);
                } else {
                    out.append(DATASTORE_INDEXES_ELEMENT_NOT_EMPTY);
                    for (Map.Entry<OnestoreEntity.Index, Integer> entry : generatedIndexMap.entrySet()) {
                        int count = entry.getValue();
                        out.append(String.format(FREQUENCY_XML_COMMENT_FORMAT, count, count == 1 ? "" : "s"));
                        String xml = CompositeIndexUtils.generateXmlForIndex((OnestoreEntity.Index)entry.getKey(), (CompositeIndexManager.IndexSource)CompositeIndexManager.IndexSource.auto);
                        out.append(xml);
                    }
                    out.append(DATASTORE_INDEXES_ELEMENT_CLOSE);
                }
            }
        }

        @Override
        public String getMissingCompositeIndexMessage(IndexComponentsOnlyQuery query, // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable OnestoreEntity.Index minimumIndex) {
            String message = "This query requires a composite index that is not defined. You must update " + this.getIndexFile().getPath() + " or enable autoGenerate to have it automatically added.";
            if (minimumIndex != null) {
                message = message + "\n\nThe minimum required index is:\n" + CompositeIndexUtils.generateXmlForIndex((OnestoreEntity.Index)minimumIndex, (CompositeIndexManager.IndexSource)CompositeIndexManager.IndexSource.manual);
            }
            return message;
        }

        @Override
        public String getGeneratedIndexFilename() {
            return this.getGeneratedIndexFile().getPath();
        }

        private File getGeneratedIndexFile() {
            File dir = GenerationDirectory.getGenerationDirectory((File)this.appDir);
            return new File(dir, "datastore-indexes-auto.xml");
        }

        @Nullable InputStream getGeneratedIndexFileInputStream() {
            try {
                return new FileInputStream(this.getGeneratedIndexFile());
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        Writer newGeneratedIndexFileWriter() throws IOException {
            File output = this.getGeneratedIndexFile();
            output.getParentFile().mkdirs();
            return new FileWriter(output);
        }

        InputStream getIndexFileInputStream() {
            try {
                return new FileInputStream(this.getIndexFile());
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        private File getIndexFile() {
            return new File(new File(this.appDir, "WEB-INF"), "datastore-indexes.xml");
        }

        private static void addIndexes(Element datastoreIndexesElement, CompositeIndexes compositeIndexes) {
            for (Element datastoreIndex : XmlUtils.getChildren((Element)datastoreIndexesElement, (String)"datastore-index")) {
                if (XmlIndexFileManager.isManual(datastoreIndex)) {
                    compositeIndexes.addManualIndex(XmlIndexFileManager.toIndex(datastoreIndex));
                    continue;
                }
                compositeIndexes.addGeneratedIndex(XmlIndexFileManager.toIndex(datastoreIndex));
            }
        }

        private static OnestoreEntity.Index toIndex(Element datastoreIndexElement) {
            OnestoreEntity.Index index = new OnestoreEntity.Index();
            index.setEntityType(XmlIndexFileManager.trim(datastoreIndexElement.getAttribute("kind")));
            String ancestorValue = XmlUtils.getAttributeOrNull((Element)datastoreIndexElement, (String)"ancestor");
            boolean ancestor = ancestorValue == null ? false : Boolean.parseBoolean(XmlIndexFileManager.trim(ancestorValue));
            index.setAncestor(ancestor);
            for (Element propertyElement : XmlUtils.getChildren((Element)datastoreIndexElement, (String)"property")) {
                String modeValue;
                OnestoreEntity.Index.Property prop = index.addProperty();
                prop.setName(XmlIndexFileManager.trim(propertyElement.getAttribute("name")));
                String directionValue = XmlUtils.getAttributeOrNull((Element)propertyElement, (String)"direction");
                if (directionValue != null) {
                    prop.setDirection(LocalCompositeIndexManager.toDirection(XmlIndexFileManager.trim(directionValue)));
                }
                if ((modeValue = XmlUtils.getAttributeOrNull((Element)propertyElement, (String)"mode")) == null) continue;
                prop.setMode(LocalCompositeIndexManager.toMode(XmlIndexFileManager.trim(modeValue)));
            }
            return index;
        }

        private static boolean isAutoGenerateIndexes(Element datastoreIndexesElement) {
            String autoGenerate = datastoreIndexesElement.getAttribute("autoGenerate");
            if (!"true".equals(autoGenerate) && !"false".equals(autoGenerate)) {
                throw new AppEngineConfigException("autoGenerate=true|false is required in datastore-indexes.xml");
            }
            return Boolean.parseBoolean(autoGenerate);
        }

        private static boolean isManual(Element datastoreIndexElement) {
            String sourceValue = XmlUtils.getAttributeOrNull((Element)datastoreIndexElement, (String)"source");
            return sourceValue == null || CompositeIndexManager.IndexSource.valueOf((String)XmlIndexFileManager.trim(sourceValue)) == CompositeIndexManager.IndexSource.manual;
        }
    }

    static class YamlIndexFileManager
    extends BaseIndexFileManager {
        private static final IndexesXmlConverter converter = new IndexesXmlConverter();
        private static final String AUTOGENERATED = "# AUTOGENERATED";
        private static final String AUTOGENERATED_COMMENT = "# This index.yaml is automatically updated whenever the Cloud Datastore\n# emulator detects that a new type of query is run. If you want to manage the\n# index.yaml file manually, remove the \"# AUTOGENERATED\" marker line above.\n# If you want to manage some indexes manually, move them above the marker line.";
        private static final String INDEXES_TAG = "indexes:";

        YamlIndexFileManager() {
        }

        @Override
        public synchronized CompositeIndexes read() {
            boolean sawAutoGenerateLine;
            InputStream indexFileInputStream = this.getIndexFileInputStream();
            if (indexFileInputStream == null) {
                return new CompositeIndexes(false);
            }
            StringBuilder manualYaml = new StringBuilder();
            StringBuilder generatedYaml = new StringBuilder("indexes:\n");
            try {
                sawAutoGenerateLine = this.splitYamlFile(indexFileInputStream, manualYaml, generatedYaml);
            }
            catch (IOException e) {
                String message = "Received IOException parsing the input stream.";
                logger.log(Level.SEVERE, message, e);
                throw new AppEngineConfigException(message, (Throwable)e);
            }
            CompositeIndexes compositeIndexes = new CompositeIndexes(!sawAutoGenerateLine);
            for (OnestoreEntity.Index index : converter.toIndexes(IndexYamlReader.parse((String)manualYaml.toString()))) {
                compositeIndexes.addManualIndex(index);
            }
            if (sawAutoGenerateLine) {
                for (OnestoreEntity.Index index : converter.toIndexes(IndexYamlReader.parse((String)generatedYaml.toString()))) {
                    compositeIndexes.addGeneratedIndex(index);
                }
            }
            return compositeIndexes;
        }

        @Override
        public synchronized void write(Map<OnestoreEntity.Index, Integer> generatedIndexMap) throws IOException {
            StringBuilder manualYaml = new StringBuilder();
            InputStream indexFileInputStream = this.getIndexFileInputStream();
            if (indexFileInputStream == null) {
                manualYaml.append("indexes:\n");
                manualYaml.append("\n");
            } else {
                try {
                    this.splitYamlFile(indexFileInputStream, manualYaml, new StringBuilder());
                }
                catch (IOException e) {
                    String message = "Received IOException parsing the input stream.";
                    logger.log(Level.SEVERE, message, e);
                    throw new AppEngineConfigException(message, (Throwable)e);
                }
            }
            ArrayList indexes = Lists.newArrayList(generatedIndexMap.keySet());
            Writer fw = this.newIndexFileWriter();
            try (BufferedWriter out = new BufferedWriter(fw);){
                out.append(manualYaml);
                out.append(AUTOGENERATED).append("\n");
                out.append("\n");
                out.append(AUTOGENERATED_COMMENT).append("\n");
                out.append("\n");
                String generatedYaml = YamlIndexFileManager.stripIndexesLine(converter.toConfigIndexes(indexes).toYaml());
                out.append(generatedYaml);
            }
        }

        @Override
        public String getMissingCompositeIndexMessage(IndexComponentsOnlyQuery query, // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable OnestoreEntity.Index minimumIndex) {
            String message = "This query requires a composite index that is not defined. You must update " + this.getIndexFile().getPath() + " or add \"# AUTOGENERATED\" to have it automatically added.";
            if (minimumIndex != null) {
                message = message + "\n\nThe minimum required index is:\n" + converter.toConfigIndex(minimumIndex).toYaml();
            }
            return message;
        }

        @Override
        public String getGeneratedIndexFilename() {
            return this.getIndexFile().getPath();
        }

        InputStream getIndexFileInputStream() {
            try {
                return new FileInputStream(this.getIndexFile());
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        Writer newIndexFileWriter() throws IOException {
            File output = this.getIndexFile();
            output.getParentFile().mkdirs();
            return new FileWriter(output);
        }

        private static String stripIndexesLine(String yaml) {
            StringBuilder out = new StringBuilder();
            String[] yamlLines = yaml.split("\n");
            if (yamlLines.length < 1 || !INDEXES_TAG.equals(yamlLines[0])) {
                throw new IllegalStateException("Failed to find indexes: at beginning out yaml.");
            }
            for (String line : Arrays.asList(yamlLines).subList(1, yamlLines.length)) {
                out.append(line).append("\n");
            }
            return out.toString();
        }

        private File getIndexFile() {
            return new File(this.appDir, "WEB-INF/index.yaml");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean splitYamlFile(InputStream indexFileInputStream, StringBuilder manualYaml, StringBuilder generatedYaml) throws IOException {
            BufferedReader in = new BufferedReader(new InputStreamReader(indexFileInputStream, StandardCharsets.UTF_8));
            boolean sawAutoGenerateLine = false;
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if (AUTOGENERATED.equals(YamlIndexFileManager.trim(line))) {
                        sawAutoGenerateLine = true;
                    }
                    if (sawAutoGenerateLine) {
                        generatedYaml.append(line).append("\n");
                        continue;
                    }
                    manualYaml.append(line).append("\n");
                }
            }
            finally {
                Closeables.closeQuietly((Reader)in);
            }
            return sawAutoGenerateLine;
        }
    }

    protected static class IndexComponentsOnlyQuery
    extends CompositeIndexManager.IndexComponentsOnlyQuery {
        protected IndexComponentsOnlyQuery(DatastorePb.Query query) {
            super(query);
        }

        public DatastorePb.Query getV3Query() {
            return super.getQuery();
        }
    }

    static class CompositeIndexes {
        private final boolean autoGenerationDisabledInFile;
        private final List<OnestoreEntity.Index> manualIndexes = new ArrayList<OnestoreEntity.Index>();
        private final List<OnestoreEntity.Index> generatedIndexes = new ArrayList<OnestoreEntity.Index>();

        CompositeIndexes(boolean autoGenerationDisabledInFile) {
            this.autoGenerationDisabledInFile = autoGenerationDisabledInFile;
        }

        public void addManualIndex(OnestoreEntity.Index index) {
            this.manualIndexes.add(index);
        }

        public void addGeneratedIndex(OnestoreEntity.Index index) {
            this.generatedIndexes.add(index);
        }

        public boolean isAutoGenerationDisabledInFile() {
            return this.autoGenerationDisabledInFile;
        }

        public ImmutableList<OnestoreEntity.Index> getAllIndexes() {
            return ImmutableList.copyOf((Iterable)Iterables.concat(this.manualIndexes, this.generatedIndexes));
        }

        public ImmutableList<OnestoreEntity.Index> getManualIndexes() {
            return ImmutableList.copyOf(this.manualIndexes);
        }

        public ImmutableList<OnestoreEntity.Index> getGeneratedIndexes() {
            return ImmutableList.copyOf(this.generatedIndexes);
        }

        public int size() {
            return this.manualIndexes.size() + this.generatedIndexes.size();
        }
    }

    protected static class KeyTranslator
    extends CompositeIndexManager.KeyTranslator {
        private KeyTranslator() {
        }
    }

    protected static class ValidatedQuery
    extends CompositeIndexManager.ValidatedQuery {
        protected ValidatedQuery(DatastorePb.Query query) {
            super(query);
        }

        public DatastorePb.Query getV3Query() {
            return super.getQuery();
        }
    }

    private static class IndexesXmlConverter {
        private IndexesXmlConverter() {
        }

        public IndexesXml toConfigIndexes(List<OnestoreEntity.Index> indexes) {
            IndexesXml configIndexes = new IndexesXml();
            for (OnestoreEntity.Index index : indexes) {
                configIndexes.addNewIndex(this.toConfigIndex(index));
            }
            return configIndexes;
        }

        public List<OnestoreEntity.Index> toIndexes(IndexesXml configIndexes) {
            ArrayList indexes = Lists.newArrayListWithCapacity((int)configIndexes.size());
            for (IndexesXml.Index configIndex : configIndexes) {
                indexes.add(this.toIndex(configIndex));
            }
            return indexes;
        }

        private IndexesXml.Index toConfigIndex(OnestoreEntity.Index index) {
            IndexesXml.Index configIndex = new IndexesXml.Index(index.getEntityType(), Boolean.valueOf(index.isAncestor()));
            for (OnestoreEntity.Index.Property property : index.propertys()) {
                configIndex.addNewProperty(property.getName(), this.toConfigDirection(property.getDirectionEnum()), this.toConfigMode(property.getModeEnum()));
            }
            return configIndex;
        }

        private OnestoreEntity.Index toIndex(IndexesXml.Index configIndex) {
            OnestoreEntity.Index index = new OnestoreEntity.Index().setEntityType(configIndex.getKind()).setAncestor(configIndex.doIndexAncestors());
            for (IndexesXml.PropertySort propertySort : configIndex.getProperties()) {
                OnestoreEntity.Index.Property property = index.addProperty().setName(propertySort.getPropertyName());
                property.setDirection(this.toDirection(propertySort.getDirection()));
                if (propertySort.getMode() == null) continue;
                property.setMode(this.toMode(propertySort.getMode()));
            }
            return index;
        }

        private String toConfigDirection(OnestoreEntity.Index.Property.Direction direction) {
            if (direction == DEFAULT_DIRECTION) {
                return null;
            }
            String configDirection = (String)DIRECTION_MAP.inverse().get((Object)direction);
            if (configDirection == null) {
                throw new IllegalArgumentException("Unrecognized direction: " + String.valueOf(direction));
            }
            return configDirection;
        }

        private OnestoreEntity.Index.Property.Direction toDirection(@Nullable String configDirection) {
            if (configDirection == null) {
                return DEFAULT_DIRECTION;
            }
            return LocalCompositeIndexManager.toDirection(configDirection);
        }

        private String toConfigMode(OnestoreEntity.Index.Property.Mode mode) {
            if (mode == OnestoreEntity.Index.Property.Mode.MODE_UNSPECIFIED) {
                return null;
            }
            String configMode = (String)MODE_MAP.inverse().get((Object)mode);
            if (configMode == null) {
                throw new IllegalArgumentException("Unrecognized mode: " + String.valueOf(mode));
            }
            return configMode;
        }

        private OnestoreEntity.Index.Property.Mode toMode(String configMode) {
            return LocalCompositeIndexManager.toMode(configMode);
        }
    }

    private static abstract class BaseIndexFileManager
    implements IndexFileManager {
        protected File appDir;
        protected Clock clock = Clock.DEFAULT;

        private BaseIndexFileManager() {
        }

        @Override
        public void setAppDir(File appDir) {
            this.appDir = appDir;
        }

        @Override
        public void setClock(Clock clock) {
            this.clock = clock;
        }

        static String trim(@Nullable String attribute) {
            return attribute == null ? null : attribute.trim();
        }
    }
}

