/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.api.datastore.dev.PseudoKind;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;

class PseudoKinds {
    static final OnestoreEntity.EntityProto NOT_A_PSEUDO_KIND = new OnestoreEntity.EntityProto();
    private final Map<String, PseudoKind> pseudoKinds = new ConcurrentHashMap<String, PseudoKind>();

    PseudoKinds() {
    }

    void register(PseudoKind implementation) {
        Preconditions.checkNotNull((Object)implementation);
        PseudoKind previous = this.pseudoKinds.put(implementation.getKindName(), implementation);
        Preconditions.checkState((previous == null ? 1 : 0) != 0, (Object)("duplicate registration for pseudo-kind " + implementation.getKindName()));
    }

    @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    OnestoreEntity.EntityProto> runQuery(DatastorePb.Query query) {
        Preconditions.checkNotNull((Object)query);
        PseudoKind pseudoKind = this.pseudoKinds.get(query.getKind());
        if (pseudoKind == null) {
            return null;
        }
        query.clearKind();
        List<OnestoreEntity.EntityProto> results = pseudoKind.runQuery(query);
        Preconditions.checkNotNull(results, (Object)("pseudo-kind " + pseudoKind.getKindName() + " returned invalid result"));
        return results;
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.EntityProto get(@Nullable LocalDatastoreService.LiveTxn txn, LocalDatastoreService.Profile.EntityGroup eg, OnestoreEntity.Reference key, boolean eventualConsistency) {
        PseudoKind pseudoKind = this.pseudoKinds.get(Utils.getKind(key));
        if (pseudoKind == null) {
            return NOT_A_PSEUDO_KIND;
        }
        return pseudoKind.get(txn, eg, key, eventualConsistency);
    }
}

