/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images.dev.jakarta;

import com.google.appengine.api.images.ImagesServicePb;
import com.google.appengine.api.images.dev.LocalImagesService;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.apphosting.api.ApiProxy;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalBlobImageServlet
extends HttpServlet {
    private static final long serialVersionUID = -12394724046108259L;
    private static final Set<String> transcodeToPng = ImmutableSet.of((Object)"png", (Object)"gif");
    private LocalImagesService imagesService;
    private static final int DEFAULT_SERVING_SIZE = 512;

    public void init() throws ServletException {
        super.init();
        this.imagesService = this.getLocalImagesService();
    }

    LocalImagesService getLocalImagesService() {
        ApiProxyLocal apiProxyLocal = (ApiProxyLocal)this.getServletContext().getAttribute("com.google.appengine.devappserver.ApiProxyLocal");
        return (LocalImagesService)apiProxyLocal.getService("images");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (ServletOutputStream out = resp.getOutputStream();){
            ParsedUrl parsedUrl = ParsedUrl.createParsedUrl(req.getRequestURI());
            Image image = this.transformImage(parsedUrl);
            resp.setContentType(image.getMimeType());
            out.write(image.getImage());
        }
        catch (ApiProxy.ApplicationException e) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.forNumber((int)e.getApplicationError());
            if (code == null) {
                code = ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR;
            }
            switch (code) {
                case NOT_IMAGE: 
                case INVALID_BLOB_KEY: {
                    resp.sendError(404, e.getMessage());
                    break;
                }
                default: {
                    resp.sendError(500, e.getMessage());
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            resp.sendError(500, e.getMessage());
        }
        catch (IOException e) {
            resp.sendError(500, e.getMessage());
        }
    }

    protected Image transformImage(ParsedUrl request) {
        LocalRpcService.Status unusedStatus = new LocalRpcService.Status();
        ImagesServicePb.ImageData imageData = ImagesServicePb.ImageData.newBuilder().setBlobKey(request.getBlobKey()).setContent(ByteString.EMPTY).build();
        String originalMimeType = this.imagesService.getMimeType(imageData);
        BufferedImage img = this.imagesService.openImage(imageData, unusedStatus);
        if (request.hasOptions()) {
            if (request.getCrop()) {
                float height;
                ImagesServicePb.Transform.Builder cropXform = null;
                float width = img.getWidth();
                if (width > (height = (float)img.getHeight())) {
                    cropXform = ImagesServicePb.Transform.newBuilder();
                    float delta = (width - height) / (width * 2.0f);
                    cropXform.setCropLeftX(delta);
                    cropXform.setCropRightX(1.0f - delta);
                } else if (width < height) {
                    cropXform = ImagesServicePb.Transform.newBuilder();
                    float delta = (height - width) / (height * 2.0f);
                    float topDelta = Math.max(0.0f, delta - 0.25f);
                    float bottomDelta = 1.0f - 2.0f * delta + topDelta;
                    cropXform.setCropTopY(topDelta);
                    cropXform.setCropBottomY(bottomDelta);
                }
                if (cropXform != null) {
                    img = this.imagesService.processTransform(img, cropXform.build(), unusedStatus);
                }
            }
            resizeXform = ImagesServicePb.Transform.newBuilder().setWidth(request.getResize()).setHeight(request.getResize()).build();
            img = this.imagesService.processTransform(img, resizeXform, unusedStatus);
        } else if (img.getWidth() > 512 || img.getHeight() > 512) {
            resizeXform = ImagesServicePb.Transform.newBuilder().setWidth(512).setHeight(512).build();
            img = this.imagesService.processTransform(img, resizeXform, unusedStatus);
        }
        ImagesServicePb.OutputSettings.MIME_TYPE outputMimeType = ImagesServicePb.OutputSettings.MIME_TYPE.JPEG;
        String outputMimeTypeString = "image/jpeg";
        if (transcodeToPng.contains(originalMimeType)) {
            outputMimeType = ImagesServicePb.OutputSettings.MIME_TYPE.PNG;
            outputMimeTypeString = "image/png";
        }
        return new Image(this.imagesService.saveImage(img, outputMimeType, unusedStatus), outputMimeTypeString);
    }

    protected static class ParsedUrl {
        private String blobKey;
        private String options;
        private int resize;
        private boolean crop;
        private static final Pattern pattern = Pattern.compile("/_ah/img/([-\\w:]+)(=[-\\w]+)?");
        private static final Pattern optionsPattern = Pattern.compile("^s(\\d+)(-c)?");
        private static final int SIZE_LIMIT = 1600;

        public boolean hasOptions() {
            return this.options != null && this.options.length() != 0;
        }

        public String getBlobKey() {
            return this.blobKey;
        }

        public int getResize() {
            return this.resize;
        }

        public boolean getCrop() {
            return this.crop;
        }

        protected static ParsedUrl createParsedUrl(String requestUri) {
            ParsedUrl parsedUrl = new ParsedUrl();
            parsedUrl.parse(requestUri);
            return parsedUrl;
        }

        protected void parse(String requestUri) {
            Matcher matcher = pattern.matcher(requestUri);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Malformed URL.");
            }
            this.blobKey = matcher.group(1);
            this.options = matcher.group(2);
            if (this.options != null && this.options.startsWith("=")) {
                this.options = this.options.substring(1);
            }
            this.parseOptions();
        }

        protected void parseOptions() {
            try {
                if (!this.hasOptions()) {
                    return;
                }
                Matcher matcher = optionsPattern.matcher(this.options);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Malformed URL Options");
                }
                this.resize = Integer.parseInt(matcher.group(1));
                this.crop = false;
                if (matcher.group(2) != null) {
                    this.crop = true;
                }
                if (this.resize > 1600 || this.resize < 0) {
                    throw new IllegalArgumentException("Invalid resize");
                }
            }
            catch (NumberFormatException e) {
                this.options = null;
                throw new IllegalArgumentException("Invalid resize", e);
            }
        }

        private ParsedUrl() {
        }
    }

    protected static class Image {
        private byte[] image;
        private String mimeType;

        Image(byte[] image, String mimeType) {
            this.image = image;
            this.mimeType = mimeType;
        }

        public byte[] getImage() {
            return this.image;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

