/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.LuceneQueryTreeContext;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.repackaged.com.google.common.base.VerifyException;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2RegionCoverer;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanClause;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.TermQuery;
import com.google.apphosting.api.search.DocumentPb;
import java.lang.reflect.Method;

class GeometricQuery
extends BooleanQuery {
    private final String fieldName;
    private final String luceneFieldName;
    private final S2LatLng point;
    private final LuceneQueryTreeContext.ComparisonOp op;
    private final double distance;

    static Query create(String fieldName, double latitude, double longitude, LuceneQueryTreeContext.ComparisonOp op, double distance) {
        switch (op) {
            case GE: 
            case GT: 
            case LE: 
            case LT: {
                return new GeometricQuery(fieldName, latitude, longitude, op, distance);
            }
        }
        return LuceneUtils.getMatchNoneQuery();
    }

    private GeometricQuery(String fieldName, double latitude, double longitude, LuceneQueryTreeContext.ComparisonOp op, double distance) {
        this.fieldName = fieldName;
        this.luceneFieldName = LuceneUtils.makeLuceneFieldName(fieldName, DocumentPb.FieldValue.ContentType.GEO);
        this.point = S2LatLng.fromDegrees(latitude, longitude).normalized();
        this.op = op;
        this.distance = distance;
        this.init();
    }

    private void init() {
        S2RegionCoverer coverer;
        S1Angle angle = S1Angle.radians(this.distance / 6371010.0);
        S2Cap cap = S2Cap.fromAxisAngle(this.point.toPoint(), angle);
        try {
            coverer = GeometricQuery.newCoverer();
        }
        catch (ReflectiveOperationException e) {
            throw new VerifyException((Throwable)e);
        }
        switch (this.op) {
            case LE: 
            case LT: {
                for (S2CellId cell : coverer.getCovering(cap)) {
                    Term term = new Term(this.luceneFieldName, "S2:" + cell.level() + ":" + cell.toToken());
                    this.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
                }
                break;
            }
            case GE: 
            case GT: {
                for (S2CellId cell : coverer.getInteriorCovering(cap)) {
                    Term term = new Term(this.luceneFieldName, "S2:" + cell.level() + ":" + cell.toToken());
                    this.add(new TermQuery(term), BooleanClause.Occur.MUST_NOT);
                }
                Term term = new Term("_ALLDOC", "X");
                this.add(new TermQuery(term), BooleanClause.Occur.MUST);
                break;
            }
            default: {
                throw new IllegalStateException("op " + String.valueOf((Object)this.op));
            }
        }
    }

    private static S2RegionCoverer newCoverer() throws ReflectiveOperationException {
        Object mutable;
        Method builder = null;
        try {
            builder = S2RegionCoverer.class.getMethod("builder", new Class[0]);
            mutable = builder.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            mutable = S2RegionCoverer.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        mutable.getClass().getMethod("setMinLevel", Integer.TYPE).invoke(mutable, 0);
        mutable.getClass().getMethod("setMaxLevel", Integer.TYPE).invoke(mutable, 30);
        Object result = builder == null ? mutable : mutable.getClass().getMethod("build", new Class[0]).invoke(mutable, new Object[0]);
        return (S2RegionCoverer)result;
    }

    @Override
    public String toString() {
        return String.format("GeometricQuery(field='%s' geopoint=(%f,%f) op=%s distance=%f)", new Object[]{this.fieldName, this.point.latDegrees(), this.point.lngDegrees(), this.op, this.distance});
    }
}

