/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.InternalFailureException;
import com.google.appengine.api.taskqueue.QueueConstants;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.DevPullQueue;
import com.google.appengine.api.taskqueue.dev.DevPushQueue;
import com.google.appengine.api.taskqueue.dev.DevQueue;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.taskqueue.dev.QueueStateInfo;
import com.google.appengine.api.taskqueue.dev.UrlFetchJob;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.urlfetch.dev.LocalURLFetchService;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.ApiUtils;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.ConfigurationException;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.QueueXmlReader;
import com.google.apphosting.utils.config.QueueYamlReader;
import com.google.auto.service.AutoService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

@AutoService(value={LocalRpcService.class})
public final class LocalTaskQueue
extends AbstractLocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalTaskQueue.class.getName());
    private static final String DOC_LINK = "https://cloud.google.com/appengine/docs/standard/java/config/queueref-yaml";
    public static final String PACKAGE = "taskqueue";
    public static final String DISABLE_AUTO_TASK_EXEC_PROP = "task_queue.disable_auto_task_execution";
    public static final String QUEUE_XML_PATH_PROP = "task_queue.queue_xml_path";
    public static final String QUEUE_YAML_PATH_PROP = "task_queue.queue_yaml_path";
    public static final String CALLBACK_CLASS_PROP = "task_queue.callback_class";
    private final Map<String, DevQueue> queues = Collections.synchronizedMap(new TreeMap());
    private QueueXml queueConfig;
    private Scheduler scheduler;
    private boolean disableAutoTaskExecution = false;
    private LocalServerEnvironment localServerEnvironment;
    private Clock clock;
    private LocalURLFetchService fetchService;
    private LocalTaskQueueCallback callback;
    private Thread shutdownHook;
    private Random rng;

    @Override
    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.localServerEnvironment = context.getLocalServerEnvironment();
        this.clock = context.getClock();
        this.queueConfig = this.parseQueueConfiguration(this.localServerEnvironment.getAppDir().getPath(), properties.get(QUEUE_XML_PATH_PROP), properties.get(QUEUE_YAML_PATH_PROP));
        logger.log(Level.INFO, "LocalTaskQueue is initialized");
        if (Boolean.parseBoolean(properties.get(DISABLE_AUTO_TASK_EXEC_PROP))) {
            this.disableAutoTaskExecution = true;
            logger.log(Level.INFO, "Automatic task execution is disabled.");
        }
        this.fetchService = new LocalURLFetchService();
        this.fetchService.init(null, new HashMap<String, String>());
        this.fetchService.setTimeoutInMs(600000);
        this.rng = new Random();
        this.initializeCallback(properties);
    }

    QueueXml parseQueueConfiguration(String appDir, final @Nullable String queueXmlPath, final @Nullable String queueYamlPath) {
        if (queueXmlPath != null && queueYamlPath != null) {
            throw new ConfigurationException("Found both queue.xml and queue.yaml. Please use queue.yaml and remove queue.xml. For more information: https://cloud.google.com/appengine/docs/standard/java/config/queueref-yaml");
        }
        QueueXml resultFromXml = null;
        QueueXml resultFromYaml = null;
        if (queueXmlPath != null) {
            QueueXmlReader xmlReader = new QueueXmlReader(appDir){

                public String getFilename() {
                    return queueXmlPath;
                }
            };
            resultFromXml = xmlReader.readQueueXml();
        } else if (queueYamlPath != null) {
            QueueYamlReader yamlReader = new QueueYamlReader(appDir){

                public String getFilename() {
                    return queueYamlPath;
                }
            };
            resultFromYaml = yamlReader.parse();
        } else {
            QueueXmlReader xmlReader = new QueueXmlReader(appDir);
            resultFromXml = xmlReader.readQueueXml();
            QueueYamlReader yamlReader = new QueueYamlReader(Paths.get(appDir, "WEB-INF").toString());
            resultFromYaml = yamlReader.parse();
        }
        if (!ApiUtils.isPromotingYaml()) {
            return resultFromXml != null ? resultFromXml : resultFromYaml;
        }
        if (resultFromXml != null && resultFromYaml == null) {
            logger.warning("Using queue.xml. Please migrate to queue.yaml. For more information: https://cloud.google.com/appengine/docs/standard/java/config/queueref-yaml");
        }
        return resultFromYaml != null ? resultFromYaml : resultFromXml;
    }

    private void initializeCallback(Map<String, String> properties) {
        String callbackOverrideClass = properties.get(CALLBACK_CLASS_PROP);
        if (callbackOverrideClass != null) {
            try {
                this.callback = (LocalTaskQueueCallback)LocalTaskQueue.newInstance(Class.forName(callbackOverrideClass));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.callback = new UrlFetchServiceLocalTaskQueueCallback(this.fetchService);
        }
        this.callback.initialize(properties);
    }

    private static <E> E newInstance(Class<E> clazz) throws InstantiationException, IllegalAccessException {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Constructor<E> defaultConstructor;
            try {
                defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException f) {
                throw new InstantiationException("No zero-arg constructor.");
            }
            defaultConstructor.setAccessible(true);
            try {
                return defaultConstructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException g) {
                throw new RuntimeException(g);
            }
        }
    }

    void setQueueXml(QueueXml queueXml) {
        this.queueConfig = queueXml;
    }

    @Override
    public void start() {
        this.start_();
    }

    private void start_() {
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                LocalTaskQueue.this.stop_();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.fetchService.start();
        UrlFetchJob.initialize(this.localServerEnvironment, this.clock);
        this.scheduler = LocalTaskQueue.startScheduler(this.disableAutoTaskExecution);
        String baseUrl = LocalTaskQueue.getBaseUrl(this.localServerEnvironment);
        if (this.queueConfig != null) {
            for (QueueXml.Entry entry : this.queueConfig.getEntries()) {
                if ("pull".equals(entry.getMode())) {
                    this.queues.put(entry.getName(), new DevPullQueue(entry, this.clock));
                    continue;
                }
                this.queues.put(entry.getName(), new DevPushQueue(entry, this.scheduler, baseUrl, this.clock, this.callback));
            }
        }
        if (this.queues.get("default") == null) {
            QueueXml.Entry entry = QueueXml.defaultEntry();
            this.queues.put(entry.getName(), new DevPushQueue(entry, this.scheduler, baseUrl, this.clock, this.callback));
        }
        logger.info("Local task queue initialized with base url " + baseUrl);
    }

    static String getBaseUrl(LocalServerEnvironment localServerEnvironment) {
        String destAddress = localServerEnvironment.getAddress();
        if ("0.0.0.0".equals(destAddress)) {
            boolean ipv6 = InetAddress.getLoopbackAddress() instanceof Inet6Address;
            destAddress = ipv6 ? "[::1]" : "127.0.0.1";
        }
        return String.format("http://%s:%d", destAddress, localServerEnvironment.getPort());
    }

    @Override
    public void stop() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
        this.stop_();
    }

    private void stop_() {
        this.queues.clear();
        LocalTaskQueue.stopScheduler(this.scheduler);
        this.fetchService.stop();
    }

    @Override
    public String getPackage() {
        return PACKAGE;
    }

    private long currentTimeMillis() {
        return this.clock.getCurrentTime();
    }

    private long currentTimeUsec() {
        return this.currentTimeMillis() * 1000L;
    }

    TaskQueuePb.TaskQueueServiceError.ErrorCode validateAddRequest(TaskQueuePb.TaskQueueAddRequest.Builder addRequest) {
        ByteString taskName = addRequest.getTaskName();
        if (!taskName.isEmpty() && !QueueConstants.TASK_NAME_PATTERN.matcher(taskName.toStringUtf8()).matches()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_TASK_NAME;
        }
        ByteString queueName = addRequest.getQueueName();
        if (queueName.isEmpty() || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName.toStringUtf8()).matches()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_NAME;
        }
        if (addRequest.getEtaUsec() < 0L) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA;
        }
        if (addRequest.getEtaUsec() - this.currentTimeUsec() > LocalTaskQueue.getMaxEtaDeltaUsec()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA;
        }
        if (addRequest.getMode() == TaskQueuePb.TaskQueueMode.Mode.PULL) {
            return this.validateAddPullRequest(addRequest);
        }
        return this.validateAddPushRequest(addRequest);
    }

    TaskQueuePb.TaskQueueServiceError.ErrorCode validateAddPullRequest(TaskQueuePb.TaskQueueAddRequest.Builder addRequest) {
        if (!addRequest.hasBody()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_REQUEST;
        }
        return TaskQueuePb.TaskQueueServiceError.ErrorCode.OK;
    }

    TaskQueuePb.TaskQueueServiceError.ErrorCode validateAddPushRequest(TaskQueuePb.TaskQueueAddRequest.Builder addRequest) {
        ByteString url = addRequest.getUrl();
        if (!addRequest.hasUrl() || url.isEmpty()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_URL;
        }
        String urlString = url.toStringUtf8();
        if (urlString.charAt(0) != '/' || urlString.length() > QueueConstants.maxUrlLength()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_URL;
        }
        return TaskQueuePb.TaskQueueServiceError.ErrorCode.OK;
    }

    static long getMaxEtaDeltaUsec() {
        return QueueConstants.getMaxEtaDeltaMillis() * 1000L;
    }

    @LatencyPercentiles(latency50th=4)
    public TaskQueuePb.TaskQueueAddResponse add(LocalRpcService.Status status, TaskQueuePb.TaskQueueAddRequest addRequest) {
        TaskQueuePb.TaskQueueBulkAddRequest.Builder bulkRequest = TaskQueuePb.TaskQueueBulkAddRequest.newBuilder();
        bulkRequest.addAddRequestBuilder().mergeFrom(addRequest);
        TaskQueuePb.TaskQueueAddResponse.Builder addResponse = TaskQueuePb.TaskQueueAddResponse.newBuilder();
        TaskQueuePb.TaskQueueBulkAddResponse bulkResponse = this.bulkAdd(status, bulkRequest.build());
        if (bulkResponse.getTaskResultCount() != 1) {
            throw new InternalFailureException(String.format("expected 1 result from BulkAdd(), got %d", bulkResponse.getTaskResultCount()));
        }
        int result = bulkResponse.getTaskResult(0).getResult().getNumber();
        if (result != 0) {
            throw new ApiProxy.ApplicationException(result);
        }
        if (bulkResponse.getTaskResult(0).hasChosenTaskName()) {
            addResponse.setChosenTaskName(bulkResponse.getTaskResult(0).getChosenTaskName());
        }
        return addResponse.build();
    }

    @LatencyPercentiles(latency50th=3)
    public TaskQueuePb.TaskQueueFetchQueueStatsResponse fetchQueueStats(LocalRpcService.Status status, TaskQueuePb.TaskQueueFetchQueueStatsRequest fetchQueueStatsRequest) {
        TaskQueuePb.TaskQueueFetchQueueStatsResponse.Builder fetchQueueStatsResponse = TaskQueuePb.TaskQueueFetchQueueStatsResponse.newBuilder();
        for (ByteString unused : fetchQueueStatsRequest.getQueueNameList()) {
            TaskQueuePb.TaskQueueFetchQueueStatsResponse.QueueStats.Builder stats = TaskQueuePb.TaskQueueFetchQueueStatsResponse.QueueStats.newBuilder();
            TaskQueuePb.TaskQueueScannerQueueInfo.Builder scannerInfo = TaskQueuePb.TaskQueueScannerQueueInfo.newBuilder();
            scannerInfo.setEnforcedRate((double)(this.rng.nextInt(500) + 1));
            scannerInfo.setExecutedLastMinute((long)this.rng.nextInt(3000));
            scannerInfo.setRequestsInFlight(this.rng.nextInt(5));
            scannerInfo.setExecutedLastHour(0L);
            scannerInfo.setSamplingDurationSeconds(0.0);
            if (this.rng.nextBoolean()) {
                stats.setNumTasks(0);
                stats.setOldestEtaUsec(-1L);
            } else {
                stats.setNumTasks(this.rng.nextInt(2000) + 1);
                stats.setOldestEtaUsec(this.currentTimeMillis() * 1000L);
            }
            stats.setScannerInfo(scannerInfo);
            fetchQueueStatsResponse.addQueueStats(stats);
        }
        return fetchQueueStatsResponse.build();
    }

    @LatencyPercentiles(latency50th=3)
    public TaskQueuePb.TaskQueuePurgeQueueResponse purgeQueue(LocalRpcService.Status status, TaskQueuePb.TaskQueuePurgeQueueRequest purgeQueueRequest) {
        TaskQueuePb.TaskQueuePurgeQueueResponse purgeQueueResponse = TaskQueuePb.TaskQueuePurgeQueueResponse.getDefaultInstance();
        this.flushQueue(purgeQueueRequest.getQueueName().toStringUtf8());
        return purgeQueueResponse;
    }

    @LatencyPercentiles(latency50th=4)
    public TaskQueuePb.TaskQueueBulkAddResponse bulkAdd(LocalRpcService.Status status, TaskQueuePb.TaskQueueBulkAddRequest bulkAddRequest) {
        TaskQueuePb.TaskQueueBulkAddResponse.TaskResult.Builder taskResult;
        TaskQueuePb.TaskQueueBulkAddResponse.Builder bulkAddResponse = TaskQueuePb.TaskQueueBulkAddResponse.newBuilder();
        if (bulkAddRequest.getAddRequestCount() == 0) {
            return bulkAddResponse.build();
        }
        TaskQueuePb.TaskQueueBulkAddRequest.Builder bulkAddRequestBuilder = bulkAddRequest.toBuilder();
        DevQueue queue = this.getQueueByName(bulkAddRequestBuilder.getAddRequest(0).getQueueName().toStringUtf8());
        IdentityHashMap<TaskQueuePb.TaskQueueBulkAddResponse.TaskResult.Builder, String> chosenNames = new IdentityHashMap<TaskQueuePb.TaskQueueBulkAddResponse.TaskResult.Builder, String>();
        boolean errorFound = false;
        for (TaskQueuePb.TaskQueueAddRequest.Builder addRequest : bulkAddRequestBuilder.getAddRequestBuilderList()) {
            taskResult = bulkAddResponse.addTaskResultBuilder();
            TaskQueuePb.TaskQueueServiceError.ErrorCode error = this.validateAddRequest(addRequest);
            taskResult.setResult(error);
            if (error == TaskQueuePb.TaskQueueServiceError.ErrorCode.OK) {
                if (!addRequest.hasTaskName() || addRequest.getTaskName().isEmpty()) {
                    addRequest.setTaskName(ByteString.copyFromUtf8((String)DevQueue.genTaskName()));
                    chosenNames.put(taskResult, addRequest.getTaskName().toStringUtf8());
                }
                taskResult.setResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.SKIPPED);
                continue;
            }
            taskResult.setResult(error);
            errorFound = true;
        }
        if (errorFound) {
            return bulkAddResponse.build();
        }
        if (bulkAddRequestBuilder.getAddRequest(0).hasTransaction() || bulkAddRequestBuilder.getAddRequest(0).hasDatastoreTransaction()) {
            try {
                ApiProxy.makeSyncCall((String)"datastore_v3", (String)"addActions", (byte[])bulkAddRequestBuilder.build().toByteArray());
            }
            catch (ApiProxy.ApplicationException exception) {
                throw new ApiProxy.ApplicationException(exception.getApplicationError() + 10000, exception.getErrorDetail());
            }
        } else {
            for (int i = 0; i < bulkAddRequestBuilder.getAddRequestCount(); ++i) {
                TaskQueuePb.TaskQueueAddRequest.Builder addRequest;
                addRequest = bulkAddRequestBuilder.getAddRequestBuilder(i);
                taskResult = bulkAddResponse.getTaskResultBuilder(i);
                try {
                    queue.add(addRequest);
                    continue;
                }
                catch (ApiProxy.ApplicationException exception) {
                    taskResult.setResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.forNumber((int)exception.getApplicationError()));
                }
            }
        }
        for (TaskQueuePb.TaskQueueBulkAddResponse.TaskResult.Builder taskResult2 : bulkAddResponse.getTaskResultBuilderList()) {
            if (taskResult2.getResult() != TaskQueuePb.TaskQueueServiceError.ErrorCode.SKIPPED) continue;
            taskResult2.setResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.OK);
            if (!chosenNames.containsKey(taskResult2)) continue;
            taskResult2.setChosenTaskName(ByteString.copyFromUtf8((String)((String)chosenNames.get(taskResult2))));
        }
        return bulkAddResponse.build();
    }

    public TaskQueuePb.TaskQueueDeleteResponse delete(LocalRpcService.Status status, TaskQueuePb.TaskQueueDeleteRequest request) {
        String queueName = request.getQueueName().toStringUtf8();
        DevQueue queue = this.getQueueByName(queueName);
        TaskQueuePb.TaskQueueDeleteResponse.Builder response = TaskQueuePb.TaskQueueDeleteResponse.newBuilder();
        for (ByteString taskName : request.getTaskNameList()) {
            try {
                if (!queue.deleteTask(taskName.toStringUtf8())) {
                    response.addResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.UNKNOWN_TASK);
                    continue;
                }
                response.addResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.OK);
            }
            catch (ApiProxy.ApplicationException e) {
                response.addResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.forNumber((int)e.getApplicationError()));
            }
        }
        return response.build();
    }

    @LatencyPercentiles(latency50th=8)
    public TaskQueuePb.TaskQueueQueryAndOwnTasksResponse queryAndOwnTasks(LocalRpcService.Status status, TaskQueuePb.TaskQueueQueryAndOwnTasksRequest request) {
        String queueName = request.getQueueName().toStringUtf8();
        LocalTaskQueue.validateQueueName(queueName);
        DevQueue queue = this.getQueueByName(queueName);
        if (queue.getMode() != TaskQueuePb.TaskQueueMode.Mode.PULL) {
            throw new ApiProxy.ApplicationException(21);
        }
        DevPullQueue pullQueue = (DevPullQueue)queue;
        List<TaskQueuePb.TaskQueueAddRequest.Builder> results = pullQueue.queryAndOwnTasks(request.getLeaseSeconds(), request.getMaxTasks(), request.hasGroupByTag(), request.getTag().toByteArray());
        TaskQueuePb.TaskQueueQueryAndOwnTasksResponse.Builder response = TaskQueuePb.TaskQueueQueryAndOwnTasksResponse.newBuilder();
        for (TaskQueuePb.TaskQueueAddRequest.Builder task : results) {
            TaskQueuePb.TaskQueueQueryAndOwnTasksResponse.Task.Builder responseTask = response.addTaskBuilder().setTaskName(task.getTaskName()).setBody(task.getBody()).setEtaUsec(task.getEtaUsec());
            if (!task.hasTag()) continue;
            responseTask.setTag(task.getTag());
        }
        return response.build();
    }

    public TaskQueuePb.TaskQueueModifyTaskLeaseResponse modifyTaskLease(LocalRpcService.Status status, TaskQueuePb.TaskQueueModifyTaskLeaseRequest request) {
        String queueName = request.getQueueName().toStringUtf8();
        LocalTaskQueue.validateQueueName(queueName);
        String taskName = request.getTaskName().toStringUtf8();
        LocalTaskQueue.validateTaskName(taskName);
        DevQueue queue = this.getQueueByName(queueName);
        if (queue.getMode() != TaskQueuePb.TaskQueueMode.Mode.PULL) {
            throw new ApiProxy.ApplicationException(21);
        }
        DevPullQueue pullQueue = (DevPullQueue)queue;
        return pullQueue.modifyTaskLease(request);
    }

    public Map<String, QueueStateInfo> getQueueStateInfo() {
        return this.getQueueStateInfoInternal();
    }

    private Map<String, QueueStateInfo> getQueueStateInfoInternal() {
        TreeMap<String, QueueStateInfo> queueStateInfo = new TreeMap<String, QueueStateInfo>();
        for (Map.Entry<String, DevQueue> entry : this.queues.entrySet()) {
            String queueName = entry.getKey();
            queueStateInfo.put(queueName, entry.getValue().getStateInfo());
        }
        return queueStateInfo;
    }

    private DevQueue getQueueByName(String queueName) {
        DevQueue queue = this.queues.get(queueName);
        if (queue == null) {
            throw new ApiProxy.ApplicationException(1, queueName);
        }
        return queue;
    }

    @LatencyPercentiles(latency50th=4)
    public void flushQueue(String queueName) {
        DevQueue queue = this.getQueueByName(queueName);
        queue.flush();
    }

    public boolean deleteTask(String queueName, String taskName) {
        DevQueue queue = this.getQueueByName(queueName);
        return queue.deleteTask(taskName);
    }

    static Scheduler startScheduler(boolean disableAutoTaskExecution) {
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            if (!disableAutoTaskExecution) {
                scheduler.start();
            }
            return scheduler;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    static void stopScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            return;
        }
        try {
            scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean runTask(String queueName, String taskName) {
        DevQueue queue = this.getQueueByName(queueName);
        return queue.runTask(taskName);
    }

    @Override
    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    static final void validateQueueName(String queueName) throws ApiProxy.ApplicationException {
        if (queueName == null || queueName.length() == 0 || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
            throw new ApiProxy.ApplicationException(6);
        }
    }

    static final void validateTaskName(String taskName) throws ApiProxy.ApplicationException {
        if (taskName == null || taskName.length() == 0 || !QueueConstants.TASK_NAME_PATTERN.matcher(taskName).matches()) {
            throw new ApiProxy.ApplicationException(5);
        }
    }

    static final class UrlFetchServiceLocalTaskQueueCallback
    implements LocalTaskQueueCallback {
        private final LocalURLFetchService fetchService;

        UrlFetchServiceLocalTaskQueueCallback(LocalURLFetchService fetchService) {
            this.fetchService = fetchService;
        }

        @Override
        public int execute(URLFetchServicePb.URLFetchRequest fetchReq) {
            LocalRpcService.Status status = new LocalRpcService.Status();
            return this.fetchService.fetch(status, fetchReq).getStatusCode();
        }

        @Override
        public void initialize(Map<String, String> properties) {
        }
    }
}

