/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users.dev.jakarta;

import com.google.appengine.api.users.dev.jakarta.LoginCookieUtils;
import com.google.appengine.repackaged.com.google.common.html.HtmlEscapers;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public final class LocalLoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 3436539147212984827L;
    private static final String BLUE_BOX_STYLE = "width: 20em;margin: 1em auto;text-align: left;padding: 0 2em 1.25em 2em;background-color: #d6e9f8;border: 2px solid #67a7e3;";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String continueUrl = req.getParameter("continue");
        if (continueUrl == null) {
            continueUrl = "";
        }
        String email = "test@example.com";
        String isAdminChecked = "";
        LoginCookieUtils.CookieData cookieData = LoginCookieUtils.getCookieData(req);
        if (cookieData != null) {
            email = cookieData.getEmail();
            if (cookieData.isAdmin()) {
                isAdminChecked = " checked='true'";
            }
        }
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        out.println("<html>");
        out.println("<body>");
        out.println("<form method='post' style='text-align:center; font:13px sans-serif'>");
        out.printf("<div style='%s'>\n", BLUE_BOX_STYLE);
        out.println("<h3>Not logged in</h3>");
        out.println("<p style='padding: 0; margin: 0'>");
        out.println("<label for='email' style='width: 3em'>Email:</label>");
        out.printf(" <input type='text' name='email' id='email'value='%s'>\n", email);
        out.println("</p>");
        out.println("<p style='margin: .5em 0 0 3em; font-size:12px'>");
        out.printf("<input type='checkbox' name='isAdmin' id='isAdmin'%s>\n", isAdminChecked);
        out.println(" <label for='isAdmin'>Sign in as Administrator</label>");
        out.println("</p>");
        out.printf("<input type='hidden' name='continue' value='%s'>\n", HtmlEscapers.htmlEscaper().escape(continueUrl));
        out.println("<p style='margin-left: 3em;'>");
        out.println("<input name='action' type='submit' value='Log In' id='btn-login'>");
        out.println("<input name='action' type='submit' value='Log Out' id='btn-logout'>");
        out.println("</p>");
        out.println("</div>");
        out.println("</form>");
        out.println("</body>");
        out.println("</html>");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String continueUrl = req.getParameter("continue");
        String email = req.getParameter("email");
        boolean logout = "Log Out".equalsIgnoreCase(req.getParameter("action"));
        boolean isAdmin = "on".equalsIgnoreCase(req.getParameter("isAdmin"));
        if (logout) {
            LoginCookieUtils.removeCookie(req, resp);
        } else {
            resp.addCookie(LoginCookieUtils.createCookie(email, isAdmin));
        }
        resp.sendRedirect(continueUrl);
    }
}

