/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSortedMap;
import com.google.appengine.tools.development.EnvironmentVariableChecker;
import com.google.appengine.tools.development.LocalURLFetchServiceStreamHandler;
import com.google.appengine.tools.development.LoggingConfigurationManager;
import com.google.appengine.tools.development.SystemPropertiesManager;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.BackendsXmlReader;
import com.google.apphosting.utils.config.BackendsYamlReader;
import com.google.apphosting.utils.config.EarHelper;
import com.google.apphosting.utils.config.EarInfo;
import com.google.apphosting.utils.config.WebModule;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public class ApplicationConfigurationManager {
    private static final Logger logger = Logger.getLogger(ApplicationConfigurationManager.class.getName());
    private final File configurationRoot;
    private final SystemPropertiesManager systemPropertiesManager;
    private final String sdkRelease;
    private final File applicationSchemaFile;
    @GuardedBy(value="this")
    private EnvironmentVariableChecker.MismatchReportingPolicy environmentVariableMismatchReportingPolicy = EnvironmentVariableChecker.MismatchReportingPolicy.EXCEPTION;
    @GuardedBy(value="this")
    private final List<ModuleConfigurationHandle> moduleConfigurationHandles;

    static ApplicationConfigurationManager newEarConfigurationManager(File earRoot, String sdkVersion, File applicationSchemaFile) throws AppEngineConfigException {
        return ApplicationConfigurationManager.newEarConfigurationManager(earRoot, sdkVersion, applicationSchemaFile, "");
    }

    public static ApplicationConfigurationManager newEarConfigurationManager(File earRoot, String sdkVersion, File applicationSchemaFile, String appIdPrefix) throws AppEngineConfigException {
        if (!EarHelper.isEar((String)earRoot.getAbsolutePath())) {
            String message = String.format("ApplicationConfigurationManager.newEarConfigurationManager passed an invalid EAR: %s", earRoot.getAbsolutePath());
            logger.severe(message);
            throw new AppEngineConfigException(message);
        }
        return new ApplicationConfigurationManager(earRoot, null, null, null, sdkVersion, applicationSchemaFile, appIdPrefix);
    }

    static ApplicationConfigurationManager newWarConfigurationManager(File warRoot, File appEngineWebXmlLocation, File webXmlLocation, File externalResourceDirectory, String sdkRelease) throws AppEngineConfigException {
        return ApplicationConfigurationManager.newWarConfigurationManager(warRoot, appEngineWebXmlLocation, webXmlLocation, externalResourceDirectory, sdkRelease, "");
    }

    public static ApplicationConfigurationManager newWarConfigurationManager(File warRoot, File appEngineWebXmlLocation, File webXmlLocation, File externalResourceDirectory, String sdkRelease, String appIdPrefix) throws AppEngineConfigException {
        if (EarHelper.isEar((String)warRoot.getAbsolutePath())) {
            String message = String.format("ApplicationConfigurationManager.newWarConfigurationManager passed an EAR: %s", warRoot.getAbsolutePath());
            logger.severe(message);
            throw new AppEngineConfigException(message);
        }
        return new ApplicationConfigurationManager(warRoot, appEngineWebXmlLocation, webXmlLocation, externalResourceDirectory, sdkRelease, null, appIdPrefix);
    }

    synchronized ModuleConfigurationHandle getPrimaryModuleConfigurationHandle() {
        return this.moduleConfigurationHandles.get(0);
    }

    public synchronized List<ModuleConfigurationHandle> getModuleConfigurationHandles() {
        return ImmutableList.copyOf(this.moduleConfigurationHandles);
    }

    private ApplicationConfigurationManager(File configurationRoot, File appEngineWebXmlLocation, File webXmlLocation, File externalResourceDirectory, String sdkRelease, File applicationSchemaFile, String appIdPrefix) {
        this.configurationRoot = configurationRoot;
        this.systemPropertiesManager = new SystemPropertiesManager();
        this.sdkRelease = sdkRelease;
        this.applicationSchemaFile = applicationSchemaFile;
        if (EarHelper.isEar((String)configurationRoot.getAbsolutePath())) {
            EarInfo earInfo = this.readEarConfiguration();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WebModule module : earInfo.getWebModules()) {
                builder.add((Object)new EarModuleConfigurationHandle(module));
            }
            this.moduleConfigurationHandles = builder.build();
        } else {
            WarModuleConfigurationHandle warConfigurationHandle = new WarModuleConfigurationHandle(appEngineWebXmlLocation, webXmlLocation, externalResourceDirectory, appIdPrefix);
            warConfigurationHandle.readConfiguration();
            this.moduleConfigurationHandles = ImmutableList.of((Object)warConfigurationHandle);
        }
    }

    private synchronized void validateAndRegisterGlobalValues(WebModule module, LoggingConfigurationManager loggingConfigurationManager, File externalResourceDirectory) {
        module.getWebXml().validate();
        AppEngineWebXml appEngineWebXml = module.getAppEngineWebXml();
        loggingConfigurationManager.read(this.systemPropertiesManager.getOriginalSystemProperties(), appEngineWebXml.getSystemProperties(), module.getApplicationDirectory(), externalResourceDirectory);
        this.systemPropertiesManager.setSystemProperties(appEngineWebXml, module.getAppEngineWebXmlFile());
    }

    private synchronized EarInfo readEarConfiguration() {
        if (!EarHelper.isEar((String)this.configurationRoot.getAbsolutePath())) {
            String message = String.format("Unsupported update from EAR to WAR for: %s", this.configurationRoot.getAbsolutePath());
            logger.severe(message);
            throw new AppEngineConfigException(message);
        }
        EarInfo earInfo = EarHelper.readEarInfo((String)this.configurationRoot.getAbsolutePath(), (File)this.applicationSchemaFile);
        String majorVersionId = null;
        String urlStreamHandlerType = null;
        LoggingConfigurationManager loggingConfigurationManager = new LoggingConfigurationManager();
        for (WebModule module : earInfo.getWebModules()) {
            module.getWebXml().validate();
            AppEngineWebXml appEngineWebXml = module.getAppEngineWebXml();
            if (majorVersionId == null) {
                majorVersionId = appEngineWebXml.getMajorVersionId();
                urlStreamHandlerType = appEngineWebXml.getUrlStreamHandlerType();
            }
            this.validateAndRegisterGlobalValues(module, loggingConfigurationManager, null);
        }
        this.systemPropertiesManager.setAppengineSystemProperties(this.sdkRelease, earInfo.getAppengineApplicationXml().getApplicationId(), majorVersionId);
        loggingConfigurationManager.updateLoggingConfiguration();
        this.updateUrlStreamHandlerMode(urlStreamHandlerType);
        return earInfo;
    }

    private synchronized void checkEnvironmentVariables() {
        EnvironmentVariableChecker environmentVariableChecker = new EnvironmentVariableChecker(this.environmentVariableMismatchReportingPolicy);
        for (ModuleConfigurationHandle moduleConfigurationHandle : this.moduleConfigurationHandles) {
            WebModule module = moduleConfigurationHandle.getModule();
            environmentVariableChecker.add(module.getAppEngineWebXml(), module.getAppEngineWebXmlFile());
        }
        environmentVariableChecker.check();
    }

    public synchronized void setEnvironmentVariableMismatchReportingPolicy(EnvironmentVariableChecker.MismatchReportingPolicy environmentVariableMismatchReportingPolicy) {
        this.environmentVariableMismatchReportingPolicy = environmentVariableMismatchReportingPolicy;
    }

    synchronized EnvironmentVariableChecker.MismatchReportingPolicy getEnvironmentVariableMismatchReportingPolicy() {
        return this.environmentVariableMismatchReportingPolicy;
    }

    private void updateUrlStreamHandlerMode(String urlStreamHandlerType) {
        if (urlStreamHandlerType == null) {
            LocalURLFetchServiceStreamHandler.setUseNativeHandlers(true);
        } else {
            LocalURLFetchServiceStreamHandler.setUseNativeHandlers("native".equals(urlStreamHandlerType));
        }
    }

    public synchronized String toString() {
        return "ApplicationConfigurationManager: configurationRoot=" + String.valueOf(this.configurationRoot) + " systemPropertiesManager=" + String.valueOf(this.systemPropertiesManager) + " sdkVersion=" + this.sdkRelease + " environmentVariableMismatchReportingPolicy=" + String.valueOf((Object)this.environmentVariableMismatchReportingPolicy) + " moduleConfigurationHandles=" + String.valueOf(this.moduleConfigurationHandles);
    }

    private static void checkDynamicModuleUpdateAllowed(WebModule currentModule, WebModule updatedModule) throws AppEngineConfigException {
        ApplicationConfigurationManager.checkServerNamesMatch(currentModule, updatedModule);
        ApplicationConfigurationManager.checkScalingTypesMatch(currentModule, updatedModule);
        ApplicationConfigurationManager.checkInstanceCountsMatch(currentModule, updatedModule);
    }

    private static void checkServerNamesMatch(WebModule currentModule, WebModule updatedModule) throws AppEngineConfigException {
        String updatedModuleName;
        String currentModuleName = currentModule.getModuleName();
        if (!currentModuleName.equals(updatedModuleName = updatedModule.getModuleName())) {
            String message = String.format("Unsupported configuration change of module name from '%s' to '%s' in '%s'", currentModuleName, updatedModuleName, currentModule.getAppEngineWebXmlFile());
            logger.severe(message);
            throw new AppEngineConfigException(message);
        }
    }

    private static void checkScalingTypesMatch(WebModule currentModule, WebModule updatedModule) throws AppEngineConfigException {
        AppEngineWebXml.ScalingType updatedScalingType;
        AppEngineWebXml.ScalingType currentScalingType = currentModule.getAppEngineWebXml().getScalingType();
        if (!currentScalingType.equals((Object)(updatedScalingType = updatedModule.getAppEngineWebXml().getScalingType()))) {
            String message = String.format("Unsupported configuration change of scaling from '%s' to '%s' in '%s'", currentScalingType, updatedScalingType, currentModule.getAppEngineWebXmlFile());
            logger.severe(message);
            throw new AppEngineConfigException(message);
        }
    }

    private static void checkInstanceCountsMatch(WebModule currentModule, WebModule updatedModule) throws AppEngineConfigException {
        AppEngineWebXml.ScalingType currentScalingType = currentModule.getAppEngineWebXml().getScalingType();
        switch (currentScalingType) {
            case MANUAL: {
                String currentManualInstances = currentModule.getAppEngineWebXml().getManualScaling().getInstances();
                String updatedManualInstances = updatedModule.getAppEngineWebXml().getManualScaling().getInstances();
                if (Objects.equals(currentManualInstances, updatedManualInstances)) break;
                String template = "Unsupported configuration change of manual scaling instances from '%s' to '%s' in '%s'";
                String message = String.format(template, currentManualInstances, updatedManualInstances, currentModule.getAppEngineWebXmlFile());
                logger.severe(message);
                throw new AppEngineConfigException(message);
            }
            case BASIC: {
                String currentBasicMaxInstances = currentModule.getAppEngineWebXml().getBasicScaling().getMaxInstances();
                String updatedBasicMaxInstances = updatedModule.getAppEngineWebXml().getBasicScaling().getMaxInstances();
                if (Objects.equals(currentBasicMaxInstances, updatedBasicMaxInstances)) break;
                String template = "Unsupported configuration change of basic scaling max instances from '%s' to '%s' in '%s'";
                String message = String.format(template, currentBasicMaxInstances, updatedBasicMaxInstances, currentModule.getAppEngineWebXmlFile());
                logger.severe(message);
                break;
            }
        }
    }

    public static interface ModuleConfigurationHandle {
        public WebModule getModule();

        public void checkEnvironmentVariables();

        public BackendsXml getBackendsXml();

        public void readConfiguration() throws AppEngineConfigException;

        public void restoreSystemProperties();
    }

    private class EarModuleConfigurationHandle
    implements ModuleConfigurationHandle {
        @GuardedBy(value="ApplicationConfigurationManager.this")
        private WebModule webModule;

        EarModuleConfigurationHandle(WebModule webModule) {
            this.webModule = webModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WebModule getModule() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                return this.webModule;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkEnvironmentVariables() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                ApplicationConfigurationManager.this.checkEnvironmentVariables();
            }
        }

        @Override
        public BackendsXml getBackendsXml() {
            return null;
        }

        @Override
        public void readConfiguration() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                EarInfo earInfo = ApplicationConfigurationManager.this.readEarConfiguration();
                this.checkDynamicUpdateAllowed(earInfo);
                for (WebModule module : earInfo.getWebModules()) {
                    if (!module.getApplicationDirectory().equals(this.webModule.getApplicationDirectory())) continue;
                    this.webModule = module;
                    return;
                }
                throw new IllegalStateException("Expected web module not found.");
            }
        }

        @GuardedBy(value="ApplicationConfigurationManager.this")
        private void checkDynamicUpdateAllowed(EarInfo updatedEarInfo) throws AppEngineConfigException {
            Map<File, WebModule> currentModuleMap = this.getCurrentModuleMap();
            Map<File, WebModule> updatedModuleMap = this.getUpdatedModuleMap(updatedEarInfo);
            this.checkWarDirectoriesMatch(currentModuleMap.keySet(), updatedModuleMap.keySet());
            for (File currentWarFile : currentModuleMap.keySet()) {
                WebModule currentModule = currentModuleMap.get(currentWarFile);
                WebModule updatedModule = updatedModuleMap.get(currentWarFile);
                ApplicationConfigurationManager.checkDynamicModuleUpdateAllowed(currentModule, updatedModule);
            }
        }

        @GuardedBy(value="ApplicationConfigurationManager.this")
        private Map<File, WebModule> getCurrentModuleMap() {
            ImmutableSortedMap.Builder currentModuleMapBuilder = ImmutableSortedMap.naturalOrder();
            for (ModuleConfigurationHandle handle : ApplicationConfigurationManager.this.moduleConfigurationHandles) {
                currentModuleMapBuilder.put((Object)handle.getModule().getApplicationDirectory(), (Object)handle.getModule());
            }
            return currentModuleMapBuilder.buildOrThrow();
        }

        private Map<File, WebModule> getUpdatedModuleMap(EarInfo earInfo) {
            ImmutableSortedMap.Builder updatedModuleMapBuilder = ImmutableSortedMap.naturalOrder();
            for (WebModule module : earInfo.getWebModules()) {
                updatedModuleMapBuilder.put((Object)module.getApplicationDirectory(), (Object)module);
            }
            return updatedModuleMapBuilder.buildOrThrow();
        }

        private void checkWarDirectoriesMatch(Set<File> currentWarDirectories, Set<File> updatedWarDirectories) {
            if (!currentWarDirectories.equals(updatedWarDirectories)) {
                String message = String.format("Unsupported configuration change of war directories from '%s' to '%s'", currentWarDirectories, updatedWarDirectories);
                logger.severe(message);
                throw new AppEngineConfigException(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void restoreSystemProperties() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                ApplicationConfigurationManager.this.systemPropertiesManager.restoreSystemProperties();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                return "WarConfigurationHandle: webModule=" + String.valueOf(this.webModule);
            }
        }
    }

    private class WarModuleConfigurationHandle
    implements ModuleConfigurationHandle {
        private final File rawAppEngineWebXmlLocation;
        private final File rawWebXmlLocation;
        private final File externalResourceDirectory;
        private final String appIdPrefix;
        @GuardedBy(value="ApplicationConfigurationManager.this")
        private BackendsXml backendsXml;
        @GuardedBy(value="ApplicationConfigurationManager.this")
        private WebModule webModule;

        WarModuleConfigurationHandle(File appEngineWebXmlLocation, File webXmlLocation, File externalResourceDirectory, String appIdPrefix) {
            this.rawAppEngineWebXmlLocation = appEngineWebXmlLocation;
            this.rawWebXmlLocation = webXmlLocation;
            this.externalResourceDirectory = externalResourceDirectory;
            this.appIdPrefix = appIdPrefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WebModule getModule() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                return this.webModule;
            }
        }

        @Override
        public void checkEnvironmentVariables() {
            ApplicationConfigurationManager.this.checkEnvironmentVariables();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BackendsXml getBackendsXml() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                return this.backendsXml;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readConfiguration() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                if (EarHelper.isEar((String)ApplicationConfigurationManager.this.configurationRoot.getAbsolutePath())) {
                    String message = String.format("Unsupported update from WAR to EAR for: %s", ApplicationConfigurationManager.this.configurationRoot.getAbsolutePath());
                    logger.severe(message);
                    throw new AppEngineConfigException(message);
                }
                WebModule updatedWebModule = EarHelper.readWebModule(null, (File)ApplicationConfigurationManager.this.configurationRoot, (File)this.rawAppEngineWebXmlLocation, (File)this.rawWebXmlLocation, (String)this.appIdPrefix);
                if (this.webModule != null) {
                    ApplicationConfigurationManager.checkDynamicModuleUpdateAllowed(this.webModule, updatedWebModule);
                }
                this.webModule = updatedWebModule;
                String baseDir = ApplicationConfigurationManager.this.configurationRoot.getAbsolutePath();
                File webinf = new File(baseDir, "WEB-INF");
                this.backendsXml = new BackendsXmlReader(baseDir).readBackendsXml();
                if (this.backendsXml == null) {
                    BackendsYamlReader backendsYaml = new BackendsYamlReader(webinf.getPath());
                    this.backendsXml = backendsYaml.parse();
                }
                AppEngineWebXml appEngineWebXml = this.webModule.getAppEngineWebXml();
                String appId = System.getenv("APPLICATION_ID");
                if (appId == null && (appEngineWebXml.getAppId() == null || appEngineWebXml.getAppId().isEmpty())) {
                    appId = "no_app_id";
                }
                if (appId != null) {
                    appEngineWebXml.setAppId(appId);
                }
                LoggingConfigurationManager loggingConfigurationManager = new LoggingConfigurationManager();
                ApplicationConfigurationManager.this.validateAndRegisterGlobalValues(this.webModule, loggingConfigurationManager, this.externalResourceDirectory);
                ApplicationConfigurationManager.this.systemPropertiesManager.setAppengineSystemProperties(ApplicationConfigurationManager.this.sdkRelease, appEngineWebXml.getAppId(), appEngineWebXml.getMajorVersionId());
                loggingConfigurationManager.updateLoggingConfiguration();
                ApplicationConfigurationManager.this.updateUrlStreamHandlerMode(appEngineWebXml.getUrlStreamHandlerType());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void restoreSystemProperties() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                ApplicationConfigurationManager.this.systemPropertiesManager.restoreSystemProperties();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            ApplicationConfigurationManager applicationConfigurationManager = ApplicationConfigurationManager.this;
            synchronized (applicationConfigurationManager) {
                return "WarConfigurationHandle: webModule=" + String.valueOf(this.webModule) + " backendsXml=" + String.valueOf(this.backendsXml) + " appEngineWebXmlLocation=" + String.valueOf(this.rawAppEngineWebXmlLocation) + " webXmlLocation=" + String.valueOf(this.rawWebXmlLocation) + " externalResourceDirectory=" + String.valueOf(this.externalResourceDirectory);
            }
        }
    }
}

