/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.backends.dev.LocalServerController;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.tools.development.AbstractContainerService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.BackendContainer;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.ContainerUtils;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.InstanceHelper;
import com.google.appengine.tools.development.InstanceStateHolder;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.BackendsXml;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackendServersBase
implements BackendContainer,
LocalServerController,
AbstractContainerService.PortMappingProvider {
    public static final String SYSTEM_PROPERTY_STATIC_PORT_NUM_PREFIX = "com.google.appengine.devappserver.";
    private static final Integer DEFAULT_INSTANCES = 1;
    private static final String DEFAULT_INSTANCE_CLASS = "B1";
    private static final Integer DEFAULT_MAX_CONCURRENT_REQUESTS = 10;
    private static final int MAX_PENDING_QUEUE_LENGTH = 20;
    private static final int MAX_PENDING_QUEUE_TIME_MS = 10000;
    private static final int MAX_START_QUEUE_TIME_MS = 30000;
    private String address;
    private ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle;
    private File externalResourceDir;
    private Map<String, Object> containerConfigProperties;
    private ImmutableMap<ServerInstanceEntry, ServerWrapper> backendServers = ImmutableMap.copyOf(new HashMap());
    private Map<String, String> portMapping = ImmutableMap.copyOf(new HashMap());
    protected Logger logger = Logger.getLogger(BackendServersBase.class.getName());
    private Map<String, String> serviceProperties = new HashMap<String, String>();
    private DevAppServer devAppServer;
    private ApiProxyLocal apiProxyLocal;
    private static BackendServersBase instance;

    public static BackendServersBase getInstance() {
        if (instance == null) {
            try {
                instance = Class.forName(AppengineSdk.getSdk().getBackendServersClassName()).asSubclass(BackendServersBase.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(BackendServersBase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return instance;
    }

    @Override
    public void init(String address, ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, File externalResourceDirectory, Map<String, Object> containerConfigProperties, DevAppServer devAppServer) {
        this.moduleConfigurationHandle = moduleConfigurationHandle;
        this.externalResourceDir = externalResourceDirectory;
        this.address = address;
        this.containerConfigProperties = containerConfigProperties;
        this.devAppServer = devAppServer;
    }

    @Override
    public void setServiceProperties(Map<String, String> properties) {
        this.serviceProperties = properties;
    }

    @Override
    public void shutdownAll() throws Exception {
        for (ServerWrapper server : this.backendServers.values()) {
            this.logger.finer("server shutdown: " + String.valueOf(server));
            server.shutdown();
        }
        this.backendServers = ImmutableMap.copyOf(new HashMap());
    }

    @Override
    public TreeMap<String, LocalServerController.BackendStateInfo> getBackendState(String requestHostName) {
        TreeMap<String, LocalServerController.BackendStateInfo> serverInfoMap = new TreeMap<String, LocalServerController.BackendStateInfo>();
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            String name = serverWrapper.serverEntry.getName();
            Object listenAddress = requestHostName == null ? this.portMapping.get(serverWrapper.getDnsPrefix()) : requestHostName + ":" + serverWrapper.port;
            LocalServerController.BackendStateInfo ssi = serverInfoMap.get(name);
            if (ssi == null) {
                ssi = new LocalServerController.BackendStateInfo(serverWrapper.serverEntry);
                serverInfoMap.put(name, ssi);
            }
            if (serverWrapper.isLoadBalanceServer()) {
                ssi.setState(serverWrapper.getStateHolder().getDisplayName());
                ssi.setAddress((String)listenAddress);
                continue;
            }
            ssi.add(new LocalServerController.InstanceStateInfo(serverWrapper.serverInstance, (String)listenAddress, serverWrapper.getStateHolder().getDisplayName()));
        }
        return serverInfoMap;
    }

    @Override
    public synchronized void startBackend(String serverToStart) throws IllegalStateException {
        if (!this.checkServerExists(serverToStart)) {
            String message = String.format("Tried to start unknown server %s", serverToStart);
            this.logger.warning(message);
            throw new IllegalStateException(message);
        }
        for (ServerWrapper server : this.backendServers.values()) {
            if (!server.getName().equals(serverToStart) || !server.getStateHolder().test(InstanceStateHolder.InstanceState.STOPPED)) continue;
            if (server.isLoadBalanceServer()) {
                server.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.RUNNING, InstanceStateHolder.InstanceState.STOPPED);
                continue;
            }
            server.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.SLEEPING, InstanceStateHolder.InstanceState.STOPPED);
            server.sendStartRequest();
        }
    }

    @Override
    public synchronized void stopBackend(String serverToStop) throws Exception {
        if (!this.checkServerExists(serverToStop)) {
            String message = String.format("Tried to stop unknown server %s", serverToStop);
            this.logger.warning(message);
            throw new IllegalStateException(message);
        }
        for (ServerWrapper server : this.backendServers.values()) {
            if (!server.getName().equals(serverToStop) || server.getStateHolder().test(InstanceStateHolder.InstanceState.STOPPED)) continue;
            if (server.isLoadBalanceServer()) {
                server.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.STOPPED, InstanceStateHolder.InstanceState.RUNNING);
                continue;
            }
            this.logger.fine("Stopping server: " + server.getDnsPrefix());
            server.shutdown();
            server.createConnection();
            server.startup(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureAll(ApiProxyLocal local) throws Exception {
        this.apiProxyLocal = local;
        BackendsXml backendsXml = this.moduleConfigurationHandle.getBackendsXml();
        if (backendsXml == null) {
            this.logger.fine("Got null backendsXml config.");
            return;
        }
        List servers = backendsXml.getBackends();
        if (servers.isEmpty()) {
            this.logger.fine("No backends configured.");
            return;
        }
        if (!this.backendServers.isEmpty()) {
            throw new Exception("Tried to start backend servers but some are already running.");
        }
        this.logger.finer("Found " + servers.size() + " configured backends.");
        HashMap serverMap = Maps.newHashMap();
        for (BackendsXml.Entry entry : servers) {
            entry = this.resolveDefaults(entry);
            for (int serverInstance = -1; serverInstance < entry.getInstances(); ++serverInstance) {
                int port = this.checkForStaticPort(entry.getName(), serverInstance);
                ServerWrapper serverWrapper = new ServerWrapper(ContainerUtils.loadContainer(), entry, serverInstance, port);
                serverMap.put(new ServerInstanceEntry(entry.getName(), serverInstance), serverWrapper);
            }
        }
        this.backendServers = ImmutableMap.copyOf((Map)serverMap);
        String prettyAddress = this.address;
        if ("0.0.0.0".equals(this.address)) {
            prettyAddress = "127.0.0.1";
        }
        HashMap portMap = Maps.newHashMap();
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            this.logger.finer("starting server: " + serverWrapper.serverInstance + "." + serverWrapper.getName() + " on " + this.address + ":" + serverWrapper.port);
            ApiProxy.Delegate configured = ApiProxy.getDelegate();
            try {
                ApiProxy.setDelegate((ApiProxy.Delegate)local);
                serverWrapper.createConnection();
            }
            finally {
                ApiProxy.setDelegate((ApiProxy.Delegate)configured);
            }
            portMap.put(serverWrapper.getDnsPrefix(), prettyAddress + ":" + serverWrapper.port);
        }
        this.portMapping = ImmutableMap.copyOf((Map)portMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startupAll() throws Exception {
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            this.logger.finer("starting server: " + serverWrapper.serverInstance + "." + serverWrapper.getName() + " on " + this.address + ":" + serverWrapper.port);
            ApiProxy.Delegate configured = ApiProxy.getDelegate();
            try {
                ApiProxy.setDelegate((ApiProxy.Delegate)this.apiProxyLocal);
                serverWrapper.startup(false);
            }
            finally {
                ApiProxy.setDelegate((ApiProxy.Delegate)configured);
            }
        }
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            if (serverWrapper.isLoadBalanceServer()) continue;
            serverWrapper.sendStartRequest();
        }
    }

    private BackendsXml.Entry resolveDefaults(BackendsXml.Entry entry) {
        return new BackendsXml.Entry(entry.getName(), entry.getInstances() == null ? DEFAULT_INSTANCES : entry.getInstances(), entry.getInstanceClass() == null ? DEFAULT_INSTANCE_CLASS : entry.getInstanceClass(), entry.getMaxConcurrentRequests() == null ? DEFAULT_MAX_CONCURRENT_REQUESTS : entry.getMaxConcurrentRequests(), entry.getOptions(), entry.getState() == null ? BackendsXml.State.STOP : entry.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireServingPermit(String serverName, int instanceNumber, boolean allowQueueOnBackends) {
        this.logger.finest(String.format("trying to get serving permit for server %d.%s", instanceNumber, serverName));
        try {
            ServerWrapper server = this.getServerWrapper(serverName, instanceNumber);
            int maxQueueTime = 0;
            InstanceStateHolder instanceStateHolder = server.getStateHolder();
            synchronized (instanceStateHolder) {
                if (!server.getStateHolder().acceptsConnections()) {
                    this.logger.finest(String.valueOf(server) + ": got request but server is not in a serving state");
                    return false;
                }
                if (server.getApproximateQueueLength() > 20) {
                    this.logger.finest(String.valueOf(server) + ": server queue is full");
                    return false;
                }
                if (server.getStateHolder().test(InstanceStateHolder.InstanceState.SLEEPING)) {
                    this.logger.finest(String.valueOf(server) + ": waking up sleeping server");
                    server.sendStartRequest();
                }
                if (server.getStateHolder().test(InstanceStateHolder.InstanceState.RUNNING_START_REQUEST)) {
                    maxQueueTime = 30000;
                } else if (allowQueueOnBackends && server.getMaxPendingQueueSize() > 0) {
                    maxQueueTime = 10000;
                }
            }
            boolean gotPermit = server.acquireServingPermit(maxQueueTime);
            this.logger.finest(String.valueOf(server) + ": tried to get server permit, timeout=" + maxQueueTime + " success=" + gotPermit);
            return gotPermit;
        }
        catch (InterruptedException e) {
            this.logger.finest(instanceNumber + "." + serverName + ": got interrupted while waiting for serving permit");
            return false;
        }
    }

    public int getAndReserveFreeInstance(String requestedServer) {
        this.logger.finest("trying to get serving permit for server " + requestedServer);
        ServerWrapper server = this.getServerWrapper(requestedServer, -1);
        if (server == null) {
            return -1;
        }
        if (!server.getStateHolder().acceptsConnections()) {
            return -1;
        }
        int instanceNum = server.getInstances();
        for (int i = 0; i < instanceNum; ++i) {
            if (!this.acquireServingPermit(requestedServer, i, false)) continue;
            return i;
        }
        if (server.getMaxPendingQueueSize() > 0) {
            return this.addToShortestInstanceQueue(requestedServer);
        }
        this.logger.finest("no servers free");
        return -1;
    }

    int addToShortestInstanceQueue(String requestedServer) {
        this.logger.finest(requestedServer + ": no instances free, trying to find a queue");
        int shortestQueue = 20;
        ServerWrapper instanceWithShortestQueue = null;
        for (ServerWrapper server : this.backendServers.values()) {
            int serverQueue;
            if (!server.getStateHolder().acceptsConnections() || shortestQueue <= (serverQueue = server.getApproximateQueueLength())) continue;
            instanceWithShortestQueue = server;
            shortestQueue = serverQueue;
        }
        try {
            if (shortestQueue < 20) {
                this.logger.finest("adding request to queue on instance: " + String.valueOf(instanceWithShortestQueue));
                if (instanceWithShortestQueue.acquireServingPermit(10000)) {
                    this.logger.finest("ready to serve request on instance: " + String.valueOf(instanceWithShortestQueue));
                    return instanceWithShortestQueue.serverInstance;
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.finer("interrupted while queued at server " + String.valueOf(instanceWithShortestQueue));
        }
        return -1;
    }

    public void returnServingPermit(String serverName, int instance) {
        ServerWrapper server = this.getServerWrapper(serverName, instance);
        server.releaseServingPermit();
    }

    public int getPort(String serverName, int instance) {
        ServerWrapper server = this.getServerWrapper(serverName, instance);
        return server.port;
    }

    public boolean checkInstanceExists(String serverName, int instance) {
        return this.getServerWrapper(serverName, instance) != null;
    }

    public boolean checkServerExists(String serverName) {
        return this.checkInstanceExists(serverName, -1);
    }

    public boolean checkServerStopped(String serverName) {
        return this.checkInstanceStopped(serverName, -1);
    }

    public boolean checkInstanceStopped(String serverName, int instance) {
        return !this.getServerWrapper(serverName, instance).getStateHolder().acceptsConnections();
    }

    @Override
    public Map<String, String> getPortMapping() {
        return this.portMapping;
    }

    public int getServerInstanceFromPort(int port) {
        ServerWrapper server = this.getServerWrapperFromPort(port);
        if (server != null) {
            return server.serverInstance;
        }
        return -1;
    }

    public String getServerNameFromPort(int port) {
        ServerWrapper server = this.getServerWrapperFromPort(port);
        if (server != null) {
            return server.getName();
        }
        return null;
    }

    private ServerWrapper getServerWrapperFromPort(int port) {
        for (Map.Entry entry : this.backendServers.entrySet()) {
            if (((ServerWrapper)entry.getValue()).port != port) continue;
            return (ServerWrapper)entry.getValue();
        }
        return null;
    }

    protected ServerWrapper getServerWrapper(String serverName, int instanceNumber) {
        return (ServerWrapper)this.backendServers.get((Object)new ServerInstanceEntry(serverName, instanceNumber));
    }

    private int checkForStaticPort(String server, int instance) {
        StringBuilder key = new StringBuilder();
        key.append(SYSTEM_PROPERTY_STATIC_PORT_NUM_PREFIX);
        key.append(server);
        if (instance >= 0) {
            key.append("." + instance);
        }
        key.append(".port");
        String configuredPort = this.serviceProperties.get(key.toString());
        if (configuredPort != null) {
            return Integer.parseInt(configuredPort);
        }
        return 0;
    }

    protected class ServerWrapper {
        private final ContainerService container;
        private final int serverInstance;
        private int port;
        private final BackendsXml.Entry serverEntry;
        private final InstanceStateHolder stateHolder;
        private final InstanceHelper instanceHelper;
        private final Semaphore servingQueue = new Semaphore(0, true);

        public ServerWrapper(ContainerService containerService, BackendsXml.Entry serverEntry, int instance, int port) {
            this.container = containerService;
            this.serverEntry = serverEntry;
            this.serverInstance = instance;
            this.port = port;
            this.stateHolder = new InstanceStateHolder(serverEntry.getName(), instance);
            this.instanceHelper = new InstanceHelper(serverEntry.getName(), instance, this.stateHolder, this.container);
        }

        void shutdown() throws Exception {
            this.instanceHelper.shutdown();
        }

        void createConnection() throws Exception {
            this.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.INITIALIZING, InstanceStateHolder.InstanceState.SHUTDOWN);
            ImmutableMap instanceConfigProperties = ImmutableMap.builder().putAll(BackendServersBase.this.containerConfigProperties).put((Object)"com.google.appengine.backend.id", (Object)this.serverEntry.getName()).put((Object)"com.google.appengine.instance.id", (Object)this.serverInstance).buildOrThrow();
            this.getContainer().configure(ContainerUtils.getServerInfo(), BackendServersBase.this.address, this.port, BackendServersBase.this.moduleConfigurationHandle, BackendServersBase.this.externalResourceDir, (Map<String, Object>)instanceConfigProperties, this.serverInstance, BackendServersBase.this.devAppServer);
            this.getContainer().createConnection();
            this.getContainer().setApiProxyDelegate(BackendServersBase.this.apiProxyLocal);
            this.port = this.getContainer().getPort();
        }

        void startup(boolean setStateToStopped) throws Exception {
            this.getContainer().startup();
            if (setStateToStopped) {
                this.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.STOPPED, InstanceStateHolder.InstanceState.INITIALIZING);
            } else {
                BackendServersBase.this.logger.info("server: " + this.serverInstance + "." + this.serverEntry.getName() + " is running on port " + this.port);
                if (this.isLoadBalanceServer()) {
                    this.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.RUNNING, InstanceStateHolder.InstanceState.INITIALIZING);
                } else {
                    this.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.SLEEPING, InstanceStateHolder.InstanceState.INITIALIZING);
                }
            }
        }

        void sendStartRequest() {
            this.instanceHelper.sendStartRequest(new Runnable(){

                @Override
                public void run() {
                    ServerWrapper.this.servingQueue.release(ServerWrapper.this.serverEntry.getMaxConcurrentRequests());
                }
            });
        }

        boolean acquireServingPermit(int maxWaitTimeInMs) throws InterruptedException {
            BackendServersBase.this.logger.finest(String.valueOf(this) + ": acquiring serving permit, available: " + this.servingQueue.availablePermits());
            return this.servingQueue.tryAcquire(maxWaitTimeInMs, TimeUnit.MILLISECONDS);
        }

        void releaseServingPermit() {
            this.servingQueue.release();
            BackendServersBase.this.logger.finest(String.valueOf(this) + ": returned serving permit, available: " + this.servingQueue.availablePermits());
        }

        int getApproximateQueueLength() {
            return this.servingQueue.getQueueLength();
        }

        int getMaxPendingQueueSize() {
            return this.serverEntry.isFailFast() ? 0 : 20;
        }

        public String getDnsPrefix() {
            if (!this.isLoadBalanceServer()) {
                return this.serverInstance + "." + this.getName();
            }
            return this.getName();
        }

        String getName() {
            return this.serverEntry.getName();
        }

        public int getInstances() {
            return this.serverEntry.getInstances();
        }

        InstanceStateHolder getStateHolder() {
            return this.stateHolder;
        }

        boolean isLoadBalanceServer() {
            return this.serverInstance == -1;
        }

        public String toString() {
            return this.serverInstance + "." + this.serverEntry.getName() + " state=" + String.valueOf(this.stateHolder);
        }

        public ContainerService getContainer() {
            return this.container;
        }
    }

    static class ServerInstanceEntry {
        private final int instanceNumber;
        private final String serverName;

        public ServerInstanceEntry(String serverName, int instanceNumber) {
            this.serverName = serverName;
            this.instanceNumber = instanceNumber;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ServerInstanceEntry)) {
                return false;
            }
            ServerInstanceEntry that = (ServerInstanceEntry)o;
            if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) {
                return false;
            }
            return this.instanceNumber == that.instanceNumber;
        }

        public int hashCode() {
            int hash = 17;
            hash = 31 * hash + this.instanceNumber;
            if (this.serverName != null) {
                hash = 31 * hash + this.serverName.hashCode();
            }
            return hash;
        }

        public String toString() {
            return this.instanceNumber + "." + this.serverName;
        }
    }
}

