/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.LocalEnvironment;
import com.google.apphosting.api.ApiProxy;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackgroundThreadFactory
implements ThreadFactory {
    private static final Logger logger = Logger.getLogger(BackgroundThreadFactory.class.getName());
    private static final int API_CALL_LATENCY_MS = 20;
    private static final int THREAD_STARTUP_LATENCY_MS = 20;
    private final String appId;
    private final String moduleName;
    private final String majorVersionId;

    public BackgroundThreadFactory(String appId, String moduleName, String majorVersionId) {
        this.appId = appId;
        this.moduleName = moduleName;
        this.majorVersionId = majorVersionId;
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        final LocalBackgroundEnvironment environment = new LocalBackgroundEnvironment(this.appId, this.moduleName, this.majorVersionId, LocalEnvironment.getCurrentInstance(), LocalEnvironment.getCurrentPort());
        this.sleepUninterruptably(20L);
        Thread thread = new Thread(runnable){

            @Override
            public void run() {
                BackgroundThreadFactory.this.sleepUninterruptably(20L);
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)environment);
                try {
                    runnable.run();
                }
                finally {
                    environment.callRequestEndListeners();
                }
            }
        };
        System.setProperty("devappserver-thread-" + thread.getName(), "true");
        return thread;
    }

    final String getAppId() {
        return this.appId;
    }

    private void sleepUninterruptably(long sleepMillis) {
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException ex) {
            logger.log(Level.INFO, "Interrupted simulating latency:", ex);
            Thread.currentThread().interrupt();
        }
    }

    private static class LocalBackgroundEnvironment
    extends LocalEnvironment {
        public LocalBackgroundEnvironment(String appId, String moduleName, String majorVersionId, int instance, int port) {
            super(appId, moduleName, majorVersionId, instance, port, null);
        }

        public String getEmail() {
            return null;
        }

        public boolean isLoggedIn() {
            return false;
        }

        public boolean isAdmin() {
            return false;
        }
    }
}

