/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.init.AppEngineWebXmlInitialParse;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerClassLoader;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.config.WebXmlReader;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DevAppServerFactory {
    static final String DEV_APP_SERVER_CLASS = "com.google.appengine.tools.development.DevAppServerImpl";
    private static final Class<?>[] devAppserverCtorArgTypes = new Class[]{File.class, File.class, File.class, File.class, String.class, Integer.TYPE, Boolean.TYPE, Map.class, String.class};
    private static final String USER_CODE_CLASSPATH_MANAGER_PROP = "devappserver.userCodeClasspathManager";
    private static final String USER_CODE_CLASSPATH = "devappserver.userCodeClasspathManager.classpath";
    private static final String USER_CODE_REQUIRES_WEB_INF = "devappserver.userCodeClasspathManager.requiresWebInf";

    public DevAppServer createDevAppServer(File appDir, String address, int port) {
        return this.createDevAppServer(appDir, null, address, port);
    }

    public DevAppServer createDevAppServer(File appDir, File externalResourceDir, String address, int port) {
        return this.createDevAppServer(appDir, new File(new File(appDir, "WEB-INF"), "web.xml"), new File(new File(appDir, "WEB-INF"), "appengine-web.xml"), address, port, true, false, new HashMap<String, Object>(), false);
    }

    public DevAppServer createDevAppServer(File appDir, File externalResourceDir, String address, int port, boolean noJavaAgent) {
        return this.createDevAppServer(appDir, null, null, address, port, true, true, new HashMap<String, Object>(), noJavaAgent);
    }

    public DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Collection<URL> classpath) {
        Map<String, Object> containerConfigProps = this.newContainerConfigPropertiesForTest(classpath);
        return this.createDevAppServer(appDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProps, false);
    }

    public DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Collection<URL> classpath, boolean noJavaAgent) {
        Map<String, Object> containerConfigProps = this.newContainerConfigPropertiesForTest(classpath);
        return this.createDevAppServer(appDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProps, noJavaAgent);
    }

    public DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Map<String, Object> containerConfigProperties) {
        return this.createDevAppServer(appDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProperties, false);
    }

    public DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Map<String, Object> containerConfigProperties, boolean noJavaAgent) {
        return this.createDevAppServer(appDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProperties, noJavaAgent, null);
    }

    public DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Map<String, Object> containerConfigProperties, boolean noJavaAgent, String applicationId) {
        return this.doCreateDevAppServer(appDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, containerConfigProperties, applicationId);
    }

    private Map<String, Object> newContainerConfigPropertiesForTest(Collection<URL> classpath) {
        HashMap<String, Object> containerConfigProps = new HashMap<String, Object>();
        HashMap<String, Object> userCodeClasspathManagerProps = new HashMap<String, Object>();
        userCodeClasspathManagerProps.put(USER_CODE_CLASSPATH, classpath);
        userCodeClasspathManagerProps.put(USER_CODE_REQUIRES_WEB_INF, false);
        containerConfigProps.put(USER_CODE_CLASSPATH_MANAGER_PROP, userCodeClasspathManagerProps);
        return containerConfigProps;
    }

    private DevAppServer doCreateDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, Map<String, Object> containerConfigProperties, String applicationId) {
        DevAppServer devAppServer;
        if (webXmlLocation == null) {
            webXmlLocation = new File(appDir, "WEB-INF/web.xml");
        }
        if (appEngineWebXmlLocation == null) {
            appEngineWebXmlLocation = new File(appDir, "WEB-INF/appengine-web.xml");
        }
        new AppEngineWebXmlInitialParse(appEngineWebXmlLocation.getAbsolutePath()).handleRuntimeProperties();
        if (Boolean.getBoolean("appengine.use.EE8") || Boolean.getBoolean("appengine.use.EE10") || Boolean.getBoolean("appengine.use.EE11")) {
            AppengineSdk.resetSdk();
        }
        if (webXmlLocation.exists()) {
            WebXmlReader webXmlReader = new WebXmlReader(webXmlLocation.getAbsolutePath(), "");
            WebXml webXml = webXmlReader.readWebXml();
            webXml.validate();
        }
        DevAppServerClassLoader loader = DevAppServerClassLoader.newClassLoader(DevAppServerFactory.class.getClassLoader());
        try {
            Class<?> devAppServerClass = Class.forName(DEV_APP_SERVER_CLASS, false, loader);
            Constructor<?> cons = devAppServerClass.getConstructor(devAppserverCtorArgTypes);
            cons.setAccessible(true);
            devAppServer = (DevAppServer)cons.newInstance(appDir, null, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, containerConfigProperties, applicationId);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException) {
                t = e.getCause();
            }
            throw new RuntimeException("Unable to create a DevAppServer", t);
        }
        return devAppServer;
    }
}

