/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.tools.development.StreamHandlerFactory;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.security.urlfetch.URLFetchServiceStreamHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jspecify.annotations.Nullable;

public class LocalURLFetchServiceStreamHandler
extends URLFetchServiceStreamHandler {
    private static boolean useNativeHandlers = false;
    private final @Nullable URLStreamHandler fallbackHandler;
    private final Method openConnection1Arg;
    private final Method openConnection2Arg;

    public LocalURLFetchServiceStreamHandler(@Nullable URLStreamHandler fallbackHandler) {
        this.fallbackHandler = fallbackHandler;
        this.openConnection1Arg = StreamHandlerFactory.getDeclaredMethod(fallbackHandler.getClass(), "openConnection", URL.class);
        this.openConnection2Arg = StreamHandlerFactory.getDeclaredMethod(fallbackHandler.getClass(), "openConnection", URL.class, Proxy.class);
    }

    private boolean useFallBackHandler() {
        return this.fallbackHandler != null && (ApiProxy.getDelegate() == null || useNativeHandlers);
    }

    protected HttpURLConnection openConnection(URL u) throws IOException {
        if (this.useFallBackHandler()) {
            return (HttpURLConnection)StreamHandlerFactory.invoke(this.fallbackHandler, this.openConnection1Arg, u);
        }
        return super.openConnection(u);
    }

    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
        if (this.useFallBackHandler()) {
            return (HttpURLConnection)StreamHandlerFactory.invoke(this.fallbackHandler, this.openConnection2Arg, u, p);
        }
        return super.openConnection(u, p);
    }

    public URLStreamHandler getFallbackHandler() {
        return this.fallbackHandler;
    }

    public static void setUseNativeHandlers(boolean useNativeHandlers) {
        LocalURLFetchServiceStreamHandler.useNativeHandlers = useNativeHandlers;
    }

    @VisibleForTesting
    static boolean getUseNativeHandlers() {
        return useNativeHandlers;
    }
}

