/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.UserCodeClasspathManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

class WebAppUserCodeClasspathManager
implements UserCodeClasspathManager {
    private static final Logger log = Logger.getLogger(WebAppUserCodeClasspathManager.class.getName());

    WebAppUserCodeClasspathManager() {
    }

    @Override
    public Collection<URL> getUserCodeClasspath(File root) {
        ArrayList<URL> appUrls = new ArrayList<URL>();
        try {
            File classes = new File(new File(root, "WEB-INF"), "classes");
            if (classes.exists()) {
                appUrls.add(classes.toURI().toURL());
            }
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Could not add WEB-INF/classes", ex);
        }
        File libDir = new File(new File(root, "WEB-INF"), "lib");
        if (libDir.isDirectory()) {
            for (File file : libDir.listFiles()) {
                try {
                    appUrls.add(file.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    log.log(Level.WARNING, "Could not get URL for file: " + String.valueOf(file), ex);
                }
            }
        }
        return appUrls;
    }

    @Override
    public boolean requiresWebInf() {
        return true;
    }
}

