/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.io.protocol.RawMessage;
import com.google.appengine.repackaged.com.google.protobuf.BlockingRpcChannel;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.RpcCallback;
import com.google.appengine.repackaged.com.google.protobuf.RpcChannel;
import com.google.appengine.repackaged.com.google.protobuf.RpcController;
import com.google.appengine.repackaged.com.google.protobuf.ServiceException;
import com.google.appengine.repackaged.com.google.protobuf.UninitializedMessageException;
import com.google.appengine.repackaged.com.google.protobuf.bridge.DowngradedMessage;
import com.google.appengine.repackaged.com.google.protobuf.bridge.StubbyRpcController;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcException;
import com.google.net.rpc.RpcStreamingCallback;
import com.google.net.rpc.RpcStreamingListener;
import com.google.net.rpc.RpcStub;
import com.google.net.rpc.RpcStubFactory;
import com.google.net.rpc.RpcStubParameters;
import com.google.net.rpc3.impl.compatibility.Rpc1CompatibilityStub;
import com.google.net.ssl.SslSecurityLevel;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubbyChannel
extends Rpc1CompatibilityStub
implements RpcChannel,
BlockingRpcChannel {
    private static final RpcCallback<Message> NO_OP_CALLBACK = new RpcCallback<Message>(){

        @Override
        public void run(Message parameter) {
        }
    };
    private final RPC[] prototypeRpc;
    private final Descriptors.ServiceDescriptor serviceDescriptor;
    private final ExtensionRegistry extensionRegistry;

    public StubbyChannel(Descriptors.ServiceDescriptor descriptor, RpcStubParameters parameters) {
        this(descriptor, parameters, descriptor.getName());
    }

    public StubbyChannel(Descriptors.ServiceDescriptor descriptor, RpcStubParameters parameters, ExtensionRegistry registry) {
        this(descriptor, parameters, descriptor.getName(), registry);
    }

    public StubbyChannel(Descriptors.ServiceDescriptor serviceDescriptor, RpcStubParameters parameters, String serviceName) {
        this(serviceDescriptor, parameters, serviceName, ExtensionRegistry.getEmptyRegistry());
    }

    public StubbyChannel(Descriptors.ServiceDescriptor serviceDescriptor, RpcStubParameters parameters, String serviceName, ExtensionRegistry registry) {
        super(serviceName, parameters);
        this.serviceDescriptor = serviceDescriptor;
        this.extensionRegistry = Preconditions.checkNotNull(registry);
        List<Descriptors.MethodDescriptor> methodDescriptors = serviceDescriptor.getMethods();
        this.prototypeRpc = new RPC[methodDescriptors.size()];
        for (Descriptors.MethodDescriptor methodDescriptor : methodDescriptors) {
            DescriptorProtos.MethodOptions options = methodDescriptor.getOptions();
            RPC rpc = new RPC();
            if (options.hasSecurityLevel()) {
                rpc.setRequestedSecurityLevel(SslSecurityLevel.valueOf((String)options.getSecurityLevel().name()));
            }
            if (options.hasProtocol()) {
                rpc.setProtocol(RPC.Protocol.valueOf((String)options.getProtocol().name()));
            }
            if (options.hasDeadline()) {
                rpc.setDeadline(options.getDeadline());
            }
            if (options.hasDuplicateSuppression()) {
                rpc.setDuplicateSuppression(options.getDuplicateSuppression());
            }
            if (options.hasFailFast()) {
                rpc.setFailFast(options.getFailFast());
            }
            if (options.hasClientLogging()) {
                rpc.setClientLogging(options.getClientLogging());
            }
            if (options.hasServerLogging()) {
                rpc.setServerLogging(options.getServerLogging());
            }
            if (options.hasResponseFormat()) {
                rpc.setResponseFormat(RPC.Format.valueOf((String)options.getResponseFormat().name()));
            }
            rpc.internalSetMethodName("/" + serviceName + "." + methodDescriptor.getName());
            this.prototypeRpc[methodDescriptor.getIndex()] = rpc;
        }
    }

    @Override
    public void callMethod(Descriptors.MethodDescriptor methodDescriptor, RpcController rpcController, Message request, Message responsePrototype, RpcCallback<Message> done) {
        try {
            this.callMethod(methodDescriptor, rpcController, request, responsePrototype, done, IsBlocking.NO);
        }
        catch (ServiceException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    @Override
    public Message callBlockingMethod(Descriptors.MethodDescriptor methodDescriptor, RpcController rpcController, Message request, Message responsePrototype) throws ServiceException {
        return this.callMethod(methodDescriptor, rpcController, request, responsePrototype, NO_OP_CALLBACK, IsBlocking.YES);
    }

    private Message callMethod(Descriptors.MethodDescriptor methodDescriptor, RpcController rpcController, Message request, Message responsePrototype, RpcCallback<Message> done, IsBlocking isBlocking) throws ServiceException {
        Message streamPrototype;
        String streamType;
        if (methodDescriptor.getService() != this.serviceDescriptor) {
            throw new IllegalArgumentException("Method isn't part of service");
        }
        StubbyRpcController controller = (StubbyRpcController)rpcController;
        String string = streamType = methodDescriptor.getOptions().hasStreamType() ? methodDescriptor.getOptions().getStreamType() : null;
        if (streamType != null && (streamPrototype = controller.getStreamingPrototype()) != null && !streamPrototype.getDescriptorForType().getFullName().equals(streamType)) {
            throw new UnsupportedOperationException("Bad prototype in callback");
        }
        String methodName = methodDescriptor.getName();
        DowngradedMessage bridgedRequest = new DowngradedMessage(request, this.extensionRegistry);
        DowngradedMessage bridgedResponse = new DowngradedMessage(responsePrototype, this.extensionRegistry);
        RpcStreamingCallback<RawMessage> callback = this.newCallback(controller, bridgedResponse, done);
        RPC rpc = controller.getStubbyRpc();
        RPC proto = this.prototypeRpc[methodDescriptor.getIndex()];
        if (isBlocking == IsBlocking.YES) {
            try {
                if (streamType == null) {
                    this.startBlockingRpc(rpc, proto.methodName(), methodName, bridgedRequest, bridgedResponse, proto);
                } else {
                    this.startStreamingBlockingRpc(rpc, proto.methodName(), methodName, bridgedRequest, bridgedResponse, RawMessage.IMMUTABLE_DEFAULT_INSTANCE, (RpcStreamingListener)callback, proto);
                }
                return bridgedResponse.getProto2Message();
            }
            catch (RpcException cause) {
                ServiceException e = new ServiceException(cause.getMessage());
                e.initCause(cause);
                throw e;
            }
        }
        if (streamType == null) {
            this.startNonBlockingRpc(rpc, proto.methodName(), methodName, bridgedRequest, bridgedResponse, (com.google.net.rpc.RpcCallback)callback, proto);
        } else {
            this.startStreamingRpc(rpc, proto.methodName(), methodName, bridgedRequest, bridgedResponse, RawMessage.IMMUTABLE_DEFAULT_INSTANCE, callback, proto);
        }
        return null;
    }

    public static RpcStubFactory newFactory(final Descriptors.ServiceDescriptor descriptor) {
        return new RpcStubFactory(){

            public RpcStub newRpcStub(RpcStubParameters params) {
                return new StubbyChannel(descriptor, params);
            }
        };
    }

    private RpcStreamingCallback<RawMessage> newCallback(final StubbyRpcController controller, final DowngradedMessage bridgedResponse, final RpcCallback<Message> done) {
        return new RpcStreamingCallback<RawMessage>(){

            public void rpcFinished() {
                done.run(bridgedResponse.getProto2Message());
            }

            public void streamReady(RawMessage stream) {
                RPC rpc = controller.getStubbyRpc();
                Message streamPrototype = controller.getStreamingPrototype();
                if (streamPrototype != null && (rpc.status() == RPC.Status.OK || rpc.status() == RPC.Status.ACTIVE)) {
                    try {
                        Message.Builder builder = streamPrototype.newBuilderForType();
                        Message message = builder.mergeFrom(stream.toByteArray(), (ExtensionRegistryLite)StubbyChannel.this.extensionRegistry).build();
                        controller.streamReady(message);
                    }
                    catch (InvalidProtocolBufferException e) {
                        rpc.internalSetStatus(RPC.Status.SERVER_ERROR);
                        rpc.internalSetErrorDetail("client could not parse server reply");
                    }
                    catch (UninitializedMessageException e) {
                        rpc.internalSetStatus(RPC.Status.SERVER_ERROR);
                        rpc.internalSetErrorDetail("client could not parse server reply");
                    }
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IsBlocking {
        YES,
        NO;

    }
}

