/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache.jsr107cache;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.memcache.Stats;
import com.google.appengine.api.memcache.jsr107cache.GCacheEntry;
import com.google.appengine.api.memcache.jsr107cache.GCacheException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheEntry;
import net.sf.jsr107cache.CacheListener;
import net.sf.jsr107cache.CacheStatistics;

public class GCache
implements Cache {
    private final MemcacheService service;
    private final List<CacheListener> listeners = new ArrayList<CacheListener>();
    private final Expiration expiration;
    private final MemcacheService.SetPolicy setPolicy;
    private final boolean throwOnPutFailure;

    public GCache(Map<?, ?> map) {
        if (map != null) {
            Object object;
            Object obj = map.get("com.google.appengine.api.memcache.jsr107cache.EXPIRATION_DELTA");
            int n = 0;
            if (obj instanceof Integer) {
                n = (Integer)obj * 1000;
            }
            if ((obj = map.get("com.google.appengine.api.memcache.jsr107cache.EXPIRATION_DELTA_MILLIS")) instanceof Integer) {
                n = (Integer)obj;
            }
            this.expiration = n != 0 ? Expiration.byDeltaMillis((int)n) : ((obj = map.get("com.google.appengine.api.memcache.jsr107cache.EXPIRATION")) instanceof Date ? Expiration.onDate((Date)((Date)obj)) : null);
            Object obj2 = map.get("com.google.appengine.api.memcache.jsr107cache.SET_POLICY");
            this.setPolicy = obj2 instanceof MemcacheService.SetPolicy ? (MemcacheService.SetPolicy)obj2 : MemcacheService.SetPolicy.SET_ALWAYS;
            Object obj3 = map.get("com.google.appengine.api.memcache.jsr107cache.MEMCACHE_SERVICE");
            if (obj3 instanceof MemcacheService) {
                this.service = (MemcacheService)obj3;
            } else {
                object = map.get("com.google.appengine.api.memcache.jsr107cache.NAMESPACE");
                if (!(object instanceof String)) {
                    object = null;
                }
                this.service = MemcacheServiceFactory.getMemcacheService((String)((String)object));
            }
            object = (Boolean)map.get("com.google.appengine.api.memcache.jsr107cache.THROW_ON_PUT_FAILURE");
            this.throwOnPutFailure = object instanceof Boolean ? (Boolean)object : false;
        } else {
            this.expiration = null;
            this.throwOnPutFailure = false;
            this.setPolicy = MemcacheService.SetPolicy.SET_ALWAYS;
            this.service = MemcacheServiceFactory.getMemcacheService();
        }
    }

    public void addListener(CacheListener cacheListener) {
        this.listeners.add(cacheListener);
    }

    public void evict() {
    }

    public Map getAll(Collection collection) {
        Collection collection2 = collection;
        return this.service.getAll(collection2);
    }

    public CacheEntry getCacheEntry(Object object) {
        Object object2 = this.service.get(object);
        if (object2 == null && !this.service.contains(object)) {
            return null;
        }
        return new GCacheEntry(this, object, object2);
    }

    public CacheStatistics getCacheStatistics() {
        return new GCacheStats(this.service.getStatistics());
    }

    public void load(Object object) {
        throw new UnsupportedOperationException();
    }

    public void loadAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object peek(Object object) {
        return this.get(object);
    }

    public void removeListener(CacheListener cacheListener) {
        this.listeners.remove(cacheListener);
    }

    public int size() {
        return this.getCacheStatistics().getObjectCount();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object object) {
        return this.service.contains(object);
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object get(Object object) {
        return this.service.get(object);
    }

    public Object put(Object object, Object object2) {
        for (CacheListener cacheListener : this.listeners) {
            cacheListener.onPut(object2);
        }
        boolean bl = this.service.put(object, object2, this.expiration, this.setPolicy);
        if (!bl && this.throwOnPutFailure) {
            throw new GCacheException("Policy prevented put operation");
        }
        return null;
    }

    public Object remove(Object object) {
        for (CacheListener cacheListener : this.listeners) {
            cacheListener.onRemove(object);
        }
        Object object2 = this.service.get(object);
        this.service.delete(object);
        return object2;
    }

    public void putAll(Map map) {
        Set set = this.service.putAll(map, this.expiration, this.setPolicy);
        if (this.throwOnPutFailure && set.size() < map.size()) {
            throw new GCacheException("Policy prevented some put operations");
        }
    }

    public void clear() {
        for (CacheListener cacheListener : this.listeners) {
            cacheListener.onClear();
        }
        this.service.clearAll();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class GCacheStats
    implements CacheStatistics {
        private Stats stats;

        private GCacheStats(Stats stats) {
            this.stats = stats;
        }

        public void clearStatistics() {
            throw new UnsupportedOperationException();
        }

        public int getCacheHits() {
            return (int)this.stats.getHitCount();
        }

        public int getCacheMisses() {
            return (int)this.stats.getMissCount();
        }

        public int getObjectCount() {
            return (int)this.stats.getItemCount();
        }

        public int getStatisticsAccuracy() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.stats.toString();
        }
    }
}

