/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.org.apache.http.cookie.Cookie;
import com.google.appengine.tools.remoteapi.BaseRemoteApiClient;
import com.google.appengine.tools.remoteapi.LegacyResponse;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AppEngineClient
extends BaseRemoteApiClient {
    private final String userEmail;
    private final Cookie[] authCookies;
    private final int maxResponseSize;

    AppEngineClient(RemoteApiOptions options, List<Cookie> authCookies, @Nullable String appId) {
        super(options, appId);
        if (options == null) {
            throw new IllegalArgumentException("options not set");
        }
        if (authCookies == null) {
            throw new IllegalArgumentException("authCookies not set");
        }
        this.userEmail = options.getUserEmail();
        this.authCookies = authCookies.toArray(new Cookie[0]);
        this.maxResponseSize = options.getMaxHttpResponseSize();
    }

    @Override
    public String serializeCredentials() {
        StringBuilder out = new StringBuilder();
        out.append("host=" + this.getHostname() + "\n");
        out.append("email=" + this.userEmail + "\n");
        for (Cookie cookie : this.authCookies) {
            out.append("cookie=" + cookie.getName() + "=" + cookie.getValue() + "\n");
        }
        return out.toString();
    }

    Cookie[] getAuthCookies() {
        return this.authCookies;
    }

    int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    List<String[]> getHeadersForPost(String mimeType) {
        List<String[]> headers = this.getHeadersBase();
        headers.add(new String[]{"Content-type", mimeType});
        return headers;
    }

    List<String[]> getHeadersForGet() {
        return this.getHeadersBase();
    }

    abstract LegacyResponse legacyPost(String var1, String var2, byte[] var3) throws IOException;

    abstract LegacyResponse legacyGet(String var1) throws IOException;

    static class Response {
        private final int statusCode;
        private final byte[] responseBody;
        private final Charset responseCharset;

        Response(int statusCode, byte[] responseBody, Charset responseCharset) {
            this.statusCode = statusCode;
            this.responseBody = responseBody;
            this.responseCharset = responseCharset == null ? StandardCharsets.UTF_8 : responseCharset;
        }

        int getStatusCode() {
            return this.statusCode;
        }

        byte[] getBodyAsBytes() {
            return this.responseBody;
        }

        String getBodyAsString() {
            return new String(this.responseBody, this.responseCharset);
        }
    }
}

