/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class LoginCookieUtils {
    public static final String COOKIE_PATH = "/";
    public static final String COOKIE_NAME = "dev_appserver_login";
    private static final int COOKIE_AGE = -1;

    static Cookie createCookie(String email, boolean isAdmin) {
        String userId = LoginCookieUtils.encodeEmailAsUserId(email);
        Cookie cookie = new Cookie(COOKIE_NAME, email + ":" + isAdmin + ":" + userId);
        cookie.setPath(COOKIE_PATH);
        cookie.setMaxAge(-1);
        return cookie;
    }

    static void removeCookie(HttpServletRequest req, HttpServletResponse resp) {
        Cookie cookie = LoginCookieUtils.findCookie(req);
        if (cookie != null) {
            cookie.setPath(COOKIE_PATH);
            cookie.setMaxAge(0);
            resp.addCookie(cookie);
        }
    }

    static CookieData getCookieData(HttpServletRequest req) {
        Cookie cookie = LoginCookieUtils.findCookie(req);
        if (cookie == null) {
            return null;
        }
        return LoginCookieUtils.parseCookie(cookie);
    }

    static String encodeEmailAsUserId(String email) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(email.toLowerCase().getBytes(StandardCharsets.UTF_8));
            StringBuilder builder = new StringBuilder();
            builder.append("1");
            for (byte b : md5.digest()) {
                builder.append(String.format("%02d", b & 0xFF));
            }
            return builder.toString().substring(0, 21);
        }
        catch (NoSuchAlgorithmException ex) {
            return "";
        }
    }

    static CookieData parseCookie(Cookie cookie) {
        String value = cookie.getValue();
        String[] parts = value.split(":");
        String userId = null;
        if (parts.length > 2) {
            userId = parts[2];
        }
        return new CookieData(parts[0], Boolean.parseBoolean(parts[1]), userId);
    }

    private static Cookie findCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(COOKIE_NAME)) continue;
                return cookie;
            }
        }
        return null;
    }

    private LoginCookieUtils() {
    }

    public static final class CookieData {
        private final String email;
        private final boolean isAdmin;
        private final String userId;

        CookieData(String email, boolean isAdmin, String userId) {
            this.email = email;
            this.isAdmin = isAdmin;
            this.userId = userId;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public String getUserId() {
            return this.userId;
        }
    }
}

