/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.org.apache.http.cookie.Cookie;
import com.google.appengine.repackaged.org.apache.http.impl.cookie.BasicClientCookie;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.HostedAppEngineClient;
import com.google.appengine.tools.remoteapi.HostedClientLogin;
import com.google.appengine.tools.remoteapi.LoginCookieUtils;
import com.google.appengine.tools.remoteapi.OAuthClient;
import com.google.appengine.tools.remoteapi.RemoteApiClient;
import com.google.appengine.tools.remoteapi.RemoteApiDelegate;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.appengine.tools.remoteapi.RemoteRpc;
import com.google.appengine.tools.remoteapi.StandaloneAppEngineClient;
import com.google.appengine.tools.remoteapi.StandaloneClientLogin;
import com.google.appengine.tools.remoteapi.ThreadLocalDelegate;
import com.google.appengine.tools.remoteapi.ToolEnvironment;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RemoteApiInstaller {
    private static final Pattern PAIR_REGEXP = Pattern.compile("([a-z0-9_-]+): +(['\\\"]?)([:~.a-z0-9_-]+)\\2");
    static final String DATASTORE_APP_ID_OVERRIDE_KEY = "com.google.appengine.datastore.AppIdOverride";
    private static ConsoleHandler remoteMethodHandler;
    private InstallerState installerState;
    private static boolean installedForAllThreads;

    private static synchronized StreamHandler getStreamHandler() {
        if (remoteMethodHandler == null) {
            remoteMethodHandler = new ConsoleHandler();
            remoteMethodHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + "\n";
                }
            });
            remoteMethodHandler.setLevel(Level.FINE);
        }
        return remoteMethodHandler;
    }

    void validateOptions(RemoteApiOptions options) {
        if (options.getHostname() == null) {
            throw new IllegalArgumentException("server not set in options");
        }
        if (options.getUserEmail() == null && options.getOAuthCredential() == null) {
            throw new IllegalArgumentException("credentials not set in options");
        }
    }

    private boolean installed() {
        return this.installerState != null || installedForAllThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installOnAllThreads(RemoteApiOptions options) throws IOException {
        final RemoteApiOptions finalOptions = options.copy();
        this.validateOptions(finalOptions);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.installed()) {
                throw new IllegalStateException("remote API is already installed");
            }
            installedForAllThreads = true;
            final RemoteApiClient client = this.login(finalOptions);
            ApiProxy.Delegate originalDelegate = ApiProxy.getDelegate();
            RemoteApiDelegate globalRemoteApiDelegate = this.createDelegate(finalOptions, client, (ApiProxy.Delegate<ApiProxy.Environment>)originalDelegate);
            ApiProxy.setDelegate((ApiProxy.Delegate)globalRemoteApiDelegate);
            ApiProxy.setEnvironmentFactory((ApiProxy.EnvironmentFactory)new ApiProxy.EnvironmentFactory(){

                public ApiProxy.Environment newEnvironment() {
                    return RemoteApiInstaller.this.createEnv(finalOptions, client);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(RemoteApiOptions options) throws IOException {
        options = options.copy();
        this.validateOptions(options);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            RemoteApiDelegate remoteApiDelegate;
            if (this.installed()) {
                throw new IllegalStateException("remote API is already installed");
            }
            ApiProxy.Delegate originalDelegate = ApiProxy.getDelegate();
            ApiProxy.Environment originalEnv = ApiProxy.getCurrentEnvironment();
            RemoteApiClient installedClient = this.login(options);
            if (originalDelegate instanceof ThreadLocalDelegate) {
                ThreadLocalDelegate installedDelegate = (ThreadLocalDelegate)originalDelegate;
                ApiProxy.Delegate globalDelegate = installedDelegate.getGlobalDelegate();
                remoteApiDelegate = this.createDelegate(options, installedClient, globalDelegate);
                if (installedDelegate.getDelegateForThread() != null) {
                    throw new IllegalStateException("remote API is already installed");
                }
                installedDelegate.setDelegateForThread(remoteApiDelegate);
            } else {
                remoteApiDelegate = this.createDelegate(options, installedClient, (ApiProxy.Delegate<ApiProxy.Environment>)originalDelegate);
                ApiProxy.setDelegate(new ThreadLocalDelegate<ApiProxy.Environment>(originalDelegate, remoteApiDelegate));
            }
            ApiProxy.Environment installedEnv = null;
            String appIdOverrideToRestore = null;
            if (originalEnv == null) {
                installedEnv = this.createEnv(options, installedClient);
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)installedEnv);
            } else {
                appIdOverrideToRestore = (String)originalEnv.getAttributes().get(DATASTORE_APP_ID_OVERRIDE_KEY);
                originalEnv.getAttributes().put(DATASTORE_APP_ID_OVERRIDE_KEY, installedClient.getAppId());
            }
            this.installerState = new InstallerState(originalEnv, installedClient, remoteApiDelegate, installedEnv, appIdOverrideToRestore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (installedForAllThreads) {
                throw new IllegalArgumentException("cannot uninstall the remote API after installing on all threads");
            }
            if (this.installerState == null) {
                throw new IllegalArgumentException("remote API is already uninstalled");
            }
            if (this.installerState.installedEnv != null && this.installerState.installedEnv != ApiProxy.getCurrentEnvironment()) {
                throw new IllegalStateException("Can't uninstall because the current environment has been modified.");
            }
            ApiProxy.Delegate currentDelegate = ApiProxy.getDelegate();
            if (!(currentDelegate instanceof ThreadLocalDelegate)) {
                throw new IllegalStateException("Can't uninstall because the current delegate has been modified.");
            }
            ThreadLocalDelegate tld = (ThreadLocalDelegate)currentDelegate;
            if (tld.getDelegateForThread() == null) {
                throw new IllegalArgumentException("remote API is already uninstalled");
            }
            tld.clearThreadDelegate();
            if (this.installerState.installedEnv != null) {
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this.installerState.originalEnv);
            } else if (this.installerState.appIdOverrideToRestore != null) {
                ApiProxy.getCurrentEnvironment().getAttributes().put(DATASTORE_APP_ID_OVERRIDE_KEY, this.installerState.appIdOverrideToRestore);
            } else {
                ApiProxy.getCurrentEnvironment().getAttributes().remove(DATASTORE_APP_ID_OVERRIDE_KEY);
            }
            this.installerState.remoteApiDelegate.shutdown();
            this.installerState = null;
        }
    }

    public String serializeCredentials() {
        return this.installerState.installedClient.serializeCredentials();
    }

    public void logMethodCalls() {
        Logger logger = Logger.getLogger(RemoteApiDelegate.class.getName());
        logger.setLevel(Level.FINE);
        if (!Arrays.asList(logger.getHandlers()).contains(RemoteApiInstaller.getStreamHandler())) {
            logger.addHandler(RemoteApiInstaller.getStreamHandler());
        }
    }

    public void resetRpcCount() {
        this.installerState.remoteApiDelegate.resetRpcCount();
    }

    public int getRpcCount() {
        return this.installerState.remoteApiDelegate.getRpcCount();
    }

    RemoteApiClient login(RemoteApiOptions options) throws IOException {
        return this.loginImpl(options);
    }

    RemoteApiDelegate createDelegate(RemoteApiOptions options, RemoteApiClient client, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ApiProxy.Delegate<// Could not load outer class - annotation placement on inner may be incorrect
    ApiProxy.Environment> originalDelegate) {
        return RemoteApiDelegate.newInstance(new RemoteRpc(client), options, originalDelegate);
    }

    ApiProxy.Environment createEnv(RemoteApiOptions options, RemoteApiClient client) {
        return new ToolEnvironment(client.getAppId(), options.getUserEmail());
    }

    private RemoteApiClient loginImpl(RemoteApiOptions options) throws IOException {
        List<Cookie> authCookies = !this.authenticationRequiresCookies(options) ? Collections.emptyList() : (options.getCredentialsToReuse() != null ? RemoteApiInstaller.parseSerializedCredentials(options.getUserEmail(), options.getHostname(), options.getCredentialsToReuse()) : (options.getHostname().equals("localhost") ? Collections.singletonList(RemoteApiInstaller.makeDevAppServerCookie(options.getHostname(), options.getUserEmail())) : (ApiProxy.getCurrentEnvironment() != null ? new HostedClientLogin().login(options.getHostname(), options.getUserEmail(), options.getPassword()) : new StandaloneClientLogin().login(options.getHostname(), options.getUserEmail(), options.getPassword()))));
        String appId = this.getAppIdFromServer(authCookies, options);
        return this.createAppEngineClient(options, authCookies, appId);
    }

    boolean authenticationRequiresCookies(RemoteApiOptions options) {
        return options.getOAuthCredential() == null;
    }

    RemoteApiClient createAppEngineClient(RemoteApiOptions options, List<Cookie> authCookies, @Nullable String appId) {
        if (options.getOAuthCredential() != null) {
            return new OAuthClient(options, appId);
        }
        if (ApiProxy.getCurrentEnvironment() != null) {
            return new HostedAppEngineClient(options, authCookies, appId);
        }
        return new StandaloneAppEngineClient(options, authCookies, appId);
    }

    public static Cookie makeDevAppServerCookie(String hostname, String email) {
        String cookieValue = email + ":true:" + LoginCookieUtils.encodeEmailAsUserId(email);
        BasicClientCookie cookie = new BasicClientCookie("dev_appserver_login", cookieValue);
        cookie.setDomain(hostname);
        cookie.setPath("/");
        return cookie;
    }

    String getAppIdFromServer(List<Cookie> authCookies, RemoteApiOptions options) throws IOException {
        RemoteApiClient tempClient = this.createAppEngineClient(options, authCookies, null);
        AppEngineClient.Response response = tempClient.get(options.getRemoteApiPath());
        int status = response.getStatusCode();
        if (status != 200) {
            if (response.getBodyAsBytes() == null) {
                throw new IOException("can't get appId from remote api; status code = " + status);
            }
            throw new IOException("can't get appId from remote api; status code = " + status + ", body: " + response.getBodyAsString());
        }
        String body = response.getBodyAsString();
        ImmutableMap<String, String> props = RemoteApiInstaller.parseYamlMap(body);
        String appId = (String)props.get("app_id");
        if (appId == null) {
            throw new IOException("unexpected response from remote api: " + body);
        }
        return appId;
    }

    static ImmutableMap<String, String> parseYamlMap(String input) {
        String[] pairs;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (!(input = input.trim()).startsWith("{") || !input.endsWith("}")) {
            return ImmutableMap.of();
        }
        input = input.substring(1, input.length() - 1);
        for (String pair : pairs = input.split(", +")) {
            Matcher matcher = PAIR_REGEXP.matcher(pair);
            if (!matcher.matches()) continue;
            result.put(matcher.group(1), matcher.group(3));
        }
        return ImmutableMap.copyOf(result);
    }

    static List<Cookie> parseSerializedCredentials(String expectedEmail, String expectedHost, String serializedCredentials) throws IOException {
        Map<String, List<String>> props = RemoteApiInstaller.parseProperties(serializedCredentials);
        RemoteApiInstaller.checkOneProperty(props, "email");
        RemoteApiInstaller.checkOneProperty(props, "host");
        String email = props.get("email").get(0);
        if (!expectedEmail.equals(email)) {
            throw new IOException("credentials don't match current user email");
        }
        String host = props.get("host").get(0);
        if (!expectedHost.equals(host)) {
            throw new IOException("credentials don't match current host");
        }
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        for (String line : props.get("cookie")) {
            result.add(RemoteApiInstaller.parseCookie(line, host));
        }
        return result;
    }

    private static Cookie parseCookie(String line, String host) throws IOException {
        int firstEqual = line.indexOf(61);
        if (firstEqual < 1) {
            throw new IOException("invalid cookie in credentials");
        }
        String key = line.substring(0, firstEqual);
        String value = line.substring(firstEqual + 1);
        BasicClientCookie cookie = new BasicClientCookie(key, value);
        cookie.setDomain(host);
        cookie.setPath("/");
        return cookie;
    }

    private static void checkOneProperty(Map<String, List<String>> props, String key) throws IOException {
        if (props.get(key).size() != 1) {
            String message = "invalid credential file (should have one property named '" + key + "')";
            throw new IOException(message);
        }
    }

    private static Map<String, List<String>> parseProperties(String serializedCredentials) {
        LinkedHashMap<String, List<String>> props = new LinkedHashMap<String, List<String>>();
        for (String line : serializedCredentials.split("\n")) {
            if ((line = line.trim()).startsWith("#") || !line.contains("=")) continue;
            int firstEqual = line.indexOf(61);
            String key = line.substring(0, firstEqual);
            String value = line.substring(firstEqual + 1);
            ArrayList<String> values = (ArrayList<String>)props.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                props.put(key, values);
            }
            values.add(value);
        }
        return props;
    }

    static {
        installedForAllThreads = false;
    }

    private static class InstallerState {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ApiProxy.Environment originalEnv;
        private final RemoteApiClient installedClient;
        private final RemoteApiDelegate remoteApiDelegate;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ApiProxy.Environment installedEnv;
        @Nullable String appIdOverrideToRestore;

        InstallerState(ApiProxy.Environment originalEnv, RemoteApiClient installedClient, RemoteApiDelegate remoteApiDelegate, ApiProxy.Environment installedEnv, String appIdOverrideToRestore) {
            this.originalEnv = originalEnv;
            this.installedClient = installedClient;
            this.remoteApiDelegate = remoteApiDelegate;
            this.installedEnv = installedEnv;
            this.appIdOverrideToRestore = appIdOverrideToRestore;
        }
    }
}

