/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.org.apache.http.HttpEntity;
import com.google.appengine.repackaged.org.apache.http.HttpResponse;
import com.google.appengine.repackaged.org.apache.http.client.CookieStore;
import com.google.appengine.repackaged.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpGet;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpPost;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpUriRequest;
import com.google.appengine.repackaged.org.apache.http.cookie.Cookie;
import com.google.appengine.repackaged.org.apache.http.entity.ContentType;
import com.google.appengine.repackaged.org.apache.http.impl.client.BasicCookieStore;
import com.google.appengine.repackaged.org.apache.http.impl.client.CloseableHttpClient;
import com.google.appengine.repackaged.org.apache.http.impl.client.HttpClientBuilder;
import com.google.appengine.repackaged.org.apache.http.message.BasicNameValuePair;
import com.google.appengine.tools.remoteapi.ClientLogin;
import com.google.appengine.tools.remoteapi.LoginException;
import com.google.appengine.tools.remoteapi.StandaloneAppEngineClient;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class StandaloneClientLogin
extends ClientLogin {
    private static final int MAX_RESPONSE_SIZE = 0x100000;

    StandaloneClientLogin() {
    }

    @Override
    ClientLogin.PostResponse executePost(String url, List<String[]> postParams) throws IOException {
        HttpPost post = new HttpPost(url);
        List params = postParams.stream().map(strings -> new BasicNameValuePair(strings[0], strings[1])).collect(Collectors.toList());
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpResponse response = client.execute((HttpUriRequest)post);
        byte[] responseBytes = StandaloneAppEngineClient.responseBytes(response, 0x100000);
        Charset charset = ContentType.get((HttpEntity)response.getEntity()).getCharset();
        String body = new String(responseBytes, charset);
        return new ClientLogin.PostResponse(response.getStatusLine().getStatusCode(), body);
    }

    @Override
    List<Cookie> getAppEngineLoginCookies(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).disableRedirectHandling().build();
        HttpResponse response = client.execute((HttpUriRequest)get);
        if (response.getStatusLine().getStatusCode() == 302) {
            return new ArrayList<Cookie>(cookieStore.getCookies());
        }
        throw new LoginException("unexpected response from app engine: " + response.getStatusLine());
    }
}

