/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.json.gson;

import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.json.JsonGenerator;
import com.google.appengine.repackaged.com.google.api.client.json.gson.GsonFactory;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

class GsonGenerator
extends JsonGenerator {
    private final JsonWriter writer;
    private final GsonFactory factory;

    GsonGenerator(GsonFactory factory, JsonWriter writer) {
        this.factory = factory;
        this.writer = writer;
        writer.setLenient(true);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public JsonFactory getFactory() {
        return this.factory;
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        this.writer.value(state);
    }

    @Override
    public void writeEndArray() throws IOException {
        this.writer.endArray();
    }

    @Override
    public void writeEndObject() throws IOException {
        this.writer.endObject();
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        this.writer.name(name);
    }

    @Override
    public void writeNull() throws IOException {
        this.writer.nullValue();
    }

    @Override
    public void writeNumber(int v) throws IOException {
        this.writer.value((long)v);
    }

    @Override
    public void writeNumber(long v) throws IOException {
        this.writer.value(v);
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException {
        this.writer.value((Number)v);
    }

    @Override
    public void writeNumber(double v) throws IOException {
        this.writer.value(v);
    }

    @Override
    public void writeNumber(float v) throws IOException {
        this.writer.value(v);
    }

    @Override
    public void writeNumber(BigDecimal v) throws IOException {
        this.writer.value((Number)v);
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException {
        this.writer.value((Number)new StringNumber(encodedValue));
    }

    @Override
    public void writeStartArray() throws IOException {
        this.writer.beginArray();
    }

    @Override
    public void writeStartObject() throws IOException {
        this.writer.beginObject();
    }

    @Override
    public void writeString(String value) throws IOException {
        this.writer.value(value);
    }

    @Override
    public void enablePrettyPrint() throws IOException {
        this.writer.setIndent("  ");
    }

    static final class StringNumber
    extends Number {
        private static final long serialVersionUID = 1L;
        private final String encodedValue;

        StringNumber(String encodedValue) {
            this.encodedValue = encodedValue;
        }

        @Override
        public double doubleValue() {
            return 0.0;
        }

        @Override
        public float floatValue() {
            return 0.0f;
        }

        @Override
        public int intValue() {
            return 0;
        }

        @Override
        public long longValue() {
            return 0L;
        }

        public String toString() {
            return this.encodedValue;
        }
    }
}

