/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.com.google.api.client.http.AbstractHttpContent;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpHeaders;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.BaseRemoteApiClient;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class OAuthClient
extends BaseRemoteApiClient {
    private final HttpRequestFactory requestFactory;

    OAuthClient(RemoteApiOptions options, String appId) {
        super(options, appId);
        if (options.getOAuthCredential() == null) {
            throw new IllegalArgumentException("options does not contain an OAuth credential");
        }
        if (options.getHttpTransport() == null) {
            throw new IllegalStateException("options does not contain an HttpTransport");
        }
        this.requestFactory = options.getHttpTransport().createRequestFactory(options.getOAuthCredential());
    }

    @Override
    public String serializeCredentials() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AppEngineClient.Response post(String path, String mimeType, byte[] body) throws IOException {
        ByteArrayHttpContent content = new ByteArrayHttpContent(mimeType, body);
        HttpRequest request = this.requestFactory.buildPostRequest(this.resolveUrl(path), content);
        this.addBaseHeaders(request);
        request.setFollowRedirects(false);
        return this.toResponse(request.execute());
    }

    @Override
    public AppEngineClient.Response get(String path) throws IOException {
        HttpRequest request = this.requestFactory.buildGetRequest(this.resolveUrl(path));
        this.addBaseHeaders(request);
        request.setFollowRedirects(false);
        return this.toResponse(request.execute());
    }

    private void addBaseHeaders(HttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        for (String[] nameAndValue : this.getHeadersBase()) {
            headers.put(nameAndValue[0], (Object)nameAndValue[1]);
        }
        this.getHeadersBase();
    }

    private GenericUrl resolveUrl(String path) {
        return new GenericUrl(this.makeUrl(path));
    }

    private AppEngineClient.Response toResponse(HttpResponse httpResponse) throws IOException {
        byte[] body = httpResponse.getContent() == null ? null : ByteStreams.toByteArray((InputStream)httpResponse.getContent());
        return new AppEngineClient.Response(httpResponse.getStatusCode(), body, httpResponse.getContentCharset());
    }

    private static class ByteArrayHttpContent
    extends AbstractHttpContent {
        private final byte[] body;

        private ByteArrayHttpContent(String mediaType, byte[] body) {
            super(mediaType);
            this.body = body;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.body);
        }
    }
}

