/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.RemoteApiClient;
import com.google.appengine.tools.remoteapi.RemoteApiException;
import com.google.apphosting.base.protos.api.RemoteApiPb;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ConcurrentModificationException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class RemoteRpc {
    private static final Logger logger = Logger.getLogger(RemoteRpc.class.getName());
    private final RemoteApiClient client;
    private int rpcCount = 0;
    private static final AtomicLong requestId = new AtomicLong();

    RemoteRpc(AppEngineClient client) {
        this.client = client;
    }

    RemoteRpc(RemoteApiClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] call(String serviceName, String methodName, String logSuffix, byte[] request) {
        logger.log(Level.FINE, "remote API call: {0}.{1}{2}", new Object[]{serviceName, methodName, logSuffix});
        long startTime = System.currentTimeMillis();
        try {
            RemoteApiPb.Request requestProto = RemoteRpc.makeRequest(serviceName, methodName, request);
            RemoteApiPb.Response responseProto = this.callImpl(requestProto);
            if (responseProto.hasJavaException()) {
                logger.fine("remote API call: failed due to a server-side Java exception");
                Object contents = RemoteRpc.parseJavaException(responseProto, requestProto.getServiceName(), requestProto.getMethod());
                if (contents instanceof ConcurrentModificationException) {
                    ConcurrentModificationException serverSide = (ConcurrentModificationException)contents;
                    ConcurrentModificationException clientSide = new ConcurrentModificationException(serverSide.getMessage());
                    clientSide.initCause(serverSide);
                    throw clientSide;
                }
                if (contents instanceof IllegalArgumentException) {
                    IllegalArgumentException serverSide = (IllegalArgumentException)contents;
                    throw new IllegalArgumentException(serverSide.getMessage(), serverSide);
                }
                if (contents instanceof RuntimeException) {
                    throw (RuntimeException)contents;
                }
                if (contents instanceof Throwable) {
                    throw new RemoteApiException("response was an exception", requestProto.getServiceName(), requestProto.getMethod(), (Throwable)contents);
                }
                throw new RemoteApiException("unexpected response type: " + String.valueOf(contents.getClass()), requestProto.getServiceName(), requestProto.getMethod(), null);
            }
            if (responseProto.hasException()) {
                String pickle = responseProto.getException().toString();
                logger.log(Level.FINE, "remote API call: failed due to a server-side Python exception:\n{0}", pickle);
                throw new RemoteApiException("response was a python exception:\n" + pickle, requestProto.getServiceName(), requestProto.getMethod(), null);
            }
            byte[] byArray = responseProto.getResponse().toByteArray();
            return byArray;
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.log(Level.FINE, "remote API call: took {0} ms", elapsedTime);
        }
    }

    RemoteApiPb.Response callImpl(RemoteApiPb.Request requestProto) {
        AppEngineClient.Response httpResponse;
        ++this.rpcCount;
        byte[] requestBytes = requestProto.toByteArray();
        try {
            String path = this.client.getRemoteApiPath();
            httpResponse = this.client.post(path, "application/octet-stream", requestBytes);
        }
        catch (IOException e) {
            throw RemoteRpc.makeException("I/O error", e, requestProto);
        }
        if (httpResponse.getStatusCode() != 200) {
            throw RemoteRpc.makeException("unexpected HTTP response: " + httpResponse.getStatusCode(), null, requestProto);
        }
        RemoteApiPb.Response.Builder parsedResponse = RemoteApiPb.Response.newBuilder();
        boolean parsed = true;
        try {
            parsedResponse.mergeFrom(httpResponse.getBodyAsBytes(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }
        catch (InvalidProtocolBufferException e) {
            parsed = false;
        }
        if (!parsed || !parsedResponse.isInitialized()) {
            throw RemoteRpc.makeException("Could not parse response bytes", null, requestProto);
        }
        return parsedResponse.build();
    }

    void resetRpcCount() {
        this.rpcCount = 0;
    }

    int getRpcCount() {
        return this.rpcCount;
    }

    private static RemoteApiPb.Request makeRequest(String packageName, String methodName, byte[] payload) {
        return RemoteApiPb.Request.newBuilder().setServiceName(packageName).setMethod(methodName).setRequest(ByteString.copyFrom((byte[])payload)).setRequestId(Long.toString(requestId.incrementAndGet())).build();
    }

    private static Object parseJavaException(RemoteApiPb.Response parsedResponse, String packageName, String methodName) {
        try {
            InputStream ins = parsedResponse.getJavaException().newInput();
            ObjectInputStream in = new ObjectInputStream(ins);
            return in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RemoteApiException("remote API call: can't deserialize server-side exception", packageName, methodName, e);
        }
    }

    private static RemoteApiException makeException(String message, Throwable cause, RemoteApiPb.Request request) {
        logger.log(Level.FINE, "remote API call: {0}", message);
        return new RemoteApiException("remote API call: " + message, request.getServiceName(), request.getMethod(), cause);
    }

    RemoteApiClient getClient() {
        return this.client;
    }
}

