/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.tools.remoteapi.RemoteApiClient;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

abstract class BaseRemoteApiClient
implements RemoteApiClient {
    private final String hostname;
    private final int port;
    private final String remoteApiPath;
    private final String appId;

    BaseRemoteApiClient(RemoteApiOptions options, @Nullable String appId) {
        this.hostname = options.getHostname();
        this.port = options.getPort();
        this.remoteApiPath = options.getRemoteApiPath();
        this.appId = appId;
    }

    @Override
    public String getRemoteApiPath() {
        return this.remoteApiPath;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    String getHostname() {
        return this.hostname;
    }

    int getPort() {
        return this.port;
    }

    String makeUrl(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path doesn't start with a slash: " + path);
        }
        String protocol = this.port == 443 ? "https" : "http";
        return protocol + "://" + this.hostname + ":" + this.port + path;
    }

    List<String[]> getHeadersBase() {
        ArrayList<String[]> headers = new ArrayList<String[]>();
        headers.add(new String[]{"Host", this.hostname});
        headers.add(new String[]{"X-appcfg-api-version", "1"});
        return headers;
    }
}

