/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.appengine.tools.remoteapi.RemoteApiException;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.appengine.tools.remoteapi.RemoteRpc;
import com.google.appengine.tools.remoteapi.TransactionBuilder;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.proto2api.DatastorePb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class RemoteDatastore {
    static final String DATASTORE_SERVICE = "datastore_v3";
    static final String REMOTE_API_SERVICE = "remote_datastore";
    private static final Logger logger = Logger.getLogger(RemoteDatastore.class.getName());
    private final RemoteRpc remoteRpc;
    private final RemoteApiOptions options;
    private final String remoteAppId;
    private final Map<Long, QueryState> idToCursor = new ConcurrentHashMap<Long, QueryState>();
    private final AtomicLong nextCursorId = new AtomicLong(1L);
    private final Map<Long, TransactionBuilder> idToTransaction = new ConcurrentHashMap<Long, TransactionBuilder>();
    private final AtomicLong nextTransactionId = new AtomicLong(1L);

    RemoteDatastore(String remoteAppId, RemoteRpc remoteRpc, RemoteApiOptions options) {
        this.remoteAppId = remoteAppId;
        this.remoteRpc = remoteRpc;
        this.options = options;
    }

    byte[] handleDatastoreCall(String methodName, byte[] request) {
        switch (methodName) {
            case "RunQuery": {
                return this.handleRunQuery(request);
            }
            case "Next": {
                return this.handleNext(request);
            }
            case "BeginTransaction": {
                return this.handleBeginTransaction(request);
            }
            case "Commit": {
                return this.handleCommit(request);
            }
            case "Rollback": {
                return this.handleRollback(request);
            }
            case "Get": {
                return this.handleGet(request);
            }
            case "Put": {
                return this.handlePut(request);
            }
            case "Delete": {
                return this.handleDelete(request);
            }
        }
        return this.remoteRpc.call(DATASTORE_SERVICE, methodName, "", request);
    }

    private byte[] handleRunQuery(byte[] request) {
        return this.runQuery(request, this.nextCursorId.getAndIncrement());
    }

    private byte[] runQuery(byte[] request, long localCursorId) {
        DatastorePb.QueryResult.Builder result;
        DatastorePb.Query.Builder query = DatastorePb.Query.newBuilder();
        RemoteDatastore.mergeFromBytes((Message.Builder)query, request);
        if (RemoteDatastore.rewriteQueryAppIds(query, this.remoteAppId)) {
            request = query.build().toByteArray();
        }
        query.setCompile(true);
        if (!query.hasCount()) {
            query.setCount(this.options.getDatastoreQueryFetchSize());
        }
        TransactionBuilder tx = null;
        if (query.hasTransaction()) {
            tx = this.getTransactionBuilder("RunQuery", query.getTransaction());
            query.clearTransaction();
        }
        if (tx != null) {
            byte[] resultBytes = this.remoteRpc.call(REMOTE_API_SERVICE, "TransactionQuery", "", query.build().toByteArray());
            result = tx.handleQueryResult(resultBytes).toBuilder();
        } else {
            byte[] resultBytes = this.remoteRpc.call(DATASTORE_SERVICE, "RunQuery", "", query.build().toByteArray());
            result = DatastorePb.QueryResult.newBuilder();
            RemoteDatastore.mergeFromBytes((Message.Builder)result, resultBytes);
            if (tx != null) {
                for (OnestoreEntity.EntityProto entity : result.getResultList()) {
                    tx.addEntityToCache(entity);
                }
            }
        }
        if (result.getMoreResults() && result.hasCompiledCursor()) {
            this.idToCursor.put(localCursorId, new QueryState(request, result.getCompiledCursor()));
        } else {
            this.idToCursor.put(localCursorId, QueryState.NO_MORE_RESULTS);
        }
        result.getCursorBuilder().setCursor(localCursorId);
        return result.build().toByteArray();
    }

    static boolean rewriteQueryAppIds(DatastorePb.Query.Builder query, String remoteAppId) {
        boolean reserialize = false;
        if (!query.getApp().equals(remoteAppId)) {
            reserialize = true;
            query.setApp(remoteAppId);
        }
        if (query.hasAncestor() && !query.getAncestor().getApp().equals(remoteAppId)) {
            reserialize = true;
            query.getAncestorBuilder().setApp(remoteAppId);
        }
        for (DatastorePb.Query.Filter filter : query.getFilterList()) {
            for (OnestoreEntity.Property prop : filter.getPropertyList()) {
                OnestoreEntity.PropertyValue.ReferenceValue.Builder ref;
                OnestoreEntity.PropertyValue propValue = prop.getValue();
                if (!propValue.hasReferenceValue() || (ref = propValue.getReferenceValue().toBuilder()).getApp().equals(remoteAppId)) continue;
                reserialize = true;
                ref.setApp(remoteAppId);
            }
        }
        return reserialize;
    }

    private byte[] handleNext(byte[] request) {
        DatastorePb.NextRequest.Builder nextRequest = DatastorePb.NextRequest.newBuilder();
        RemoteDatastore.mergeFromBytes((Message.Builder)nextRequest, request);
        long cursorId = nextRequest.getCursor().getCursor();
        QueryState queryState = this.idToCursor.get(cursorId);
        if (queryState == null) {
            throw new RemoteApiException("local cursor not found", DATASTORE_SERVICE, "Next", null);
        }
        if (!queryState.hasMoreResults()) {
            DatastorePb.QueryResult result = DatastorePb.QueryResult.newBuilder().setMoreResults(false).build();
            return result.toByteArray();
        }
        return this.runQuery(queryState.makeNextQuery(nextRequest.build()).toByteArray(), cursorId);
    }

    private byte[] handleBeginTransaction(byte[] request) {
        DatastorePb.BeginTransactionRequest.Builder beginTxnRequest = DatastorePb.BeginTransactionRequest.newBuilder();
        RemoteDatastore.mergeFromBytes((Message.Builder)beginTxnRequest, request);
        long txId = this.nextTransactionId.getAndIncrement();
        this.idToTransaction.put(txId, new TransactionBuilder(beginTxnRequest.getAllowMultipleEg()));
        DatastorePb.Transaction tx = DatastorePb.Transaction.newBuilder().setHandle(txId).setApp(this.remoteAppId).build();
        return tx.toByteArray();
    }

    private byte[] handleCommit(byte[] requestBytes) {
        DatastorePb.Transaction.Builder request = DatastorePb.Transaction.newBuilder();
        RemoteDatastore.mergeFromBytes((Message.Builder)request, requestBytes);
        request.setApp(this.remoteAppId);
        TransactionBuilder tx = this.removeTransactionBuilder("Commit", request.build());
        this.remoteRpc.call(REMOTE_API_SERVICE, "Transaction", "", tx.makeCommitRequest().toByteArray());
        return DatastorePb.CommitResponse.getDefaultInstance().toByteArray();
    }

    private byte[] handleRollback(byte[] requestBytes) {
        DatastorePb.Transaction.Builder request = DatastorePb.Transaction.newBuilder();
        RemoteDatastore.mergeFromBytes((Message.Builder)request, requestBytes);
        request.setApp(this.remoteAppId);
        TransactionBuilder unused = this.removeTransactionBuilder("Rollback", request.build());
        return new byte[0];
    }

    private byte[] handleGet(byte[] originalRequestBytes) {
        DatastorePb.GetRequest.Builder rewrittenReq = DatastorePb.GetRequest.newBuilder();
        RemoteDatastore.mergeFromBytes((Message.Builder)rewrittenReq, originalRequestBytes);
        boolean reserialize = RemoteDatastore.rewriteRequestReferences(rewrittenReq.getKeyList(), this.remoteAppId);
        if (rewrittenReq.hasTransaction()) {
            return this.handleGetWithTransaction(rewrittenReq.build());
        }
        byte[] requestBytesToSend = reserialize ? rewrittenReq.build().toByteArray() : originalRequestBytes;
        return this.remoteRpc.call(DATASTORE_SERVICE, "Get", "", requestBytesToSend);
    }

    private byte[] handlePut(byte[] requestBytes) {
        DatastorePb.PutRequest.Builder request = DatastorePb.PutRequest.newBuilder();
        RemoteDatastore.mergeFromBytes((Message.Builder)request, requestBytes);
        boolean reserialize = RemoteDatastore.rewritePutAppIds(request, this.remoteAppId);
        if (request.hasTransaction()) {
            return this.handlePutForTransaction(request);
        }
        if (reserialize) {
            requestBytes = request.build().toByteArray();
        }
        String suffix = "";
        if (logger.isLoggable(Level.FINE)) {
            suffix = RemoteDatastore.describePutRequestForLog(request.build());
        }
        return this.remoteRpc.call(DATASTORE_SERVICE, "Put", suffix, requestBytes);
    }

    static boolean rewritePutAppIds(DatastorePb.PutRequest.Builder request, String remoteAppId) {
        boolean reserialize = false;
        for (OnestoreEntity.EntityProto.Builder entity : request.getEntityBuilderList()) {
            if (!entity.getKey().getApp().equals(remoteAppId)) {
                reserialize = true;
                entity.getKeyBuilder().setApp(remoteAppId);
            }
            for (OnestoreEntity.Property.Builder prop : entity.getPropertyBuilderList()) {
                OnestoreEntity.PropertyValue.ReferenceValue.Builder ref;
                if (!prop.getValue().hasReferenceValue() || !(ref = prop.getValueBuilder().getReferenceValueBuilder()).hasApp() || ref.getApp().equals(remoteAppId)) continue;
                reserialize = true;
                ref.setApp(remoteAppId);
            }
        }
        return reserialize;
    }

    private byte[] handleDelete(byte[] requestBytes) {
        DatastorePb.DeleteRequest.Builder request = DatastorePb.DeleteRequest.newBuilder();
        RemoteDatastore.mergeFromBytes((Message.Builder)request, requestBytes);
        boolean reserialize = RemoteDatastore.rewriteRequestReferences(request.getKeyList(), this.remoteAppId);
        if (reserialize) {
            requestBytes = request.build().toByteArray();
        }
        if (request.hasTransaction()) {
            return this.handleDeleteForTransaction(request);
        }
        return this.remoteRpc.call(DATASTORE_SERVICE, "Delete", "", requestBytes);
    }

    static boolean rewriteRequestReferences(Collection<OnestoreEntity.Reference> references, String remoteAppId) {
        boolean reserialize = false;
        for (OnestoreEntity.Reference refToCheck : references) {
            if (refToCheck.getApp().equals(remoteAppId)) continue;
            refToCheck = refToCheck.toBuilder().setApp(remoteAppId).build();
            reserialize = true;
        }
        return reserialize;
    }

    private byte[] handleGetWithTransaction(DatastorePb.GetRequest rewrittenReq) {
        TransactionBuilder tx = this.getTransactionBuilder("Get", rewrittenReq.getTransaction());
        DatastorePb.GetRequest.Builder requestForKeysNotInCache = rewrittenReq.toBuilder().clone().clearTransaction().clearKey();
        for (OnestoreEntity.Reference key : rewrittenReq.getKeyList()) {
            if (tx.isCachedEntity(key)) continue;
            requestForKeysNotInCache.addKey(key);
        }
        HashSet deferredRefs = new HashSet();
        if (requestForKeysNotInCache.getKeyCount() > 0) {
            byte[] respBytesFromRemoteApp = this.remoteRpc.call(DATASTORE_SERVICE, "Get", "", requestForKeysNotInCache.build().toByteArray());
            DatastorePb.GetResponse.Builder respFromRemoteApp = DatastorePb.GetResponse.newBuilder();
            RemoteDatastore.mergeFromBytes((Message.Builder)respFromRemoteApp, respBytesFromRemoteApp);
            for (DatastorePb.GetResponse.Entity entityResult : respFromRemoteApp.getEntityList()) {
                if (entityResult.hasEntity()) {
                    tx.addEntityToCache(entityResult.getEntity());
                    continue;
                }
                tx.addEntityAbsenceToCache(entityResult.getKey());
            }
            deferredRefs.addAll(respFromRemoteApp.getDeferredList());
        }
        DatastorePb.GetResponse.Builder mergedResponse = DatastorePb.GetResponse.newBuilder().setInOrder(deferredRefs.isEmpty());
        for (OnestoreEntity.Reference key : rewrittenReq.getKeyList()) {
            if (deferredRefs.contains(key)) {
                mergedResponse.addDeferred(key);
                continue;
            }
            OnestoreEntity.EntityProto entity = tx.getCachedEntity(key);
            if (entity == null) {
                mergedResponse.addEntityBuilder().setKey(key);
                continue;
            }
            mergedResponse.addEntityBuilder().setEntity(entity);
        }
        return mergedResponse.build().toByteArray();
    }

    byte[] handlePutForTransaction(DatastorePb.PutRequest.Builder request) {
        TransactionBuilder tx = this.getTransactionBuilder("Put", request.getTransaction());
        ArrayList<Object> entitiesWithoutIds = new ArrayList<Object>();
        for (Object entity : request.getEntityBuilderList()) {
            if (!this.requiresId((OnestoreEntity.EntityProto.Builder)entity)) continue;
            entitiesWithoutIds.add(entity);
        }
        if (!entitiesWithoutIds.isEmpty()) {
            DatastorePb.PutRequest.Builder subRequest = DatastorePb.PutRequest.newBuilder();
            for (OnestoreEntity.EntityProto.Builder builder : entitiesWithoutIds) {
                OnestoreEntity.EntityProto.Builder subEntity = subRequest.addEntityBuilder();
                subEntity.getKeyBuilder().mergeFrom(builder.getKey());
                OnestoreEntity.Path.Builder builder2 = subEntity.getEntityGroupBuilder();
            }
            String getIdsRpc = tx.isXG() ? "GetIDsXG" : "GetIDs";
            byte[] byArray = this.remoteRpc.call(REMOTE_API_SERVICE, getIdsRpc, "", subRequest.build().toByteArray());
            DatastorePb.PutResponse.Builder subResponse = DatastorePb.PutResponse.newBuilder();
            RemoteDatastore.mergeFromBytes((Message.Builder)subResponse, byArray);
            Iterator it = entitiesWithoutIds.iterator();
            for (OnestoreEntity.Reference.Builder newKey : subResponse.getKeyBuilderList()) {
                OnestoreEntity.EntityProto.Builder entity = (OnestoreEntity.EntityProto.Builder)it.next();
                entity.setKey(newKey);
                entity.getEntityGroupBuilder().addElementBuilder().mergeFrom(newKey.getPath().getElement(0));
            }
        }
        DatastorePb.PutResponse.Builder response = DatastorePb.PutResponse.newBuilder();
        for (OnestoreEntity.EntityProto entityProto : request.getEntityList()) {
            tx.putEntityOnCommit(entityProto);
            response.addKeyBuilder().mergeFrom(entityProto.getKey());
        }
        return response.build().toByteArray();
    }

    byte[] handleDeleteForTransaction(DatastorePb.DeleteRequest.Builder request) {
        TransactionBuilder tx = this.getTransactionBuilder("Delete", request.getTransaction());
        for (OnestoreEntity.Reference key : request.getKeyList()) {
            tx.deleteEntityOnCommit(key);
        }
        DatastorePb.DeleteResponse response = DatastorePb.DeleteResponse.getDefaultInstance();
        return response.toByteArray();
    }

    TransactionBuilder getTransactionBuilder(String methodName, DatastorePb.Transaction tx) {
        TransactionBuilder result = this.idToTransaction.get(tx.getHandle());
        if (result == null) {
            throw new RemoteApiException("transaction not found", DATASTORE_SERVICE, methodName, null);
        }
        return result;
    }

    TransactionBuilder removeTransactionBuilder(String methodName, DatastorePb.Transaction tx) {
        TransactionBuilder result = this.idToTransaction.remove(tx.getHandle());
        if (result == null) {
            throw new RemoteApiException("transaction not found", DATASTORE_SERVICE, methodName, null);
        }
        return result;
    }

    private boolean requiresId(OnestoreEntity.EntityProto.Builder entity) {
        OnestoreEntity.Path path = entity.getKey().getPath();
        OnestoreEntity.Path.Element lastElement = (OnestoreEntity.Path.Element)path.getElementList().get(path.getElementCount() - 1);
        return lastElement.getId() == 0L && !lastElement.hasName();
    }

    private static String describePutRequestForLog(DatastorePb.PutRequest putRequest) {
        int count = putRequest.getEntityCount();
        if (count <= 0) {
            return "()";
        }
        OnestoreEntity.Reference keyProto = putRequest.getEntity(0).getKey();
        if (count == 1) {
            return "(" + RemoteDatastore.describeKeyForLog(keyProto) + ")";
        }
        return "(" + RemoteDatastore.describeKeyForLog(keyProto) + ", ...)";
    }

    private static String describeKeyForLog(OnestoreEntity.Reference keyProto) {
        StringBuilder pathString = new StringBuilder();
        OnestoreEntity.Path path = keyProto.getPath();
        for (OnestoreEntity.Path.Element element : path.getElementList()) {
            if (pathString.length() > 0) {
                pathString.append(",");
            }
            pathString.append(element.getType() + "/");
            if (element.hasId()) {
                pathString.append(element.getId());
                continue;
            }
            pathString.append(element.getName());
        }
        return "[" + String.valueOf(pathString) + "]";
    }

    private static void mergeFromBytes(Message.Builder message, byte[] bytes) {
        boolean parsed = true;
        try {
            message.mergeFrom(bytes, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }
        catch (InvalidProtocolBufferException e) {
            parsed = false;
        }
        if (!parsed || !message.isInitialized()) {
            throw new ApiProxy.ApiProxyException("Could not parse protobuf bytes");
        }
    }

    private static class QueryState {
        private static final QueryState NO_MORE_RESULTS = new QueryState(null, null);
        private final byte[] query;
        private final DatastorePb.CompiledCursor cursor;

        QueryState(byte[] query, DatastorePb.CompiledCursor cursor) {
            this.query = query;
            this.cursor = cursor;
        }

        boolean hasMoreResults() {
            return this.query != null;
        }

        private DatastorePb.Query makeNextQuery(DatastorePb.NextRequest nextRequest) {
            DatastorePb.Query.Builder result = DatastorePb.Query.newBuilder();
            RemoteDatastore.mergeFromBytes((Message.Builder)result, this.query);
            result.setOffset(0);
            result.setCompiledCursor(this.cursor);
            result.setCompile(true);
            if (nextRequest.hasCount()) {
                result.setCount(nextRequest.getCount());
            } else {
                result.clearCount();
            }
            return result.build();
        }
    }
}

