/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.apphosting.api.proto2api.DatastorePb;
import com.google.apphosting.base.protos.api.RemoteApiPb;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

class TransactionBuilder {
    private final Map<ByteString, OnestoreEntity.EntityProto> getCache = new HashMap<ByteString, OnestoreEntity.EntityProto>();
    private final Map<ByteString, OnestoreEntity.EntityProto> updates = new HashMap<ByteString, OnestoreEntity.EntityProto>();
    private final boolean isXG;

    TransactionBuilder(boolean isXG) {
        this.isXG = isXG;
    }

    public boolean isXG() {
        return this.isXG;
    }

    public boolean isCachedEntity(OnestoreEntity.Reference key) {
        return this.getCache.containsKey(key.toByteString());
    }

    public void addEntityToCache(OnestoreEntity.EntityProto entityPb) {
        ByteString key = entityPb.getKey().toByteString();
        if (this.getCache.containsKey(key)) {
            throw new IllegalStateException("shouldn't load the same entity twice within a transaction");
        }
        this.getCache.put(key, entityPb);
    }

    public void addEntityAbsenceToCache(OnestoreEntity.Reference key) {
        ByteString keyBytes = key.toByteString();
        if (this.getCache.containsKey(keyBytes)) {
            throw new IllegalStateException("shouldn't load the same entity twice within a transaction");
        }
        this.getCache.put(keyBytes, null);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.EntityProto getCachedEntity(OnestoreEntity.Reference key) {
        ByteString keyBytes = key.toByteString();
        if (!this.getCache.containsKey(keyBytes)) {
            throw new IllegalStateException("entity's status unexpectedly not in cache");
        }
        return this.getCache.get(keyBytes);
    }

    public DatastorePb.QueryResult handleQueryResult(byte[] resultBytes) {
        RemoteApiPb.TransactionQueryResult.Builder result = RemoteApiPb.TransactionQueryResult.newBuilder();
        boolean parsed = true;
        try {
            result.mergeFrom(resultBytes, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }
        catch (InvalidProtocolBufferException e) {
            parsed = false;
        }
        if (!parsed || !result.isInitialized()) {
            throw new IllegalArgumentException("Could not parse TransactionQueryResult");
        }
        if (this.isCachedEntity(result.getEntityGroupKey())) {
            OnestoreEntity.EntityProto cached = this.getCachedEntity(result.getEntityGroupKey());
            if (!(result.hasEntityGroup() && result.getEntityGroup().equals((Object)cached) || !result.hasEntityGroup() && cached == null)) {
                throw new ConcurrentModificationException("Transaction precondition failed.");
            }
        } else if (result.hasEntityGroup()) {
            this.addEntityToCache(result.getEntityGroup());
        } else {
            this.addEntityAbsenceToCache(result.getEntityGroupKey());
        }
        return result.getResult();
    }

    public void putEntityOnCommit(OnestoreEntity.EntityProto entity) {
        this.updates.put(entity.getKey().toByteString(), entity);
    }

    public void deleteEntityOnCommit(OnestoreEntity.Reference key) {
        this.updates.put(key.toByteString(), null);
    }

    public RemoteApiPb.TransactionRequest makeCommitRequest() {
        RemoteApiPb.TransactionRequest.Builder result = RemoteApiPb.TransactionRequest.newBuilder().setAllowMultipleEg(this.isXG);
        for (Map.Entry<ByteString, OnestoreEntity.EntityProto> entry : this.getCache.entrySet()) {
            if (entry.getValue() == null) {
                result.addPrecondition(TransactionBuilder.makeEntityNotFoundPrecondition(entry.getKey()));
                continue;
            }
            result.addPrecondition(TransactionBuilder.makeEqualEntityPrecondition(entry.getValue()));
        }
        for (Map.Entry<ByteString, OnestoreEntity.EntityProto> entry : this.updates.entrySet()) {
            OnestoreEntity.EntityProto entityPb = entry.getValue();
            if (entityPb == null) {
                OnestoreEntity.Reference.Builder newKey = result.getDeletesBuilder().addKeyBuilder();
                boolean parsed = true;
                try {
                    newKey.mergeFrom(entry.getKey(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                }
                catch (InvalidProtocolBufferException e) {
                    parsed = false;
                }
                if (parsed && newKey.isInitialized()) continue;
                throw new IllegalStateException("Could not parse serialized key");
            }
            result.getPutsBuilder().addEntity(entityPb);
        }
        return result.build();
    }

    private static RemoteApiPb.TransactionRequest.Precondition makeEntityNotFoundPrecondition(ByteString key) {
        OnestoreEntity.Reference.Builder ref = OnestoreEntity.Reference.newBuilder();
        boolean parsed = true;
        try {
            ref.mergeFrom(key, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }
        catch (InvalidProtocolBufferException e) {
            parsed = false;
        }
        if (!parsed || !ref.isInitialized()) {
            throw new IllegalArgumentException("Could not parse Reference");
        }
        return RemoteApiPb.TransactionRequest.Precondition.newBuilder().setKey(ref).build();
    }

    private static RemoteApiPb.TransactionRequest.Precondition makeEqualEntityPrecondition(OnestoreEntity.EntityProto entityPb) {
        return RemoteApiPb.TransactionRequest.Precondition.newBuilder().setKey(entityPb.getKey()).setHashBytes(ByteString.copyFrom((byte[])TransactionBuilder.computeSha1(entityPb))).build();
    }

    private static byte[] computeSha1(OnestoreEntity.EntityProto entity) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("can't compute sha1 hash");
        }
        byte[] entityBytes = entity.toByteArray();
        md.update(entityBytes, 0, entityBytes.length);
        return md.digest();
    }
}

