/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.ByteArrays;
import com.google.appengine.repackaged.com.google.common.base.CharEscaper;
import com.google.appengine.repackaged.com.google.common.base.CharEscaperBuilder;
import com.google.appengine.repackaged.com.google.common.base.CharEscapers;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.Charsets;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public final class StringUtil {
    @Deprecated
    public static final String WHITE_SPACES = " \r\n\t\u3000\u00a0\u2007\u202f";
    public static final String LINE_BREAKS = "\r\n";
    private static final Splitter NEWLINE_SPLITTER = Splitter.on('\n').omitEmptyStrings();
    private static final Splitter TO_WORDS = Splitter.on(CharMatcher.BREAKING_WHITESPACE).omitEmptyStrings();
    private static final CharMatcher FANCY_SINGLE_QUOTE = CharMatcher.anyOf("\u0091\u0092\u2018\u2019");
    private static final CharMatcher FANCY_DOUBLE_QUOTE = CharMatcher.anyOf("\u0093\u0094\u201c\u201d");
    static final Map<String, Character> ESCAPE_STRINGS = new HashMap<String, Character>(252);
    static final Set<Character> HEX_LETTERS;
    private static final CharEscaper LT_GT_ESCAPE;
    private static final Pattern htmlTagPattern;
    private static final CharMatcher CONTROL_MATCHER;
    private static final CharEscaper JAVA_ESCAPE;
    private static final CharEscaper REGEX_ESCAPE;
    private static final Pattern characterReferencePattern;
    private static final Set<Character.UnicodeBlock> CJK_BLOCKS;
    private static final char[] HEX_CHARS;
    private static final char[] OCTAL_CHARS;
    private static final Pattern dbSpecPattern;
    private static final Set<Integer> JS_ESCAPE_CHARS;
    private static final Set<Integer> JSON_ESCAPE_CHARS;

    private StringUtil() {
    }

    public static boolean isEmpty(@Nullable String string) {
        return Strings.isNullOrEmpty(string);
    }

    public static boolean isEmptyOrWhitespace(@Nullable String string) {
        return string == null || CharMatcher.WHITESPACE.matchesAllOf(string);
    }

    public static String makeSafe(@Nullable String string) {
        return Strings.nullToEmpty(string);
    }

    @Nullable
    public static String toNullIfEmpty(@Nullable String string) {
        return Strings.emptyToNull(string);
    }

    @Nullable
    public static String toNullIfEmptyOrWhitespace(@Nullable String string) {
        return StringUtil.isEmptyOrWhitespace(string) ? null : string;
    }

    public static String repeat(String string, int count) {
        return Strings.repeat(string, count);
    }

    public static int indexOfChars(CharSequence string, CharSequence chars, int fromIndex) {
        char c;
        int i;
        if (fromIndex >= string.length()) {
            return -1;
        }
        Set charSet = Collections.emptySet();
        boolean[] charArray = new boolean[128];
        for (i = 0; i < chars.length(); ++i) {
            c = chars.charAt(i);
            if (c < '\u0080') {
                charArray[c] = true;
                continue;
            }
            if (charSet.isEmpty()) {
                charSet = new HashSet();
            }
            charSet.add(Character.valueOf(c));
        }
        for (i = Math.max(fromIndex, 0); i < string.length(); ++i) {
            c = string.charAt(i);
            if (!(c < '\u0080' ? charArray[c] : charSet.contains(Character.valueOf(c)))) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public static String[] split(String str, String delims) {
        return StringUtil.split(str, delims, false);
    }

    @Deprecated
    public static String[] split(String str, String delims, boolean trimTokens) {
        StringTokenizer tokenizer = new StringTokenizer(str, delims);
        int n = tokenizer.countTokens();
        String[] list = new String[n];
        for (int i = 0; i < n; ++i) {
            list[i] = trimTokens ? tokenizer.nextToken().trim() : tokenizer.nextToken();
        }
        return list;
    }

    public static String trimStart(String s) {
        return StringUtil.trimStart(s, null);
    }

    public static String trimStart(String s, @Nullable String extraChars) {
        char ch;
        int trimCount;
        for (trimCount = 0; trimCount < s.length() && (Character.isWhitespace(ch = s.charAt(trimCount)) || extraChars != null && extraChars.indexOf(ch) >= 0); ++trimCount) {
        }
        if (trimCount == 0) {
            return s;
        }
        return s.substring(trimCount);
    }

    public static String trimEnd(String s) {
        return StringUtil.trimEnd(s, null);
    }

    public static String trimEnd(String s, @Nullable String extraChars) {
        char ch;
        int trimCount;
        for (trimCount = 0; trimCount < s.length() && (Character.isWhitespace(ch = s.charAt(s.length() - trimCount - 1)) || extraChars != null && extraChars.indexOf(ch) >= 0); ++trimCount) {
        }
        if (trimCount == 0) {
            return s;
        }
        return s.substring(0, s.length() - trimCount);
    }

    @Deprecated
    public static String[] splitAndTrim(String str, String delims) {
        return StringUtil.split(str, delims, true);
    }

    public static int[] splitInts(String str) throws IllegalArgumentException {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int n = tokenizer.countTokens();
        int[] list = new int[n];
        for (int i = 0; i < n; ++i) {
            String token = tokenizer.nextToken();
            list[i] = Integer.parseInt(token);
        }
        return list;
    }

    public static long[] splitLongs(String str) throws IllegalArgumentException {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int n = tokenizer.countTokens();
        long[] list = new long[n];
        for (int i = 0; i < n; ++i) {
            String token = tokenizer.nextToken();
            list[i] = Long.parseLong(token);
        }
        return list;
    }

    @Deprecated
    public static String replace(String str, CharSequence what, CharSequence with) {
        Preconditions.checkArgument(what.length() > 0);
        return str.replace(what, with);
    }

    public static String fixedWidth(String str, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : NEWLINE_SPLITTER.split(str)) {
            lines.add(line);
        }
        String[] lineArray = lines.toArray(new String[0]);
        return StringUtil.fixedWidth(lineArray, width);
    }

    public static String fixedWidth(String[] lines, int width) {
        ArrayList<String> formattedLines = new ArrayList<String>();
        for (String line : lines) {
            formattedLines.add(StringUtil.formatLineToFixedWidth(line, width));
        }
        return Joiner.on('\n').join(formattedLines);
    }

    private static String formatLineToFixedWidth(String line, int width) {
        if (line.length() <= width) {
            return line;
        }
        StringBuilder builder = new StringBuilder();
        int col = 0;
        for (String word : TO_WORDS.split(line)) {
            if (col == 0) {
                col = word.length();
            } else {
                int newCol = col + word.length() + 1;
                if (newCol <= width) {
                    builder.append(' ');
                    col = newCol;
                } else {
                    builder.append('\n');
                    col = word.length();
                }
            }
            builder.append(word);
        }
        return builder.toString();
    }

    @Deprecated
    public static List<String> fixedSplit(String original, int lineLen) {
        ArrayList<String> output = new ArrayList<String>();
        for (String elem : Splitter.fixedLength(lineLen).split(original)) {
            output.add(elem);
        }
        return output;
    }

    public static String indent(String iString, int iIndentDepth) {
        StringBuilder spacer = new StringBuilder();
        spacer.append("\n");
        for (int i = 0; i < iIndentDepth; ++i) {
            spacer.append("  ");
        }
        return iString.replace("\n", spacer.toString());
    }

    @Deprecated
    public static String megastrip(@Nullable String str, boolean left, boolean right, String what) {
        if (str == null) {
            return null;
        }
        CharMatcher matcher = CharMatcher.anyOf(what);
        if (left) {
            if (right) {
                return matcher.trimFrom(str);
            }
            return matcher.trimLeadingFrom(str);
        }
        if (right) {
            return matcher.trimTrailingFrom(str);
        }
        return str;
    }

    @Deprecated
    public static String strip(@Nullable String str) {
        return str == null ? null : CharMatcher.LEGACY_WHITESPACE.trimFrom(str);
    }

    @Deprecated
    public static String stripAndCollapse(@Nullable String str) {
        return str == null ? null : CharMatcher.LEGACY_WHITESPACE.trimAndCollapseFrom(str, ' ');
    }

    @Nullable
    public static String stripPrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : null;
    }

    @Nullable
    public static String stripPrefixIgnoreCase(String str, String prefix) {
        return StringUtil.startsWithIgnoreCase(str, prefix) ? str.substring(prefix.length()) : null;
    }

    @Nullable
    public static String stripSuffix(String str, String suffix) {
        return str.endsWith(suffix) ? str.substring(0, str.length() - suffix.length()) : null;
    }

    @Nullable
    public static String stripSuffixIgnoreCase(String str, String suffix) {
        return StringUtil.endsWithIgnoreCase(str, suffix) ? str.substring(0, str.length() - suffix.length()) : null;
    }

    @Deprecated
    public static String stripNonDigits(String str) {
        return CharMatcher.JAVA_DIGIT.retainFrom(str);
    }

    public static int lastIndexNotOf(String str, String chars, int fromIndex) {
        for (int pos = fromIndex = Math.min(fromIndex, str.length() - 1); pos >= 0; --pos) {
            if (chars.indexOf(str.charAt(pos)) >= 0) continue;
            return pos;
        }
        return -1;
    }

    @Deprecated
    public static String replaceChars(String str, CharSequence oldchars, char newchar) {
        return CharMatcher.anyOf(oldchars).replaceFrom((CharSequence)str, newchar);
    }

    @Deprecated
    public static String removeChars(String str, CharSequence oldchars) {
        return CharMatcher.anyOf(oldchars).removeFrom(str);
    }

    public static String replaceSmartQuotes(String str) {
        String tmp = FANCY_SINGLE_QUOTE.replaceFrom((CharSequence)str, '\'');
        return FANCY_DOUBLE_QUOTE.replaceFrom((CharSequence)tmp, '\"');
    }

    public static byte[] hexToBytes(CharSequence str) {
        byte[] bytes = new byte[(str.length() + 1) / 2];
        if (str.length() == 0) {
            return bytes;
        }
        bytes[0] = 0;
        int nibbleIdx = str.length() % 2;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!StringUtil.isHex(c)) {
                throw new IllegalArgumentException("string contains non-hex chars");
            }
            if (nibbleIdx % 2 == 0) {
                bytes[nibbleIdx >> 1] = (byte)(StringUtil.hexValue(c) << 4);
            } else {
                int n = nibbleIdx >> 1;
                bytes[n] = (byte)(bytes[n] + (byte)StringUtil.hexValue(c));
            }
            ++nibbleIdx;
        }
        return bytes;
    }

    public static String convertEOLToLF(String input) {
        StringBuilder res = new StringBuilder(input.length());
        char[] s = input.toCharArray();
        int from = 0;
        int end = s.length;
        for (int i = 0; i < end; ++i) {
            if (s[i] != '\r') continue;
            res.append(s, from, i - from);
            res.append('\n');
            if (i + 1 < end && s[i + 1] == '\n') {
                ++i;
            }
            from = i + 1;
        }
        if (from == 0) {
            return input;
        }
        res.append(s, from, end - from);
        return res.toString();
    }

    public static String padLeft(String s, int len, char padChar) {
        return Strings.padStart(s, len, padChar);
    }

    public static String padRight(String s, int len, char padChar) {
        return Strings.padEnd(s, len, padChar);
    }

    public static String maskLeft(String s, int len, char maskChar) {
        if (len <= 0) {
            return s;
        }
        len = Math.min(len, s.length());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(maskChar);
        }
        sb.append(s.substring(len));
        return sb.toString();
    }

    private static boolean isOctal(char c) {
        return c >= '0' && c <= '7';
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    public static String unescapeCString(String s) {
        if (s.indexOf(92) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c;
            if ((c = s.charAt(i++)) == '\\' && i < len) {
                c = s.charAt(i++);
                switch (c) {
                    case 'a': {
                        c = '\u0007';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'v': {
                        c = '\u000b';
                        break;
                    }
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    case '?': {
                        c = '?';
                        break;
                    }
                    case '\'': {
                        c = '\'';
                        break;
                    }
                    case '\"': {
                        c = '\"';
                        break;
                    }
                    default: {
                        int v;
                        if (c == 'x' && i < len && StringUtil.isHex(s.charAt(i))) {
                            v = StringUtil.hexValue(s.charAt(i++));
                            if (i < len && StringUtil.isHex(s.charAt(i))) {
                                v = v * 16 + StringUtil.hexValue(s.charAt(i++));
                            }
                            c = (char)v;
                            break;
                        }
                        if (StringUtil.isOctal(c)) {
                            v = c - 48;
                            if (i < len && StringUtil.isOctal(s.charAt(i))) {
                                v = v * 8 + (s.charAt(i++) - 48);
                            }
                            if (i < len && StringUtil.isOctal(s.charAt(i))) {
                                v = v * 8 + (s.charAt(i++) - 48);
                            }
                            c = (char)v;
                            break;
                        }
                        sb.append('\\');
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapeMySQLString(String s) throws IllegalArgumentException {
        char[] chars = s.toCharArray();
        if (chars.length < 2 || chars[0] != chars[chars.length - 1] || chars[0] != '\'' && chars[0] != '\"') {
            throw new IllegalArgumentException("not a valid MySQL string: " + s);
        }
        int j = 1;
        int f = 0;
        for (int i = 1; i < chars.length - 1; ++i) {
            if (f == 0) {
                if (chars[i] == '\\') {
                    f = 1;
                    continue;
                }
                if (chars[i] == chars[0]) {
                    f = 2;
                    continue;
                }
                chars[j++] = chars[i];
                continue;
            }
            if (f == 1) {
                switch (chars[i]) {
                    case '0': {
                        chars[j++] = '\u0000';
                        break;
                    }
                    case '\'': {
                        chars[j++] = 39;
                        break;
                    }
                    case '\"': {
                        chars[j++] = 34;
                        break;
                    }
                    case 'b': {
                        chars[j++] = 8;
                        break;
                    }
                    case 'n': {
                        chars[j++] = 10;
                        break;
                    }
                    case 'r': {
                        chars[j++] = 13;
                        break;
                    }
                    case 't': {
                        chars[j++] = 9;
                        break;
                    }
                    case 'z': {
                        chars[j++] = 26;
                        break;
                    }
                    case '\\': {
                        chars[j++] = 92;
                        break;
                    }
                    default: {
                        chars[j++] = chars[i];
                    }
                }
                f = 0;
                continue;
            }
            if (chars[i] != chars[0]) {
                throw new IllegalArgumentException("not a valid MySQL string: " + s);
            }
            chars[j++] = chars[0];
            f = 0;
        }
        if (f != 0) {
            throw new IllegalArgumentException("not a valid MySQL string: " + s);
        }
        return new String(chars, 1, j - 1);
    }

    public static final String unescapeHTML(String s) {
        return StringUtil.unescapeHTML(s, false);
    }

    public static final String unescapeHTML(String s, boolean emulateBrowsers) {
        int index = s.indexOf(38);
        if (index == -1) {
            return s;
        }
        char[] chars = s.toCharArray();
        char[] escaped = new char[chars.length];
        System.arraycopy(chars, 0, escaped, 0, index);
        int pos = index;
        int i = index;
        while (i < chars.length) {
            if (chars[i] != '&') {
                escaped[pos++] = chars[i++];
                continue;
            }
            int j = i + 1;
            boolean isNumericEntity = false;
            if (j < chars.length && chars[j] == '#') {
                ++j;
                isNumericEntity = true;
            }
            boolean isHexEntity = false;
            if (j < chars.length && (chars[j] == 'x' || chars[j] == 'X')) {
                ++j;
                isHexEntity = true;
            }
            while (j < chars.length) {
                char ch = chars[j];
                boolean isDigit = Character.isDigit(ch);
                if (isNumericEntity && (!isHexEntity && !isDigit || isHexEntity && !isDigit && !HEX_LETTERS.contains(Character.valueOf(ch))) || !isDigit && !Character.isLetter(ch)) break;
                ++j;
            }
            boolean replaced = false;
            if (j <= chars.length && emulateBrowsers || j < chars.length && chars[j] == ';') {
                if (i + 2 < chars.length && s.charAt(i + 1) == '#') {
                    try {
                        long charcode = 0L;
                        char ch = s.charAt(i + 2);
                        if (isHexEntity) {
                            charcode = Long.parseLong(new String(chars, i + 3, j - i - 3), 16);
                        } else if (Character.isDigit(ch)) {
                            charcode = Long.parseLong(new String(chars, i + 2, j - i - 2));
                        }
                        if (charcode > 0L && charcode < 65536L) {
                            escaped[pos++] = (char)charcode;
                            replaced = true;
                        }
                    }
                    catch (NumberFormatException ex) {}
                } else {
                    String key = new String(chars, i, j - i);
                    Character repl = ESCAPE_STRINGS.get(key);
                    if (repl != null) {
                        escaped[pos++] = repl.charValue();
                        replaced = true;
                    }
                }
                if (j < chars.length && chars[j] == ';') {
                    ++j;
                }
            }
            if (!replaced) {
                System.arraycopy(chars, i, escaped, pos, j - i);
                pos += j - i;
            }
            i = j;
        }
        return new String(escaped, 0, pos);
    }

    public static String stripHtmlTags(@Nullable String string) {
        if (string == null || "".equals(string)) {
            return string;
        }
        String stripped = htmlTagPattern.matcher(string).replaceAll("");
        return LT_GT_ESCAPE.escape(stripped);
    }

    public static String javaScriptEscape(CharSequence s) {
        return StringUtil.javaScriptEscapeHelper(s, false);
    }

    public static String javaScriptEscapeToAscii(CharSequence s) {
        return StringUtil.javaScriptEscapeHelper(s, true);
    }

    private static String javaScriptEscapeHelper(CharSequence s, boolean escapeToAscii) {
        StringBuilder sb = new StringBuilder(s.length() * 9 / 8);
        try {
            StringUtil.escapeStringBody(s, escapeToAscii, JsEscapingMode.EMBEDDABLE_JS, sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sb.toString();
    }

    public static void escapeStringBody(CharSequence plainText, boolean escapeToAscii, JsEscapingMode jsEscapingMode, Appendable out) throws IOException {
        int charCount;
        int pos = 0;
        int len = plainText.length();
        block9: for (int i = 0; i < len; i += charCount) {
            int codePoint = Character.codePointAt(plainText, i);
            charCount = Character.charCount(codePoint);
            if (!StringUtil.shouldEscapeChar(codePoint, escapeToAscii, jsEscapingMode)) continue;
            out.append(plainText, pos, i);
            pos = i + charCount;
            switch (codePoint) {
                case 8: {
                    out.append("\\b");
                    continue block9;
                }
                case 9: {
                    out.append("\\t");
                    continue block9;
                }
                case 10: {
                    out.append("\\n");
                    continue block9;
                }
                case 12: {
                    out.append("\\f");
                    continue block9;
                }
                case 13: {
                    out.append("\\r");
                    continue block9;
                }
                case 92: {
                    out.append("\\\\");
                    continue block9;
                }
                case 34: 
                case 39: {
                    if (jsEscapingMode == JsEscapingMode.JSON && 39 == codePoint) {
                        out.append((char)codePoint);
                        continue block9;
                    }
                    if (jsEscapingMode != JsEscapingMode.EMBEDDABLE_JS) {
                        out.append('\\').append((char)codePoint);
                        continue block9;
                    }
                }
                default: {
                    if (codePoint >= 256 || jsEscapingMode == JsEscapingMode.JSON) {
                        StringUtil.appendHexJavaScriptRepresentation(codePoint, out);
                        continue block9;
                    }
                    boolean pad = i + charCount >= len || StringUtil.isOctal(plainText.charAt(i + charCount));
                    StringUtil.appendOctalJavaScriptRepresentation((char)codePoint, pad, out);
                }
            }
        }
        out.append(plainText, pos, len);
    }

    private static boolean shouldEscapeChar(int codePoint, boolean escapeToAscii, JsEscapingMode jsEscapingMode) {
        if (escapeToAscii && (codePoint < 32 || codePoint > 126)) {
            return true;
        }
        if (jsEscapingMode == JsEscapingMode.JSON) {
            return StringUtil.mustEscapeCharInJsonString(codePoint) || StringUtil.mustEscapeCharInJsString(codePoint);
        }
        return StringUtil.mustEscapeCharInJsString(codePoint);
    }

    private static void appendHexJavaScriptRepresentation(int codePoint, Appendable out) throws IOException {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            char[] surrogates = Character.toChars(codePoint);
            StringUtil.appendHexJavaScriptRepresentation(surrogates[0], out);
            StringUtil.appendHexJavaScriptRepresentation(surrogates[1], out);
            return;
        }
        out.append("\\u").append(HEX_CHARS[codePoint >>> 12 & 0xF]).append(HEX_CHARS[codePoint >>> 8 & 0xF]).append(HEX_CHARS[codePoint >>> 4 & 0xF]).append(HEX_CHARS[codePoint & 0xF]);
    }

    private static void appendOctalJavaScriptRepresentation(char ch, boolean pad, Appendable out) throws IOException {
        if (ch >= '@' || pad) {
            out.append('\\').append(OCTAL_CHARS[ch >>> 6 & 7]).append(OCTAL_CHARS[ch >>> 3 & 7]).append(OCTAL_CHARS[ch & 7]);
        } else if (ch >= '\b') {
            out.append('\\').append(OCTAL_CHARS[ch >>> 3 & 7]).append(OCTAL_CHARS[ch & 7]);
        } else {
            out.append('\\').append(OCTAL_CHARS[ch & 7]);
        }
    }

    public static void appendHexJavaScriptRepresentation(StringBuilder sb, char c) {
        try {
            StringUtil.appendHexJavaScriptRepresentation(c, sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String javaScriptUnescape(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\') {
                i = StringUtil.javaScriptUnescapeHelper(s, i + 1, sb);
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private static int javaScriptUnescapeHelper(String s, int i, StringBuilder sb) {
        if (i >= s.length()) {
            throw new IllegalArgumentException("End-of-string after escape character in [" + s + "]");
        }
        char c = s.charAt(i++);
        switch (c) {
            case 'n': {
                sb.append('\n');
                break;
            }
            case 'r': {
                sb.append('\r');
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'b': {
                sb.append('\b');
                break;
            }
            case 'f': {
                sb.append('\f');
                break;
            }
            case '\"': 
            case '\'': 
            case '>': 
            case '\\': {
                sb.append(c);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                int nOctalDigits;
                int digitLimit;
                --i;
                int n = digitLimit = c < '4' ? 3 : 2;
                for (nOctalDigits = 1; nOctalDigits < digitLimit && i + nOctalDigits < s.length() && StringUtil.isOctal(s.charAt(i + nOctalDigits)); ++nOctalDigits) {
                }
                sb.append((char)Integer.parseInt(s.substring(i, i + nOctalDigits), 8));
                i += nOctalDigits;
                break;
            }
            case 'u': 
            case 'x': {
                int unicodeValue;
                String hexCode;
                int nHexDigits = c == 'u' ? 4 : 2;
                try {
                    hexCode = s.substring(i, i + nHexDigits);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    throw new IllegalArgumentException("Invalid unicode sequence [" + s.substring(i) + "] at index " + i + " in [" + s + "]");
                }
                try {
                    unicodeValue = Integer.parseInt(hexCode, 16);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid unicode sequence [" + hexCode + "] at index " + i + " in [" + s + "]");
                }
                sb.append((char)unicodeValue);
                i += nHexDigits;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown escape code [" + c + "] at index " + i + " in [" + s + "]");
            }
        }
        return i;
    }

    public static String xmlCDataEscape(String s) {
        int found = (s = CONTROL_MATCHER.removeFrom(s)).indexOf("]]>");
        if (found == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int prev = 0;
        do {
            sb.append(s.substring(prev, found + 3));
            sb.append("]]&gt;<![CDATA[");
        } while ((found = s.indexOf("]]>", prev = found + 3)) != -1);
        sb.append(s.substring(prev));
        return sb.toString();
    }

    @Deprecated
    public static String javaEscape(String s) {
        return JAVA_ESCAPE.escape(s);
    }

    @Deprecated
    public static String regexEscape(String s) {
        return REGEX_ESCAPE.escape(s);
    }

    @Deprecated
    public static LinkedList<String> string2List(@Nullable String in, @Nullable String delimiter, boolean doStrip) {
        if (in == null) {
            return null;
        }
        LinkedList<String> out = new LinkedList<String>();
        StringUtil.string2Collection(in, delimiter, doStrip, out);
        return out;
    }

    @Deprecated
    public static Set<String> string2Set(@Nullable String in, @Nullable String delimiter, boolean doStrip) {
        if (in == null) {
            return null;
        }
        HashSet<String> out = new HashSet<String>();
        StringUtil.string2Collection(in, delimiter, doStrip, out);
        return out;
    }

    @Deprecated
    public static Collection<String> string2Collection(@Nullable String in, @Nullable String delimiter, boolean doStrip, Collection<String> collection) {
        String interim;
        int pos;
        if (in == null) {
            return null;
        }
        if (collection == null) {
            collection = new ArrayList<String>();
        }
        if (delimiter == null || delimiter.length() == 0) {
            collection.add(in);
            return collection;
        }
        int fromIndex = 0;
        while ((pos = in.indexOf(delimiter, fromIndex)) >= 0) {
            interim = in.substring(fromIndex, pos);
            if (doStrip) {
                interim = StringUtil.strip(interim);
            }
            if (!doStrip || interim.length() > 0) {
                collection.add(interim);
            }
            fromIndex = pos + delimiter.length();
        }
        interim = in.substring(fromIndex);
        if (doStrip) {
            interim = StringUtil.strip(interim);
        }
        if (!doStrip || interim.length() > 0) {
            collection.add(interim);
        }
        return collection;
    }

    public static HashMap<String, String> string2Map(@Nullable String in, @Nullable String delimEntry, @Nullable String delimKey, boolean doStripEntry) {
        if (in == null) {
            return null;
        }
        return StringUtil.stringToMapImpl(new HashMap(), in, delimEntry, delimKey, doStripEntry);
    }

    public static Map<String, String> stringToOrderedMap(@Nullable String in, @Nullable String delimEntry, @Nullable String delimKey, boolean doStripEntry) {
        if (in == null) {
            return null;
        }
        return StringUtil.stringToMapImpl(new LinkedHashMap(), in, delimEntry, delimKey, doStripEntry);
    }

    private static <T extends Map<String, String>> T stringToMapImpl(T out, String in, String delimEntry, String delimKey, boolean doStripEntry) {
        if (StringUtil.isEmpty(delimEntry) || StringUtil.isEmpty(delimKey)) {
            out.put((String)StringUtil.strip(in), (String)"");
            return out;
        }
        Iterator it = StringUtil.string2List(in, delimEntry, false).iterator();
        int len = delimKey.length();
        while (it.hasNext()) {
            String entry = (String)it.next();
            int pos = entry.indexOf(delimKey);
            if (pos > 0) {
                String value = entry.substring(pos + len);
                if (doStripEntry) {
                    value = StringUtil.strip(value);
                }
                out.put((String)StringUtil.strip(entry.substring(0, pos)), (String)value);
                continue;
            }
            out.put((String)StringUtil.strip(entry), (String)"");
        }
        return out;
    }

    @Deprecated
    public static <K, V> String map2String(@Nullable Map<K, V> in, String sepKey, String sepEntry) {
        return in == null ? null : Joiner.on(sepEntry).useForNull("null").withKeyValueSeparator(sepKey).join(in);
    }

    public static <V> Map<String, V> lowercaseKeys(Map<String, V> map) {
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        for (Map.Entry<String, V> entry : map.entrySet()) {
            String key = entry.getKey();
            if (result.containsKey(key.toLowerCase())) {
                throw new IllegalArgumentException("Duplicate string key in map when lower casing");
            }
            result.put(key.toLowerCase(), entry.getValue());
        }
        return result;
    }

    @Deprecated
    public static String collapseWhitespace(@Nullable String str) {
        return str == null ? null : CharMatcher.LEGACY_WHITESPACE.collapseFrom(str, ' ');
    }

    @Deprecated
    public static String collapse(@Nullable String str, String chars, String replacement) {
        if (str == null) {
            return null;
        }
        StringBuilder newStr = new StringBuilder();
        boolean prevCharMatched = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (chars.indexOf(c) != -1) {
                if (prevCharMatched) continue;
                prevCharMatched = true;
                newStr.append(replacement);
                continue;
            }
            prevCharMatched = false;
            newStr.append(c);
        }
        return newStr.toString();
    }

    @Deprecated
    public static String collapseControlChars(@Nullable String str, String replacement) {
        if (str == null) {
            return null;
        }
        StringBuilder newStr = new StringBuilder();
        boolean prevCharMatched = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isISOControl(c)) {
                if (prevCharMatched) continue;
                prevCharMatched = true;
                newStr.append(replacement);
                continue;
            }
            prevCharMatched = false;
            newStr.append(c);
        }
        return newStr.toString();
    }

    @Deprecated
    public static String stream2String(InputStream is, int maxLength) throws IOException {
        byte[] buffer = new byte[4096];
        StringWriter sw = new StringWriter();
        int totalRead = 0;
        int read = 0;
        do {
            sw.write(new String(buffer, 0, read));
            read = is.read(buffer, 0, buffer.length);
        } while ((-1 == maxLength || (totalRead += read) < maxLength) && read != -1);
        return sw.toString();
    }

    public static String[] parseDelimitedList(String list, char delimiter) {
        String delim = "" + delimiter;
        StringTokenizer st = new StringTokenizer(list + delim + " ", delim, true);
        ArrayList<String> v = new ArrayList<String>();
        String lastToken = "";
        StringBuilder word = new StringBuilder();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (lastToken != null) {
                if (tok.equals(delim)) {
                    word.append(lastToken);
                    if (lastToken.equals(delim)) {
                        tok = null;
                    }
                } else {
                    if (word.length() != 0) {
                        v.add(word.toString());
                    }
                    word.setLength(0);
                }
            }
            lastToken = tok;
        }
        return v.toArray(new String[0]);
    }

    @Deprecated
    public static int compareToIgnoreCase(@Nullable String s1, @Nullable String s2, boolean nullsAreGreater) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return nullsAreGreater ? 1 : -1;
        }
        if (s2 == null) {
            return nullsAreGreater ? -1 : 1;
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static String lastToken(String s, String delimiter) {
        return s.substring(CharMatcher.anyOf(delimiter).lastIndexIn(s) + 1);
    }

    public static boolean containsCharRef(String s) {
        return characterReferencePattern.matcher(s).find();
    }

    public static boolean isHebrew(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (!StringUtil.isHebrew(s.codePointAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isHebrew(int codePoint) {
        return Character.UnicodeBlock.HEBREW.equals(Character.UnicodeBlock.of(codePoint));
    }

    public static boolean isCjk(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (!StringUtil.isCjk(s.codePointAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isCjk(char ch) {
        return StringUtil.isCjk((int)ch);
    }

    public static boolean isCjk(int codePoint) {
        if ((codePoint & 0xFFFFFF00) == 0) {
            return false;
        }
        return CJK_BLOCKS.contains(Character.UnicodeBlock.of(codePoint));
    }

    public static int displayWidth(String s) {
        int width = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            width += StringUtil.displayWidth(s.charAt(i));
        }
        return width;
    }

    public static int displayWidth(char ch) {
        if (ch <= '\u04f9' || ch == '\u05be' || ch >= '\u05d0' && ch <= '\u05ea' || ch == '\u05f3' || ch == '\u05f4' || ch >= '\u0600' && ch <= '\u06ff' || ch >= '\u0750' && ch <= '\u077f' || ch >= '\ufb50' && ch <= '\ufdff' || ch >= '\ufe70' && ch <= '\ufeff' || ch >= '\u1e00' && ch <= '\u20af' || ch >= '\u2100' && ch <= '\u213a' || ch >= '\u0e00' && ch <= '\u0e7f' || ch >= '\uff61' && ch <= '\uffdc') {
            return 1;
        }
        return 2;
    }

    public static String toString(@Nullable float[] iArray) {
        if (iArray == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < iArray.length; ++i) {
            buffer.append(iArray[i]);
            if (i == iArray.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toString(@Nullable long[] iArray) {
        if (iArray == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < iArray.length; ++i) {
            buffer.append(iArray[i]);
            if (i == iArray.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toString(@Nullable int[] iArray) {
        if (iArray == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < iArray.length; ++i) {
            buffer.append(iArray[i]);
            if (i == iArray.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toString(@Nullable String[] iArray) {
        if (iArray == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < iArray.length; ++i) {
            buffer.append("'").append(iArray[i]).append("'");
            if (i == iArray.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toString(@Nullable String s) {
        if (s == null) {
            return "NULL";
        }
        return new StringBuilder(s.length() + 2).append("'").append(s).append("'").toString();
    }

    public static String toString(@Nullable int[][] iArray) {
        if (iArray == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < iArray.length; ++i) {
            buffer.append("[");
            for (int j = 0; j < iArray[i].length; ++j) {
                buffer.append(iArray[i][j]);
                if (j == iArray[i].length - 1) continue;
                buffer.append(", ");
            }
            buffer.append("]");
            if (i == iArray.length - 1) continue;
            buffer.append(" ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toString(@Nullable long[][] iArray) {
        if (iArray == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < iArray.length; ++i) {
            buffer.append("[");
            for (int j = 0; j < iArray[i].length; ++j) {
                buffer.append(iArray[i][j]);
                if (j == iArray[i].length - 1) continue;
                buffer.append(", ");
            }
            buffer.append("]");
            if (i == iArray.length - 1) continue;
            buffer.append(" ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toString(@Nullable Object[] obj) {
        if (obj == null) {
            return "NULL";
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append("[");
        for (int i = 0; i < obj.length; ++i) {
            tmp.append(obj[i].toString());
            if (i == obj.length - 1) continue;
            tmp.append(",");
        }
        tmp.append("]");
        return tmp.toString();
    }

    @Deprecated
    public static String bytesToHexString(byte[] bytes) {
        return ByteArrays.toHexString(bytes);
    }

    public static String bytesToHexString(byte[] bytes, @Nullable Character delimiter) {
        StringBuilder hex = new StringBuilder(bytes.length * (delimiter == null ? 2 : 3));
        for (int i = 0; i < bytes.length; ++i) {
            int nibble1 = bytes[i] >>> 4 & 0xF;
            int nibble2 = bytes[i] & 0xF;
            if (i > 0 && delimiter != null) {
                hex.append(delimiter.charValue());
            }
            hex.append(HEX_CHARS[nibble1]);
            hex.append(HEX_CHARS[nibble2]);
        }
        return hex.toString();
    }

    @Deprecated
    public static String bytesToUtf8(@Nullable byte[] ba) {
        return ba == null ? null : new String(ba, Charsets.UTF_8);
    }

    @Deprecated
    public static byte[] utf8ToBytes(@Nullable String str) {
        return str == null ? null : str.getBytes(Charsets.UTF_8);
    }

    public static String toUpperCase(@Nullable String src) {
        if (src == null) {
            return null;
        }
        return src.toUpperCase();
    }

    public static String toLowerCase(@Nullable String src) {
        if (src == null) {
            return null;
        }
        return src.toLowerCase();
    }

    public static String expandShardNames(String dbSpecComponent) throws IllegalArgumentException, IllegalStateException {
        Matcher matcher = dbSpecPattern.matcher(dbSpecComponent);
        if (matcher.find()) {
            try {
                String prefix = dbSpecComponent.substring(matcher.start(1), matcher.end(1));
                int minShard = Integer.parseInt(dbSpecComponent.substring(matcher.start(2), matcher.end(2)));
                int maxShard = Integer.parseInt(dbSpecComponent.substring(matcher.start(3), matcher.end(3)));
                String suffix = dbSpecComponent.substring(matcher.start(4), matcher.end(4));
                if (minShard > maxShard) {
                    throw new IllegalArgumentException("Maximum shard must be greater than or equal to the minimum shard");
                }
                StringBuilder tmp = new StringBuilder();
                for (int shard = minShard; shard <= maxShard; ++shard) {
                    tmp.append(prefix).append(shard).append(suffix);
                    if (shard == maxShard) continue;
                    tmp.append(",");
                }
                return tmp.toString();
            }
            catch (NumberFormatException nfex) {
                throw new IllegalArgumentException("Malformed DB specification component: " + dbSpecComponent);
            }
        }
        return dbSpecComponent;
    }

    public static String capitalize(String s) {
        char capitalized;
        if (s.isEmpty()) {
            return s;
        }
        char first = s.charAt(0);
        return first == (capitalized = Character.toUpperCase(first)) ? s : capitalized + s.substring(1);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        int len = suffix.length();
        return str.regionMatches(true, str.length() - len, suffix, 0, len);
    }

    private static int bytesUtf8(int c) {
        if (c < 128) {
            return 1;
        }
        if (c < 2048) {
            return 2;
        }
        if (c < 65536) {
            return 3;
        }
        if (c < 0x200000) {
            return 4;
        }
        if (c < 0x4000000) {
            return 5;
        }
        return 6;
    }

    public static int bytesStorage(String str) {
        String s = new String(str);
        int len = 0;
        int i = 0;
        while (i < s.length()) {
            len += StringUtil.bytesUtf8(s.codePointAt(i));
            i = s.offsetByCodePoints(i, 1);
        }
        return len;
    }

    public static String truncateStringForUtf8Storage(String str, int maxbytes) {
        int glyphBytes;
        if (maxbytes < 0) {
            throw new IndexOutOfBoundsException();
        }
        String s = new String(str);
        int codepoints = 0;
        int bytesUsed = 0;
        codepoints = 0;
        while (codepoints < s.length() && bytesUsed + (glyphBytes = StringUtil.bytesUtf8(s.codePointAt(codepoints))) <= maxbytes) {
            bytesUsed += glyphBytes;
            codepoints = s.offsetByCodePoints(codepoints, 1);
        }
        return s.substring(0, codepoints);
    }

    public static String truncateIfNecessary(String source, int maxLength) {
        if (source.length() <= maxLength) {
            return source;
        }
        CharMatcher whitespaceMatcher = CharMatcher.LEGACY_WHITESPACE;
        String str = StringUtil.unicodePreservingSubstring(source, 0, maxLength);
        String truncated = whitespaceMatcher.trimTrailingFrom(str);
        if (truncated.length() < maxLength) {
            return truncated;
        }
        if (Character.isSpaceChar(source.charAt(maxLength))) {
            return truncated;
        }
        for (int i = truncated.length() - 1; i >= 0; --i) {
            if (!Character.isSpaceChar(truncated.charAt(i))) continue;
            String substr = truncated.substring(0, i);
            return whitespaceMatcher.trimTrailingFrom(substr);
        }
        return truncated;
    }

    public static String truncateAtMaxLength(String source, int maxLength, boolean addEllipsis) {
        if (source.length() <= maxLength) {
            return source;
        }
        if (addEllipsis && maxLength > 3) {
            return StringUtil.unicodePreservingSubstring(source, 0, maxLength - 3) + "...";
        }
        return StringUtil.unicodePreservingSubstring(source, 0, maxLength);
    }

    public static int unicodePreservingIndex(String str, int index) {
        if (index > 0 && index < str.length() && Character.isHighSurrogate(str.charAt(index - 1)) && Character.isLowSurrogate(str.charAt(index))) {
            return index - 1;
        }
        return index;
    }

    public static String unicodePreservingSubstring(String str, int begin, int end) {
        return str.substring(StringUtil.unicodePreservingIndex(str, begin), StringUtil.unicodePreservingIndex(str, end));
    }

    public static String unicodePreservingSubstring(String str, int begin) {
        return StringUtil.unicodePreservingSubstring(str, begin, str.length());
    }

    @VisibleForTesting
    static boolean mustEscapeCharInJsString(int codepoint) {
        return JS_ESCAPE_CHARS.contains(codepoint);
    }

    @VisibleForTesting
    static boolean mustEscapeCharInJsonString(int codepoint) {
        return JSON_ESCAPE_CHARS.contains(codepoint);
    }

    public static String xmlEscape(String s) {
        return CharEscapers.xmlEscaper().escape(s);
    }

    public static String htmlEscape(String s) {
        return CharEscapers.asciiHtmlEscaper().escape(s);
    }

    static {
        ESCAPE_STRINGS.put("&nbsp", Character.valueOf('\u00a0'));
        ESCAPE_STRINGS.put("&iexcl", Character.valueOf('\u00a1'));
        ESCAPE_STRINGS.put("&cent", Character.valueOf('\u00a2'));
        ESCAPE_STRINGS.put("&pound", Character.valueOf('\u00a3'));
        ESCAPE_STRINGS.put("&curren", Character.valueOf('\u00a4'));
        ESCAPE_STRINGS.put("&yen", Character.valueOf('\u00a5'));
        ESCAPE_STRINGS.put("&brvbar", Character.valueOf('\u00a6'));
        ESCAPE_STRINGS.put("&sect", Character.valueOf('\u00a7'));
        ESCAPE_STRINGS.put("&uml", Character.valueOf('\u00a8'));
        ESCAPE_STRINGS.put("&copy", Character.valueOf('\u00a9'));
        ESCAPE_STRINGS.put("&ordf", Character.valueOf('\u00aa'));
        ESCAPE_STRINGS.put("&laquo", Character.valueOf('\u00ab'));
        ESCAPE_STRINGS.put("&not", Character.valueOf('\u00ac'));
        ESCAPE_STRINGS.put("&shy", Character.valueOf('\u00ad'));
        ESCAPE_STRINGS.put("&reg", Character.valueOf('\u00ae'));
        ESCAPE_STRINGS.put("&macr", Character.valueOf('\u00af'));
        ESCAPE_STRINGS.put("&deg", Character.valueOf('\u00b0'));
        ESCAPE_STRINGS.put("&plusmn", Character.valueOf('\u00b1'));
        ESCAPE_STRINGS.put("&sup2", Character.valueOf('\u00b2'));
        ESCAPE_STRINGS.put("&sup3", Character.valueOf('\u00b3'));
        ESCAPE_STRINGS.put("&acute", Character.valueOf('\u00b4'));
        ESCAPE_STRINGS.put("&micro", Character.valueOf('\u00b5'));
        ESCAPE_STRINGS.put("&para", Character.valueOf('\u00b6'));
        ESCAPE_STRINGS.put("&middot", Character.valueOf('\u00b7'));
        ESCAPE_STRINGS.put("&cedil", Character.valueOf('\u00b8'));
        ESCAPE_STRINGS.put("&sup1", Character.valueOf('\u00b9'));
        ESCAPE_STRINGS.put("&ordm", Character.valueOf('\u00ba'));
        ESCAPE_STRINGS.put("&raquo", Character.valueOf('\u00bb'));
        ESCAPE_STRINGS.put("&frac14", Character.valueOf('\u00bc'));
        ESCAPE_STRINGS.put("&frac12", Character.valueOf('\u00bd'));
        ESCAPE_STRINGS.put("&frac34", Character.valueOf('\u00be'));
        ESCAPE_STRINGS.put("&iquest", Character.valueOf('\u00bf'));
        ESCAPE_STRINGS.put("&Agrave", Character.valueOf('\u00c0'));
        ESCAPE_STRINGS.put("&Aacute", Character.valueOf('\u00c1'));
        ESCAPE_STRINGS.put("&Acirc", Character.valueOf('\u00c2'));
        ESCAPE_STRINGS.put("&Atilde", Character.valueOf('\u00c3'));
        ESCAPE_STRINGS.put("&Auml", Character.valueOf('\u00c4'));
        ESCAPE_STRINGS.put("&Aring", Character.valueOf('\u00c5'));
        ESCAPE_STRINGS.put("&AElig", Character.valueOf('\u00c6'));
        ESCAPE_STRINGS.put("&Ccedil", Character.valueOf('\u00c7'));
        ESCAPE_STRINGS.put("&Egrave", Character.valueOf('\u00c8'));
        ESCAPE_STRINGS.put("&Eacute", Character.valueOf('\u00c9'));
        ESCAPE_STRINGS.put("&Ecirc", Character.valueOf('\u00ca'));
        ESCAPE_STRINGS.put("&Euml", Character.valueOf('\u00cb'));
        ESCAPE_STRINGS.put("&Igrave", Character.valueOf('\u00cc'));
        ESCAPE_STRINGS.put("&Iacute", Character.valueOf('\u00cd'));
        ESCAPE_STRINGS.put("&Icirc", Character.valueOf('\u00ce'));
        ESCAPE_STRINGS.put("&Iuml", Character.valueOf('\u00cf'));
        ESCAPE_STRINGS.put("&ETH", Character.valueOf('\u00d0'));
        ESCAPE_STRINGS.put("&Ntilde", Character.valueOf('\u00d1'));
        ESCAPE_STRINGS.put("&Ograve", Character.valueOf('\u00d2'));
        ESCAPE_STRINGS.put("&Oacute", Character.valueOf('\u00d3'));
        ESCAPE_STRINGS.put("&Ocirc", Character.valueOf('\u00d4'));
        ESCAPE_STRINGS.put("&Otilde", Character.valueOf('\u00d5'));
        ESCAPE_STRINGS.put("&Ouml", Character.valueOf('\u00d6'));
        ESCAPE_STRINGS.put("&times", Character.valueOf('\u00d7'));
        ESCAPE_STRINGS.put("&Oslash", Character.valueOf('\u00d8'));
        ESCAPE_STRINGS.put("&Ugrave", Character.valueOf('\u00d9'));
        ESCAPE_STRINGS.put("&Uacute", Character.valueOf('\u00da'));
        ESCAPE_STRINGS.put("&Ucirc", Character.valueOf('\u00db'));
        ESCAPE_STRINGS.put("&Uuml", Character.valueOf('\u00dc'));
        ESCAPE_STRINGS.put("&Yacute", Character.valueOf('\u00dd'));
        ESCAPE_STRINGS.put("&THORN", Character.valueOf('\u00de'));
        ESCAPE_STRINGS.put("&szlig", Character.valueOf('\u00df'));
        ESCAPE_STRINGS.put("&agrave", Character.valueOf('\u00e0'));
        ESCAPE_STRINGS.put("&aacute", Character.valueOf('\u00e1'));
        ESCAPE_STRINGS.put("&acirc", Character.valueOf('\u00e2'));
        ESCAPE_STRINGS.put("&atilde", Character.valueOf('\u00e3'));
        ESCAPE_STRINGS.put("&auml", Character.valueOf('\u00e4'));
        ESCAPE_STRINGS.put("&aring", Character.valueOf('\u00e5'));
        ESCAPE_STRINGS.put("&aelig", Character.valueOf('\u00e6'));
        ESCAPE_STRINGS.put("&ccedil", Character.valueOf('\u00e7'));
        ESCAPE_STRINGS.put("&egrave", Character.valueOf('\u00e8'));
        ESCAPE_STRINGS.put("&eacute", Character.valueOf('\u00e9'));
        ESCAPE_STRINGS.put("&ecirc", Character.valueOf('\u00ea'));
        ESCAPE_STRINGS.put("&euml", Character.valueOf('\u00eb'));
        ESCAPE_STRINGS.put("&igrave", Character.valueOf('\u00ec'));
        ESCAPE_STRINGS.put("&iacute", Character.valueOf('\u00ed'));
        ESCAPE_STRINGS.put("&icirc", Character.valueOf('\u00ee'));
        ESCAPE_STRINGS.put("&iuml", Character.valueOf('\u00ef'));
        ESCAPE_STRINGS.put("&eth", Character.valueOf('\u00f0'));
        ESCAPE_STRINGS.put("&ntilde", Character.valueOf('\u00f1'));
        ESCAPE_STRINGS.put("&ograve", Character.valueOf('\u00f2'));
        ESCAPE_STRINGS.put("&oacute", Character.valueOf('\u00f3'));
        ESCAPE_STRINGS.put("&ocirc", Character.valueOf('\u00f4'));
        ESCAPE_STRINGS.put("&otilde", Character.valueOf('\u00f5'));
        ESCAPE_STRINGS.put("&ouml", Character.valueOf('\u00f6'));
        ESCAPE_STRINGS.put("&divide", Character.valueOf('\u00f7'));
        ESCAPE_STRINGS.put("&oslash", Character.valueOf('\u00f8'));
        ESCAPE_STRINGS.put("&ugrave", Character.valueOf('\u00f9'));
        ESCAPE_STRINGS.put("&uacute", Character.valueOf('\u00fa'));
        ESCAPE_STRINGS.put("&ucirc", Character.valueOf('\u00fb'));
        ESCAPE_STRINGS.put("&uuml", Character.valueOf('\u00fc'));
        ESCAPE_STRINGS.put("&yacute", Character.valueOf('\u00fd'));
        ESCAPE_STRINGS.put("&thorn", Character.valueOf('\u00fe'));
        ESCAPE_STRINGS.put("&yuml", Character.valueOf('\u00ff'));
        ESCAPE_STRINGS.put("&fnof", Character.valueOf('\u0192'));
        ESCAPE_STRINGS.put("&Alpha", Character.valueOf('\u0391'));
        ESCAPE_STRINGS.put("&Beta", Character.valueOf('\u0392'));
        ESCAPE_STRINGS.put("&Gamma", Character.valueOf('\u0393'));
        ESCAPE_STRINGS.put("&Delta", Character.valueOf('\u0394'));
        ESCAPE_STRINGS.put("&Epsilon", Character.valueOf('\u0395'));
        ESCAPE_STRINGS.put("&Zeta", Character.valueOf('\u0396'));
        ESCAPE_STRINGS.put("&Eta", Character.valueOf('\u0397'));
        ESCAPE_STRINGS.put("&Theta", Character.valueOf('\u0398'));
        ESCAPE_STRINGS.put("&Iota", Character.valueOf('\u0399'));
        ESCAPE_STRINGS.put("&Kappa", Character.valueOf('\u039a'));
        ESCAPE_STRINGS.put("&Lambda", Character.valueOf('\u039b'));
        ESCAPE_STRINGS.put("&Mu", Character.valueOf('\u039c'));
        ESCAPE_STRINGS.put("&Nu", Character.valueOf('\u039d'));
        ESCAPE_STRINGS.put("&Xi", Character.valueOf('\u039e'));
        ESCAPE_STRINGS.put("&Omicron", Character.valueOf('\u039f'));
        ESCAPE_STRINGS.put("&Pi", Character.valueOf('\u03a0'));
        ESCAPE_STRINGS.put("&Rho", Character.valueOf('\u03a1'));
        ESCAPE_STRINGS.put("&Sigma", Character.valueOf('\u03a3'));
        ESCAPE_STRINGS.put("&Tau", Character.valueOf('\u03a4'));
        ESCAPE_STRINGS.put("&Upsilon", Character.valueOf('\u03a5'));
        ESCAPE_STRINGS.put("&Phi", Character.valueOf('\u03a6'));
        ESCAPE_STRINGS.put("&Chi", Character.valueOf('\u03a7'));
        ESCAPE_STRINGS.put("&Psi", Character.valueOf('\u03a8'));
        ESCAPE_STRINGS.put("&Omega", Character.valueOf('\u03a9'));
        ESCAPE_STRINGS.put("&alpha", Character.valueOf('\u03b1'));
        ESCAPE_STRINGS.put("&beta", Character.valueOf('\u03b2'));
        ESCAPE_STRINGS.put("&gamma", Character.valueOf('\u03b3'));
        ESCAPE_STRINGS.put("&delta", Character.valueOf('\u03b4'));
        ESCAPE_STRINGS.put("&epsilon", Character.valueOf('\u03b5'));
        ESCAPE_STRINGS.put("&zeta", Character.valueOf('\u03b6'));
        ESCAPE_STRINGS.put("&eta", Character.valueOf('\u03b7'));
        ESCAPE_STRINGS.put("&theta", Character.valueOf('\u03b8'));
        ESCAPE_STRINGS.put("&iota", Character.valueOf('\u03b9'));
        ESCAPE_STRINGS.put("&kappa", Character.valueOf('\u03ba'));
        ESCAPE_STRINGS.put("&lambda", Character.valueOf('\u03bb'));
        ESCAPE_STRINGS.put("&mu", Character.valueOf('\u03bc'));
        ESCAPE_STRINGS.put("&nu", Character.valueOf('\u03bd'));
        ESCAPE_STRINGS.put("&xi", Character.valueOf('\u03be'));
        ESCAPE_STRINGS.put("&omicron", Character.valueOf('\u03bf'));
        ESCAPE_STRINGS.put("&pi", Character.valueOf('\u03c0'));
        ESCAPE_STRINGS.put("&rho", Character.valueOf('\u03c1'));
        ESCAPE_STRINGS.put("&sigmaf", Character.valueOf('\u03c2'));
        ESCAPE_STRINGS.put("&sigma", Character.valueOf('\u03c3'));
        ESCAPE_STRINGS.put("&tau", Character.valueOf('\u03c4'));
        ESCAPE_STRINGS.put("&upsilon", Character.valueOf('\u03c5'));
        ESCAPE_STRINGS.put("&phi", Character.valueOf('\u03c6'));
        ESCAPE_STRINGS.put("&chi", Character.valueOf('\u03c7'));
        ESCAPE_STRINGS.put("&psi", Character.valueOf('\u03c8'));
        ESCAPE_STRINGS.put("&omega", Character.valueOf('\u03c9'));
        ESCAPE_STRINGS.put("&thetasym", Character.valueOf('\u03d1'));
        ESCAPE_STRINGS.put("&upsih", Character.valueOf('\u03d2'));
        ESCAPE_STRINGS.put("&piv", Character.valueOf('\u03d6'));
        ESCAPE_STRINGS.put("&bull", Character.valueOf('\u2022'));
        ESCAPE_STRINGS.put("&hellip", Character.valueOf('\u2026'));
        ESCAPE_STRINGS.put("&prime", Character.valueOf('\u2032'));
        ESCAPE_STRINGS.put("&Prime", Character.valueOf('\u2033'));
        ESCAPE_STRINGS.put("&oline", Character.valueOf('\u203e'));
        ESCAPE_STRINGS.put("&frasl", Character.valueOf('\u2044'));
        ESCAPE_STRINGS.put("&weierp", Character.valueOf('\u2118'));
        ESCAPE_STRINGS.put("&image", Character.valueOf('\u2111'));
        ESCAPE_STRINGS.put("&real", Character.valueOf('\u211c'));
        ESCAPE_STRINGS.put("&trade", Character.valueOf('\u2122'));
        ESCAPE_STRINGS.put("&alefsym", Character.valueOf('\u2135'));
        ESCAPE_STRINGS.put("&larr", Character.valueOf('\u2190'));
        ESCAPE_STRINGS.put("&uarr", Character.valueOf('\u2191'));
        ESCAPE_STRINGS.put("&rarr", Character.valueOf('\u2192'));
        ESCAPE_STRINGS.put("&darr", Character.valueOf('\u2193'));
        ESCAPE_STRINGS.put("&harr", Character.valueOf('\u2194'));
        ESCAPE_STRINGS.put("&crarr", Character.valueOf('\u21b5'));
        ESCAPE_STRINGS.put("&lArr", Character.valueOf('\u21d0'));
        ESCAPE_STRINGS.put("&uArr", Character.valueOf('\u21d1'));
        ESCAPE_STRINGS.put("&rArr", Character.valueOf('\u21d2'));
        ESCAPE_STRINGS.put("&dArr", Character.valueOf('\u21d3'));
        ESCAPE_STRINGS.put("&hArr", Character.valueOf('\u21d4'));
        ESCAPE_STRINGS.put("&forall", Character.valueOf('\u2200'));
        ESCAPE_STRINGS.put("&part", Character.valueOf('\u2202'));
        ESCAPE_STRINGS.put("&exist", Character.valueOf('\u2203'));
        ESCAPE_STRINGS.put("&empty", Character.valueOf('\u2205'));
        ESCAPE_STRINGS.put("&nabla", Character.valueOf('\u2207'));
        ESCAPE_STRINGS.put("&isin", Character.valueOf('\u2208'));
        ESCAPE_STRINGS.put("&notin", Character.valueOf('\u2209'));
        ESCAPE_STRINGS.put("&ni", Character.valueOf('\u220b'));
        ESCAPE_STRINGS.put("&prod", Character.valueOf('\u220f'));
        ESCAPE_STRINGS.put("&sum", Character.valueOf('\u2211'));
        ESCAPE_STRINGS.put("&minus", Character.valueOf('\u2212'));
        ESCAPE_STRINGS.put("&lowast", Character.valueOf('\u2217'));
        ESCAPE_STRINGS.put("&radic", Character.valueOf('\u221a'));
        ESCAPE_STRINGS.put("&prop", Character.valueOf('\u221d'));
        ESCAPE_STRINGS.put("&infin", Character.valueOf('\u221e'));
        ESCAPE_STRINGS.put("&ang", Character.valueOf('\u2220'));
        ESCAPE_STRINGS.put("&and", Character.valueOf('\u2227'));
        ESCAPE_STRINGS.put("&or", Character.valueOf('\u2228'));
        ESCAPE_STRINGS.put("&cap", Character.valueOf('\u2229'));
        ESCAPE_STRINGS.put("&cup", Character.valueOf('\u222a'));
        ESCAPE_STRINGS.put("&int", Character.valueOf('\u222b'));
        ESCAPE_STRINGS.put("&there4", Character.valueOf('\u2234'));
        ESCAPE_STRINGS.put("&sim", Character.valueOf('\u223c'));
        ESCAPE_STRINGS.put("&cong", Character.valueOf('\u2245'));
        ESCAPE_STRINGS.put("&asymp", Character.valueOf('\u2248'));
        ESCAPE_STRINGS.put("&ne", Character.valueOf('\u2260'));
        ESCAPE_STRINGS.put("&equiv", Character.valueOf('\u2261'));
        ESCAPE_STRINGS.put("&le", Character.valueOf('\u2264'));
        ESCAPE_STRINGS.put("&ge", Character.valueOf('\u2265'));
        ESCAPE_STRINGS.put("&sub", Character.valueOf('\u2282'));
        ESCAPE_STRINGS.put("&sup", Character.valueOf('\u2283'));
        ESCAPE_STRINGS.put("&nsub", Character.valueOf('\u2284'));
        ESCAPE_STRINGS.put("&sube", Character.valueOf('\u2286'));
        ESCAPE_STRINGS.put("&supe", Character.valueOf('\u2287'));
        ESCAPE_STRINGS.put("&oplus", Character.valueOf('\u2295'));
        ESCAPE_STRINGS.put("&otimes", Character.valueOf('\u2297'));
        ESCAPE_STRINGS.put("&perp", Character.valueOf('\u22a5'));
        ESCAPE_STRINGS.put("&sdot", Character.valueOf('\u22c5'));
        ESCAPE_STRINGS.put("&lceil", Character.valueOf('\u2308'));
        ESCAPE_STRINGS.put("&rceil", Character.valueOf('\u2309'));
        ESCAPE_STRINGS.put("&lfloor", Character.valueOf('\u230a'));
        ESCAPE_STRINGS.put("&rfloor", Character.valueOf('\u230b'));
        ESCAPE_STRINGS.put("&lang", Character.valueOf('\u2329'));
        ESCAPE_STRINGS.put("&rang", Character.valueOf('\u232a'));
        ESCAPE_STRINGS.put("&loz", Character.valueOf('\u25ca'));
        ESCAPE_STRINGS.put("&spades", Character.valueOf('\u2660'));
        ESCAPE_STRINGS.put("&clubs", Character.valueOf('\u2663'));
        ESCAPE_STRINGS.put("&hearts", Character.valueOf('\u2665'));
        ESCAPE_STRINGS.put("&diams", Character.valueOf('\u2666'));
        ESCAPE_STRINGS.put("&quot", Character.valueOf('\"'));
        ESCAPE_STRINGS.put("&amp", Character.valueOf('&'));
        ESCAPE_STRINGS.put("&lt", Character.valueOf('<'));
        ESCAPE_STRINGS.put("&gt", Character.valueOf('>'));
        ESCAPE_STRINGS.put("&OElig", Character.valueOf('\u0152'));
        ESCAPE_STRINGS.put("&oelig", Character.valueOf('\u0153'));
        ESCAPE_STRINGS.put("&Scaron", Character.valueOf('\u0160'));
        ESCAPE_STRINGS.put("&scaron", Character.valueOf('\u0161'));
        ESCAPE_STRINGS.put("&Yuml", Character.valueOf('\u0178'));
        ESCAPE_STRINGS.put("&circ", Character.valueOf('\u02c6'));
        ESCAPE_STRINGS.put("&tilde", Character.valueOf('\u02dc'));
        ESCAPE_STRINGS.put("&ensp", Character.valueOf('\u2002'));
        ESCAPE_STRINGS.put("&emsp", Character.valueOf('\u2003'));
        ESCAPE_STRINGS.put("&thinsp", Character.valueOf('\u2009'));
        ESCAPE_STRINGS.put("&zwnj", Character.valueOf('\u200c'));
        ESCAPE_STRINGS.put("&zwj", Character.valueOf('\u200d'));
        ESCAPE_STRINGS.put("&lrm", Character.valueOf('\u200e'));
        ESCAPE_STRINGS.put("&rlm", Character.valueOf('\u200f'));
        ESCAPE_STRINGS.put("&ndash", Character.valueOf('\u2013'));
        ESCAPE_STRINGS.put("&mdash", Character.valueOf('\u2014'));
        ESCAPE_STRINGS.put("&lsquo", Character.valueOf('\u2018'));
        ESCAPE_STRINGS.put("&rsquo", Character.valueOf('\u2019'));
        ESCAPE_STRINGS.put("&sbquo", Character.valueOf('\u201a'));
        ESCAPE_STRINGS.put("&ldquo", Character.valueOf('\u201c'));
        ESCAPE_STRINGS.put("&rdquo", Character.valueOf('\u201d'));
        ESCAPE_STRINGS.put("&bdquo", Character.valueOf('\u201e'));
        ESCAPE_STRINGS.put("&dagger", Character.valueOf('\u2020'));
        ESCAPE_STRINGS.put("&Dagger", Character.valueOf('\u2021'));
        ESCAPE_STRINGS.put("&permil", Character.valueOf('\u2030'));
        ESCAPE_STRINGS.put("&lsaquo", Character.valueOf('\u2039'));
        ESCAPE_STRINGS.put("&rsaquo", Character.valueOf('\u203a'));
        ESCAPE_STRINGS.put("&euro", Character.valueOf('\u20ac'));
        HEX_LETTERS = new HashSet<Character>(12);
        HEX_LETTERS.add(Character.valueOf('a'));
        HEX_LETTERS.add(Character.valueOf('A'));
        HEX_LETTERS.add(Character.valueOf('b'));
        HEX_LETTERS.add(Character.valueOf('B'));
        HEX_LETTERS.add(Character.valueOf('c'));
        HEX_LETTERS.add(Character.valueOf('C'));
        HEX_LETTERS.add(Character.valueOf('d'));
        HEX_LETTERS.add(Character.valueOf('D'));
        HEX_LETTERS.add(Character.valueOf('e'));
        HEX_LETTERS.add(Character.valueOf('E'));
        HEX_LETTERS.add(Character.valueOf('f'));
        HEX_LETTERS.add(Character.valueOf('F'));
        LT_GT_ESCAPE = new CharEscaperBuilder().addEscape('<', "&lt;").addEscape('>', "&gt;").toEscaper();
        htmlTagPattern = Pattern.compile("</?[a-zA-Z][^>]*>");
        CONTROL_MATCHER = CharMatcher.anyOf("\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\ufffe\uffff");
        JAVA_ESCAPE = new CharEscaperBuilder().addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\t', "\\t").addEscape('\\', "\\\\").addEscape('\"', "\\\"").addEscape('&', "&amp;").addEscape('<', "&lt;").addEscape('>', "&gt;").addEscape('\'', "\\'").toEscaper();
        REGEX_ESCAPE = new CharEscaperBuilder().addEscape('(', "\\(").addEscape(')', "\\)").addEscape('|', "\\|").addEscape('*', "\\*").addEscape('+', "\\+").addEscape('?', "\\?").addEscape('.', "\\.").addEscape('{', "\\{").addEscape('}', "\\}").addEscape('[', "\\[").addEscape(']', "\\]").addEscape('$', "\\$").addEscape('^', "\\^").addEscape('\\', "\\\\").toEscaper();
        characterReferencePattern = Pattern.compile("&#?[a-zA-Z0-9]{1,8};");
        HashSet<Character.UnicodeBlock> set = new HashSet<Character.UnicodeBlock>();
        set.add(Character.UnicodeBlock.HANGUL_JAMO);
        set.add(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT);
        set.add(Character.UnicodeBlock.KANGXI_RADICALS);
        set.add(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION);
        set.add(Character.UnicodeBlock.HIRAGANA);
        set.add(Character.UnicodeBlock.KATAKANA);
        set.add(Character.UnicodeBlock.BOPOMOFO);
        set.add(Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO);
        set.add(Character.UnicodeBlock.KANBUN);
        set.add(Character.UnicodeBlock.BOPOMOFO_EXTENDED);
        set.add(Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS);
        set.add(Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS);
        set.add(Character.UnicodeBlock.CJK_COMPATIBILITY);
        set.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
        set.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        set.add(Character.UnicodeBlock.HANGUL_SYLLABLES);
        set.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        set.add(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS);
        set.add(Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS);
        set.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B);
        set.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT);
        CJK_BLOCKS = Collections.unmodifiableSet(set);
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        OCTAL_CHARS = HEX_CHARS;
        dbSpecPattern = Pattern.compile("(.*)\\{(\\d+),(\\d+)\\}(.*)");
        JS_ESCAPE_CHARS = new UnicodeSetBuilder().addCodePoint(173).addRange(1536, 1539).addCodePoint(1757).addCodePoint(1807).addRange(6068, 6069).addRange(8203, 8207).addRange(8234, 8238).addRange(8288, 8292).addRange(8298, 8303).addCodePoint(65279).addRange(65529, 65531).addRange(119155, 119162).addCodePoint(917505).addRange(917536, 917631).addCodePoint(0).addCodePoint(10).addCodePoint(13).addRange(8232, 8233).addCodePoint(133).addCodePoint(Character.codePointAt("'", 0)).addCodePoint(Character.codePointAt("\"", 0)).addCodePoint(Character.codePointAt("&", 0)).addCodePoint(Character.codePointAt("<", 0)).addCodePoint(Character.codePointAt(">", 0)).addCodePoint(Character.codePointAt("=", 0)).addCodePoint(Character.codePointAt("\\", 0)).create();
        JSON_ESCAPE_CHARS = new UnicodeSetBuilder().addCodePoint(Character.codePointAt("\"", 0)).addCodePoint(Character.codePointAt("\\", 0)).addRange(0, 31).create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnicodeSetBuilder {
        Set<Integer> codePointSet = new HashSet<Integer>();

        private UnicodeSetBuilder() {
        }

        UnicodeSetBuilder addCodePoint(int c) {
            this.codePointSet.add(c);
            return this;
        }

        UnicodeSetBuilder addRange(int from, int to) {
            for (int i = from; i <= to; ++i) {
                this.codePointSet.add(i);
            }
            return this;
        }

        Set<Integer> create() {
            return this.codePointSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JsEscapingMode {
        JSON,
        EMBEDDABLE_JS,
        MINIMAL_JS;

    }
}

