/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@GoogleInternal
public final class MapMakerSpec {
    private static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put("initialCapacity", new InitialCapacityParser()).put("maximumSize", (InitialCapacityParser)((Object)new MaximumSizeParser())).put("concurrencyLevel", (InitialCapacityParser)((Object)new ConcurrencyLevelParser())).put("softKeys", (InitialCapacityParser)((Object)new KeyStrengthParser(Strength.SOFT))).put("weakKeys", (InitialCapacityParser)((Object)new KeyStrengthParser(Strength.WEAK))).put("softValues", (InitialCapacityParser)((Object)new ValueStrengthParser(Strength.SOFT))).put("weakValues", (InitialCapacityParser)((Object)new ValueStrengthParser(Strength.WEAK))).put("expireAfterAccess", (InitialCapacityParser)((Object)new AccessDurationParser())).put("expireAfterWrite", (InitialCapacityParser)((Object)new WriteDurationParser())).build();
    @VisibleForTesting
    Integer initialCapacity;
    @VisibleForTesting
    Integer maximumSize;
    @VisibleForTesting
    Integer concurrencyLevel;
    @VisibleForTesting
    Strength keyStrength;
    @VisibleForTesting
    Strength valueStrength;
    @VisibleForTesting
    long writeExpirationDuration;
    @VisibleForTesting
    TimeUnit writeExpirationTimeUnit;
    @VisibleForTesting
    long accessExpirationDuration;
    @VisibleForTesting
    TimeUnit accessExpirationTimeUnit;
    private final String specification;

    private MapMakerSpec(String specification) {
        this.specification = specification;
    }

    public static MapMakerSpec parse(String mapMakerSpecification) {
        MapMakerSpec spec = new MapMakerSpec(mapMakerSpecification);
        if (!mapMakerSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split(mapMakerSpecification)) {
                List<String> keyAndValue = KEY_VALUE_SPLITTER.splitToList(keyValuePair);
                Preconditions.checkArgument(!keyAndValue.isEmpty(), "blank key-value pair");
                Preconditions.checkArgument(keyAndValue.size() <= 2, "key-value pair %s with more than one equals sign", keyValuePair);
                String key = keyAndValue.get(0);
                ValueParser valueParser = VALUE_PARSERS.get(key);
                Preconditions.checkArgument(valueParser != null, "unknown key %s", key);
                String value = keyAndValue.size() == 1 ? null : keyAndValue.get(1);
                valueParser.parse(spec, key, value);
            }
        }
        return spec;
    }

    public static MapMakerSpec disableCaching() {
        return MapMakerSpec.parse("maximumSize=0");
    }

    public MapMaker toMapMaker() {
        MapMaker mapMaker = new MapMaker();
        if (this.initialCapacity != null) {
            mapMaker.initialCapacity(this.initialCapacity);
        }
        if (this.maximumSize != null) {
            mapMaker.maximumSize(this.maximumSize);
        }
        if (this.concurrencyLevel != null) {
            mapMaker.concurrencyLevel(this.concurrencyLevel);
        }
        if (this.keyStrength != null) {
            switch (this.keyStrength) {
                case SOFT: {
                    mapMaker.softKeys();
                    break;
                }
                case WEAK: {
                    mapMaker.weakKeys();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.valueStrength != null) {
            switch (this.valueStrength) {
                case SOFT: {
                    mapMaker.softValues();
                    break;
                }
                case WEAK: {
                    mapMaker.weakValues();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.writeExpirationTimeUnit != null) {
            mapMaker.expireAfterWrite(this.writeExpirationDuration, this.writeExpirationTimeUnit);
        }
        if (this.accessExpirationTimeUnit != null) {
            mapMaker.expireAfterAccess(this.accessExpirationDuration, this.accessExpirationTimeUnit);
        }
        return mapMaker;
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.toParsableString()).toString();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.initialCapacity, this.maximumSize, this.concurrencyLevel, this.keyStrength, this.valueStrength, MapMakerSpec.expirationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), MapMakerSpec.expirationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit)});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapMakerSpec)) {
            return false;
        }
        MapMakerSpec that = (MapMakerSpec)obj;
        return Objects.equal(this.initialCapacity, that.initialCapacity) && Objects.equal(this.maximumSize, that.maximumSize) && Objects.equal(this.concurrencyLevel, that.concurrencyLevel) && Objects.equal((Object)this.keyStrength, (Object)that.keyStrength) && Objects.equal((Object)this.valueStrength, (Object)that.valueStrength) && Objects.equal(MapMakerSpec.expirationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), MapMakerSpec.expirationInNanos(that.writeExpirationDuration, that.writeExpirationTimeUnit)) && Objects.equal(MapMakerSpec.expirationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), MapMakerSpec.expirationInNanos(that.accessExpirationDuration, that.accessExpirationTimeUnit));
    }

    @Nullable
    private static Long expirationInNanos(long duration, @Nullable TimeUnit unit) {
        if (unit == null) {
            return null;
        }
        return unit.toNanos(duration);
    }

    static class WriteDurationParser
    extends DurationParser {
        WriteDurationParser() {
        }

        protected void parseDuration(MapMakerSpec spec, long duration, TimeUnit unit) {
            spec.writeExpirationDuration = duration;
            spec.writeExpirationTimeUnit = unit;
        }
    }

    static class AccessDurationParser
    extends DurationParser {
        AccessDurationParser() {
        }

        protected void parseDuration(MapMakerSpec spec, long duration, TimeUnit unit) {
            spec.accessExpirationDuration = duration;
            spec.accessExpirationTimeUnit = unit;
        }
    }

    static abstract class DurationParser
    implements ValueParser {
        DurationParser() {
        }

        protected abstract void parseDuration(MapMakerSpec var1, long var2, TimeUnit var4);

        public void parse(MapMakerSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            Preconditions.checkArgument(spec.accessExpirationTimeUnit == null, "expireAfterAccess already set");
            Preconditions.checkArgument(spec.writeExpirationTimeUnit == null, "expireAfterWrite already set");
            try {
                TimeUnit timeUnit;
                char lastChar = value.charAt(value.length() - 1);
                switch (lastChar) {
                    case 'd': {
                        timeUnit = TimeUnit.DAYS;
                        break;
                    }
                    case 'h': {
                        timeUnit = TimeUnit.HOURS;
                        break;
                    }
                    case 'm': {
                        timeUnit = TimeUnit.MINUTES;
                        break;
                    }
                    case 's': {
                        timeUnit = TimeUnit.SECONDS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("key %s invalid format.  was %s, must end with one of [dDhHmMsS]", key, value));
                    }
                }
                long duration = Long.parseLong(value.substring(0, value.length() - 1));
                this.parseDuration(spec, duration, timeUnit);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value));
            }
        }
    }

    static class ValueStrengthParser
    implements ValueParser {
        private final Strength strength;

        public ValueStrengthParser(Strength strength) {
            this.strength = strength;
        }

        public void parse(MapMakerSpec spec, String key, @Nullable String value) {
            Preconditions.checkArgument(value == null, "key %s does not take values", key);
            Preconditions.checkArgument(spec.valueStrength == null, "%s was already set to %s", new Object[]{key, spec.valueStrength});
            spec.valueStrength = this.strength;
        }
    }

    static class KeyStrengthParser
    implements ValueParser {
        private final Strength strength;

        public KeyStrengthParser(Strength strength) {
            this.strength = strength;
        }

        public void parse(MapMakerSpec spec, String key, @Nullable String value) {
            Preconditions.checkArgument(value == null, "key %s does not take values", key);
            Preconditions.checkArgument(spec.keyStrength == null, "%s was already set to %s", new Object[]{key, spec.keyStrength});
            spec.keyStrength = this.strength;
        }
    }

    static class ConcurrencyLevelParser
    extends IntegerParser {
        ConcurrencyLevelParser() {
        }

        protected void parseInteger(MapMakerSpec spec, int value) {
            Preconditions.checkArgument(spec.concurrencyLevel == null, "concurrency level was already set to ", spec.concurrencyLevel);
            spec.concurrencyLevel = value;
        }
    }

    static class MaximumSizeParser
    extends IntegerParser {
        MaximumSizeParser() {
        }

        protected void parseInteger(MapMakerSpec spec, int value) {
            Preconditions.checkArgument(spec.maximumSize == null, "maximum size was already set to ", spec.maximumSize);
            spec.maximumSize = value;
        }
    }

    static class InitialCapacityParser
    extends IntegerParser {
        InitialCapacityParser() {
        }

        protected void parseInteger(MapMakerSpec spec, int value) {
            Preconditions.checkArgument(spec.initialCapacity == null, "initial capacity was already set to ", spec.initialCapacity);
            spec.initialCapacity = value;
        }
    }

    static abstract class IntegerParser
    implements ValueParser {
        IntegerParser() {
        }

        protected abstract void parseInteger(MapMakerSpec var1, int var2);

        public void parse(MapMakerSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseInteger(spec, Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Strength {
        SOFT,
        WEAK;

    }

    private static interface ValueParser {
        public void parse(MapMakerSpec var1, String var2, @Nullable String var3);
    }
}

