/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.Clock;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimedFuture<T>
implements Future<T> {
    private final Future<T> future;
    private final Clock clock;
    private final long deadlineTime;

    public TimedFuture(Future<T> future, long deadlineMillis) {
        this(future, deadlineMillis, Clock.DEFAULT);
    }

    public TimedFuture(Future<T> future, long deadlineMillis, Clock clock) {
        this.future = future;
        this.deadlineTime = clock.getCurrentTime() + deadlineMillis;
        this.clock = clock;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        long millisRemaining = this.getMillisRemaining();
        try {
            return this.future.get(millisRemaining, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            throw new ExecutionException(this.createDeadlineException());
        }
    }

    @Override
    public T get(long value, TimeUnit units) throws InterruptedException, ExecutionException, TimeoutException {
        long millisRemaining;
        long millisRequested = units.toMillis(value);
        if (millisRequested < (millisRemaining = this.getMillisRemaining())) {
            return this.future.get(millisRequested, TimeUnit.MILLISECONDS);
        }
        try {
            return this.future.get(millisRemaining, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            throw new ExecutionException(this.createDeadlineException());
        }
    }

    protected abstract RuntimeException createDeadlineException();

    private long getMillisRemaining() {
        return Math.max(0L, this.deadlineTime - this.clock.getCurrentTime());
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone() || this.getMillisRemaining() == 0L;
    }

    @Override
    public boolean cancel(boolean force) {
        return this.future.cancel(force);
    }
}

