/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.rdbms.dev.LocalRdbmsService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.cloud.sql.jdbc.internal.SqlClientFactory;
import java.util.Iterator;
import java.util.Map;
import org.hsqldb.jdbcDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRdbmsServiceTestConfig
implements LocalServiceTestConfig {
    private String driverClass = jdbcDriver.class.getName();
    private String driverUrl = "jdbc:hsqldb:mem:%s";
    private LocalRdbmsService.ServerType serverType = LocalRdbmsService.ServerType.LOCAL;
    private String extraDriverProperties = "";
    private Class<? extends SqlClientFactory> remoteClientFactory = null;

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        proxy.setProperty("rdbms.driver", this.driverClass);
        proxy.setProperty("rdbms.url", this.driverUrl);
        proxy.setProperty("rdbms.server", this.serverType.flagValue());
        proxy.setProperty("rdbms.extra.properties", this.extraDriverProperties);
        if (this.remoteClientFactory != null) {
            proxy.setProperty("rdbms.remote.client.factory", this.remoteClientFactory.getName());
        }
    }

    @Override
    public void tearDown() {
    }

    public static LocalRdbmsService getLocalRdbmsService() {
        return (LocalRdbmsService)LocalServiceTestHelper.getLocalService("rdbms");
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public LocalRdbmsServiceTestConfig setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        try {
            Class.forName(driverClass);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        return this;
    }

    public String getJdbcConnectionStringFormat() {
        return this.driverUrl;
    }

    public LocalRdbmsServiceTestConfig setJdbcConnectionStringFormat(String jdbcConnectionStringFormat) {
        this.driverUrl = jdbcConnectionStringFormat;
        return this;
    }

    public LocalRdbmsServiceTestConfig setServerType(LocalRdbmsService.ServerType serverType) {
        if (serverType == null) {
            throw new NullPointerException("serverType can not be null");
        }
        this.serverType = serverType;
        return this;
    }

    public LocalRdbmsServiceTestConfig setExtraDriverProperties(Map<String, String> props) {
        this.extraDriverProperties = LocalRdbmsServiceTestConfig.mapToString(props);
        return this;
    }

    public LocalRdbmsServiceTestConfig setRemoteClientFactory(Class<? extends SqlClientFactory> remoteClientFactory) {
        this.remoteClientFactory = remoteClientFactory;
        return this;
    }

    private static String mapToString(Map<String, String> map) {
        StringBuilder out = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            out.append(entry.getKey()).append("=").append(entry.getValue());
            while (iterator.hasNext()) {
                entry = iterator.next();
                out.append(",").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return out.toString();
    }
}

