/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger;

import com.google.appengine.repackaged.com.google.common.flogger.AbstractLogger;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLoggingApi;
import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.LogFormat;
import com.google.appengine.repackaged.com.google.common.flogger.parser.DefaultBraceStyleMessageParser;
import com.google.appengine.repackaged.com.google.common.flogger.parser.DefaultPrintfMessageParser;
import com.google.appengine.repackaged.com.google.common.flogger.parser.MessageParser;
import java.util.logging.Level;
import javax.annotation.CheckReturnValue;

@CheckReturnValue
public abstract class GoogleLogContext<LOGGER extends AbstractLogger<API>, API extends GoogleLoggingApi<API>>
extends LogContext<LOGGER, API>
implements GoogleLoggingApi<API> {
    private LogFormat format = LogFormat.PRINTF_STYLE;

    protected GoogleLogContext(Level level, boolean isForced) {
        super(level, isForced);
    }

    @Override
    public final API usingLegacyBraceFormat() {
        this.format = LogFormat.BRACE_STYLE;
        return (API)((GoogleLoggingApi)this.api());
    }

    @Override
    protected final MessageParser getMessageParser() {
        switch (this.format) {
            case PRINTF_STYLE: {
                return DefaultPrintfMessageParser.getInstance();
            }
            case BRACE_STYLE: {
                return DefaultBraceStyleMessageParser.getInstance();
            }
        }
        String string = String.valueOf((Object)this.format);
        throw new AssertionError((Object)new StringBuilder(25 + String.valueOf(string).length()).append("unsupported format type: ").append(string).toString());
    }
}

