/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend;

import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;

public final class Tags {
    private static final Comparator<Object> VALUE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object lhs, Object rhs) {
            Type rtype;
            Type type = Type.of(lhs);
            return type == (rtype = Type.of(rhs)) ? type.compare(lhs, rhs) : type.compareTo(rtype);
        }
    };
    private static final SortedSet<Object> EMPTY_SET = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Tags EMPTY_TAGS = new Tags(Collections.unmodifiableSortedMap(new TreeMap()));
    private final SortedMap<String, SortedSet<Object>> map;
    private Integer hashCode = null;
    private String toString = null;

    private static boolean isLetter(int cp) {
        return 97 <= cp && cp <= 122 || 65 <= cp && cp <= 90;
    }

    private static int checkTagStart(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("tag name must not be empty");
        }
        int cp = name.codePointAt(0);
        if (!Tags.isLetter(cp)) {
            String string = String.valueOf(name);
            throw new IllegalArgumentException(string.length() != 0 ? "tag name must start with an ASCII letter: ".concat(string) : new String("tag name must start with an ASCII letter: "));
        }
        return Character.charCount(cp);
    }

    private static int checkTag(String name, int n) {
        int cp = name.codePointAt(n);
        if (!(Tags.isLetter(cp) || cp >= 48 && cp <= 57 || cp == 95)) {
            String string = String.valueOf(name);
            throw new IllegalArgumentException(string.length() != 0 ? "tag name must contain only ASCII letters, digits or underscore: ".concat(string) : new String("tag name must contain only ASCII letters, digits or underscore: "));
        }
        return n + Character.charCount(cp);
    }

    private static String checkTagName(String name) {
        int n = Tags.checkTagStart(name);
        while (n < name.length()) {
            n = Tags.checkTag(name, n);
        }
        return name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Tags empty() {
        return EMPTY_TAGS;
    }

    private Tags(SortedMap<String, SortedSet<Object>> map) {
        this.map = map;
    }

    public SortedMap<String, SortedSet<Object>> asMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Tags merge(Tags other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        TreeMap<String, SortedSet<Object>> merged = new TreeMap<String, SortedSet<Object>>();
        for (Map.Entry<String, SortedSet<Object>> e : this.map.entrySet()) {
            SortedSet otherValues = (SortedSet)other.map.get(e.getKey());
            if (otherValues == null || e.getValue().containsAll(otherValues)) {
                merged.put(e.getKey(), e.getValue());
                continue;
            }
            if (otherValues.containsAll((Collection)e.getValue())) {
                merged.put(e.getKey(), otherValues);
                continue;
            }
            TreeSet<Object> mergedValues = new TreeSet<Object>(e.getValue());
            mergedValues.addAll(otherValues);
            merged.put(e.getKey(), Collections.unmodifiableSortedSet(mergedValues));
        }
        for (Map.Entry<String, SortedSet<Object>> e : other.map.entrySet()) {
            if (this.map.containsKey(e.getKey())) continue;
            merged.put(e.getKey(), e.getValue());
        }
        return new Tags(Collections.unmodifiableSortedMap(merged));
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof Tags && ((Tags)obj).map.equals(this.map);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.map.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = Tags.toString(this.map);
        }
        return this.toString;
    }

    private static String toString(SortedMap<String, SortedSet<Object>> map) {
        StringBuilder out = new StringBuilder("{");
        if (map.isEmpty()) {
            out.append("}");
        } else {
            for (Map.Entry<String, SortedSet<Object>> e : map.entrySet()) {
                out.append(e.getKey());
                SortedSet<Object> values = e.getValue();
                if (!values.isEmpty()) {
                    out.append(':');
                    if (values.size() == 1) {
                        Tags.appendFormatted(out, values.iterator().next());
                    } else {
                        out.append('[');
                        for (Object e2 : values) {
                            Tags.appendFormatted(out, e2);
                            out.append(',');
                        }
                        out.setCharAt(out.length() - 1, ']');
                    }
                }
                out.append(", ");
            }
            out.setCharAt(out.length() - 2, '}');
            out.setLength(out.length() - 1);
        }
        return out.toString();
    }

    private static void appendFormatted(StringBuilder out, Object value) {
        if (!(value instanceof String)) {
            out.append(value);
        } else {
            out.append('\"');
            Tags.appendEscaped(out, (String)value);
            out.append('\"');
        }
    }

    private static void appendEscaped(StringBuilder out, String s) {
        int start = 0;
        int end = Tags.nextEscapableChar(s, start);
        while (end != -1) {
            out.append(s, start, end).append("\\");
            start = end;
            end = Tags.nextEscapableChar(s, start + 1);
        }
        out.append(s, start, s.length());
    }

    private static int nextEscapableChar(String s, int n) {
        while (n < s.length()) {
            char c = s.charAt(n);
            if (c == '\"' || c == '\\') {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static final class Builder {
        private final SortedMap<String, SortedSet<Object>> map = new TreeMap<String, SortedSet<Object>>();

        @CanIgnoreReturnValue
        public Builder addTag(String name) {
            Set values = (Set)this.map.get(Tags.checkTagName(name));
            if (values == null) {
                this.map.put(name, EMPTY_SET);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String name, String value) {
            if (value == null) {
                throw new IllegalArgumentException("tag values cannot be null");
            }
            this.addImpl(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String name, boolean value) {
            this.addImpl(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String name, long value) {
            this.addImpl(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTag(String name, double value) {
            this.addImpl(name, value);
            return this;
        }

        private void addImpl(String name, Object value) {
            TreeSet<Object> values = (TreeSet<Object>)this.map.get(Tags.checkTagName(name));
            if (values == null || values == EMPTY_SET) {
                values = new TreeSet<Object>(VALUE_COMPARATOR);
                this.map.put(name, values);
            }
            values.add(value);
        }

        public Tags build() {
            if (this.map.isEmpty()) {
                return EMPTY_TAGS;
            }
            TreeMap<String, SortedSet<Object>> copy = new TreeMap<String, SortedSet<Object>>();
            for (Map.Entry<String, SortedSet<Object>> e : this.map.entrySet()) {
                copy.put(e.getKey(), Collections.unmodifiableSortedSet(new TreeSet<Object>(e.getValue())));
            }
            return new Tags(Collections.unmodifiableSortedMap(copy));
        }

        public String toString() {
            return Tags.toString(this.map);
        }
    }

    private static enum Type {
        BOOLEAN{

            @Override
            int compare(Object lhs, Object rhs) {
                return ((Boolean)lhs).compareTo((Boolean)rhs);
            }
        }
        ,
        STRING{

            @Override
            int compare(Object lhs, Object rhs) {
                return ((String)lhs).compareTo((String)rhs);
            }
        }
        ,
        LONG{

            @Override
            int compare(Object lhs, Object rhs) {
                return ((Long)lhs).compareTo((Long)rhs);
            }
        }
        ,
        DOUBLE{

            @Override
            int compare(Object lhs, Object rhs) {
                return ((Double)lhs).compareTo((Double)rhs);
            }
        };


        abstract int compare(Object var1, Object var2);

        private static Type of(Object tag) {
            if (tag instanceof String) {
                return STRING;
            }
            if (tag instanceof Boolean) {
                return BOOLEAN;
            }
            if (tag instanceof Long) {
                return LONG;
            }
            if (tag instanceof Double) {
                return DOUBLE;
            }
            String string = String.valueOf(tag.getClass());
            throw new AssertionError((Object)new StringBuilder(18 + String.valueOf(string).length()).append("invalid tag type: ").append(string).toString());
        }
    }
}

