/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.j2objc.annotations.ReflectionSupport;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
@ReflectionSupport(value=ReflectionSupport.Level.FULL)
abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE = new DoNothingRunnable();
    private static final Runnable INTERRUPTING = new DoNothingRunnable();

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Thread currentThread = Thread.currentThread();
        if (!this.compareAndSet(null, currentThread)) {
            return;
        }
        boolean run = !this.isDone();
        T result = null;
        Throwable error = null;
        try {
            if (run) {
                result = this.runInterruptibly();
            }
        }
        catch (Throwable t) {
            error = t;
        }
        finally {
            if (!this.compareAndSet(currentThread, DONE)) {
                while (this.get() == INTERRUPTING) {
                    Thread.yield();
                }
            }
            if (run) {
                this.afterRanInterruptibly(result, error);
            }
        }
    }

    abstract boolean isDone();

    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptibly(@NullableDecl T var1, @NullableDecl Throwable var2);

    final void interruptTask() {
        Runnable currentRunner = (Runnable)this.get();
        if (currentRunner instanceof Thread && this.compareAndSet(currentRunner, INTERRUPTING)) {
            ((Thread)currentRunner).interrupt();
            this.set(DONE);
        }
    }

    @Override
    public abstract String toString();

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

