/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

@GwtIncompatible
final class SequentialExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(SequentialExecutor.class.getName());
    private final Executor executor;
    @GuardedBy(value="queue")
    private final Queue<Runnable> queue = new ArrayDeque<Runnable>();
    @GuardedBy(value="queue")
    private boolean isWorkerRunning = false;
    private final QueueWorker worker = new QueueWorker();

    SequentialExecutor(Executor executor) {
        this.executor = Preconditions.checkNotNull(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        Queue<Runnable> queue = this.queue;
        synchronized (queue) {
            this.queue.add(task);
            if (this.isWorkerRunning) {
                return;
            }
            this.isWorkerRunning = true;
        }
        this.startQueueWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQueueWorker() {
        boolean executionRejected = true;
        try {
            this.executor.execute(this.worker);
            executionRejected = false;
        }
        finally {
            if (executionRejected) {
                Queue<Runnable> queue = this.queue;
                synchronized (queue) {
                    this.isWorkerRunning = false;
                }
            }
        }
    }

    private final class QueueWorker
    implements Runnable {
        private QueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.workOnQueue();
            }
            catch (Error e) {
                Queue queue = SequentialExecutor.this.queue;
                synchronized (queue) {
                    SequentialExecutor.this.isWorkerRunning = false;
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void workOnQueue() {
            boolean interruptedDuringTask = false;
            try {
                while (true) {
                    Runnable task;
                    interruptedDuringTask |= Thread.interrupted();
                    Queue queue = SequentialExecutor.this.queue;
                    synchronized (queue) {
                        task = (Runnable)SequentialExecutor.this.queue.poll();
                        if (task == null) {
                            SequentialExecutor.this.isWorkerRunning = false;
                            return;
                        }
                    }
                    try {
                        task.run();
                    }
                    catch (RuntimeException e) {
                        String string = String.valueOf(task);
                        log.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.common.util.concurrent.SequentialExecutor$QueueWorker", "workOnQueue", new StringBuilder(35 + String.valueOf(string).length()).append("Exception while executing runnable ").append(string).toString(), e);
                    }
                }
            }
            finally {
                if (interruptedDuringTask) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

