/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.blobstore.BlobstoreStubServicePb;
import com.google.appengine.api.capabilities.CapabilityStatus;
import com.google.appengine.api.mail.MailStubServicePb;
import com.google.appengine.api.memcache.MemcacheStubServicePb;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApiServer;
import com.google.appengine.tools.development.ApiServerFactory;
import com.google.appengine.tools.development.ApiUtils;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.DevLogService;
import com.google.appengine.tools.development.DevServices;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LatencySimulator;
import com.google.appengine.tools.development.LocalCapabilitiesEnvironment;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.TimedFuture;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.UserStubServicePb;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ApiProxyLocalImpl
implements ApiProxyLocal,
DevServices {
    private static final String FILESAPI_DISABLED_MESSAGE = "The Files API is disabled. Further information: https://cloud.google.com/appengine/docs/deprecations/files_api";
    private static final int MAX_API_REQUEST_SIZE = 0x100000;
    private static final String API_DEADLINE_KEY = "com.google.apphosting.api.ApiProxy.api_deadline_key";
    static final String IS_OFFLINE_REQUEST_KEY = "com.google.appengine.request.offline";
    private static final Logger logger = Logger.getLogger(ApiProxyLocalImpl.class.getName());
    private final Map<String, LocalRpcService> serviceCache = new ConcurrentHashMap<String, LocalRpcService>();
    private final Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();
    final Map<Method, LatencySimulator> latencySimulatorCache = new ConcurrentHashMap<Method, LatencySimulator>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final ExecutorService apiExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory(Executors.defaultThreadFactory()));
    private final LocalServiceContext context;
    private ApiServer apiServer;
    private final Set<String> apisUsingPythonStubs;
    private Clock clock = Clock.DEFAULT;

    public ApiProxyLocalImpl(LocalServerEnvironment environment) {
        this.context = new LocalServiceContextImpl(environment);
        this.apisUsingPythonStubs = new HashSet<String>();
    }

    private ApiProxyLocalImpl(LocalServerEnvironment environment, Set<String> apisUsingPythonStubs, ApiServer apiServer) {
        this.context = new LocalServiceContextImpl(environment);
        this.apisUsingPythonStubs = apisUsingPythonStubs;
        this.apiServer = apiServer;
    }

    static ApiProxyLocal getApiProxyLocal(LocalServerEnvironment environment, Set<String> apisUsingPythonStubs, String applicationName) {
        if (!apisUsingPythonStubs.isEmpty()) {
            ApiServer apiServer;
            if (ApiServerFactory.hasExistingApiServer()) {
                apiServer = ApiServerFactory.getExistingApiServer();
            } else {
                String pathToApiServer = System.getProperty("appengine.pathToPythonApiServer");
                if (pathToApiServer != null) {
                    String string = environment.getAddress();
                    int n = environment.getPort();
                    String baseUrl = new StringBuilder(19 + String.valueOf(string).length()).append("http://").append(string).append(":").append(n).toString();
                    apiServer = ApiServerFactory.getApiServer(pathToApiServer, applicationName, environment.getAppDir().getAbsolutePath(), baseUrl);
                } else {
                    throw new RuntimeException("No path to Python API server found.");
                }
            }
            return new ApiProxyLocalImpl(environment, apisUsingPythonStubs, apiServer);
        }
        return new ApiProxyLocalImpl(environment);
    }

    @Override
    public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
        logger.logp(ApiProxyLocalImpl.toJavaLevel(record.getLevel()), "com.google.appengine.tools.development.ApiProxyLocalImpl", "log", record.getMessage());
    }

    @Override
    public void flushLogs(ApiProxy.Environment environment) {
        System.err.flush();
    }

    @Override
    public byte[] makeSyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] requestBytes) {
        ApiProxy.ApiConfig apiConfig = null;
        Double deadline = (Double)environment.getAttributes().get(API_DEADLINE_KEY);
        if (deadline != null) {
            apiConfig = new ApiProxy.ApiConfig();
            apiConfig.setDeadlineInSeconds(deadline);
        }
        Future<byte[]> future = this.makeAsyncCall(environment, packageName, methodName, requestBytes, apiConfig);
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            throw new ApiProxy.CancelledException(packageName, methodName);
        }
        catch (CancellationException ex) {
            throw new ApiProxy.CancelledException(packageName, methodName);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            if (ex.getCause() instanceof Error) {
                throw (Error)ex.getCause();
            }
            throw new ApiProxy.UnknownException(packageName, methodName, ex.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<byte[]> makeAsyncCall(ApiProxy.Environment environment, final String packageName, final String methodName, byte[] requestBytes, ApiProxy.ApiConfig apiConfig) {
        Semaphore semaphore = (Semaphore)environment.getAttributes().get("com.google.appengine.tools.development.api_call_semaphore");
        if (semaphore != null) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted while waiting on semaphore:", ex);
            }
        }
        boolean apiCallShouldUsePythonStub = this.apisUsingPythonStubs.contains(packageName);
        this.updateMemcachePythonStubClockIfNecessary(apiCallShouldUsePythonStub, packageName);
        AsyncApiCall asyncApiCall = new AsyncApiCall(environment, packageName, methodName, requestBytes, semaphore, apiCallShouldUsePythonStub);
        boolean offline = environment.getAttributes().get(IS_OFFLINE_REQUEST_KEY) != null;
        boolean success = false;
        try {
            Callable<byte[]> callable = Executors.privilegedCallable(asyncApiCall);
            TimedFuture<byte[]> resultFuture = AccessController.doPrivileged(new PrivilegedApiAction(callable, asyncApiCall));
            success = true;
            if (this.context.getLocalServerEnvironment().enforceApiDeadlines()) {
                long deadlineMillis = (long)(1000.0 * this.resolveDeadline(packageName, apiConfig, offline));
                resultFuture = new TimedFuture<byte[]>(this, resultFuture, deadlineMillis, this.clock){

                    @Override
                    protected RuntimeException createDeadlineException() {
                        return new ApiProxy.ApiDeadlineExceededException(packageName, methodName);
                    }
                };
            }
            TimedFuture<byte[]> timedFuture = resultFuture;
            return timedFuture;
        }
        finally {
            if (!success) {
                asyncApiCall.tryReleaseSemaphore();
            }
        }
    }

    private void updateMemcachePythonStubClockIfNecessary(boolean apiCallShouldUsePythonStub, String packageName) {
        if (apiCallShouldUsePythonStub && packageName.equals("memcache") && this.clock != Clock.DEFAULT) {
            MemcacheStubServicePb.SetClockRequest.Builder request = MemcacheStubServicePb.SetClockRequest.newBuilder().setClockTimeMilliseconds(this.clock.getCurrentTime());
            try {
                this.apiServer.makeSyncCall("memcache", "SetClock", ApiUtils.convertPbToBytes(request.build()));
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, "com.google.appengine.tools.development.ApiProxyLocalImpl", "updateMemcachePythonStubClockIfNecessary", "memcache SetClock() failed: ", e);
            }
        }
    }

    @Override
    public List<Thread> getRequestThreads(ApiProxy.Environment environment) {
        return Arrays.asList(Thread.currentThread());
    }

    private double resolveDeadline(String packageName, ApiProxy.ApiConfig apiConfig, boolean isOffline) {
        LocalRpcService service = this.getService(packageName);
        Double deadline = null;
        if (apiConfig != null) {
            deadline = apiConfig.getDeadlineInSeconds();
        }
        if (deadline == null && service != null) {
            deadline = service.getDefaultDeadline(isOffline);
        }
        if (deadline == null) {
            deadline = 5.0;
        }
        Double maxDeadline = null;
        if (service != null) {
            maxDeadline = service.getMaximumDeadline(isOffline);
        }
        if (maxDeadline == null) {
            maxDeadline = 10.0;
        }
        return Math.min(deadline, maxDeadline);
    }

    @Override
    public void setProperty(String serviceProperty, String value) {
        if (serviceProperty == null) {
            throw new NullPointerException("Property key must not be null.");
        }
        String[] propertyComponents = serviceProperty.split("\\.");
        if (propertyComponents.length < 2) {
            String string = String.valueOf(serviceProperty);
            throw new IllegalArgumentException(string.length() != 0 ? "Property string must be of the form {service}.{property}, received: ".concat(string) : new String("Property string must be of the form {service}.{property}, received: "));
        }
        String service = propertyComponents[0];
        String property = propertyComponents[1];
        if (this.apisUsingPythonStubs.contains(service)) {
            this.setPropertyOnPythonApiServer(service, property, value);
        }
        this.properties.put(serviceProperty, value);
    }

    private void setPropertyOnPythonApiServer(String service, String property, String value) {
        block7: {
            try {
                if (service.equals("memcache") && property.equals("maxsize")) {
                    this.setMemcacheMaxSizeProperty(Long.parseLong(value));
                    break block7;
                }
                if (service.equals("oauth")) {
                    this.setOAuthUserProperty(property, value);
                    break block7;
                }
                if (service.equals("blobstore") && property.equals("no_storage")) {
                    this.setBlobstoreNoStorageProperty(Boolean.parseBoolean(value));
                    break block7;
                }
                if (service.equals("mail") && property.equals("log_mail_level")) {
                    this.setMailLogMailLevelProperty(value);
                    break block7;
                }
                if (service.equals("mail") && property.equals("log_mail_body")) {
                    this.setMailLogMailBodyProperty(Boolean.parseBoolean(value));
                    break block7;
                }
                throw new IllegalArgumentException(new StringBuilder(30 + String.valueOf(service).length() + String.valueOf(property).length()).append("Property \"").append(service).append(".").append(property).append("\" is not supported.").toString());
            }
            catch (IOException e) {
                throw new RuntimeException(new StringBuilder(31 + String.valueOf(service).length() + String.valueOf(property).length()).append("Setting property \"").append(service).append(".").append(property).append("\" has failed").toString(), e);
            }
        }
    }

    private void setMailLogMailBodyProperty(boolean value) throws IOException {
        MailStubServicePb.SetLogMailBodyRequest request = new MailStubServicePb.SetLogMailBodyRequest();
        request.setLogMailBody(value);
        this.apiServer.makeSyncCall("mail", "SetLogMailBody", ApiUtils.convertPbToBytes(request));
    }

    private void setMailLogMailLevelProperty(String value) throws IOException {
        MailStubServicePb.SetLogMailLevelRequest request = new MailStubServicePb.SetLogMailLevelRequest();
        request.setLogMailLevel(value);
        this.apiServer.makeSyncCall("mail", "SetLogMailLevel", ApiUtils.convertPbToBytes(request));
    }

    private void setMemcacheMaxSizeProperty(long value) throws IOException {
        MemcacheStubServicePb.SetMaxSizeRequest.Builder request = MemcacheStubServicePb.SetMaxSizeRequest.newBuilder();
        request.setMaxSizeBytes(value);
        this.apiServer.makeSyncCall("memcache", "SetMaxSize", ApiUtils.convertPbToBytes(request.build()));
    }

    private void setOAuthUserProperty(String property, String value) throws IOException {
        UserStubServicePb.SetOAuthUserRequest request = new UserStubServicePb.SetOAuthUserRequest();
        switch (property) {
            case "email": {
                request.setEmail(value);
                break;
            }
            case "user_id": {
                request.setUserId(value);
                break;
            }
            case "auth_domain": {
                request.setAuthDomain(value);
                break;
            }
            case "is_admin": {
                request.setIsAdmin(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(property).length()).append("Property \"oauth.").append(property).append("\" is not supported.").toString());
            }
        }
        this.apiServer.makeSyncCall("user", "SetOAuthUser", ApiUtils.convertPbToBytes(request));
    }

    private void setBlobstoreNoStorageProperty(boolean noStorage) throws IOException {
        BlobstoreStubServicePb.SetBlobStorageTypeRequest.Builder request = BlobstoreStubServicePb.SetBlobStorageTypeRequest.newBuilder();
        if (noStorage) {
            request.setStorageType(BlobstoreStubServicePb.SetBlobStorageTypeRequest.StorageType.MEMORY);
        } else {
            request.setStorageType(BlobstoreStubServicePb.SetBlobStorageTypeRequest.StorageType.FILE);
        }
        this.apiServer.makeSyncCall("blobstore", "SetBlobStorageType", ApiUtils.convertPbToBytes(request.build()));
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        if (properties != null) {
            this.appendProperties(properties);
        }
    }

    @Override
    public void appendProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Override
    public void stop() {
        for (LocalRpcService service : this.serviceCache.values()) {
            service.stop();
        }
        this.serviceCache.clear();
        this.methodCache.clear();
        this.latencySimulatorCache.clear();
    }

    int getMaxApiRequestSize(LocalRpcService rpcService) {
        Integer size = rpcService.getMaxApiRequestSize();
        if (size == null) {
            return 0x100000;
        }
        return size;
    }

    private Method getDispatchMethod(LocalRpcService service, String packageName, String methodName) {
        char c = Character.toLowerCase(methodName.charAt(0));
        String string = methodName.substring(1);
        String dispatchName = new StringBuilder(1 + String.valueOf(string).length()).append(c).append(string).toString();
        String methodId = new StringBuilder(1 + String.valueOf(packageName).length() + String.valueOf(dispatchName).length()).append(packageName).append(".").append(dispatchName).toString();
        Method method = this.methodCache.get(methodId);
        if (method != null) {
            return method;
        }
        for (Method candidate : service.getClass().getMethods()) {
            if (!dispatchName.equals(candidate.getName())) continue;
            this.methodCache.put(methodId, candidate);
            LatencyPercentiles latencyPercentiles = candidate.getAnnotation(LatencyPercentiles.class);
            if (latencyPercentiles == null) {
                latencyPercentiles = service.getClass().getAnnotation(LatencyPercentiles.class);
            }
            if (latencyPercentiles != null) {
                this.latencySimulatorCache.put(candidate, new LatencySimulator(latencyPercentiles));
            }
            return candidate;
        }
        throw new ApiProxy.CallNotFoundException(packageName, methodName);
    }

    @Override
    public final synchronized LocalRpcService getService(final String pkg) {
        LocalRpcService cachedService = this.serviceCache.get(pkg);
        if (cachedService != null) {
            return cachedService;
        }
        return AccessController.doPrivileged(new PrivilegedAction<LocalRpcService>(){

            @Override
            public LocalRpcService run() {
                return ApiProxyLocalImpl.this.startServices(pkg);
            }
        });
    }

    @Override
    public DevLogService getLogService() {
        return (DevLogService)((Object)this.getService("logservice"));
    }

    private LocalRpcService startServices(String pkg) {
        for (LocalRpcService service : ServiceLoader.load(LocalRpcService.class, ApiProxyLocalImpl.class.getClassLoader())) {
            if (!service.getPackage().equals(pkg)) continue;
            service.init(this.context, this.properties);
            service.start();
            this.serviceCache.put(pkg, service);
            return service;
        }
        return null;
    }

    private static Level toJavaLevel(ApiProxy.LogRecord.Level apiProxyLevel) {
        switch (apiProxyLevel) {
            case debug: {
                return Level.FINE;
            }
            case info: {
                return Level.INFO;
            }
            case warn: {
                return Level.WARNING;
            }
            case error: {
                return Level.SEVERE;
            }
            case fatal: {
                return Level.SEVERE;
            }
        }
        return Level.WARNING;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory parent;

        public DaemonThreadFactory(ThreadFactory parent) {
            this.parent = parent;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.parent.newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    private class AsyncApiCall
    implements Callable<byte[]> {
        private final ApiProxy.Environment environment;
        private final String packageName;
        private final String methodName;
        private final byte[] requestBytes;
        private final Semaphore semaphore;
        private boolean released;
        private final boolean apiCallShouldUsePythonStub;

        public AsyncApiCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] requestBytes, Semaphore semaphore, boolean apiCallShouldUsePythonStub) {
            this.environment = environment;
            this.packageName = packageName;
            this.methodName = methodName;
            this.requestBytes = requestBytes;
            this.semaphore = semaphore;
            this.apiCallShouldUsePythonStub = apiCallShouldUsePythonStub;
        }

        @Override
        public byte[] call() {
            try {
                byte[] byArray = this.callInternal();
                return byArray;
            }
            finally {
                this.tryReleaseSemaphore();
            }
        }

        private byte[] callInternal() {
            ApiProxy.setEnvironmentForCurrentThread(this.environment);
            try {
                LocalCapabilitiesEnvironment capEnv;
                CapabilityStatus capabilityStatus;
                if ("file".equals(this.packageName)) {
                    if (Boolean.getBoolean("appengine.enableFilesApi")) {
                        this.environment.getAttributes().put("com.google.appengine.api.files.filesapi_was_used", true);
                    } else {
                        throw new ApiProxy.FeatureNotEnabledException(ApiProxyLocalImpl.FILESAPI_DISABLED_MESSAGE, this.packageName, this.methodName);
                    }
                }
                if (!CapabilityStatus.ENABLED.equals((Object)(capabilityStatus = (capEnv = ApiProxyLocalImpl.this.context.getLocalCapabilitiesEnvironment()).getStatusFromMethodName(this.packageName, this.methodName)))) {
                    throw new ApiProxy.CapabilityDisabledException("Setup in local configuration.", this.packageName, this.methodName);
                }
                if (this.apiCallShouldUsePythonStub) {
                    byte[] byArray = this.invokeApiMethodPython(this.packageName, this.methodName, this.requestBytes);
                    return byArray;
                }
                byte[] byArray = this.invokeApiMethodJava(this.packageName, this.methodName, this.requestBytes);
                return byArray;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new ApiProxy.UnknownException(this.packageName, this.methodName, e.getCause());
            }
            catch (IOException | ReflectiveOperationException e) {
                throw new ApiProxy.UnknownException(this.packageName, this.methodName, e);
            }
            finally {
                ApiProxy.clearEnvironmentForCurrentThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] invokeApiMethodJava(String packageName, String methodName, byte[] requestBytes) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
            logger.logp(Level.FINE, "com.google.appengine.tools.development.ApiProxyLocalImpl$AsyncApiCall", "invokeApiMethodJava", new StringBuilder(46 + String.valueOf(packageName).length() + String.valueOf(methodName).length()).append("Making an API call to a Java implementation: ").append(packageName).append(".").append(methodName).toString());
            LocalRpcService service = ApiProxyLocalImpl.this.getService(packageName);
            if (service == null) {
                throw new ApiProxy.CallNotFoundException(packageName, methodName);
            }
            if (requestBytes.length > ApiProxyLocalImpl.this.getMaxApiRequestSize(service)) {
                throw new ApiProxy.RequestTooLargeException(packageName, methodName);
            }
            Method method = ApiProxyLocalImpl.this.getDispatchMethod(service, packageName, methodName);
            LocalRpcService.Status status = new LocalRpcService.Status();
            Class<?> requestClass = method.getParameterTypes()[1];
            Object request = ApiUtils.convertBytesToPb(requestBytes, requestClass);
            long start = ApiProxyLocalImpl.this.clock.getCurrentTime();
            try {
                byte[] byArray = ApiUtils.convertPbToBytes(method.invoke((Object)service, status, request));
                return byArray;
            }
            finally {
                LatencySimulator latencySimulator = ApiProxyLocalImpl.this.latencySimulatorCache.get(method);
                if (latencySimulator != null && ApiProxyLocalImpl.this.context.getLocalServerEnvironment().simulateProductionLatencies()) {
                    latencySimulator.simulateLatency(ApiProxyLocalImpl.this.clock.getCurrentTime() - start, service, request);
                }
            }
        }

        public byte[] invokeApiMethodPython(String packageName, String methodName, byte[] requestBytes) throws IOException {
            logger.logp(Level.FINE, "com.google.appengine.tools.development.ApiProxyLocalImpl$AsyncApiCall", "invokeApiMethodPython", new StringBuilder(48 + String.valueOf(packageName).length() + String.valueOf(methodName).length()).append("Making an API call to a Python implementation: ").append(packageName).append(".").append(methodName).toString());
            return ApiProxyLocalImpl.this.apiServer.makeSyncCall(packageName, methodName, requestBytes);
        }

        synchronized void tryReleaseSemaphore() {
            if (!this.released && this.semaphore != null) {
                this.semaphore.release();
                this.released = true;
            }
        }
    }

    private class PrivilegedApiAction
    implements PrivilegedAction<Future<byte[]>> {
        private final Callable<byte[]> callable;
        private final AsyncApiCall asyncApiCall;

        PrivilegedApiAction(Callable<byte[]> callable, AsyncApiCall asyncApiCall) {
            this.callable = callable;
            this.asyncApiCall = asyncApiCall;
        }

        @Override
        public Future<byte[]> run() {
            final Future<byte[]> result = ApiProxyLocalImpl.this.apiExecutor.submit(this.callable);
            return new Future<byte[]>(){

                @Override
                public boolean cancel(final boolean mayInterruptIfRunning) {
                    return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            PrivilegedApiAction.this.asyncApiCall.tryReleaseSemaphore();
                            return result.cancel(mayInterruptIfRunning);
                        }
                    });
                }

                @Override
                public boolean isCancelled() {
                    return result.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return result.isDone();
                }

                @Override
                public byte[] get() throws InterruptedException, ExecutionException {
                    return (byte[])result.get();
                }

                @Override
                public byte[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return (byte[])result.get(timeout, unit);
                }
            };
        }
    }

    private class LocalServiceContextImpl
    implements LocalServiceContext {
        private final LocalServerEnvironment localServerEnvironment;
        private final LocalCapabilitiesEnvironment localCapabilitiesEnvironment = new LocalCapabilitiesEnvironment(System.getProperties());

        public LocalServiceContextImpl(LocalServerEnvironment localServerEnvironment) {
            this.localServerEnvironment = localServerEnvironment;
        }

        @Override
        public LocalServerEnvironment getLocalServerEnvironment() {
            return this.localServerEnvironment;
        }

        @Override
        public LocalCapabilitiesEnvironment getLocalCapabilitiesEnvironment() {
            return this.localCapabilitiesEnvironment;
        }

        @Override
        public Clock getClock() {
            return ApiProxyLocalImpl.this.clock;
        }

        @Override
        public LocalRpcService getLocalService(String packageName) {
            return ApiProxyLocalImpl.this.getService(packageName);
        }
    }
}

