/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.taskqueue.TaskQueueStubServicePb;
import com.google.appengine.api.urlfetch.URLFetchStubServicePb;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.net.util.proto2api.Status;
import com.google.appengine.repackaged.org.apache.http.HttpResponse;
import com.google.appengine.repackaged.org.apache.http.StatusLine;
import com.google.appengine.repackaged.org.apache.http.client.HttpResponseException;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpGet;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpPost;
import com.google.appengine.repackaged.org.apache.http.entity.ByteArrayEntity;
import com.google.appengine.repackaged.org.apache.http.impl.client.CloseableHttpClient;
import com.google.appengine.repackaged.org.apache.http.impl.client.HttpClientBuilder;
import com.google.appengine.repackaged.org.apache.http.impl.client.HttpClients;
import com.google.appengine.tools.development.ApiUtils;
import com.google.appengine.tools.development.DevSocketImplFactory;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;
import com.google.apphosting.utils.runtime.ApiProxyUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class ApiServer {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/appengine/tools/development/ApiServer");
    private final Process process;
    private final int port;
    private final ServerOutput serverOutput;

    ApiServer(String pathToApiServer, String applicationName, String appDir, String baseUrl) {
        try {
            try (ServerSocket socket = new ServerSocket(0);){
                this.port = socket.getLocalPort();
            }
            String[] stringArray = new String[12];
            stringArray[0] = pathToApiServer;
            stringArray[1] = "--api_port";
            stringArray[2] = String.valueOf(this.port);
            stringArray[3] = "--clear_datastore";
            stringArray[4] = "--datastore_consistency_policy";
            stringArray[5] = "consistent";
            stringArray[6] = "--application";
            stringArray[7] = applicationName;
            stringArray[8] = "--application_prefix";
            stringArray[9] = "";
            stringArray[10] = "--datastore_path";
            int n = this.port;
            stringArray[11] = new StringBuilder(16).append("/tmp/").append(n).toString();
            ArrayList<String> apiServerCommand = new ArrayList<String>(Arrays.asList(stringArray));
            if (System.getProperty("appengine.pythonApiServerFlags") != null) {
                for (String apiServerFlag : Splitter.on('|').split(System.getProperty("appengine.pythonApiServerFlags"))) {
                    apiServerCommand.add(apiServerFlag);
                }
            }
            if (baseUrl != null) {
                apiServerCommand.add("--java_app_base_url");
                apiServerCommand.add(baseUrl);
            }
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(apiServerCommand).redirectErrorStream(true);
            Map<String, String> env = pb.environment();
            String datastoreEmulatorHost = System.getenv("DATASTORE_EMULATOR_HOST");
            if (datastoreEmulatorHost != null) {
                env.put("DATASTORE_EMULATOR_HOST", datastoreEmulatorHost);
            }
            this.process = pb.start();
            this.serverOutput = new ServerOutput(this.process);
            this.serverOutput.start();
            this.serverOutput.await();
            if (appDir != null) {
                this.findAndLoadQueueXmlFileInAppDir(appDir);
            }
            this.setUrlFetchHttpProxy();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getPort() {
        return this.port;
    }

    public void clear() throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        int n = this.port;
        HttpGet request = new HttpGet(new StringBuilder(34).append("http://localhost:").append(n).append("/clear").toString());
        HttpResponse response = httpClient.execute(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            String string = String.valueOf(response.getStatusLine());
            throw new IOException(new StringBuilder(67 + String.valueOf(string).length()).append("Sending HTTP request to clear the API server failed with response: ").append(string).toString());
        }
    }

    public void close() {
        try {
            int exitValue = this.process.exitValue();
            if (exitValue != 0) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/appengine/tools/development/ApiServer", "close", 142, "ApiServer.java")).log("The API server process exited with a non-zero value of: %s", exitValue);
            }
        }
        catch (IllegalThreadStateException e) {
            this.serverOutput.stopReadingOutput();
            this.process.destroy();
        }
    }

    public byte[] makeSyncCall(String packageName, String methodName, byte[] requestBytes) throws IOException {
        RemoteApiPb.Request remoteApiRequest = new RemoteApiPb.Request();
        remoteApiRequest.setServiceName(packageName);
        remoteApiRequest.setMethod(methodName);
        remoteApiRequest.setRequestAsBytes(requestBytes);
        remoteApiRequest.setRequestId(UUID.randomUUID().toString().substring(0, 10));
        byte[] remoteApiRequestBytes = ApiUtils.convertPbToBytes(remoteApiRequest);
        int n = this.port;
        HttpPost post = new HttpPost(new StringBuilder(28).append("http://localhost:").append(n).toString());
        post.addHeader("Host", "localhost");
        post.addHeader("Content-Type", "application/octet-stream");
        post.setEntity(new ByteArrayEntity(remoteApiRequestBytes));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        boolean oldNativeSocketMode = DevSocketImplFactory.isNativeSocketMode();
        DevSocketImplFactory.setSocketNativeMode(true);
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().disableRedirectHandling().build();
            HttpResponse response = httpClient.execute(post);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            response.getEntity().writeTo(bout);
        }
        catch (IOException e) {
            throw new IOException("Error executing POST to HTTP API server.");
        }
        finally {
            DevSocketImplFactory.setSocketNativeMode(oldNativeSocketMode);
        }
        RemoteApiPb.Response response = new RemoteApiPb.Response();
        boolean parsed = response.mergeFrom(bout.toByteArray());
        if (!parsed) {
            throw new IOException("Error parsing the response from the HTTP API server.");
        }
        if (response.hasApplicationError()) {
            throw ApiProxyUtils.getRpcError(packageName, methodName, Status.StatusProto.getDefaultInstance(), response.getApplicationError().getCode(), response.getApplicationError().getDetail(), null);
        }
        if (response.hasRpcError()) {
            throw ApiProxyUtils.getApiError(packageName, methodName, response, logger);
        }
        return response.getResponseAsBytes();
    }

    private void setUrlFetchHttpProxy() {
        String proxyHost = System.getProperty("host.proxyHost");
        String proxyPort = System.getProperty("host.proxyPort");
        if (proxyHost == null || proxyPort == null) {
            return;
        }
        Integer parsedProxyPort = Ints.tryParse(proxyPort);
        if (parsedProxyPort == null) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/appengine/tools/development/ApiServer", "setUrlFetchHttpProxy", 215, "ApiServer.java")).log("host.proxyPort not a valid integer: %s", proxyPort);
            return;
        }
        URLFetchStubServicePb.SetHttpProxyRequest.Builder setProxyRequestBuilder = URLFetchStubServicePb.SetHttpProxyRequest.newBuilder();
        setProxyRequestBuilder.setHttpProxyHost(proxyHost);
        setProxyRequestBuilder.setHttpProxyPort(parsedProxyPort.intValue());
        byte[] requestBytes = ApiUtils.convertPbToBytes(setProxyRequestBuilder.build());
        try {
            this.makeSyncCall("urlfetch", "SetHttProxy", requestBytes);
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).withInjectedLogSite("com/google/appengine/tools/development/ApiServer", "setUrlFetchHttpProxy", 227, "ApiServer.java")).log("SetHttpProxy(%s:%s) failed: %s", proxyHost, parsedProxyPort, e);
        }
    }

    private void findAndLoadQueueXmlFileInAppDir(String appDir) {
        Path queueXmlPath = Paths.get(appDir, "WEB-INF", "queue.xml");
        if (!Files.exists(queueXmlPath, new LinkOption[0])) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/appengine/tools/development/ApiServer", "findAndLoadQueueXmlFileInAppDir", 240, "ApiServer.java")).log("No queue.xml found at %s. Python task queue stub will use default queue configuration.", queueXmlPath);
            return;
        }
        TaskQueueStubServicePb.LoadQueueXmlRequest lqxr = TaskQueueStubServicePb.LoadQueueXmlRequest.newBuilder().setQueueXmlPath(queueXmlPath.toString()).build();
        byte[] requestBytes = ApiUtils.convertPbToBytes(lqxr);
        try {
            this.makeSyncCall("taskqueue", "LoadQueueXml", requestBytes);
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).withInjectedLogSite("com/google/appengine/tools/development/ApiServer", "findAndLoadQueueXmlFileInAppDir", 252, "ApiServer.java")).log("LoadQueueXml(queueXmlPath=%s) failed: %s", (Object)queueXmlPath, (Object)e);
        }
    }

    private static class ServerOutput
    extends Thread {
        private final Process process;
        private final CountDownLatch readyLatch = new CountDownLatch(1);
        private final String readyMessage = "Starting API server at:";
        private final AtomicBoolean stopped = new AtomicBoolean();

        private ServerOutput(Process process) {
            this.process = process;
        }

        public void await() {
            try {
                this.readyLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private void stopReadingOutput() {
            this.stopped.set(true);
        }

        @Override
        public void run() {
            block3: {
                try {
                    String stdInputLine;
                    BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
                    while ((stdInputLine = stdInput.readLine()) != null) {
                        System.out.println(stdInputLine);
                        if (!stdInputLine.contains("Starting API server at:")) continue;
                        this.readyLatch.countDown();
                    }
                }
                catch (IOException e) {
                    if (this.stopped.get()) break block3;
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

