/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.tools.development.ApiServerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ApiUtils {
    private ApiUtils() {
    }

    public static <T> T convertBytesToPb(byte[] bytes, Class<T> messageClass) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (ProtocolMessage.class.isAssignableFrom(messageClass)) {
            ProtocolMessage proto = (ProtocolMessage)messageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            boolean parsed = proto.mergeFrom(bytes);
            if (!parsed || !proto.isInitialized()) {
                String string = String.valueOf(ApiUtils.classDescription(messageClass));
                throw new RuntimeException(string.length() != 0 ? "Could not parse request bytes into ".concat(string) : new String("Could not parse request bytes into "));
            }
            return messageClass.cast(proto);
        }
        if (Message.class.isAssignableFrom(messageClass)) {
            Method method = messageClass.getMethod("parseFrom", byte[].class);
            return messageClass.cast(method.invoke(null, new Object[]{bytes}));
        }
        throw new UnsupportedOperationException(String.format("Cannot assign %s to either %s or %s", ApiUtils.classDescription(messageClass), ProtocolMessage.class, Message.class));
    }

    public static byte[] convertPbToBytes(Object object) {
        if (object instanceof MessageLite) {
            return ((MessageLite)object).toByteArray();
        }
        throw new UnsupportedOperationException(String.format("%s is neither %s nor %s", ApiUtils.classDescription(object.getClass()), ProtocolMessage.class, Message.class));
    }

    private static String classDescription(Class<?> klass) {
        return String.format("(%s extends %s loaded from %s)", klass, klass.getSuperclass(), klass.getProtectionDomain().getCodeSource().getLocation());
    }

    public static boolean isUsingPythonStub(String packageName) {
        return ApiServerFactory.hasExistingApiServer() && System.getProperty("appengine.apisUsingPythonStubs", "").contains(packageName);
    }

    public static boolean isPromotingYaml() {
        return Boolean.getBoolean("appengine.promoteYaml");
    }
}

