/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.io.Resources;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApiProxyLocalFactory;
import com.google.appengine.tools.development.ApiServer;
import com.google.appengine.tools.development.ApiServerFactory;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.testing.LocalModulesServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.TestLocalServerEnvironment;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalServiceTestHelper {
    private static final ImmutableSet<String> DEFAULT_APIS_USING_PYTHON_STUBS = ImmutableSet.of("app_identity_service", "capability_service", "log", "mail", "memcache", "socket", new String[]{"urlfetch"});
    private static final String APPS_NAMESPACE_KEY = String.valueOf(NamespaceManager.class.getName()).concat(".appsNamespace");
    private static ApiProxyLocal apiProxyLocal;
    static final String DEFAULT_APP_ID = "test";
    static final String DEFAULT_VERSION_ID = "1.0";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<LocalServiceTestConfig> configs;
    private String envAppId = "test";
    private String envModuleId = "default";
    private String envVersionId = "1.0";
    private int envInstance = -1;
    private String envEmail;
    private boolean envIsLoggedIn;
    private boolean envIsAdmin;
    private String envAuthDomain;
    private RequestMillisTimer timer = RequestMillisTimer.DEFAULT;
    private ConcurrentMap<String, Object> envAttributes = new ConcurrentHashMap<String, Object>();
    private Clock clock;
    private boolean enforceApiDeadlines = false;
    private boolean simulateProdLatencies = false;
    private final LocalModulesServiceTestConfig modulesServiceTestConfig;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private TimeZone originalDefaultTimeZone;
    private ApiServer apiServer;
    private Set<String> apisUsingPythonStubs = new HashSet<String>();

    public LocalServiceTestHelper(LocalServiceTestConfig ... configs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        LocalModulesServiceTestConfig configuredModulesServiceTestConfig = null;
        for (LocalServiceTestConfig config : configs) {
            if (config instanceof LocalModulesServiceTestConfig) {
                if (configuredModulesServiceTestConfig != null) {
                    throw new IllegalArgumentException("Multiple LocalModulesServiceTestConfig instances provided");
                }
                configuredModulesServiceTestConfig = (LocalModulesServiceTestConfig)config;
                continue;
            }
            builder.add(config);
        }
        this.configs = builder.build();
        this.modulesServiceTestConfig = configuredModulesServiceTestConfig;
        String apiServerPath = this.getApiServerPathIfExists();
        if (apiServerPath != null && configs.length > 0 && Boolean.parseBoolean(System.getProperty("appengine.enablePythonApis", "true"))) {
            this.populateApisUsingPythonStubs();
            this.apiServer = ApiServerFactory.getApiServer(apiServerPath, this.envAppId, null, null);
        }
    }

    private String getApiServerPathIfExists() {
        String apiServerPath = System.getProperty("appengine.pathToPythonApiServer");
        if (apiServerPath == null) {
            URL apiServerPathUrl = LocalServiceTestHelper.class.getClassLoader().getResource("com/google/appengine/tools/development/ApiServerPath.txt");
            if (apiServerPathUrl == null) {
                return null;
            }
            try {
                apiServerPath = Resources.toString(apiServerPathUrl, StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read the API server path resource.", e);
            }
        }
        return apiServerPath;
    }

    private void populateApisUsingPythonStubs() {
        Collection<String> apis;
        String apisUsingPythonStubsProperty = System.getProperty("appengine.apisUsingPythonStubs");
        if (apisUsingPythonStubsProperty == null) {
            apis = DEFAULT_APIS_USING_PYTHON_STUBS;
            System.setProperty("appengine.apisUsingPythonStubs", Joiner.on(",").join(DEFAULT_APIS_USING_PYTHON_STUBS));
        } else {
            apis = Splitter.on(',').splitToList(apisUsingPythonStubsProperty);
        }
        this.apisUsingPythonStubs.addAll(apis);
    }

    public LocalServiceTestHelper setEnvAppId(String envAppId) {
        this.envAppId = envAppId;
        return this;
    }

    public LocalServiceTestHelper setEnvModuleId(String envModuleId) {
        this.envModuleId = envModuleId;
        return this;
    }

    public LocalServiceTestHelper setEnvVersionId(String envVersionId) {
        this.envVersionId = envVersionId;
        return this;
    }

    public LocalServiceTestHelper setEnvInstance(String envInstance) {
        int intValue = Integer.parseInt(envInstance);
        boolean bl = intValue >= -1;
        String string = String.valueOf(envInstance);
        Preconditions.checkArgument(bl, string.length() != 0 ? "envInstanceId must be >= -1 and envInstanceId=".concat(string) : new String("envInstanceId must be >= -1 and envInstanceId="));
        this.envInstance = intValue;
        return this;
    }

    public LocalServiceTestHelper setEnvEmail(String envEmail) {
        this.envEmail = envEmail;
        return this;
    }

    public LocalServiceTestHelper setEnvIsLoggedIn(boolean envIsLoggedIn) {
        this.envIsLoggedIn = envIsLoggedIn;
        return this;
    }

    public LocalServiceTestHelper setEnvIsAdmin(boolean envIsAdmin) {
        this.envIsAdmin = envIsAdmin;
        return this;
    }

    public LocalServiceTestHelper setEnvAuthDomain(String envAuthDomain) {
        this.envAuthDomain = envAuthDomain;
        return this;
    }

    public LocalServiceTestHelper setRemainingMillisTimer(RequestMillisTimer timer) {
        this.timer = timer;
        return this;
    }

    public LocalServiceTestHelper setEnvRequestNamespace(String envRequestNamespace) {
        this.envAttributes.put(APPS_NAMESPACE_KEY, envRequestNamespace);
        return this;
    }

    public LocalServiceTestHelper setEnvAttributes(Map<String, Object> envAttributes) {
        this.envAttributes = new ConcurrentHashMap<String, Object>(envAttributes);
        return this;
    }

    public LocalServiceTestHelper setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public LocalServiceTestHelper setEnforceApiDeadlines(boolean val) {
        this.enforceApiDeadlines = val;
        return this;
    }

    public LocalServiceTestHelper setSimulateProdLatencies(boolean val) {
        this.simulateProdLatencies = val;
        return this;
    }

    public LocalServiceTestHelper setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public final LocalServiceTestHelper setUp() {
        this.originalDefaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(this.timeZone);
        if (this.modulesServiceTestConfig != null && this.envInstance == -1 && this.modulesServiceTestConfig.requiresEnvironmentInstance(this.envModuleId, this.envVersionId)) {
            this.envInstance = 0;
        }
        ApiProxy.setEnvironmentForCurrentThread(this.newEnvironment());
        if (this.apiServer != null) {
            try {
                this.apiServer.clear();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            apiProxyLocal = new ApiProxyLocalFactory().create(this.newLocalServerEnvironment(), this.apisUsingPythonStubs, this.envAppId);
        } else {
            apiProxyLocal = new ApiProxyLocalFactory().create(this.newLocalServerEnvironment());
        }
        if (this.clock != null) {
            apiProxyLocal.setClock(this.clock);
        }
        ApiProxy.setDelegate(apiProxyLocal);
        if (this.modulesServiceTestConfig != null) {
            this.modulesServiceTestConfig.setUp();
            this.modulesServiceTestConfig.verifyEnvironment(this.envModuleId, this.envVersionId, this.envInstance);
        }
        for (LocalServiceTestConfig config : this.configs) {
            config.setUp();
        }
        return this;
    }

    protected ApiProxy.Environment newEnvironment() {
        LocalEnvironment env = new LocalEnvironment(this.envAppId, this.envModuleId, this.envVersionId, this.envInstance, 8080, null){

            @Override
            public String getEmail() {
                return LocalServiceTestHelper.this.envEmail;
            }

            @Override
            public boolean isLoggedIn() {
                return LocalServiceTestHelper.this.envIsLoggedIn;
            }

            @Override
            public boolean isAdmin() {
                return LocalServiceTestHelper.this.envIsAdmin;
            }

            @Override
            public String getAuthDomain() {
                return LocalServiceTestHelper.this.envAuthDomain;
            }

            @Override
            public long getRemainingMillis() {
                return LocalServiceTestHelper.this.timer.getRemainingMillis();
            }
        };
        env.getAttributes().putAll(this.envAttributes);
        return env;
    }

    static ApiProxy.Environment copyEnvironment(ApiProxy.Environment copyFrom) {
        return new TestEnvironment(copyFrom);
    }

    static ApiProxy.Environment newDefaultTestEnvironment() {
        return new TestEnvironment();
    }

    protected LocalServerEnvironment newLocalServerEnvironment() {
        return new TestLocalServerEnvironment(this.enforceApiDeadlines, this.simulateProdLatencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tearDown() {
        try {
            RuntimeException firstException = null;
            for (LocalServiceTestConfig config : this.configs) {
                firstException = this.tearDownService(firstException, config);
            }
            if (this.modulesServiceTestConfig != null) {
                firstException = this.tearDownService(firstException, this.modulesServiceTestConfig);
            }
            if (firstException != null) {
                throw firstException;
            }
            LocalServiceTestHelper.endRequest();
            ApiProxy.setDelegate(null);
            ApiProxy.setEnvironmentForCurrentThread(null);
            apiProxyLocal = null;
        }
        finally {
            TimeZone.setDefault(this.originalDefaultTimeZone);
        }
    }

    private RuntimeException tearDownService(RuntimeException firstException, LocalServiceTestConfig config) {
        try {
            config.tearDown();
        }
        catch (RuntimeException rte) {
            if (firstException == null) {
                firstException = rte;
            }
            String string = String.valueOf(config.getClass().getName());
            this.logger.logp(Level.SEVERE, "com.google.appengine.tools.development.testing.LocalServiceTestHelper", "tearDownService", string.length() != 0 ? "Caught exception tearing down config of type ".concat(string) : new String("Caught exception tearing down config of type "), rte);
        }
        return firstException;
    }

    public static void endRequest() {
        ((LocalEnvironment)ApiProxy.getCurrentEnvironment()).callRequestEndListeners();
    }

    public static ApiProxyLocal getApiProxyLocal() {
        return apiProxyLocal;
    }

    public static LocalRpcService getLocalService(String serviceName) {
        return LocalServiceTestHelper.getApiProxyLocal().getService(serviceName);
    }

    private static class TestEnvironment
    extends LocalEnvironment {
        private String email;
        private boolean isLoggedIn;
        private boolean isAdmin;
        private String authDomain;

        private TestEnvironment() {
            super(LocalServiceTestHelper.DEFAULT_APP_ID, "default", LocalServiceTestHelper.DEFAULT_VERSION_ID, -1, 8080, null);
        }

        private TestEnvironment(String appId, String majorVersionId, String email, boolean isLoggedIn, boolean isAdmin, String authDomain, String moduleName, int instance, Map<String, Object> attributes) {
            super(appId, moduleName, majorVersionId, instance, 8080, null);
            this.email = email;
            this.isLoggedIn = isLoggedIn;
            this.isAdmin = isAdmin;
            this.authDomain = authDomain;
            this.attributes.putAll(attributes);
        }

        public TestEnvironment(ApiProxy.Environment copyFrom) {
            this(copyFrom.getAppId(), TestEnvironment.getMajorVersion(copyFrom.getVersionId()), copyFrom.getEmail(), copyFrom.isLoggedIn(), copyFrom.isAdmin(), copyFrom.getAuthDomain(), copyFrom.getModuleId(), TestEnvironment.getInstance(copyFrom), copyFrom.getAttributes());
        }

        private static int getInstance(ApiProxy.Environment environment) {
            int result = -1;
            if (environment.getAttributes().containsKey("com.google.appengine.instance.id")) {
                result = Integer.parseInt((String)environment.getAttributes().get("com.google.appengine.instance.id"));
            }
            return result;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public boolean isLoggedIn() {
            return this.isLoggedIn;
        }

        @Override
        public boolean isAdmin() {
            return this.isAdmin;
        }

        @Override
        public String getAuthDomain() {
            return this.authDomain;
        }
    }

    public static interface RequestMillisTimer {
        public static final RequestMillisTimer DEFAULT = new RequestMillisTimer(){

            @Override
            public long getRemainingMillis() {
                return Long.MAX_VALUE;
            }
        };

        public long getRemainingMillis();
    }
}

