/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.primitives.Doubles;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApiProxyLocalFactory;
import com.google.appengine.tools.development.ApiServlet;
import com.google.appengine.tools.development.ApiUtils;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.api.RemoteApiPb;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApiServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(ApiServlet.class.getName());
    private static final String RPC_ENDPOINT_HEADER = "X-Google-RPC-Service-Endpoint";
    private static final String RPC_ENDPOINT_VALUE = "app-engine-apis";
    private static final String RPC_METHOD_HEADER = "X-Google-RPC-Service-Method";
    private static final String RPC_METHOD_VALUE = "/VMRemoteAPI.CallRemoteAPI";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE_VALUE = "application/octet-stream";
    private static final String DEADLINE_HEADER = "X-Google-RPC-Service-Deadline";
    private static final String RUNTIME_PORT_CONFIG = "java_runtime_port";
    private static final String EXECUTOR_POOL_SIZE = "executor_pool_size";
    private final Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();
    private ApiProxyLocal apiProxyLocal;
    private int serverPort;
    private ExecutorService executor;
    private static final int EXECUTOR_THREAD_POOL_DEFAULT_SIZE = 10;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config.getInitParameter(RUNTIME_PORT_CONFIG) == null) {
            throw new NumberFormatException("Missing java_runtime_port init parameter.");
        }
        this.serverPort = Integer.parseInt(config.getInitParameter(RUNTIME_PORT_CONFIG));
        this.apiProxyLocal = new ApiProxyLocalFactory().create((LocalServerEnvironment)new LocalEnv(this.serverPort));
        this.apiProxyLocal.setProperty("datastore.no_storage", "true");
        String executorSize = config.getInitParameter(EXECUTOR_POOL_SIZE);
        int poolSize = executorSize == null ? 10 : Integer.parseInt(executorSize);
        this.executor = Executors.newFixedThreadPool(poolSize);
    }

    public void destroy() {
        this.executor.shutdown();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Double deadline = this.validateHeaders(request);
        try (ServletInputStream in = request.getInputStream();){
            RemoteApiPb.Request requestPb = RemoteApiPb.Request.parseFrom((InputStream)in, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
            if (in.read() >= 0) {
                throw new IllegalArgumentException("Extra data after request");
            }
            response.addHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_VALUE);
            RemoteApiPb.Response responsePb = this.handleRequestInThread(this.apiProxyLocal, requestPb, deadline);
            try (ServletOutputStream out = response.getOutputStream();){
                out.write(responsePb.toByteArray());
            }
        }
        catch (RuntimeException e) {
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.ApiServlet", "doPost", "bad request:", e);
            response.setStatus(400);
        }
    }

    @VisibleForTesting
    Double validateHeaders(HttpServletRequest request) {
        Double deadline;
        String endpoint = request.getHeader(RPC_ENDPOINT_HEADER);
        if (!RPC_ENDPOINT_VALUE.equals(endpoint)) {
            throw new IllegalArgumentException(new StringBuilder(62 + String.valueOf(endpoint).length()).append("X-Google-RPC-Service-Endpoint should be app-engine-apis, not ").append(endpoint).append(".").toString());
        }
        String method = request.getHeader(RPC_METHOD_HEADER);
        if (!RPC_METHOD_VALUE.equals(method)) {
            throw new IllegalArgumentException(new StringBuilder(71 + String.valueOf(method).length()).append("X-Google-RPC-Service-Method should be /VMRemoteAPI.CallRemoteAPI, not ").append(method).append(".").toString());
        }
        String contentType = request.getHeader(CONTENT_TYPE_HEADER);
        if (!CONTENT_TYPE_VALUE.equals(contentType)) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(contentType).length()).append("Content-Type should be application/octet-stream, not ").append(contentType).append(".").toString());
        }
        String deadlineString = request.getHeader(DEADLINE_HEADER);
        Double d = deadline = deadlineString == null ? null : Doubles.tryParse(deadlineString);
        if (deadline == null) {
            throw new IllegalArgumentException(new StringBuilder(50 + String.valueOf(deadlineString).length()).append("Missing or incorrect deadline header in request: ").append(deadlineString).append(".").toString());
        }
        return deadline;
    }

    private RemoteApiPb.Response handleRequestInThread(ApiProxyLocal apiProxy, RemoteApiPb.Request requestPb, double deadline) {
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        Future future = this.executor.submit(task);
        try {
            return (RemoteApiPb.Response)future.get((long)(deadline * 1000.0), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            return this.exceptionResponse(e);
        }
        catch (InterruptedException | TimeoutException e) {
            future.cancel(true);
            return this.timeoutResponse(deadline);
        }
    }

    @VisibleForTesting
    byte[] invokeApiMethodJava(ApiProxyLocal apiProxy, String packageName, String methodName, byte[] requestBytes) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        LocalRpcService service = apiProxy.getService(packageName);
        if (service == null) {
            throw new ApiProxy.CallNotFoundException(packageName, methodName);
        }
        Method method = this.getDispatchMethod(service, packageName, methodName);
        LocalRpcService.Status status = new LocalRpcService.Status();
        Class<?> requestClass = method.getParameterTypes()[1];
        Object request = ApiUtils.convertBytesToPb(requestBytes, requestClass);
        return ApiUtils.convertPbToBytes(method.invoke((Object)service, status, request));
    }

    @VisibleForTesting
    Method getDispatchMethod(LocalRpcService service, String packageName, String methodName) {
        char c = Ascii.toLowerCase(methodName.charAt(0));
        String string = methodName.substring(1);
        String dispatchName = new StringBuilder(1 + String.valueOf(string).length()).append(c).append(string).toString();
        String methodId = new StringBuilder(1 + String.valueOf(packageName).length() + String.valueOf(dispatchName).length()).append(packageName).append(".").append(dispatchName).toString();
        Method method = this.methodCache.get(methodId);
        if (method != null) {
            return method;
        }
        for (Method candidate : service.getClass().getMethods()) {
            if (!dispatchName.equals(candidate.getName())) continue;
            this.methodCache.put(methodId, candidate);
            return candidate;
        }
        throw new ApiProxy.CallNotFoundException(packageName, methodName);
    }

    @VisibleForTesting
    RemoteApiPb.Response handle(ApiProxyLocal apiProxy, RemoteApiPb.Request request) {
        byte[] resp;
        try {
            resp = this.invokeApiMethodJava(apiProxy, request.getServiceName(), request.getMethod(), request.getRequest().toByteArray());
        }
        catch (InvocationTargetException ex) {
            String string = request.getServiceName();
            String string2 = request.getMethod();
            throw new ApiProxy.ApiProxyException(new StringBuilder(47 + String.valueOf(string).length() + String.valueOf(string2).length()).append("API invocation error for service: ").append(string).append(" and method: ").append(string2).toString(), ex.getCause());
        }
        catch (ReflectiveOperationException ex) {
            throw new ApiProxy.CallNotFoundException(request.getServiceName(), request.getMethod());
        }
        return RemoteApiPb.Response.newBuilder().setResponse(ByteString.copyFrom(resp)).build();
    }

    private RemoteApiPb.Response timeoutResponse(double deadline) {
        return RemoteApiPb.Response.newBuilder().setRpcError(RemoteApiPb.RpcError.newBuilder().setCode(RemoteApiPb.RpcError.ErrorCode.DEADLINE_EXCEEDED.getNumber()).setDetail(new StringBuilder(50).append("Deadline of ").append(deadline).append("s was exceeded").toString())).build();
    }

    private RemoteApiPb.Response exceptionResponse(ExecutionException exception) {
        String string = String.valueOf(exception.getMessage());
        RemoteApiPb.RpcError rpcError = RemoteApiPb.RpcError.newBuilder().setCode(RemoteApiPb.RpcError.ErrorCode.BAD_REQUEST.getNumber()).setDetail(string.length() != 0 ? "Execution exception ".concat(string) : new String("Execution exception ")).build();
        RemoteApiPb.Response.Builder response = RemoteApiPb.Response.newBuilder();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteStream);){
            out.writeObject(exception);
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, "com.google.appengine.tools.development.ApiServlet", "exceptionResponse", "Cannot serialize the exception: ", e);
        }
        byte[] serializedException = byteStream.toByteArray();
        response.setJavaException(ByteString.copyFrom(serializedException));
        response.setRpcError(rpcError);
        return response.build();
    }
}

