/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.StagingOptions;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AppEngineWebXmlProcessor {
    private static final Logger logger = Logger.getLogger(AppEngineWebXmlProcessor.class.getName());
    private boolean moduleNodeFound;
    private boolean serviceNodeFound;
    private boolean warmupNodeFound;

    AppEngineWebXmlProcessor() {
    }

    public AppEngineWebXml processXml(InputStream is) {
        Element config = this.getTopLevelNode(is);
        AppEngineWebXml appEngineWebXml = new AppEngineWebXml();
        NodeList nodes = config.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            this.processSecondLevelNode((Element)node, appEngineWebXml);
        }
        AppEngineWebXmlProcessor.checkScalingConstraints(appEngineWebXml);
        if (this.serviceNodeFound && this.moduleNodeFound) {
            throw new AppEngineConfigException("The <service> and <module> elements are conflicting. Please remove the deprecated <module> element.");
        }
        if (!appEngineWebXml.isFlexible() && !this.warmupNodeFound) {
            appEngineWebXml.setWarmupRequestsEnabled(true);
        }
        return appEngineWebXml;
    }

    private static void checkScalingConstraints(AppEngineWebXml appEngineWebXml) {
        int count = appEngineWebXml.getManualScaling().isEmpty() ? 0 : 1;
        count += appEngineWebXml.getBasicScaling().isEmpty() ? 0 : 1;
        if ((count += appEngineWebXml.getAutomaticScaling().isEmpty() ? 0 : 1) > 1) {
            throw new AppEngineConfigException("There may be only one of 'automatic-scaling', 'manual-scaling' or 'basic-scaling' elements.");
        }
    }

    Element getTopLevelNode(InputStream is) {
        return XmlUtils.parseXml(is).getDocumentElement();
    }

    private void processSecondLevelNode(Element elt, AppEngineWebXml appEngineWebXml) {
        String elementName;
        switch (elementName = elt.getTagName()) {
            case "system-properties": {
                this.processSystemPropertiesNode(elt, appEngineWebXml);
                break;
            }
            case "vm-settings": 
            case "beta-settings": {
                this.processBetaSettingsNode(elt, appEngineWebXml);
                break;
            }
            case "vm-health-check": 
            case "health-check": {
                this.processHealthCheckNode(elt, appEngineWebXml);
                break;
            }
            case "liveness-check": {
                this.processLivenessCheckNode(elt, appEngineWebXml);
                break;
            }
            case "readiness-check": {
                this.processReadinessCheckNode(elt, appEngineWebXml);
                break;
            }
            case "resources": {
                this.processResourcesNode(elt, appEngineWebXml);
                break;
            }
            case "network": {
                this.processNetworkNode(elt, appEngineWebXml);
                break;
            }
            case "env-variables": {
                this.processEnvironmentVariablesNode(elt, appEngineWebXml);
                break;
            }
            case "build-env-variables": {
                this.processBuildEnvironmentVariablesNode(elt, appEngineWebXml);
                break;
            }
            case "application": {
                this.processApplicationNode(elt, appEngineWebXml);
                break;
            }
            case "entrypoint": {
                this.processEntrypointNode(elt, appEngineWebXml);
                break;
            }
            case "runtime-channel": {
                this.processRuntimeChannelNode(elt, appEngineWebXml);
                break;
            }
            case "runtime": {
                this.processRuntimeNode(elt, appEngineWebXml);
                break;
            }
            case "version": {
                this.processVersionNode(elt, appEngineWebXml);
                break;
            }
            case "source-language": {
                logger.logp(Level.WARNING, "com.google.apphosting.utils.config.AppEngineWebXmlProcessor", "processSecondLevelNode", "The element <source-language> in appengine-web.xml file was ignored.");
                break;
            }
            case "module": {
                this.moduleNodeFound = true;
                this.processModuleNode(elt, appEngineWebXml);
                break;
            }
            case "service": {
                this.serviceNodeFound = true;
                this.processServiceNode(elt, appEngineWebXml);
                break;
            }
            case "instance-class": {
                this.processInstanceClassNode(elt, appEngineWebXml);
                break;
            }
            case "automatic-scaling": {
                this.processAutomaticScalingNode(elt, appEngineWebXml);
                break;
            }
            case "manual-scaling": {
                this.processManualScalingNode(elt, appEngineWebXml);
                break;
            }
            case "basic-scaling": {
                this.processBasicScalingNode(elt, appEngineWebXml);
                break;
            }
            case "static-files": {
                this.processFilesetNode(elt, appEngineWebXml, FileType.STATIC);
                break;
            }
            case "resource-files": {
                this.processFilesetNode(elt, appEngineWebXml, FileType.RESOURCE);
                break;
            }
            case "ssl-enabled": {
                this.processSslEnabledNode(elt, appEngineWebXml);
                break;
            }
            case "sessions-enabled": {
                this.processSessionsEnabledNode(elt, appEngineWebXml);
                break;
            }
            case "async-session-persistence": {
                this.processAsyncSessionPersistenceNode(elt, appEngineWebXml);
                break;
            }
            case "user-permissions": {
                this.processPermissionsNode(elt, appEngineWebXml);
                break;
            }
            case "public-root": {
                this.processPublicRootNode(elt, appEngineWebXml);
                break;
            }
            case "inbound-services": {
                this.processInboundServicesNode(elt, appEngineWebXml);
                break;
            }
            case "precompilation-enabled": {
                this.processPrecompilationEnabledNode(elt, appEngineWebXml);
                break;
            }
            case "admin-console": {
                this.processAdminConsoleNode(elt, appEngineWebXml);
                break;
            }
            case "static-error-handlers": {
                this.processErrorHandlerNode(elt, appEngineWebXml);
                break;
            }
            case "warmup-requests-enabled": {
                this.warmupNodeFound = true;
                this.processWarmupRequestsEnabledNode(elt, appEngineWebXml);
                break;
            }
            case "threadsafe": {
                this.processThreadsafeNode(elt, appEngineWebXml);
                break;
            }
            case "app-engine-apis": {
                appEngineWebXml.setAppEngineApis(this.getBooleanValue(elt));
                break;
            }
            case "auto-id-policy": {
                this.processAutoIdPolicyNode(elt, appEngineWebXml);
                break;
            }
            case "code-lock": {
                this.processCodeLockNode(elt, appEngineWebXml);
                break;
            }
            case "vm": {
                this.processVmNode(elt, appEngineWebXml);
                break;
            }
            case "env": {
                this.processEnvNode(elt, appEngineWebXml);
                break;
            }
            case "api-config": {
                this.processApiConfigNode(elt, appEngineWebXml);
                break;
            }
            case "class-loader-config": {
                this.processClassLoaderConfig(elt, appEngineWebXml);
                break;
            }
            case "url-stream-handler": {
                this.processUrlStreamHandler(elt, appEngineWebXml);
                break;
            }
            case "use-google-connector-j": {
                this.processUseGoogleConnectorJNode(elt, appEngineWebXml);
                break;
            }
            case "pagespeed": {
                String string = appEngineWebXml.getAppId();
                logger.logp(Level.WARNING, "com.google.apphosting.utils.config.AppEngineWebXmlProcessor", "processSecondLevelNode", new StringBuilder(59 + String.valueOf(string).length()).append("app_id ").append(string).append(" has <pagespeed> in appengine-web.xml file, ignored.").toString());
                break;
            }
            case "staging": {
                this.processStagingNode(elt, appEngineWebXml);
                break;
            }
            case "vpc-access-connector": {
                this.processVpcAccessConnector(elt, appEngineWebXml);
                break;
            }
            case "service-account": {
                this.processServiceAccountNode(elt, appEngineWebXml);
                break;
            }
            default: {
                throw new AppEngineConfigException(new StringBuilder(23 + String.valueOf(elementName).length()).append("Unrecognized element <").append(elementName).append(">").toString());
            }
        }
    }

    private void processApplicationNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setAppId(XmlUtils.getText(node));
    }

    private void processEntrypointNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setEntrypoint(XmlUtils.getText(node));
    }

    private void processRuntimeChannelNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setRuntimeChannel(XmlUtils.getText(node));
    }

    private void processPublicRootNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setPublicRoot(XmlUtils.getText(node));
    }

    private void processVersionNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setMajorVersionId(XmlUtils.getText(node));
    }

    private void processRuntimeNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setRuntime(XmlUtils.getText(node));
    }

    private void processModuleNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setModule(XmlUtils.getText(node));
    }

    private void processServiceNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setService(XmlUtils.getText(node));
    }

    private void processInstanceClassNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setInstanceClass(XmlUtils.getText(node));
    }

    private void processServiceAccountNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setServiceAccount(XmlUtils.getText(node));
    }

    private String getChildNodeText(Element parentNode, String childTag) {
        Element node = XmlUtils.getOptionalChildElement(parentNode, childTag);
        if (node == null) {
            return null;
        }
        String result = XmlUtils.getText(node);
        return result.isEmpty() ? null : result;
    }

    private Integer getChildNodePositiveInteger(Element parentNode, String childTag) {
        Integer result = this.getChildNodeNonNegativeInteger(parentNode, childTag);
        if (result != null && result == 0) {
            throw new AppEngineConfigException(String.valueOf(childTag).concat(" should only contain positive integers."));
        }
        return result;
    }

    private Integer getChildNodeNonNegativeInteger(Element parentNode, String childTag) {
        String trimmedText;
        Integer result = null;
        Element node = XmlUtils.getOptionalChildElement(parentNode, childTag);
        if (node != null && !(trimmedText = XmlUtils.getText(node)).isEmpty()) {
            try {
                result = Integer.parseInt(trimmedText);
            }
            catch (NumberFormatException ex) {
                throw new AppEngineConfigException(String.valueOf(childTag).concat(" should only contain integers."));
            }
            if (result < 0) {
                throw new AppEngineConfigException(String.valueOf(childTag).concat(" should only contain non-negative integers."));
            }
        }
        return result;
    }

    private Double getChildNodeDouble(Element parentNode, String childTag) {
        String trimmedText;
        Double result = null;
        Element node = XmlUtils.getOptionalChildElement(parentNode, childTag);
        if (node != null && !(trimmedText = XmlUtils.getText(node)).isEmpty()) {
            try {
                result = Double.parseDouble(trimmedText);
            }
            catch (NumberFormatException ex) {
                throw new AppEngineConfigException(String.valueOf(childTag).concat(" should only contain doubles."));
            }
            catch (NullPointerException ex) {
                throw new AppEngineConfigException(String.valueOf(childTag).concat(" should NOT be empty."));
            }
        }
        return result;
    }

    private void processAutomaticScalingNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.AutomaticScaling automaticScaling = appEngineWebXml.getAutomaticScaling();
        automaticScaling.setMinPendingLatency(this.getChildNodeText(settingsNode, "min-pending-latency"));
        automaticScaling.setMaxPendingLatency(this.getChildNodeText(settingsNode, "max-pending-latency"));
        automaticScaling.setMinIdleInstances(this.getChildNodeText(settingsNode, "min-idle-instances"));
        automaticScaling.setMaxIdleInstances(this.getChildNodeText(settingsNode, "max-idle-instances"));
        automaticScaling.setMaxInstances(this.getChildNodePositiveInteger(settingsNode, "max-instances"));
        automaticScaling.setMinInstances(this.getChildNodeNonNegativeInteger(settingsNode, "min-instances"));
        automaticScaling.setTargetCpuUtilization(this.getChildNodeDouble(settingsNode, "target-cpu-utilization"));
        automaticScaling.setTargetThroughputUtilization(this.getChildNodeDouble(settingsNode, "target-throughput-utilization"));
        automaticScaling.setMaxConcurrentRequests(this.getChildNodeText(settingsNode, "max-concurrent-requests"));
        automaticScaling.setMinNumInstances(this.getChildNodePositiveInteger(settingsNode, "min-num-instances"));
        automaticScaling.setMaxNumInstances(this.getChildNodePositiveInteger(settingsNode, "max-num-instances"));
        automaticScaling.setCoolDownPeriodSec(this.getChildNodePositiveInteger(settingsNode, "cool-down-period-sec"));
        this.processCpuUtilizationNode(settingsNode, automaticScaling);
        this.processCustomMetricsNode(settingsNode, automaticScaling);
        automaticScaling.setTargetNetworkSentBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-sent-bytes-per-sec"));
        automaticScaling.setTargetNetworkSentPacketsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-sent-packets-per-sec"));
        automaticScaling.setTargetNetworkReceivedBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-received-bytes-per-sec"));
        automaticScaling.setTargetNetworkReceivedPacketsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-network-received-packets-per-sec"));
        automaticScaling.setTargetDiskWriteBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-write-bytes-per-sec"));
        automaticScaling.setTargetDiskWriteOpsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-write-ops-per-sec"));
        automaticScaling.setTargetDiskReadBytesPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-read-bytes-per-sec"));
        automaticScaling.setTargetDiskReadOpsPerSec(this.getChildNodePositiveInteger(settingsNode, "target-disk-read-ops-per-sec"));
        automaticScaling.setTargetRequestCountPerSec(this.getChildNodePositiveInteger(settingsNode, "target-request-count-per-sec"));
        automaticScaling.setTargetConcurrentRequests(this.getChildNodePositiveInteger(settingsNode, "target-concurrent-requests"));
    }

    private void processCpuUtilizationNode(Element settingsNode, AppEngineWebXml.AutomaticScaling automaticScaling) {
        Element childNode = XmlUtils.getOptionalChildElement(settingsNode, "cpu-utilization");
        if (childNode != null) {
            AppEngineWebXml.CpuUtilization cpuUtilization = new AppEngineWebXml.CpuUtilization();
            Double targetUtilization = this.getChildNodeDouble(childNode, "target-utilization");
            if (targetUtilization != null) {
                if (targetUtilization <= 0.0 || targetUtilization > 1.0) {
                    throw new AppEngineConfigException("target-utilization should be in range (0, 1].");
                }
                cpuUtilization.setTargetUtilization(targetUtilization);
            }
            cpuUtilization.setAggregationWindowLengthSec(this.getChildNodePositiveInteger(childNode, "aggregation-window-length-sec"));
            if (!cpuUtilization.isEmpty()) {
                automaticScaling.setCpuUtilization(cpuUtilization);
            }
        }
    }

    private void processCustomMetricsNode(Element settingsNode, AppEngineWebXml.AutomaticScaling automaticScaling) {
        ArrayList<AppEngineWebXml.CustomMetricUtilization> customMetrics = new ArrayList<AppEngineWebXml.CustomMetricUtilization>();
        Element node = XmlUtils.getOptionalChildElement(settingsNode, "custom-metrics");
        if (node == null) {
            return;
        }
        for (Element metric : this.getNodeIterable(node, "custom-metric")) {
            String filter;
            Double singleInstanceAssignment;
            AppEngineWebXml.CustomMetricUtilization customMetric = new AppEngineWebXml.CustomMetricUtilization();
            String metricName = this.getChildNodeText(metric, "metric-name");
            if (metricName == null || metricName.isEmpty()) {
                throw new AppEngineConfigException("metric-name must be defined.");
            }
            customMetric.setMetricName(metricName);
            String targetType = this.getChildNodeText(metric, "target-type");
            if (targetType == null || targetType.isEmpty()) {
                throw new AppEngineConfigException("target-type must be defined.");
            }
            customMetric.setTargetType(targetType);
            Double targetUtilization = this.getChildNodeDouble(metric, "target-utilization");
            if (targetUtilization != null) {
                if (targetUtilization <= 0.0) {
                    throw new AppEngineConfigException("target-utilization must be positive.");
                }
                customMetric.setTargetUtilization(targetUtilization);
            }
            if ((singleInstanceAssignment = this.getChildNodeDouble(metric, "single-instance-assignment")) != null) {
                if (singleInstanceAssignment <= 0.0) {
                    throw new AppEngineConfigException("single-instance-assignment must be positive.");
                }
                customMetric.setSingleInstanceAssignment(singleInstanceAssignment);
            }
            if ((filter = this.getChildNodeText(metric, "filter")) != null && !filter.isEmpty()) {
                customMetric.setFilter(filter);
            }
            customMetrics.add(customMetric);
        }
        automaticScaling.setCustomMetrics(customMetrics);
    }

    private void processManualScalingNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.ManualScaling manualScaling = appEngineWebXml.getManualScaling();
        manualScaling.setInstances(this.getChildNodeText(settingsNode, "instances"));
    }

    private void processBasicScalingNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.BasicScaling basicScaling = appEngineWebXml.getBasicScaling();
        basicScaling.setMaxInstances(this.getChildNodeText(settingsNode, "max-instances"));
        basicScaling.setIdleTimeout(this.getChildNodeText(settingsNode, "idle-timeout"));
    }

    private void processSslEnabledNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSslEnabled(this.getBooleanValue(node));
    }

    private void processSessionsEnabledNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setSessionsEnabled(this.getBooleanValue(node));
    }

    private void processAsyncSessionPersistenceNode(Element node, AppEngineWebXml appEngineWebXml) {
        boolean enabled = this.getBooleanAttributeValue(node, "enabled");
        appEngineWebXml.setAsyncSessionPersistence(enabled);
        String queueName = this.trim(node.getAttribute("queue-name"));
        if (queueName.equals("")) {
            queueName = null;
        }
        appEngineWebXml.setAsyncSessionPersistenceQueueName(queueName);
    }

    private void processPrecompilationEnabledNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setPrecompilationEnabled(this.getBooleanValue(node));
    }

    private void processWarmupRequestsEnabledNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setWarmupRequestsEnabled(this.getBooleanValue(node));
    }

    private void processThreadsafeNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setThreadsafe(this.getBooleanValue(node));
    }

    private void processAutoIdPolicyNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setAutoIdPolicy(XmlUtils.getText(node));
    }

    private void processCodeLockNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setCodeLock(this.getBooleanValue(node));
    }

    private void processVmNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setUseVm(this.getBooleanValue(node));
    }

    private void processEnvNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setEnv(XmlUtils.getText(node));
    }

    private void processFilesetNode(Element node, AppEngineWebXml appEngineWebXml, FileType type) {
        String path;
        for (Element includeNode : this.getNodeIterable(node, "include")) {
            path = this.trim(includeNode.getAttribute("path"));
            if (path.equals("")) {
                path = null;
            }
            if (type == FileType.STATIC) {
                String expiration = this.trim(includeNode.getAttribute("expiration"));
                if (expiration.equals("")) {
                    expiration = null;
                }
                AppEngineWebXml.StaticFileInclude staticFileInclude = appEngineWebXml.includeStaticPattern(path, expiration);
                Map<String, String> httpHeaders = staticFileInclude.getHttpHeaders();
                for (Element httpHeaderNode : this.getNodeIterable(includeNode, "http-header")) {
                    String name = httpHeaderNode.getAttribute("name");
                    String value = httpHeaderNode.getAttribute("value");
                    if (httpHeaders.containsKey(name)) {
                        throw new AppEngineConfigException("Two http-header elements have the same name.");
                    }
                    httpHeaders.put(name, value);
                }
                continue;
            }
            appEngineWebXml.includeResourcePattern(path);
        }
        for (Element excludeNode : this.getNodeIterable(node, "exclude")) {
            path = this.trim(excludeNode.getAttribute("path"));
            if (type == FileType.STATIC) {
                appEngineWebXml.excludeStaticPattern(path);
                continue;
            }
            appEngineWebXml.excludeResourcePattern(path);
        }
    }

    private Iterable<Element> getNodeIterable(Element node, String filter) {
        return XmlUtils.getChildren(node, filter);
    }

    private void processSystemPropertiesNode(Element node, AppEngineWebXml appEngineWebXml) {
        for (Element propertyNode : this.getNodeIterable(node, "property")) {
            String propertyName = this.trim(propertyNode.getAttribute("name"));
            String propertyValue = this.trim(propertyNode.getAttribute("value"));
            appEngineWebXml.addSystemProperty(propertyName, propertyValue);
        }
    }

    private void processBetaSettingsNode(Element node, AppEngineWebXml appEngineWebXml) {
        for (Element subNode : this.getNodeIterable(node, "setting")) {
            String name = this.trim(subNode.getAttribute("name"));
            String value = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addBetaSetting(name, value);
        }
    }

    private void processHealthCheckNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        String host;
        Integer restartThreshold;
        Integer healthyThreshold;
        Integer unhealthyThreshold;
        Integer timeoutSec;
        Integer checkIntervalSec;
        AppEngineWebXml.HealthCheck healthCheck = new AppEngineWebXml.HealthCheck();
        String enableHealthCheck = this.trim(this.getChildNodeText(settingsNode, "enable-health-check"));
        if (enableHealthCheck != null && !enableHealthCheck.isEmpty()) {
            healthCheck.setEnableHealthCheck(this.toBoolean(enableHealthCheck));
        }
        if ((checkIntervalSec = this.getChildNodePositiveInteger(settingsNode, "check-interval-sec")) != null) {
            healthCheck.setCheckIntervalSec(checkIntervalSec);
        }
        if ((timeoutSec = this.getChildNodePositiveInteger(settingsNode, "timeout-sec")) != null) {
            healthCheck.setTimeoutSec(timeoutSec);
        }
        if ((unhealthyThreshold = this.getChildNodePositiveInteger(settingsNode, "unhealthy-threshold")) != null) {
            healthCheck.setUnhealthyThreshold(unhealthyThreshold);
        }
        if ((healthyThreshold = this.getChildNodePositiveInteger(settingsNode, "healthy-threshold")) != null) {
            healthCheck.setHealthyThreshold(healthyThreshold);
        }
        if ((restartThreshold = this.getChildNodePositiveInteger(settingsNode, "restart-threshold")) != null) {
            healthCheck.setRestartThreshold(restartThreshold);
        }
        if ((host = this.getChildNodeText(settingsNode, "host")) != null) {
            healthCheck.setHost(host);
        }
        appEngineWebXml.setHealthCheck(healthCheck);
    }

    private void processLivenessCheckNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        Integer initialDelaySec;
        String host;
        Integer successThreshold;
        Integer failureThreshold;
        Integer timeoutSec;
        Integer checkIntervalSec;
        AppEngineWebXml.LivenessCheck livenessCheck = new AppEngineWebXml.LivenessCheck();
        String path = this.getChildNodeText(settingsNode, "path");
        if (path != null) {
            livenessCheck.setPath(path);
        }
        if ((checkIntervalSec = this.getChildNodePositiveInteger(settingsNode, "check-interval-sec")) != null) {
            livenessCheck.setCheckIntervalSec(checkIntervalSec);
        }
        if ((timeoutSec = this.getChildNodePositiveInteger(settingsNode, "timeout-sec")) != null) {
            livenessCheck.setTimeoutSec(timeoutSec);
        }
        if ((failureThreshold = this.getChildNodePositiveInteger(settingsNode, "failure-threshold")) != null) {
            livenessCheck.setFailureThreshold(failureThreshold);
        }
        if ((successThreshold = this.getChildNodePositiveInteger(settingsNode, "success-threshold")) != null) {
            livenessCheck.setSuccessThreshold(successThreshold);
        }
        if ((host = this.getChildNodeText(settingsNode, "host")) != null) {
            livenessCheck.setHost(host);
        }
        if ((initialDelaySec = this.getChildNodePositiveInteger(settingsNode, "initial-delay-sec")) != null) {
            livenessCheck.setInitialDelaySec(initialDelaySec);
        }
        appEngineWebXml.setLivenessCheck(livenessCheck);
    }

    private void processReadinessCheckNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        Integer appStartTimeoutSec;
        String host;
        Integer successThreshold;
        Integer failureThreshold;
        Integer timeoutSec;
        Integer checkIntervalSec;
        AppEngineWebXml.ReadinessCheck readinessCheck = new AppEngineWebXml.ReadinessCheck();
        String path = this.getChildNodeText(settingsNode, "path");
        if (path != null) {
            readinessCheck.setPath(path);
        }
        if ((checkIntervalSec = this.getChildNodePositiveInteger(settingsNode, "check-interval-sec")) != null) {
            readinessCheck.setCheckIntervalSec(checkIntervalSec);
        }
        if ((timeoutSec = this.getChildNodePositiveInteger(settingsNode, "timeout-sec")) != null) {
            readinessCheck.setTimeoutSec(timeoutSec);
        }
        if ((failureThreshold = this.getChildNodePositiveInteger(settingsNode, "failure-threshold")) != null) {
            readinessCheck.setFailureThreshold(failureThreshold);
        }
        if ((successThreshold = this.getChildNodePositiveInteger(settingsNode, "success-threshold")) != null) {
            readinessCheck.setSuccessThreshold(successThreshold);
        }
        if ((host = this.getChildNodeText(settingsNode, "host")) != null) {
            readinessCheck.setHost(host);
        }
        if ((appStartTimeoutSec = this.getChildNodePositiveInteger(settingsNode, "app-start-timeout-sec")) != null) {
            readinessCheck.setAppStartTimeoutSec(appStartTimeoutSec);
        }
        appEngineWebXml.setReadinessCheck(readinessCheck);
    }

    private void processResourcesNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        Integer disk_size_gb;
        Double memory_gb;
        AppEngineWebXml.Resources resources = appEngineWebXml.getResources();
        Double cpu = this.getChildNodeDouble(settingsNode, "cpu");
        if (cpu != null) {
            resources.setCpu(cpu);
        }
        if ((memory_gb = this.getChildNodeDouble(settingsNode, "memory-gb")) != null) {
            resources.setMemoryGb(memory_gb);
        }
        if ((disk_size_gb = this.getChildNodePositiveInteger(settingsNode, "disk-size-gb")) != null) {
            resources.setDiskSizeGb(disk_size_gb);
        }
    }

    private void processNetworkNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        String sessionAffinity;
        String subnetworkName;
        AppEngineWebXml.Network network = appEngineWebXml.getNetwork();
        String instance_tag = this.trim(this.getChildNodeText(settingsNode, "instance-tag"));
        if (instance_tag != null && !instance_tag.isEmpty()) {
            network.setInstanceTag(instance_tag);
        }
        for (Element subNode : this.getNodeIterable(settingsNode, "forwarded-port")) {
            String forwardedPort = XmlUtils.getText(subNode);
            network.addForwardedPort(forwardedPort);
        }
        String name = this.trim(this.getChildNodeText(settingsNode, "name"));
        if (name != null && !name.isEmpty()) {
            network.setName(name);
        }
        if ((subnetworkName = this.trim(this.getChildNodeText(settingsNode, "subnetwork-name"))) != null && !subnetworkName.isEmpty()) {
            network.setSubnetworkName(subnetworkName);
        }
        if ((sessionAffinity = this.trim(this.getChildNodeText(settingsNode, "session-affinity"))) != null && !sessionAffinity.isEmpty()) {
            network.setSessionAffinity(this.toBoolean(sessionAffinity));
        }
    }

    private void processEnvironmentVariablesNode(Element node, AppEngineWebXml appEngineWebXml) {
        for (Element subNode : this.getNodeIterable(node, "env-var")) {
            String propertyName = this.trim(subNode.getAttribute("name"));
            String propertyValue = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addEnvironmentVariable(propertyName, propertyValue);
        }
    }

    private void processBuildEnvironmentVariablesNode(Element node, AppEngineWebXml appEngineWebXml) {
        for (Element subNode : this.getNodeIterable(node, "build-env-var")) {
            String propertyName = this.trim(subNode.getAttribute("name"));
            String propertyValue = this.trim(subNode.getAttribute("value"));
            appEngineWebXml.addBuildEnvironmentVariable(propertyName, propertyValue);
        }
    }

    private void processPermissionsNode(Element node, AppEngineWebXml appEngineWebXml) {
        for (Element subNode : this.getNodeIterable(node, "permission")) {
            String actions;
            String name;
            String className = this.trim(subNode.getAttribute("class"));
            if (className.equals("")) {
                className = null;
            }
            if ((name = this.trim(subNode.getAttribute("name"))).equals("")) {
                name = null;
            }
            if ((actions = this.trim(subNode.getAttribute("actions"))).equals("")) {
                actions = null;
            }
            appEngineWebXml.addUserPermission(className, name, actions);
        }
    }

    private void processInboundServicesNode(Element node, AppEngineWebXml appEngineWebXml) {
        for (Element subNode : this.getNodeIterable(node, "service")) {
            String service = XmlUtils.getText(subNode);
            appEngineWebXml.addInboundService(service);
        }
    }

    private void processAdminConsoleNode(Element node, AppEngineWebXml appEngineWebXml) {
        for (Element subNode : this.getNodeIterable(node, "page")) {
            String name = this.trim(subNode.getAttribute("name"));
            String url = this.trim(subNode.getAttribute("url"));
            appEngineWebXml.addAdminConsolePage(AppEngineWebXml.AdminConsolePage.of(name, url));
        }
    }

    private void processErrorHandlerNode(Element node, AppEngineWebXml appEngineWebXml) {
        for (Element subNode : this.getNodeIterable(node, "handler")) {
            String errorCode;
            String file = this.trim(subNode.getAttribute("file"));
            if (file.equals("")) {
                file = null;
            }
            if ((errorCode = this.trim(subNode.getAttribute("error-code"))).equals("")) {
                errorCode = null;
            }
            appEngineWebXml.addErrorHandler(AppEngineWebXml.ErrorHandler.of(file, errorCode));
        }
    }

    private void processApiConfigNode(Element node, AppEngineWebXml appEngineWebXml) {
        String servlet = this.trim(node.getAttribute("servlet-class"));
        String url = this.trim(node.getAttribute("url-pattern"));
        appEngineWebXml.setApiConfig(AppEngineWebXml.ApiConfig.of(servlet, url));
        for (Element subNode : this.getNodeIterable(node, "endpoint-servlet-mapping-id")) {
            String id = XmlUtils.getText(subNode);
            if (id.isEmpty()) continue;
            appEngineWebXml.addApiEndpoint(id);
        }
    }

    private void processClassLoaderConfig(Element node, AppEngineWebXml appEngineWebXml) {
        AppEngineWebXml.ClassLoaderConfig config = new AppEngineWebXml.ClassLoaderConfig();
        appEngineWebXml.setClassLoaderConfig(config);
        for (Element subNode : this.getNodeIterable(node, "priority-specifier")) {
            this.processClassPathPrioritySpecifier(subNode, config);
        }
    }

    private void processClassPathPrioritySpecifier(Element node, AppEngineWebXml.ClassLoaderConfig config) {
        AppEngineWebXml.PrioritySpecifierEntry entry = new AppEngineWebXml.PrioritySpecifierEntry();
        entry.setFilename(XmlUtils.getAttributeOrNull(node, "filename"));
        entry.setPriority(XmlUtils.getAttributeOrNull(node, "priority"));
        entry.checkClassLoaderConfig();
        config.add(entry);
    }

    private void processVpcAccessConnector(Element node, AppEngineWebXml appEngineWebXml) {
        String name = this.getChildNodeText(node, "name");
        if (name == null) {
            throw new AppEngineConfigException("The <vpc-access-connector> element should have a name sub element.");
        }
        AppEngineWebXml.VpcAccessConnector.Builder connectorBuilder = AppEngineWebXml.VpcAccessConnector.builderFor(name);
        String egressSetting = this.getChildNodeText(node, "egress-setting");
        if (egressSetting != null) {
            connectorBuilder.setEgressSetting(egressSetting);
        }
        appEngineWebXml.setVpcAccessConnector(connectorBuilder.build());
    }

    private void processStagingNode(Element settingsNode, AppEngineWebXml appEngineWebXml) {
        String compileEncoding;
        String deleteJsps;
        String enableJarClasses;
        String disableJarJsps;
        String jarSplittingExcludes;
        StagingOptions.Builder builder = StagingOptions.builder();
        String enableJarSplitting = this.getChildNodeText(settingsNode, "enable-jar-splitting");
        if (enableJarSplitting != null) {
            builder.setSplitJarFiles(Optional.of(this.toBoolean(enableJarSplitting)));
        }
        if ((jarSplittingExcludes = this.getChildNodeText(settingsNode, "jar-splitting-excludes")) != null) {
            ImmutableSortedSet jarSplittingExcludeSuffixes = ImmutableSortedSet.copyOf((Comparable[])jarSplittingExcludes.split(","));
            builder.setSplitJarFilesExcludes(Optional.of(jarSplittingExcludeSuffixes));
        }
        if ((disableJarJsps = this.getChildNodeText(settingsNode, "disable-jar-jsps")) != null) {
            builder.setJarJsps(Optional.of(!this.toBoolean(disableJarJsps)));
        }
        if ((enableJarClasses = this.getChildNodeText(settingsNode, "enable-jar-classes")) != null) {
            builder.setJarClasses(Optional.of(this.toBoolean(enableJarClasses)));
        }
        if ((deleteJsps = this.getChildNodeText(settingsNode, "delete-jsps")) != null) {
            builder.setDeleteJsps(Optional.of(this.toBoolean(deleteJsps)));
        }
        if ((compileEncoding = this.getChildNodeText(settingsNode, "compile-encoding")) != null) {
            builder.setCompileEncoding(Optional.of(compileEncoding));
        }
        appEngineWebXml.setStagingOptions(builder.build());
    }

    private void processUrlStreamHandler(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setUrlStreamHandlerType(XmlUtils.getText(node));
    }

    private boolean getBooleanValue(Element node) {
        return this.toBoolean(XmlUtils.getText(node));
    }

    private boolean getBooleanAttributeValue(Element node, String attribute) {
        return this.toBoolean(node.getAttribute(attribute));
    }

    private boolean toBoolean(String value) {
        return (value = value.trim()).equalsIgnoreCase("true") || value.equals("1");
    }

    private String trim(String attribute) {
        return attribute == null ? null : attribute.trim();
    }

    private void processUseGoogleConnectorJNode(Element node, AppEngineWebXml appEngineWebXml) {
        appEngineWebXml.setUseGoogleConnectorJ(this.getBooleanValue(node));
    }

    static enum FileType {
        STATIC,
        RESOURCE;

    }
}

