/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.esotericsoftware.yamlbeans;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.Beans;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.Version;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.emitter.EmitterConfig;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.scalar.DateSerializer;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class YamlConfig {
    public final WriteConfig writeConfig = new WriteConfig();
    public final ReadConfig readConfig = new ReadConfig();
    final Map<String, String> classNameToTag = new HashMap<String, String>();
    final Map<String, Class> tagToClass = new HashMap<String, Class>();
    final Map<Class, ScalarSerializer> scalarSerializers = new IdentityHashMap<Class, ScalarSerializer>();
    final Map<Beans.Property, Class> propertyToElementType = new HashMap<Beans.Property, Class>();
    final Map<Beans.Property, Class> propertyToDefaultType = new HashMap<Beans.Property, Class>();
    boolean beanProperties = true;
    boolean privateFields;
    boolean privateConstructors = true;
    boolean allowDuplicates = true;

    public YamlConfig() {
        this.scalarSerializers.put(Date.class, new DateSerializer());
        this.tagToClass.put("tag:yaml.org,2002:str", String.class);
        this.tagToClass.put("tag:yaml.org,2002:int", Integer.class);
        this.tagToClass.put("tag:yaml.org,2002:seq", ArrayList.class);
        this.tagToClass.put("tag:yaml.org,2002:map", HashMap.class);
        this.tagToClass.put("tag:yaml.org,2002:float", Float.class);
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public void setClassTag(String tag, Class type) {
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.classNameToTag.put(type.getName(), tag);
        this.tagToClass.put(tag, type);
    }

    public void setScalarSerializer(Class type, ScalarSerializer serializer) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.scalarSerializers.put(type, serializer);
    }

    public void setPropertyElementType(Class type, String propertyName, Class elementType) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName cannot be null.");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("propertyType cannot be null.");
        }
        Beans.Property property = Beans.getProperty(type, propertyName, this.beanProperties, this.privateFields, this);
        if (property == null) {
            throw new IllegalArgumentException("The class " + type.getName() + " does not have a property named: " + propertyName);
        }
        if (!Collection.class.isAssignableFrom(property.getType()) && !Map.class.isAssignableFrom(property.getType())) {
            throw new IllegalArgumentException("The '" + propertyName + "' property on the " + type.getName() + " class must be a Collection or Map: " + property.getType());
        }
        this.propertyToElementType.put(property, elementType);
    }

    public void setPropertyDefaultType(Class type, String propertyName, Class defaultType) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName cannot be null.");
        }
        if (defaultType == null) {
            throw new IllegalArgumentException("defaultType cannot be null.");
        }
        Beans.Property property = Beans.getProperty(type, propertyName, this.beanProperties, this.privateFields, this);
        if (property == null) {
            throw new IllegalArgumentException("The class " + type.getName() + " does not have a property named: " + propertyName);
        }
        this.propertyToDefaultType.put(property, defaultType);
    }

    public void setBeanProperties(boolean beanProperties) {
        this.beanProperties = beanProperties;
    }

    public void setPrivateFields(boolean privateFields) {
        this.privateFields = privateFields;
    }

    public void setPrivateConstructors(boolean privateConstructors) {
        this.privateConstructors = privateConstructors;
    }

    public static enum WriteClassName {
        ALWAYS,
        NEVER,
        AUTO;

    }

    static class ConstructorParameters {
        public Constructor constructor;
        public String[] parameterNames;

        ConstructorParameters() {
        }
    }

    public static class ReadConfig {
        Version defaultVersion = new Version(1, 1);
        ClassLoader classLoader;
        final Map<Class, ConstructorParameters> constructorParameters = new IdentityHashMap<Class, ConstructorParameters>();
        boolean ignoreUnknownProperties;

        ReadConfig() {
        }

        public void setDefaultVersion(Version defaultVersion) {
            if (defaultVersion == null) {
                throw new IllegalArgumentException("defaultVersion cannot be null.");
            }
            this.defaultVersion = defaultVersion;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void setConstructorParameters(Class type, Class[] parameterTypes, String[] parameterNames) {
            if (type == null) {
                throw new IllegalArgumentException("type cannot be null.");
            }
            if (parameterTypes == null) {
                throw new IllegalArgumentException("parameterTypes cannot be null.");
            }
            if (parameterNames == null) {
                throw new IllegalArgumentException("parameterNames cannot be null.");
            }
            ConstructorParameters parameters = new ConstructorParameters();
            try {
                parameters.constructor = type.getConstructor(parameterTypes);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to find constructor: " + type.getName() + "(" + Arrays.toString(parameterTypes) + ")", ex);
            }
            parameters.parameterNames = parameterNames;
            this.constructorParameters.put(type, parameters);
        }

        public void setIgnoreUnknownProperties(boolean allowUnknownProperties) {
            this.ignoreUnknownProperties = allowUnknownProperties;
        }
    }

    public static class WriteConfig {
        boolean explicitFirstDocument = false;
        boolean explicitEndDocument = false;
        boolean writeDefaultValues = false;
        boolean writeRootTags = true;
        boolean writeRootElementTags = true;
        boolean autoAnchor = true;
        boolean keepBeanPropertyOrder = false;
        WriteClassName writeClassName = WriteClassName.AUTO;
        EmitterConfig emitterConfig = new EmitterConfig();

        WriteConfig() {
            this.emitterConfig.setUseVerbatimTags(false);
        }

        public void setExplicitFirstDocument(boolean explicitFirstDocument) {
            this.explicitFirstDocument = explicitFirstDocument;
        }

        public void setExplicitEndDocument(boolean explicitEndDocument) {
            this.explicitEndDocument = explicitEndDocument;
        }

        public void setWriteRootTags(boolean writeRootTags) {
            this.writeRootTags = writeRootTags;
        }

        public void setWriteRootElementTags(boolean writeRootElementTags) {
            this.writeRootElementTags = writeRootElementTags;
        }

        public void setWriteDefaultValues(boolean writeDefaultValues) {
            this.writeDefaultValues = writeDefaultValues;
        }

        public void setAutoAnchor(boolean autoAnchor) {
            this.autoAnchor = autoAnchor;
        }

        public void setKeepBeanPropertyOrder(boolean keepBeanPropertyOrder) {
            this.keepBeanPropertyOrder = keepBeanPropertyOrder;
        }

        public void setVersion(Version version) {
            this.emitterConfig.setVersion(version);
        }

        public void setCanonical(boolean canonical) {
            this.emitterConfig.setCanonical(canonical);
        }

        public void setIndentSize(int indentSize) {
            this.emitterConfig.setIndentSize(indentSize);
        }

        public void setWrapColumn(int wrapColumn) {
            this.emitterConfig.setWrapColumn(wrapColumn);
        }

        public void setUseVerbatimTags(boolean useVerbatimTags) {
            this.emitterConfig.setUseVerbatimTags(useVerbatimTags);
        }

        public void setEscapeUnicode(boolean escapeUnicode) {
            this.emitterConfig.setEscapeUnicode(escapeUnicode);
        }

        public void setWriteClassname(WriteClassName write) {
            this.writeClassName = write;
        }
    }
}

