/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerFactory;
import com.google.appengine.tools.development.testing.DevAppServerTestConfig;
import com.google.appengine.tools.info.AppengineSdk;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class DevAppServerTestHelper {
    private static final String SDK_ROOT_PROP = "appengine.sdk.root";
    private static final String USER_CODE_CLASSPATH_MANAGER_PROP = "devappserver.userCodeClasspathManager";
    private static final String USER_CODE_CLASSPATH = "devappserver.userCodeClasspathManager.classpath";
    private static final String USER_CODE_REQUIRES_WEB_INF = "devappserver.userCodeClasspathManager.requiresWebInf";
    static DevAppServer server;
    static String originalSdkRoot;
    static boolean running;

    DevAppServerTestHelper() {
    }

    public static DevAppServer startServer(DevAppServerTestConfig testConfig) {
        if (running) {
            throw new IllegalStateException("Dev Appserver is already running.");
        }
        originalSdkRoot = System.getProperty(SDK_ROOT_PROP);
        System.setProperty(SDK_ROOT_PROP, testConfig.getSdkRoot().getAbsolutePath());
        String address = "localhost";
        AppengineSdk sdk = AppengineSdk.getSdk();
        AppengineSdk.includeTestingJarOnSharedPath((boolean)true);
        Map<String, Object> containerConfigProps = DevAppServerTestHelper.newContainerConfigPropertiesForTest(testConfig.getClasspath());
        server = new DevAppServerFactory().createDevAppServer(testConfig.getAppDir(), testConfig.getWebXml(), testConfig.getAppEngineWebXml(), address, 0, true, testConfig.installSecurityManager(), containerConfigProps, false);
        try {
            server.start();
            System.setProperty(testConfig.getPortSystemProperty(), Integer.toString(server.getPort()));
            running = true;
            DevAppServer devAppServer = server;
            return devAppServer;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (!running) {
                server = null;
                AppengineSdk.includeTestingJarOnSharedPath((boolean)false);
            }
        }
    }

    public static void stopServer() {
        AppengineSdk.getSdk();
        AppengineSdk.includeTestingJarOnSharedPath((boolean)false);
        running = false;
        if (server != null) {
            try {
                server.shutdown();
                server = null;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        if (originalSdkRoot == null) {
            System.clearProperty(SDK_ROOT_PROP);
        } else {
            System.setProperty(SDK_ROOT_PROP, originalSdkRoot);
        }
    }

    private static Map<String, Object> newContainerConfigPropertiesForTest(Collection<URL> classpath) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(USER_CODE_CLASSPATH, classpath);
        props.put(USER_CODE_REQUIRES_WEB_INF, false);
        HashMap<String, HashMap<String, Object>> userProps = new HashMap<String, HashMap<String, Object>>();
        userProps.put(USER_CODE_CLASSPATH_MANAGER_PROP, props);
        return Collections.unmodifiableMap(userProps);
    }

    static {
        running = false;
    }
}

