/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing.ee10;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.LinkedListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ListMultimap;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class FakeHttpServletResponse
implements HttpServletResponse {
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private final ListMultimap<String, String> headers = LinkedListMultimap.create();
    private String characterEncoding;
    private ByteArrayOutputStream actualBody;
    private int status = 200;
    private boolean committed;
    private ServletOutputStream outputStream;
    private PrintWriter writer;
    protected HttpServletRequest request = null;

    public FakeHttpServletResponse() {
        this(null);
    }

    public FakeHttpServletResponse(HttpServletRequest request) {
        this.request = request;
    }

    public synchronized void flushBuffer() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
        if (this.writer != null) {
            this.writer.flush();
        }
        this.committed = true;
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        List types = this.headers.get((Object)"Content-Type");
        if (types.isEmpty()) {
            return null;
        }
        return (String)types.get(0);
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public synchronized ServletOutputStream getOutputStream() {
        this.checkCommit();
        Preconditions.checkState((this.writer == null ? 1 : 0) != 0, (Object)"getWriter() already called");
        if (this.outputStream == null) {
            this.actualBody = new ByteArrayOutputStream();
            this.outputStream = new FakeServletOutputStream(this.actualBody);
        }
        return this.outputStream;
    }

    public synchronized String getOutputString() {
        if (this.outputStream == null) {
            return null;
        }
        try {
            this.actualBody.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.characterEncoding == null) {
            return this.actualBody.toString();
        }
        try {
            return this.actualBody.toString(this.characterEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized byte[] getOutputBytes() {
        if (this.outputStream == null) {
            return null;
        }
        try {
            this.actualBody.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.actualBody.toByteArray();
    }

    public synchronized PrintWriter getWriter() throws UnsupportedEncodingException {
        this.checkCommit();
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream() has been called before");
        }
        if (this.getCharacterEncoding() == null) {
            throw new UnsupportedEncodingException("charset not found");
        }
        if (this.writer == null) {
            this.actualBody = new ByteArrayOutputStream();
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.outputStream, this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public synchronized boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void resetBuffer() {
        throw new UnsupportedOperationException();
    }

    public void setBufferSize(int sz) {
        throw new UnsupportedOperationException();
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = DEFAULT_CHARSET;
        if (encoding != null && encoding.length() > 0) {
            this.characterEncoding = encoding;
        }
    }

    public void setContentLength(int length) {
        this.headers.removeAll((Object)"Content-Length");
        this.headers.put((Object)"Content-Length", (Object)Integer.toString(length));
    }

    public void setContentLengthLong(long l) {
        this.headers.removeAll((Object)"Content-Length");
        this.headers.put((Object)"Content-Length", (Object)Long.toString(l));
    }

    public void setContentType(String type) {
        this.headers.removeAll((Object)"Content-Type");
        this.headers.put((Object)"Content-Type", (Object)type);
        String encoding = FakeHttpServletResponse.getCharSet(type);
        if (encoding != null) {
            this.setCharacterEncoding(encoding);
        }
    }

    private static String getCharSet(String contentType) {
        int index = contentType.indexOf("charset");
        if (index < 0) {
            return null;
        }
        String charset = contentType.substring(index + "charset=".length()).trim();
        if (charset.startsWith("\"") && charset.endsWith("\"")) {
            charset = charset.substring(1, charset.length() - 1);
        }
        return charset;
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException();
    }

    public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, String.valueOf(value));
    }

    public void addHeader(String name, String value) {
        this.headers.put((Object)name, (Object)value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.put((Object)name, (Object)Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        return !this.headers.get((Object)name).isEmpty();
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeURL(String url) {
        if (this.request != null && this.request.getSession(false) != null && url != null) {
            url = url.contains("?") ? url + "&" : url + "?";
            url = url + "gsessionid=" + this.request.getSession().getId();
        }
        return url;
    }

    public synchronized void sendError(int sc) {
        this.status = sc;
        this.committed = true;
    }

    public synchronized void sendError(int sc, String msg) {
        this.status = sc;
        this.committed = true;
    }

    public synchronized void sendRedirect(String location) {
        if (this.request != null) {
            try {
                URL url = new URL(new URL(this.request.getRequestURL().toString()), location);
                location = url.toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        this.status = 302;
        this.setHeader("Location", location);
        this.committed = true;
    }

    public void setDateHeader(String name, long value) {
        this.setHeader(name, Long.toString(value));
    }

    public void setHeader(String name, String value) {
        this.headers.removeAll((Object)name);
        this.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.removeAll((Object)name);
        this.addIntHeader(name, value);
    }

    public synchronized void setStatus(int sc) {
        this.status = sc;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public String getHeader(String name) {
        return (String)Iterables.getFirst((Iterable)this.headers.get((Object)((String)Preconditions.checkNotNull((Object)name))), null);
    }

    public Collection<String> getHeaders(String s) {
        return this.headers.get((Object)((String)Preconditions.checkNotNull((Object)s)));
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keys();
    }

    private void checkCommit() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response is already committed");
        }
    }

    private static class FakeServletOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream byteStream;
        private long count;

        FakeServletOutputStream(ByteArrayOutputStream byteStream) {
            this.byteStream = byteStream;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.byteStream.write(b, off, len);
            this.count += (long)len;
        }

        public void write(byte[] b) throws IOException {
            this.byteStream.write(b);
            this.count += (long)b.length;
        }

        public void write(int b) throws IOException {
            this.byteStream.write(b);
            ++this.count;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public boolean isReady() {
            return true;
        }

        long getCount() {
            return this.count;
        }
    }
}

