/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.testing.DevAppServerTest;
import com.google.appengine.tools.development.testing.DevAppServerTestConfig;
import com.google.appengine.tools.development.testing.DevAppServerTestHelper;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class DevAppServerTestRunner
extends BlockJUnit4ClassRunner {
    public DevAppServerTestRunner(Class<?> klass) throws InitializationError {
        super(DevAppServerTestRunner.startServerAndIsolateClass(klass));
    }

    private static Class<?> startServerAndIsolateClass(Class<?> klass) throws InitializationError {
        DevAppServerTest testAnno = klass.getAnnotation(DevAppServerTest.class);
        if (testAnno == null) {
            throw new InitializationError(String.format("Test uses %s but is not also annotated with %s.", DevAppServerTestRunner.class.getSimpleName(), DevAppServerTest.class.getSimpleName()));
        }
        try {
            DevAppServerTestConfig config = testAnno.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DevAppServer devServer = DevAppServerTestHelper.startServer(config);
            return devServer.getAppContext().getClassLoader().loadClass(klass.getName());
        }
        catch (ReflectiveOperationException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        try {
            this.rewriteAnnotationMap("methodsForAnnotations");
            this.rewriteAnnotationMap("fieldsForAnnotations");
            super.collectInitializationErrors(errors);
        }
        catch (InitializationError initializationError) {
            errors.add(initializationError);
        }
    }

    private void rewriteAnnotationMap(String mapFieldName) throws InitializationError {
        try {
            Field annotationMapField = this.getTestClass().getClass().getDeclaredField(mapFieldName);
            annotationMapField.setAccessible(true);
            Map annotationMap = (Map)annotationMapField.get(this.getTestClass());
            HashMap copy = new HashMap(annotationMap);
            ClassLoader junitClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
            for (Map.Entry entry : annotationMap.entrySet()) {
                copy.put(junitClassLoader.loadClass(((Class)entry.getKey()).getName()), (List)entry.getValue());
            }
            annotationMapField.set(this.getTestClass(), Collections.unmodifiableMap(copy));
        }
        catch (ReflectiveOperationException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected Statement withAfterClasses(Statement statement) {
        final Statement statementWithAfter = super.withAfterClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable exception = null;
                try {
                    statementWithAfter.evaluate();
                }
                catch (Throwable e) {
                    exception = e;
                }
                finally {
                    block13: {
                        try {
                            DevAppServerTestHelper.stopServer();
                        }
                        catch (Throwable e) {
                            if (exception != null) break block13;
                            exception = e;
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        };
    }
}

