/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.LinkedListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class FakeHttpServletRequest
implements HttpServletRequest {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 443;
    private static final String COOKIE_HEADER = "Cookie";
    private static final String HOST_HEADER = "Host";
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private final Map<String, Object> attributes = Maps.newConcurrentMap();
    private final Map<String, String> headers = Maps.newHashMap();
    private final ListMultimap<String, String> parameters = LinkedListMultimap.create();
    private final Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
    private String hostName = "localhost";
    private int port = 443;
    private String contextPath = "";
    private String servletPath = "";
    private String pathInfo;
    private String method;
    protected String contentType;
    protected byte[] bodyData = new byte[0];
    protected String characterEncoding;
    protected boolean getReaderCalled = false;
    protected boolean getInputStreamCalled = false;
    static final String METHOD_POST = "POST";
    static final String METHOD_PUT = "PUT";
    private static final Function<Collection<String>, String[]> STRING_COLLECTION_TO_ARRAY = new Function<Collection<String>, String[]>(){

        public String[] apply(Collection<String> values) {
            return values.toArray(new String[0]);
        }
    };

    public FakeHttpServletRequest() {
        this(DEFAULT_HOST, 443);
    }

    public FakeHttpServletRequest(String hostName, int port) {
        this.constructor(hostName, port, "", "", null);
    }

    public FakeHttpServletRequest(String urlStr) {
        String servletPath;
        String contextPath;
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String path = url.getPath();
        if (path.length() <= 1) {
            contextPath = path;
            servletPath = null;
        } else {
            int secondSlash = path.indexOf("/", 1);
            if (secondSlash < 0) {
                contextPath = path;
                servletPath = null;
            } else {
                contextPath = path.substring(0, secondSlash);
                servletPath = path.substring(secondSlash);
            }
        }
        int port = url.getPort();
        this.constructor(url.getHost(), port, contextPath, servletPath, url.getQuery());
    }

    protected void constructor(String host, int port, String contextPath, String servletPath, String queryString) {
        this.setHeader(HOST_HEADER, host);
        this.setPort(port);
        this.setContextPath(contextPath);
        this.setSerletPath(servletPath);
        this.setParametersFromQueryString(queryString);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public int getContentLength() {
        return -1;
    }

    public long getContentLengthLong() {
        return -1L;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() {
        if (this.getReaderCalled) {
            throw new IllegalStateException("getInputStream() called after getReader()");
        }
        this.getInputStreamCalled = true;
        final ByteArrayInputStream in = new ByteArrayInputStream(this.bodyData);
        return new ServletInputStream(){

            public int read() throws IOException {
                return in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return in.read(b, off, len);
            }

            public void close() throws IOException {
                in.close();
            }

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getLocalAddr() {
        return "1.2.3.4";
    }

    public String getLocalName() {
        return DEFAULT_HOST;
    }

    public int getLocalPort() {
        return this.port;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Collections.singleton(Locale.US));
    }

    public String getParameter(String name) {
        return (String)Iterables.getFirst((Iterable)this.parameters.get((Object)name), null);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(Maps.transformValues((Map)this.parameters.asMap(), STRING_COLLECTION_TO_ARRAY));
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return (String[])STRING_COLLECTION_TO_ARRAY.apply((Object)this.parameters.get((Object)name));
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public BufferedReader getReader() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return "5.6.7.8";
    }

    public String getRemoteHost() {
        return "remotehost";
    }

    public int getRemotePort() {
        return 1234;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return this.port == 443 ? "https" : "http";
    }

    public String getServerName() {
        return this.hostName;
    }

    public int getServerPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.port == 443;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setCharacterEncoding(String env) {
        throw new UnsupportedOperationException();
    }

    public String getAuthType() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return format.parse(value).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse number from header " + name + ":" + value, e);
        }
    }

    public String getHeader(String name) {
        return this.headers.get(Ascii.toLowerCase((String)name));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (!Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)entry.getKey())) continue;
            values.add(entry.getValue());
        }
        return Collections.enumeration(values);
    }

    public int getIntHeader(String name) {
        return Integer.parseInt(this.getHeader(name));
    }

    public String getMethod() {
        if (this.method == null) {
            return "GET";
        }
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo;
    }

    public String getQueryString() {
        if (this.parameters.isEmpty() || !this.getMethod().equals("GET")) {
            return null;
        }
        return FakeHttpServletRequest.paramsToString(this.parameters);
    }

    public String getRemoteUser() {
        return null;
    }

    public String getRequestURI() {
        return this.contextPath + this.servletPath + (this.pathInfo == null ? "" : this.pathInfo);
    }

    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        sb.append(":");
        sb.append(this.getServerPort());
        sb.append(this.contextPath);
        sb.append(this.servletPath);
        if (this.pathInfo != null) {
            sb.append(this.pathInfo);
        }
        return sb;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException();
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String s, String s1) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public Part getPart(String s) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    private static String paramsToString(ListMultimap<String, String> params) {
        try {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry e : params.entries()) {
                if (!first) {
                    sb.append('&');
                } else {
                    first = false;
                }
                sb.append(URLEncoder.encode((String)e.getKey(), StandardCharsets.UTF_8.name()));
                if ("".equals(e.getValue())) continue;
                sb.append('=').append(URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8.name()));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setParametersFromQueryString(String qs) {
        this.parameters.clear();
        if (qs != null) {
            for (String entry : Splitter.on((char)'&').split((CharSequence)qs)) {
                ImmutableList kv = ImmutableList.copyOf((Iterable)Splitter.on((char)'=').limit(2).split((CharSequence)entry));
                try {
                    this.parameters.put((Object)URLDecoder.decode((String)kv.get(0), StandardCharsets.UTF_8.name()), (Object)(kv.size() == 2 ? URLDecoder.decode((String)kv.get(1), StandardCharsets.UTF_8.name()) : ""));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHeader(String name, String value) {
        if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)COOKIE_HEADER)) {
            for (String pair : Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)value)) {
                int equalsPos = pair.indexOf(61);
                if (equalsPos == -1) continue;
                String cookieName = pair.substring(0, equalsPos);
                String cookieValue = pair.substring(equalsPos + 1);
                this.addToCookieMap(new Cookie(cookieName, cookieValue));
            }
            this.setCookieHeader();
            return;
        }
        this.addToHeaderMap(name, value);
        if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)HOST_HEADER)) {
            this.hostName = value;
        }
    }

    private void addToHeaderMap(String name, String value) {
        this.headers.put(Ascii.toLowerCase((String)name), value);
    }

    public void setCookies(Cookie ... cookies) {
        for (Cookie cookie : cookies) {
            this.addToCookieMap(cookie);
        }
        this.setCookieHeader();
    }

    public void setCookie(Cookie c) {
        this.addToCookieMap(c);
        this.setCookieHeader();
    }

    private void addToCookieMap(Cookie c) {
        this.cookies.put(c.getName(), c);
    }

    private void setCookieHeader() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Cookie c : this.cookies.values()) {
            if (!isFirst) {
                sb.append("; ");
            }
            sb.append(c.getName());
            sb.append("=");
            sb.append(c.getValue());
            isFirst = false;
        }
        this.addToHeaderMap(COOKIE_HEADER, sb.toString());
    }

    public void addParameter(String key, String value) {
        this.parameters.put((Object)key, (Object)value);
    }

    public void setMethod(String name) {
        this.method = name;
    }

    void setSerletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    void setPathInfo(String pathInfo) {
        this.pathInfo = "".equals(pathInfo) ? null : pathInfo;
    }

    public void setPostData(String postString, Charset encoding) throws UnsupportedEncodingException {
        this.setPostData(postString, encoding.name());
    }

    public void setPostData(String postString, String encoding) throws UnsupportedEncodingException {
        this.setPostData(postString.getBytes(encoding));
        this.characterEncoding = encoding;
    }

    public void setPostData(byte[] data) {
        this.bodyData = data;
        this.characterEncoding = null;
        this.setMethod(METHOD_POST);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

