/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.modules.dev.LocalModulesService;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.ModulesController;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.apphosting.api.ApiProxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class LocalModulesServiceTestConfig
implements LocalServiceTestConfig {
    private static final String INSTANCE_ID_ENV_ATTRIBUTE = "com.google.appengine.instance.id";
    public static final String DEFAULT_MODULE_NAME = "default";
    static final String DEFAULT_VERSION = "1";
    private static final Logger logger = Logger.getLogger(LocalModulesServiceTestConfig.class.getName());
    static final int MAIN_INSTANCE = -1;
    static final int DYNAMIC_INSTANCE_COUNT = -1;
    private TestModulesController testModulesController;
    private final Map<ModuleVersionKey, ModuleVersion> moduleVersionMap = new LinkedHashMap<ModuleVersionKey, ModuleVersion>();

    @Override
    public synchronized void setUp() {
        this.createModulesController(this.moduleVersionMap.isEmpty() ? this.generateModuleVersions() : this.moduleVersionMap.values());
        LocalModulesService localModulesService = LocalModulesServiceTestConfig.getLocalModulesService();
        localModulesService.setModulesController((ModulesController)this.testModulesController);
    }

    @Override
    public void tearDown() {
    }

    public LocalModulesServiceTestConfig addAutomaticScalingModuleVersion(String module, String version) {
        ModuleVersion moduleVersion = new ModuleVersion(module, version, ScalingType.AUTOMATIC, -1);
        this.addModuleVersion(moduleVersion);
        return this;
    }

    public LocalModulesServiceTestConfig addManualScalingModuleVersion(String module, String version, int numInstances) {
        this.validateInstances(numInstances);
        ModuleVersion moduleVersion = new ModuleVersion(module, version, ScalingType.MANUAL, numInstances);
        this.addModuleVersion(moduleVersion);
        return this;
    }

    public LocalModulesServiceTestConfig addBasicScalingModuleVersion(String module, String version, int numInstances) {
        this.validateInstances(numInstances);
        ModuleVersion moduleVersion = new ModuleVersion(module, version, ScalingType.BASIC, numInstances);
        this.addModuleVersion(moduleVersion);
        return this;
    }

    private void validateInstances(int numInstances) {
        if (numInstances <= 0) {
            throw new IllegalArgumentException("instanceCount " + numInstances + " <= 0");
        }
    }

    public LocalModulesServiceTestConfig addDefaultModuleVersion() {
        ModuleVersion moduleVersion = new ModuleVersion(DEFAULT_MODULE_NAME, DEFAULT_VERSION, ScalingType.AUTOMATIC, -1);
        this.addModuleVersion(moduleVersion);
        return this;
    }

    public synchronized void clearModuleVersions() {
        this.moduleVersionMap.clear();
    }

    private Iterable<ModuleVersion> generateModuleVersions() {
        String envModuleId = ApiProxy.getCurrentEnvironment().getModuleId();
        String envVersionId = LocalModulesServiceTestConfig.stripMinorVersion(ApiProxy.getCurrentEnvironment().getVersionId());
        String envInstance = (String)ApiProxy.getCurrentEnvironment().getAttributes().get(INSTANCE_ID_ENV_ATTRIBUTE);
        ImmutableList.Builder versionsBuilder = ImmutableList.builder();
        if (!DEFAULT_MODULE_NAME.equals(envModuleId)) {
            versionsBuilder.add((Object)this.generateModuleVersion(DEFAULT_MODULE_NAME, "1.0", null));
        }
        versionsBuilder.add((Object)this.generateModuleVersion(envModuleId, envVersionId, envInstance));
        return versionsBuilder.build();
    }

    private ModuleVersion generateModuleVersion(String module, String version, String instance) {
        if (instance == null) {
            return new ModuleVersion(module, version, ScalingType.AUTOMATIC, -1);
        }
        return new ModuleVersion(module, version, ScalingType.MANUAL, Integer.parseInt(instance) + 1);
    }

    private synchronized void addModuleVersion(ModuleVersion moduleVersion) {
        Preconditions.checkArgument((!this.moduleVersionMap.containsKey(moduleVersion.getKey()) ? 1 : 0) != 0, (Object)String.format("Module version module %s version %s is already defined: %s", moduleVersion.getModule(), moduleVersion.getVersion(), this.moduleVersionMap.values()));
        this.moduleVersionMap.put(moduleVersion.getKey(), moduleVersion);
    }

    public static LocalModulesService getLocalModulesService() {
        return (LocalModulesService)LocalServiceTestHelper.getLocalService("modules");
    }

    void verifyEnvironment(String module, String version, int instance) {
        version = LocalModulesServiceTestConfig.stripMinorVersion(version);
        this.testModulesController.verifyEnvironment(module, version, instance);
    }

    synchronized boolean requiresEnvironmentInstance(String module, String version) {
        ModuleVersion moduleVersion = this.moduleVersionMap.get(new ModuleVersionKey(module, version));
        return moduleVersion != null && moduleVersion.getInitialNumInstances() != -1;
    }

    private void createModulesController(Iterable<ModuleVersion> moduleVersions) {
        HashMap<String, String> defaultVersions = new HashMap<String, String>();
        ImmutableList.Builder modulesListBuilder = ImmutableList.builder();
        ImmutableListMultimap.Builder versionMapBuilder = ImmutableListMultimap.builder();
        ImmutableMap.Builder moduleVersionStateMapBuilder = ImmutableMap.builder();
        for (ModuleVersion moduleVersion : moduleVersions) {
            if (!defaultVersions.containsKey(moduleVersion.getModule())) {
                defaultVersions.put(moduleVersion.getModule(), moduleVersion.getVersion());
                modulesListBuilder.add((Object)moduleVersion.getModule());
            }
            moduleVersionStateMapBuilder.put((Object)moduleVersion.getKey(), (Object)moduleVersion.getScalingType().getModuleVersionState(moduleVersion));
            versionMapBuilder.put((Object)moduleVersion.getModule(), (Object)moduleVersion.getVersion());
        }
        Preconditions.checkArgument((boolean)defaultVersions.containsKey(DEFAULT_MODULE_NAME), (Object)("No version of the default module is configured: moduleVersions=" + String.valueOf(moduleVersions)));
        ImmutableMap.Builder defaultVersionsBuilder = ImmutableMap.builder();
        defaultVersionsBuilder.putAll(defaultVersions);
        this.testModulesController = new TestModulesController((ImmutableMap<ModuleVersionKey, AbstractModuleVersionState>)moduleVersionStateMapBuilder.buildOrThrow(), (ImmutableList<String>)modulesListBuilder.build(), (ImmutableMap<String, Collection<String>>)versionMapBuilder.build().asMap(), (ImmutableMap<String, String>)defaultVersionsBuilder.buildOrThrow());
    }

    private static String stripMinorVersion(String version) {
        return (String)Splitter.on((char)'.').split((CharSequence)version).iterator().next();
    }

    private static class TestModulesController
    implements ModulesController {
        private final ImmutableMap<ModuleVersionKey, AbstractModuleVersionState> moduleVersionStateMap;
        private final ImmutableList<String> modules;
        private final ImmutableMap<String, Collection<String>> versions;
        private final ImmutableMap<String, String> defaultVersions;

        TestModulesController(ImmutableMap<ModuleVersionKey, AbstractModuleVersionState> moduleVersionStateMap, ImmutableList<String> modules, ImmutableMap<String, Collection<String>> versions, ImmutableMap<String, String> defaultVersions) {
            this.moduleVersionStateMap = (ImmutableMap)Preconditions.checkNotNull(moduleVersionStateMap);
            this.modules = (ImmutableList)Preconditions.checkNotNull(modules);
            this.versions = (ImmutableMap)Preconditions.checkNotNull(versions);
            this.defaultVersions = (ImmutableMap)Preconditions.checkNotNull(defaultVersions);
        }

        public Iterable<String> getModuleNames() {
            return this.modules;
        }

        public Iterable<String> getVersions(String moduleName) throws ApiProxy.ApplicationException {
            if (this.versions.containsKey((Object)moduleName)) {
                return (Iterable)this.versions.get((Object)moduleName);
            }
            logger.info("Operation getVersions failed because module=" + moduleName + " is not defined.");
            throw new ApiProxy.ApplicationException(1, "The specified module does not exist.");
        }

        public String getDefaultVersion(String moduleName) throws ApiProxy.ApplicationException {
            if (this.defaultVersions.containsKey((Object)moduleName)) {
                return (String)this.defaultVersions.get((Object)moduleName);
            }
            logger.info("Operation getDefaultVersion failed because module=" + moduleName + " is not defined.");
            throw new ApiProxy.ApplicationException(1, "Invalid module name.");
        }

        public int getNumInstances(String moduleName, String version) throws ApiProxy.ApplicationException {
            AbstractModuleVersionState moduleVersionState = this.getModuleVersionState("getNumInstances", moduleName, version);
            return moduleVersionState.getNumInstances();
        }

        public void setNumInstances(String moduleName, String version, int numInstances) throws ApiProxy.ApplicationException {
            AbstractModuleVersionState moduleVersionState = this.getModuleVersionState("setNumInstances", moduleName, version);
            moduleVersionState.setNumInstances(numInstances);
        }

        public String getHostname(String moduleName, String version, int instance) throws ApiProxy.ApplicationException {
            String operation;
            String string = operation = instance == -1 ? "getHostName" : "getInstanceHostname";
            if (!this.versions.containsKey((Object)moduleName)) {
                logger.warning("Operation " + operation + " could not find the requested module  Module " + moduleName);
                throw new ApiProxy.ApplicationException(1, "The specified module does not exist.");
            }
            StringBuilder sb = new StringBuilder();
            if (instance != -1) {
                AbstractModuleVersionState moduleVersionState = this.getModuleVersionState(operation, moduleName, version);
                sb.append(moduleVersionState.getInstanceDot(instance));
            }
            sb.append(version);
            sb.append(".");
            sb.append(moduleName);
            sb.append(".");
            sb.append(ApiProxy.getCurrentEnvironment().getAppId());
            sb.append(".");
            sb.append(LocalModulesServiceTestConfig.getLocalModulesService().getServerHostname());
            return sb.toString();
        }

        public void startModule(String moduleName, String version) throws ApiProxy.ApplicationException {
            Preconditions.checkNotNull((Object)moduleName);
            Preconditions.checkNotNull((Object)version);
            AbstractModuleVersionState moduleVersionState = this.getModuleVersionState("startVersion", moduleName, version);
            moduleVersionState.start();
        }

        public void stopModule(String moduleName, String version) throws ApiProxy.ApplicationException {
            AbstractModuleVersionState moduleVersionState = this.getModuleVersionState("stopVersion", moduleName, version);
            moduleVersionState.stop();
        }

        public String getScalingType(String moduleName) throws ApiProxy.ApplicationException {
            throw new UnsupportedOperationException();
        }

        public ModulesController.ModuleState getModuleState(String moduleName) throws ApiProxy.ApplicationException {
            throw new UnsupportedOperationException();
        }

        private AbstractModuleVersionState getModuleVersionState(String operation, String module, String version) {
            AbstractModuleVersionState moduleVersionState = (AbstractModuleVersionState)this.moduleVersionStateMap.get((Object)new ModuleVersionKey(module, version));
            if (moduleVersionState == null) {
                logger.warning("Operation " + operation + " could not find the requested module version  Module " + module + " version " + version);
                throw new ApiProxy.ApplicationException(2, "Could not find the given version.");
            }
            return moduleVersionState;
        }

        private void verifyEnvironment(String module, String version, int instance) {
            AbstractModuleVersionState moduleVersionState = (AbstractModuleVersionState)this.moduleVersionStateMap.get((Object)new ModuleVersionKey(module, version));
            if (moduleVersionState == null) {
                throw new IllegalStateException("The LocalServiceTestHelper Environment module = '" + module + "' version = '" + version + "' specifies a module version that has not been configured, either add the needed module version (with one of LocalModulesServiceTestConfig.addDefaultModuleVersion, LocalModulesServiceTestConfig.addAutomaticScalingModuleeVersion, LocalModulesServiceTestConfig.addBasicScalingModuleVersion, or LocalModulesServiceTestConfig.addManualScalingModuleVersion) or correct the Environment (with LocalServiceTestHelper.setEnvModuleId and LocalServiceTestHelper.setEnvVersionId)");
            }
            if (instance != -1) {
                if (moduleVersionState.getModuleVersion().getInitialNumInstances() == -1) {
                    throw new IllegalStateException("The requested module version module = '" + module + "' version = '" + version + "' does not support instances but the LocalServiceTestHelper environment has instances set. You can correct this issue by providing a matching manually scaling or basic scaling module version to LocalModulesServiceTestConfig.setVersions or by calling LocalServiceTestHelper.setEnvModuleInstance with com.google.appengine.tools.development.LocalEnvironment.MAIN_INSTANCE (-1) which is the default value");
                }
                if (instance >= moduleVersionState.getNumInstancesInternal()) {
                    throw new IllegalStateException("The requested module version module = '" + module + "' version = '" + version + "' has only " + moduleVersionState.getNumInstancesInternal() + " instances and the LocalServiceTestHelper environment has envInstance set to " + instance + " which is too big. You can correct this issue by defining more instances for the module version with LocalModulesServiceTestConfig.setVersions or by calling LocalServiceTestHelper.setEnvModuleInstance with a supported instance or com.google.appengine.tools.development.LocalEnvironment.MAIN_INSTANCE (-1) which is the default value");
                }
            }
        }
    }

    private static class ModuleVersion {
        private final ModuleVersionKey key;
        private final ScalingType scalingType;
        private final int initialNumInstances;

        ModuleVersion(String module, String version, ScalingType scalingType, int initialNumInstances) {
            Preconditions.checkNotNull((Object)module);
            Preconditions.checkNotNull((Object)version);
            if (scalingType == ScalingType.AUTOMATIC) {
                Preconditions.checkArgument((initialNumInstances == -1 ? 1 : 0) != 0, (Object)("Automatic scaling module version module " + module + " version " + version + " must have initialNumInstances -1"));
            } else {
                Preconditions.checkArgument((initialNumInstances != -1 ? 1 : 0) != 0, (Object)("Automatic scaling module version module " + module + " version " + version + " must not have initialNumInstances -1"));
            }
            version = LocalModulesServiceTestConfig.stripMinorVersion(version);
            this.key = new ModuleVersionKey(module, version);
            this.scalingType = scalingType;
            this.initialNumInstances = initialNumInstances;
        }

        String getModule() {
            return this.key.getModule();
        }

        String getVersion() {
            return this.key.getVersion();
        }

        int getInitialNumInstances() {
            return this.initialNumInstances;
        }

        ModuleVersionKey getKey() {
            return this.key;
        }

        ScalingType getScalingType() {
            return this.scalingType;
        }

        public String toString() {
            return "ModuleVersion module=" + this.key.getModule() + " version=" + this.key.getVersion() + " scalingType=" + String.valueOf((Object)this.scalingType) + (String)(this.initialNumInstances == -1 ? "" : " initialNumInstances=" + this.initialNumInstances);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.initialNumInstances;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.scalingType == null ? 0 : this.scalingType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleVersion other = (ModuleVersion)obj;
            if (this.initialNumInstances != other.initialNumInstances) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return this.scalingType == other.scalingType;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum ScalingType {
        AUTOMATIC{

            @Override
            AutomaticScalingModuleVersionState getModuleVersionState(ModuleVersion moduleVersion) {
                return new AutomaticScalingModuleVersionState(moduleVersion);
            }
        }
        ,
        BASIC{

            @Override
            BasicScalingModuleVersionState getModuleVersionState(ModuleVersion moduleVersion) {
                return new BasicScalingModuleVersionState(moduleVersion);
            }
        }
        ,
        MANUAL{

            @Override
            ManualScalingModuleVersionState getModuleVersionState(ModuleVersion moduleVersion) {
                return new ManualScalingModuleVersionState(moduleVersion);
            }
        };


        abstract AbstractModuleVersionState getModuleVersionState(ModuleVersion var1);
    }

    private static class ModuleVersionKey {
        private final String module;
        private final String version;

        ModuleVersionKey(String module, String version) {
            this.module = module;
            this.version = version;
        }

        public String getModule() {
            return this.module;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleVersionKey other = (ModuleVersionKey)obj;
            if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public String toString() {
            return "ModuleVersionKey: module=" + this.module + " version=" + this.version;
        }
    }

    private static abstract class AbstractModuleVersionState {
        protected final ModuleVersion moduleVersion;
        protected final AtomicInteger numInstances;

        AbstractModuleVersionState(ModuleVersion moduleVersion) {
            this.moduleVersion = moduleVersion;
            this.numInstances = new AtomicInteger(moduleVersion.getInitialNumInstances());
        }

        int getNumInstances() {
            logger.warning("Operation getNumInstances requires a manually scaling module version but  Module " + this.moduleVersion.getModule() + " version " + this.moduleVersion.getVersion() + " is not manual scaling.");
            throw new ApiProxy.ApplicationException(2, "Could not find the given version.");
        }

        int getNumInstancesInternal() {
            return this.numInstances.get();
        }

        void setNumInstances(int numInstances) {
            logger.warning("Operation setNumInstances requires a manually scaling version but  Module " + this.moduleVersion.getModule() + " version " + this.moduleVersion.getVersion() + " is not manual scaling.");
            throw new ApiProxy.ApplicationException(2, "Cannot set the number of instances for a module that has automatic scaling.");
        }

        ModuleVersion getModuleVersion() {
            return this.moduleVersion;
        }

        void start() {
            logger.info("Stopped  Module " + this.moduleVersion.getModule() + " version " + this.moduleVersion.getVersion());
        }

        void stop() {
            logger.info("Started  Module " + this.moduleVersion.getModule() + " version " + this.moduleVersion.getVersion());
        }

        String getInstanceDot(int instance) {
            if (instance >= this.numInstances.get()) {
                logger.warning("Operation getInstanceHostname failed because instances value " + instance + " is out of range for module " + this.moduleVersion.getModule() + " version " + this.moduleVersion.getVersion() + " numInstances " + this.numInstances.get());
                throw new ApiProxy.ApplicationException(3, "The specified instance does not exist for this module/version.");
            }
            return instance + ".";
        }

        public String toString() {
            return "AbstractModuleVersionState (" + String.valueOf(this.moduleVersion) + ")" + (String)(this.numInstances.get() == -1 ? "" : "numInstances =" + this.numInstances.get());
        }
    }

    static class BasicScalingModuleVersionState
    extends AbstractModuleVersionState {
        BasicScalingModuleVersionState(ModuleVersion moduleVersion) {
            super(moduleVersion);
        }
    }

    static class ManualScalingModuleVersionState
    extends AbstractModuleVersionState {
        ManualScalingModuleVersionState(ModuleVersion moduleVersion) {
            super(moduleVersion);
        }

        @Override
        int getNumInstances() {
            return this.numInstances.get();
        }

        @Override
        void setNumInstances(int numInstances) {
            if (numInstances <= 0) {
                logger.warning("Operation setNumInstances failed with invalid instances value " + numInstances + " for module " + this.moduleVersion.getModule() + " version " + this.moduleVersion.getVersion());
                throw new ApiProxy.ApplicationException(3, "The number of instances must be greater than 0.");
            }
            this.numInstances.set(numInstances);
        }
    }

    static class AutomaticScalingModuleVersionState
    extends AbstractModuleVersionState {
        AutomaticScalingModuleVersionState(ModuleVersion moduleVersion) {
            super(moduleVersion);
        }

        @Override
        void start() {
            this.reportStartStop("startVersion");
        }

        @Override
        void stop() {
            this.reportStartStop("stopVersion");
        }

        @Override
        String getInstanceDot(int instance) {
            logger.warning("Operation getInstanceHostname not allowed for dynamic module version  module " + this.moduleVersion.getModule() + " version " + this.moduleVersion.getVersion());
            throw new ApiProxy.ApplicationException(2, "The specified instance does not exist for this module/version.");
        }

        private void reportStartStop(String operation) {
            logger.warning("Automatic scaling module  module " + this.moduleVersion.getModule() + " version " + this.moduleVersion.getVersion() + " does not support " + operation);
            throw new ApiProxy.ApplicationException(2, "Could not find the specified version.");
        }
    }
}

