/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing.jakarta;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.taskqueue.DeferredTask;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueue;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.EnvSettingTaskqueueCallback;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.appengine.tools.development.testing.jakarta.FakeHttpServletRequest;
import com.google.appengine.tools.development.testing.jakarta.FakeHttpServletResponse;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LocalTaskQueueTestConfig
implements LocalServiceTestConfig {
    private static final Logger logger = Logger.getLogger(LocalTaskQueueTestConfig.class.getName());
    private Boolean disableAutoTaskExecution = true;
    private String queueXmlPath;
    private String queueYamlPath;
    private Class<? extends LocalTaskQueueCallback> callbackClass;
    private boolean shouldCopyApiProxyEnvironment = false;
    private CountDownLatch taskExecutionLatch;

    public LocalTaskQueueTestConfig setDisableAutoTaskExecution(boolean disableAutoTaskExecution) {
        this.disableAutoTaskExecution = disableAutoTaskExecution;
        return this;
    }

    public LocalTaskQueueTestConfig setQueueXmlPath(String queueXmlPath) {
        this.queueXmlPath = queueXmlPath;
        return this;
    }

    public LocalTaskQueueTestConfig setQueueYamlPath(String queueYamlPath) {
        this.queueYamlPath = queueYamlPath;
        return this;
    }

    public LocalTaskQueueTestConfig setCallbackClass(Class<? extends LocalTaskQueueCallback> callbackClass) {
        this.callbackClass = callbackClass;
        return this;
    }

    public LocalTaskQueueTestConfig setShouldCopyApiProxyEnvironment(boolean b) {
        this.shouldCopyApiProxyEnvironment = b;
        return this;
    }

    public LocalTaskQueueTestConfig setTaskExecutionLatch(CountDownLatch latch) {
        this.taskExecutionLatch = latch;
        return this;
    }

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        proxy.setProperty("task_queue.disable_auto_task_execution", this.disableAutoTaskExecution.toString());
        if (this.queueXmlPath != null) {
            proxy.setProperty("task_queue.queue_xml_path", this.queueXmlPath);
        }
        if (this.queueYamlPath != null) {
            proxy.setProperty("task_queue.queue_yaml_path", this.queueYamlPath);
        }
        if (this.callbackClass != null) {
            String callbackName;
            if (!this.disableAutoTaskExecution.booleanValue()) {
                EnvSettingTaskqueueCallback.setProxyProperties(proxy, this.callbackClass, this.shouldCopyApiProxyEnvironment);
                if (this.taskExecutionLatch != null) {
                    EnvSettingTaskqueueCallback.setTaskExecutionLatch(this.taskExecutionLatch);
                }
                callbackName = EnvSettingTaskqueueCallback.class.getName();
            } else {
                callbackName = this.callbackClass.getName();
            }
            proxy.setProperty("task_queue.callback_class", callbackName);
        }
    }

    @Override
    public void tearDown() {
        LocalTaskQueue ltq = LocalTaskQueueTestConfig.getLocalTaskQueue();
        if (ltq != null) {
            for (String queueName : ltq.getQueueStateInfo().keySet()) {
                ltq.flushQueue(queueName);
            }
            ltq.stop();
        }
    }

    public static LocalTaskQueue getLocalTaskQueue() {
        return (LocalTaskQueue)LocalServiceTestHelper.getLocalService("taskqueue");
    }

    public static final class TaskCountDownLatch
    extends CountDownLatch {
        private int initialCount;
        private CountDownLatch latch;

        public TaskCountDownLatch(int count) {
            super(count);
            this.reset(count);
        }

        @Override
        public long getCount() {
            return this.latch.getCount();
        }

        @Override
        public String toString() {
            return this.latch.toString();
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }

        @Override
        public void countDown() {
            this.latch.countDown();
        }

        public void awaitAndReset() throws InterruptedException {
            this.awaitAndReset(this.initialCount);
        }

        public void awaitAndReset(int count) throws InterruptedException {
            this.await();
            this.reset(count);
        }

        public boolean awaitAndReset(long timeout, TimeUnit unit) throws InterruptedException {
            return this.awaitAndReset(timeout, unit, this.initialCount);
        }

        public boolean awaitAndReset(long timeout, TimeUnit unit, int count) throws InterruptedException {
            boolean result = this.await(timeout, unit);
            this.reset(count);
            return result;
        }

        public void reset() {
            this.reset(this.initialCount);
        }

        public void reset(int count) {
            this.initialCount = count;
            this.latch = new CountDownLatch(count);
        }
    }

    public static abstract class ServletInvokingTaskCallback
    extends DeferredTaskCallback {
        @Override
        public void initialize(Map<String, String> properties) {
        }

        protected abstract Map<String, ? extends HttpServlet> getServletMap();

        protected abstract HttpServlet getDefaultServlet();

        private static Map<String, String> extractParamValues(String body) {
            HashMap params = Maps.newHashMap();
            if (body.length() > 0) {
                for (String keyValue : body.split("&")) {
                    String[] split = keyValue.split("=");
                    try {
                        params.put(split[0], URLDecoder.decode(split[1], "utf-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Could not decode param " + split[1]);
                    }
                }
            }
            return params;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected int executeNonDeferredRequest(URLFetchServicePb.URLFetchRequest req) {
            try {
                void var7_13;
                void var7_10;
                FakeHttpServletResponse response = new FakeHttpServletResponse();
                response.setCharacterEncoding("utf-8");
                URL url = new URL(req.getUrl());
                FakeHttpServletRequest request = new FakeHttpServletRequest();
                request.setMethod(req.getMethod().name());
                request.setHostName(url.getHost());
                request.setPort(url.getPort());
                request.setParametersFromQueryString(url.getQuery());
                for (Object header : req.getHeaderList()) {
                    request.setHeader(header.getKey(), header.getValue());
                }
                String payload = req.getPayload().toStringUtf8();
                for (Map.Entry entry : ServletInvokingTaskCallback.extractParamValues(payload).entrySet()) {
                    request.addParameter((String)entry.getKey(), (String)entry.getValue());
                }
                String servletPath = null;
                Object var7_9 = null;
                for (Map.Entry<String, ? extends HttpServlet> entry : this.getServletMap().entrySet()) {
                    if (!url.getPath().startsWith(entry.getKey())) continue;
                    servletPath = entry.getKey();
                    HttpServlet httpServlet = entry.getValue();
                }
                if (var7_10 == null) {
                    HttpServlet httpServlet = this.getDefaultServlet();
                    request.setPathInfo(url.getPath());
                } else {
                    int servletPathStart = servletPath.lastIndexOf(47);
                    if (servletPathStart == -1) {
                        throw new IllegalArgumentException("The servlet path was configured as: " + servletPath + " which does not contan a '/'");
                    }
                    request.setContextPath(servletPath.substring(0, servletPathStart));
                    request.setSerletPath(servletPath.substring(servletPathStart));
                    request.setPathInfo(url.getPath().substring(servletPath.length()));
                }
                var7_13.service((ServletRequest)request, (ServletResponse)response);
                int result = response.getStatus();
                return result;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                return 500;
            }
        }
    }

    public static class DeferredTaskCallback
    implements LocalTaskQueueCallback {
        private static final String CURRENT_NAMESPACE_HEADER = "X-AppEngine-Current-Namespace";

        public void initialize(Map<String, String> properties) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public int execute(URLFetchServicePb.URLFetchRequest req) {
            boolean namespacesDiffer;
            String currentNamespace = NamespaceManager.get();
            String requestNamespace = null;
            ByteString payload = null;
            for (URLFetchServicePb.URLFetchRequest.Header header : req.getHeaderList()) {
                if (header.getKey().equals("content-type") && "application/x-binary-app-engine-java-runnable-task".equals(header.getValue())) {
                    payload = req.getPayload();
                    continue;
                }
                if (!CURRENT_NAMESPACE_HEADER.equals(header.getKey())) continue;
                requestNamespace = header.getValue();
            }
            boolean bl = namespacesDiffer = requestNamespace != null && !requestNamespace.equals(currentNamespace);
            if (namespacesDiffer) {
                NamespaceManager.set((String)requestNamespace);
            }
            try {
                if (payload != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(payload.toByteArray());
                    try {
                        ObjectInputStream ois = new ObjectInputStream(bais);
                        DeferredTask deferredTask = (DeferredTask)ois.readObject();
                        deferredTask.run();
                        int n = 200;
                        return n;
                    }
                    catch (Exception e) {
                        int n;
                        block12: {
                            logger.log(Level.WARNING, e.getMessage(), e);
                            n = 500;
                            if (!namespacesDiffer) break block12;
                            NamespaceManager.set((String)currentNamespace);
                        }
                        return n;
                    }
                }
                int n = this.executeNonDeferredRequest(req);
                return n;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (namespacesDiffer) {
                    NamespaceManager.set((String)currentNamespace);
                }
            }
        }

        protected int executeNonDeferredRequest(URLFetchServicePb.URLFetchRequest req) {
            return 200;
        }
    }
}

