/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.cron;

import com.google.appengine.repackaged.com.google.cron.GrocLexer;
import com.google.appengine.repackaged.com.google.cron.GrocParser;
import com.google.appengine.repackaged.org.antlr.runtime.ANTLRStringStream;
import com.google.appengine.repackaged.org.antlr.runtime.CommonTokenStream;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrocTimeSpecification {
    private final Set<Integer> months;
    private final Set<Integer> ordinals;
    private final Set<Integer> weekdays;
    private final Set<Integer> monthdays;
    private final Integer interval;
    private final String intervalPeriod;
    private final int hour;
    private final int minute;
    private final int seconds;
    private final TimeZone timezone;
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_MINUTE = 60000L;
    private final boolean synchronize;

    public static GrocTimeSpecification create(String spec, TimeZone timezone) throws IllegalArgumentException {
        GrocLexer lexer = new GrocLexer(new ANTLRStringStream(spec));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        GrocParser parser = new GrocParser(tokens);
        parser.init();
        try {
            parser.timespec();
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException("Specification '" + spec + "' is invalid.");
        }
        if (timezone == null) {
            timezone = UTC_ZONE;
        }
        if (parser.getInterval() != null) {
            return new GrocTimeSpecification(parser.getInterval(), parser.getIntervalPeriod(), parser.getSynchronized(), timezone);
        }
        return new GrocTimeSpecification(parser.getOrdinals(), parser.getMonths(), parser.getWeekdays(), parser.getMonthdays(), parser.getTime(), timezone);
    }

    public static GrocTimeSpecification create(String spec) throws IllegalArgumentException {
        return GrocTimeSpecification.create(spec, UTC_ZONE);
    }

    public GrocTimeSpecification(Set<Integer> ordinals, Set<Integer> months, Set<Integer> weekdays, Set<Integer> monthdays, String time, TimeZone timezone) {
        this.timezone = timezone;
        this.ordinals = ordinals;
        this.months = months;
        this.weekdays = weekdays;
        this.monthdays = monthdays;
        if (!weekdays.isEmpty() && !monthdays.isEmpty()) {
            throw new IllegalArgumentException("cannot specify both monthdays and weekdays");
        }
        for (int day : monthdays) {
            if (day >= 1 && day <= 31) continue;
            throw new IllegalArgumentException("invalid day of month: " + day);
        }
        String[] timeElements = time.split(":");
        this.hour = Integer.parseInt(timeElements[0]);
        this.minute = Integer.parseInt(timeElements[1]);
        this.interval = null;
        this.seconds = 0;
        this.synchronize = false;
        this.intervalPeriod = "";
    }

    public GrocTimeSpecification(int interval, String period, boolean synchronize, TimeZone timezone) throws IllegalArgumentException {
        this.hour = 0;
        this.minute = 0;
        this.months = new HashSet<Integer>();
        this.ordinals = new HashSet<Integer>();
        this.weekdays = new HashSet<Integer>();
        this.monthdays = new HashSet<Integer>();
        this.timezone = timezone;
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than zero");
        }
        this.interval = interval;
        this.intervalPeriod = period;
        this.seconds = this.intervalPeriod.equals("hours") ? this.interval * 3600 : this.interval * 60;
        this.synchronize = synchronize;
        if (synchronize && (this.seconds > 86400 || 86400 % this.seconds != 0)) {
            throw new IllegalArgumentException("can only use synchronized for periods that divide evenly into 24 hours");
        }
    }

    public List<Date> getMatches(Date start, int count) {
        ArrayList<Date> results = new ArrayList<Date>();
        Date next = start;
        for (int i = 0; i < count; ++i) {
            next = this.getMatch(next);
            results.add(next);
        }
        return results;
    }

    public Date getMatch(Date start) {
        if (this.interval != null) {
            return this.getMatchInterval(start);
        }
        return this.getMatchSpecificTime(start);
    }

    private Date getMatchInterval(Date start) {
        if (!this.synchronize) {
            if (this.intervalPeriod.equals("hours")) {
                return new Date(start.getTime() + (long)this.interval.intValue() * 3600000L);
            }
            return new Date(start.getTime() + (long)this.interval.intValue() * 60000L);
        }
        System.out.println("start " + start);
        Calendar runTime = Calendar.getInstance(this.timezone);
        runTime.setTime(start);
        Calendar startOfDay = Calendar.getInstance(this.timezone);
        startOfDay.setTime(start);
        startOfDay.set(11, 0);
        startOfDay.set(12, 0);
        startOfDay.set(13, 0);
        startOfDay.set(14, 0);
        long daySeconds = (runTime.getTimeInMillis() - startOfDay.getTimeInMillis()) / 1000L;
        long delta = (long)this.seconds - daySeconds % (long)this.seconds;
        runTime.add(13, (int)delta);
        return runTime.getTime();
    }

    private Date getMatchSpecificTime(Date start) {
        List<Integer> dayMatches;
        int yearWraps;
        int nextMonth;
        Calendar calendar = Calendar.getInstance(this.timezone);
        calendar.setTime(start);
        int startYear = calendar.get(1);
        int startMonth = calendar.get(2) + 1;
        int startDayOfMonth = calendar.get(5);
        int startHour = calendar.get(11);
        int startMinute = calendar.get(12);
        int MAX_MONTHS_TO_CONSIDER = 48;
        NextGenerator monthGen = new NextGenerator(startMonth, this.months);
        int monthsConsidered = 0;
        while (true) {
            IntegerPair nextMonthWrapPair = monthGen.next();
            nextMonth = nextMonthWrapPair.first;
            yearWraps = nextMonthWrapPair.second;
            ++monthsConsidered;
            calendar.set(startYear + yearWraps, nextMonth - 1, 1);
            dayMatches = this.findDays(calendar);
            if (dayMatches.size() == 0) {
                if (monthsConsidered >= 48) {
                    throw new AssertionError((Object)"no matching days");
                }
                continue;
            }
            if (calendar.get(1) == startYear && nextMonth == startMonth) {
                while (!dayMatches.isEmpty() && dayMatches.get(0) < startDayOfMonth) {
                    dayMatches.remove(0);
                }
                if (!dayMatches.isEmpty() && dayMatches.get(0) == startDayOfMonth && (startHour > this.hour || startHour == this.hour && startMinute >= this.minute)) {
                    dayMatches.remove(0);
                }
            }
            if (!dayMatches.isEmpty()) break;
        }
        int candidateDay = dayMatches.get(0);
        dayMatches.remove(0);
        calendar.set(startYear + yearWraps, nextMonth - 1, candidateDay, this.hour, this.minute, 0);
        return calendar.getTime();
    }

    List<Integer> findDays(Calendar candidate) {
        TreeSet<Integer> outDays = new TreeSet<Integer>();
        long original = candidate.getTimeInMillis();
        candidate.set(5, 1);
        int firstWeekDay = candidate.get(7) - 1;
        candidate.set(2, candidate.get(2) + 1);
        candidate.add(5, -1);
        int lastDayOfMonth = candidate.get(5);
        candidate.setTimeInMillis(original);
        if (this.monthdays.isEmpty()) {
            for (int ordinal : this.ordinals) {
                for (int weekday : this.weekdays) {
                    int day = (7 + weekday - firstWeekDay) % 7 + 1;
                    if ((day += 7 * (ordinal - 1)) > lastDayOfMonth) continue;
                    outDays.add(day);
                }
            }
        } else {
            for (int day : this.monthdays) {
                if (day > lastDayOfMonth) continue;
                outDays.add(day);
            }
        }
        return new ArrayList<Integer>(outDays);
    }

    static class IntegerPair {
        public final int first;
        public final int second;

        IntegerPair(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object other) {
            return other instanceof IntegerPair && this.first == ((IntegerPair)other).first && this.second == ((IntegerPair)other).second;
        }

        public String toString() {
            return "<" + this.first + "," + this.second + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NextGenerator {
        private int start;
        private final Set<Integer> matches;
        private List<Integer> remaining;
        private int wrapcount;

        NextGenerator(Integer start, Set<Integer> matches) {
            this.start = start;
            this.matches = new TreeSet<Integer>(matches);
            this.remaining = new ArrayList<Integer>(this.matches);
            this.wrapcount = 0;
        }

        public IntegerPair next() {
            while (this.remaining.size() > 0 && this.remaining.get(0) < this.start) {
                this.remaining.remove(0);
            }
            if (this.remaining.size() == 0) {
                this.remaining = new ArrayList<Integer>(this.matches);
                ++this.wrapcount;
            }
            this.start = this.remaining.get(0);
            this.remaining.remove(0);
            return new IntegerPair(this.start, this.wrapcount);
        }
    }
}

