/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.io.protocol.CategoryInformation;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DowngradedMessage
extends ProtocolMessage<DowngradedMessage> {
    private Message message;
    private final ExtensionRegistry extensionRegistry;
    static final CategoryInformation<DowngradedMessage> CATEGORY_INFORMATION = new CategoryInformation<DowngradedMessage>(){

        @Override
        public String getSimpleClassName(DowngradedMessage message) {
            return message.message.getDescriptorForType().getName();
        }

        @Override
        public String getFullClassName(DowngradedMessage message) {
            return message.message.getDescriptorForType().getFullName();
        }

        @Override
        public DowngradedMessage parse(CharSequence text, DowngradedMessage message) {
            try {
                Message.Builder builder = message.message.newBuilderForType();
                TextFormat.merge(text, message.extensionRegistry, builder);
                message.message = builder.build();
                return message;
            }
            catch (TextFormat.ParseException e) {
                throw new RuntimeException("ParseException: " + e.getMessage());
            }
        }
    };

    public DowngradedMessage() {
        throw new UnsupportedOperationException();
    }

    public DowngradedMessage(Message message) {
        this(message, ExtensionRegistry.getEmptyRegistry());
    }

    public DowngradedMessage(Message message, ExtensionRegistry registry) {
        this.message = message;
        this.extensionRegistry = registry;
    }

    @Override
    public DowngradedMessage getDefaultInstanceForType() {
        return new DowngradedMessage(this.message.getDefaultInstanceForType());
    }

    public Message getProto2Message() {
        return this.message;
    }

    public void setProto2Message(Message message) {
        this.message = message;
    }

    @Override
    public int encodingSize() {
        return this.message.getSerializedSize();
    }

    @Override
    public int maxEncodingSize() {
        return this.message.getSerializedSize();
    }

    @Override
    public void clear() {
        this.message = this.message.getDefaultInstanceForType();
    }

    @Override
    public int hashCode() {
        return this.message.toByteString().hashCode();
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof DowngradedMessage && ((Object)this.message).equals(((DowngradedMessage)that).message);
    }

    @Override
    public boolean equals(DowngradedMessage that) {
        return this.equals(that, false);
    }

    @Override
    public boolean equalsIgnoreUninterpreted(DowngradedMessage that) {
        return this.equals(that, true);
    }

    @Override
    public boolean equals(DowngradedMessage that, boolean ignoreUninterpreted) {
        ByteString string1 = this.message.toByteString();
        ByteString string2 = that.message.toByteString();
        return string1.equals(string2);
    }

    @Override
    public String findInitializationError() {
        return this.message.isInitialized() ? null : "Unknown field";
    }

    @Override
    public boolean isInitialized() {
        return this.message.isInitialized();
    }

    @Override
    public ProtocolType getProtocolType() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean merge(final ProtocolSource source) {
        InputStream is = new InputStream(){

            public int read() throws IOException {
                return source.getByte();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int remaining = source.remaining();
                if (remaining == 0) {
                    return -1;
                }
                len = Math.min(len, remaining);
                source.getBytes(b, off, len);
                return len;
            }
        };
        Message.Builder builder = this.message.toBuilder();
        try {
            builder.mergeFrom(is, (ExtensionRegistryLite)this.extensionRegistry);
        }
        catch (IOException e) {
            return false;
        }
        this.message = builder.buildPartial();
        return true;
    }

    @Override
    public DowngradedMessage mergeFrom(DowngradedMessage that) {
        this.message = this.message.toBuilder().mergeFrom(that.message).buildPartial();
        return this;
    }

    @Override
    public DowngradedMessage newInstance() {
        return new DowngradedMessage(this.message.getDefaultInstanceForType(), this.extensionRegistry);
    }

    @Override
    public void outputTo(final ProtocolSink sink) {
        OutputStream os = new OutputStream(){

            public void write(int b) {
                sink.putByte((byte)b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                sink.putBytes(b, off, len);
            }
        };
        try {
            this.message.writeTo(os);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Cannot reach here");
        }
    }

    @Override
    public String toString() {
        return ((Object)this.message).toString();
    }

    @Override
    public String toFlatString() {
        String temp = ((Object)this.message).toString();
        return temp.replaceAll("\n *", " ");
    }

    @Override
    public CategoryInformation<DowngradedMessage> messageCategoryInformation() {
        return CATEGORY_INFORMATION;
    }
}

