/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.AppVersionUpload;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.CronEntry;
import com.google.appengine.tools.admin.CronEntryImpl;
import com.google.appengine.tools.admin.LogFetcher;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.appengine.tools.admin.UpdateFailureEvent;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.apphosting.utils.config.CronXml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppAdminImpl
implements AppAdmin {
    private AppAdminFactory.ConnectOptions options;
    private Application app;
    private PrintWriter errorWriter;
    private AppAdminFactory.ApplicationProcessingOptions appOptions;
    private final Class<? extends AppVersionUpload> appVersionUploadClass;

    AppAdminImpl(AppAdminFactory.ConnectOptions options, Application app, PrintWriter errorWriter, AppAdminFactory.ApplicationProcessingOptions appOptions, Class<? extends AppVersionUpload> appVersionUploadClass) {
        this.options = options;
        this.app = app;
        this.errorWriter = errorWriter;
        this.appOptions = appOptions;
        this.appVersionUploadClass = appVersionUploadClass;
    }

    @Override
    public void update(UpdateListener listener) {
        ServerConnection connection = new ServerConnection(this.options);
        StringWriter detailsWriter = new StringWriter();
        try {
            this.app.setListener(listener);
            this.app.setDetailsWriter(new PrintWriter((Writer)detailsWriter, true));
            this.app.createStagingDirectory(this.appOptions);
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app);
            uploader.doUpload();
            listener.onSuccess(new UpdateSuccessEvent(detailsWriter.toString()));
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update:");
            t.printStackTrace(this.errorWriter);
            listener.onFailure(new UpdateFailureEvent(t, t.toString(), detailsWriter.toString()));
            throw new AdminException("Unable to update app: " + t.getMessage(), t);
        }
        finally {
            connection.saveCookies();
        }
    }

    @Override
    public void rollback() {
        ServerConnection connection = new ServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app);
            uploader.forceRollback();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to rollback:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to rollback app: " + t.getMessage(), t);
        }
        finally {
            connection.saveCookies();
        }
    }

    @Override
    public void updateIndexes() {
        ServerConnection connection = new ServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app);
            uploader.updateIndexes();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update indexes:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to update indexes for app: " + t.getMessage(), t);
        }
        finally {
            connection.saveCookies();
        }
    }

    @Override
    public void updateCron() {
        ServerConnection connection = new ServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app);
            uploader.updateCron();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update cron entries:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to update cron entries for app: " + t.getMessage(), t);
        }
        finally {
            connection.saveCookies();
        }
    }

    @Override
    public void updateQueues() {
        ServerConnection connection = new ServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app);
            uploader.updateQueue();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to upload:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to update task queues for app: " + t.getMessage(), t);
        }
        finally {
            connection.saveCookies();
        }
    }

    @Override
    public List<CronEntry> cronInfo() {
        try {
            ArrayList<CronEntry> result = new ArrayList<CronEntry>();
            CronXml cron = this.app.getCronXml();
            if (cron == null) {
                return result;
            }
            for (CronXml.Entry entry : cron.getEntries()) {
                result.add(new CronEntryImpl(entry.getUrl(), entry.getDescription(), entry.getSchedule(), entry.getTimezone()));
            }
            return result;
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to display run times for cron entries:");
            t.printStackTrace(this.errorWriter);
            throw new AdminException("Unable to display run times for cron entries for app: " + t.getMessage(), t);
        }
    }

    @Override
    public void vacuumIndexes() {
        throw new UnsupportedOperationException("Vacuuming of indices is not yet supported.");
    }

    @Override
    public Reader requestLogs(int numDays, AppAdmin.LogSeverity severity) {
        ServerConnection connection = new ServerConnection(this.options);
        try {
            File logFile = File.createTempFile(this.app.getAppId() + "-" + this.app.getVersion(), ".log");
            logFile.deleteOnExit();
            LogFetcher logFetcher = new LogFetcher(this.app, connection);
            logFetcher.fetch(numDays, severity, new FileOutputStream(logFile));
            BufferedReader bufferedReader = new BufferedReader(new FileReader(logFile));
            return bufferedReader;
        }
        catch (Exception ex) {
            throw new AdminException("Unable to retrieve the remote application logs:", ex);
        }
        finally {
            connection.saveCookies();
        }
    }

    private AppVersionUpload createAppVersionUpload(ServerConnection connection, Application app) throws Exception {
        Constructor<? extends AppVersionUpload> constructor = this.appVersionUploadClass.getConstructor(ServerConnection.class, Application.class);
        return constructor.newInstance(connection, app);
    }
}

