/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.glob.ConflictResolver;
import com.google.apphosting.utils.glob.Glob;
import com.google.apphosting.utils.glob.GlobFactory;
import com.google.apphosting.utils.glob.GlobIntersector;
import com.google.apphosting.utils.glob.LongestPatternConflictResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppYamlTranslator {
    private static final String NO_API_VERSION = "none";
    private static final ConflictResolver RESOLVER = new LongestPatternConflictResolver();
    private static final String DYNAMIC_PROPERTY = "dynamic";
    private static final String STATIC_PROPERTY = "static";
    private static final String WELCOME_FILES = "welcome";
    private static final String TRANSPORT_GUARANTEE_PROPERTY = "transportGuarantee";
    private static final String REQUIRED_ROLE_PROPERTY = "requiredRole";
    private static final String EXPIRATION_PROPERTY = "expiration";
    private static final String[] PROPERTIES = new String[]{"dynamic", "static", "welcome", "transportGuarantee", "requiredRole", "expiration"};
    private final AppEngineWebXml appEngineWebXml;
    private final WebXml webXml;
    private final String apiVersion;
    private final Set<String> staticFiles;

    public AppYamlTranslator(AppEngineWebXml appEngineWebXml, WebXml webXml, String apiVersion, Set<String> staticFiles) {
        this.appEngineWebXml = appEngineWebXml;
        this.webXml = webXml;
        this.apiVersion = apiVersion;
        this.staticFiles = staticFiles;
    }

    public String getYaml() {
        StringBuilder builder = new StringBuilder();
        this.translateAppEngineWebXml(builder);
        this.translateApiVersion(builder);
        this.translateWebXml(builder);
        return builder.toString();
    }

    private void translateAppEngineWebXml(StringBuilder builder) {
        List<AppEngineWebXml.AdminConsolePage> adminConsolePages;
        builder.append("application: '" + this.appEngineWebXml.getAppId() + "'\n");
        builder.append("runtime: java\n");
        builder.append("version: '" + this.appEngineWebXml.getMajorVersionId() + "'\n");
        List<String> services = this.appEngineWebXml.getInboundServices();
        if (!services.isEmpty()) {
            builder.append("inbound_services:\n");
            for (String service : services) {
                builder.append("- " + service + "\n");
            }
        }
        if (this.appEngineWebXml.getPrecompilationEnabled()) {
            builder.append("derived_file_type:\n");
            builder.append("- java_precompiled\n");
        }
        if (!(adminConsolePages = this.appEngineWebXml.getAdminConsolePages()).isEmpty()) {
            builder.append("admin_console:\n");
            builder.append("  pages:\n");
            for (AppEngineWebXml.AdminConsolePage page : adminConsolePages) {
                builder.append("  - name: " + page.getName() + "\n");
                builder.append("    url: " + page.getUrl() + "\n");
            }
        }
    }

    private void translateApiVersion(StringBuilder builder) {
        if (this.apiVersion == null) {
            builder.append("api_version: 'none'\n");
        } else {
            builder.append("api_version: '" + this.apiVersion + "'\n");
        }
    }

    private void translateWebXml(StringBuilder builder) {
        builder.append("handlers:\n");
        if (!this.staticFiles.isEmpty()) {
            new StaticHandlerGenerator(this.appEngineWebXml.getPublicRoot()).translate(builder);
        }
        new DynamicHandlerGenerator().translate(builder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractHandlerGenerator {
        AbstractHandlerGenerator() {
        }

        public void translate(StringBuilder builder) {
            for (Glob glob : this.createGlobPatterns()) {
                this.translateGlob(builder, glob);
            }
        }

        protected abstract void addPatterns(GlobIntersector var1);

        protected abstract void translateGlob(StringBuilder var1, Glob var2);

        protected abstract Map<String, Object> getWelcomeProperties();

        protected List<Glob> createGlobPatterns() {
            GlobIntersector intersector = new GlobIntersector();
            this.addPatterns(intersector);
            this.addSecurityConstraints(intersector);
            this.addWelcomeFiles(intersector);
            List<Glob> globs = intersector.getIntersection();
            this.removeNearDuplicates(globs);
            return globs;
        }

        protected void addWelcomeFiles(GlobIntersector intersector) {
            Map<String, Object> welcomeProperties = this.getWelcomeProperties();
            if (welcomeProperties != null) {
                intersector.addGlob(GlobFactory.createGlob("/", welcomeProperties));
                intersector.addGlob(GlobFactory.createGlob("/*/", welcomeProperties));
            }
        }

        protected void addSecurityConstraints(GlobIntersector intersector) {
            for (WebXml.SecurityConstraint constraint : AppYamlTranslator.this.webXml.getSecurityConstraints()) {
                for (String pattern : constraint.getUrlPatterns()) {
                    intersector.addGlob(GlobFactory.createGlob(pattern, AppYamlTranslator.TRANSPORT_GUARANTEE_PROPERTY, (Object)constraint.getTransportGuarantee()));
                    intersector.addGlob(GlobFactory.createGlob(pattern, AppYamlTranslator.REQUIRED_ROLE_PROPERTY, (Object)constraint.getRequiredRole()));
                }
            }
        }

        protected void translateHandlerOptions(StringBuilder builder, Glob glob) {
            WebXml.SecurityConstraint.RequiredRole requiredRole = (WebXml.SecurityConstraint.RequiredRole)((Object)glob.getProperty(AppYamlTranslator.REQUIRED_ROLE_PROPERTY, RESOLVER));
            if (requiredRole == null) {
                requiredRole = WebXml.SecurityConstraint.RequiredRole.NONE;
            }
            switch (requiredRole) {
                case NONE: {
                    builder.append("  login: optional\n");
                    break;
                }
                case ANY_USER: {
                    builder.append("  login: required\n");
                    break;
                }
                case ADMIN: {
                    builder.append("  login: admin\n");
                }
            }
            WebXml.SecurityConstraint.TransportGuarantee transportGuarantee = (WebXml.SecurityConstraint.TransportGuarantee)((Object)glob.getProperty(AppYamlTranslator.TRANSPORT_GUARANTEE_PROPERTY, RESOLVER));
            if (transportGuarantee == null) {
                transportGuarantee = WebXml.SecurityConstraint.TransportGuarantee.NONE;
            }
            switch (transportGuarantee) {
                case NONE: {
                    if (AppYamlTranslator.this.appEngineWebXml.getSslEnabled()) {
                        builder.append("  secure: optional\n");
                        break;
                    }
                    builder.append("  secure: never\n");
                    break;
                }
                case INTEGRAL: 
                case CONFIDENTIAL: {
                    if (!AppYamlTranslator.this.appEngineWebXml.getSslEnabled()) {
                        throw new AppEngineConfigException("SSL must be enabled in appengine-web.xml to use transport-guarantee");
                    }
                    builder.append("  secure: always\n");
                }
            }
        }

        private void removeNearDuplicates(List<Glob> globs) {
            block0: while (globs.size() >= 2) {
                Glob lastGlob = globs.get(0);
                for (int i = 1; i < globs.size(); ++i) {
                    Glob glob = globs.get(i);
                    if (!glob.matchesAll(lastGlob) || !this.propertiesMatch(glob, lastGlob)) continue;
                    globs.remove(lastGlob);
                    continue block0;
                }
            }
        }

        private boolean propertiesMatch(Glob glob1, Glob glob2) {
            for (String property : PROPERTIES) {
                Object value2;
                Object value1 = glob1.getProperty(property, RESOLVER);
                if (value1 == (value2 = glob2.getProperty(property, RESOLVER)) || value1 != null && value1.equals(value2)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DynamicHandlerGenerator
    extends AbstractHandlerGenerator {
        private final List<String> patterns;
        private boolean hasJsps;
        private boolean fallthrough;

        DynamicHandlerGenerator() {
            this.fallthrough = AppYamlTranslator.this.webXml.getFallThroughToRuntime();
            this.patterns = new ArrayList<String>();
            for (String servletPattern : AppYamlTranslator.this.webXml.getServletPatterns()) {
                if (servletPattern.equals("/") || servletPattern.equals("/*")) {
                    this.fallthrough = true;
                    continue;
                }
                if (servletPattern.endsWith(".jsp")) {
                    this.hasJsps = true;
                    continue;
                }
                this.patterns.add(servletPattern);
            }
        }

        @Override
        protected Map<String, Object> getWelcomeProperties() {
            if (this.fallthrough) {
                return null;
            }
            return Collections.singletonMap(AppYamlTranslator.DYNAMIC_PROPERTY, true);
        }

        @Override
        protected void addPatterns(GlobIntersector intersector) {
            if (this.fallthrough) {
                intersector.addGlob(GlobFactory.createGlob("/*", AppYamlTranslator.DYNAMIC_PROPERTY, true));
            } else {
                for (String servletPattern : this.patterns) {
                    intersector.addGlob(GlobFactory.createGlob(servletPattern, AppYamlTranslator.DYNAMIC_PROPERTY, true));
                }
                if (this.hasJsps) {
                    intersector.addGlob(GlobFactory.createGlob("*.jsp", AppYamlTranslator.DYNAMIC_PROPERTY, true));
                }
            }
        }

        @Override
        public void translateGlob(StringBuilder builder, Glob glob) {
            String regex = glob.getRegularExpression().pattern();
            Boolean isDynamic = (Boolean)glob.getProperty(AppYamlTranslator.DYNAMIC_PROPERTY, RESOLVER);
            if (isDynamic != null && isDynamic.booleanValue()) {
                builder.append("- url: " + regex + "\n");
                builder.append("  script: unused\n");
                this.translateHandlerOptions(builder, glob);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StaticHandlerGenerator
    extends AbstractHandlerGenerator {
        private final String root;
        private final String rootRegex;

        public StaticHandlerGenerator(String root) {
            this.root = root;
            this.rootRegex = root.replaceAll("([^A-Za-z0-9\\-_/])", "\\\\$1");
        }

        @Override
        protected Map<String, Object> getWelcomeProperties() {
            ArrayList<String> staticWelcomeFiles = new ArrayList<String>();
            block0: for (String welcomeFile : AppYamlTranslator.this.webXml.getWelcomeFiles()) {
                for (String staticFile : AppYamlTranslator.this.staticFiles) {
                    if (!staticFile.endsWith("/" + welcomeFile)) continue;
                    staticWelcomeFiles.add(welcomeFile);
                    continue block0;
                }
            }
            return Collections.singletonMap(AppYamlTranslator.WELCOME_FILES, staticWelcomeFiles);
        }

        @Override
        protected void addPatterns(GlobIntersector intersector) {
            List<AppEngineWebXml.StaticFileInclude> includes = AppYamlTranslator.this.appEngineWebXml.getStaticFileIncludes();
            if (includes.isEmpty()) {
                intersector.addGlob(GlobFactory.createGlob("/*", AppYamlTranslator.STATIC_PROPERTY, true));
            } else {
                for (AppEngineWebXml.StaticFileInclude include : includes) {
                    String pattern = include.getPattern().replaceAll("\\*\\*", "*");
                    if (!pattern.startsWith("/")) {
                        pattern = "/" + pattern;
                    }
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put(AppYamlTranslator.STATIC_PROPERTY, true);
                    if (include.getExpiration() != null) {
                        props.put(AppYamlTranslator.EXPIRATION_PROPERTY, include.getExpiration());
                    }
                    intersector.addGlob(GlobFactory.createGlob(pattern, props));
                }
            }
        }

        @Override
        public void translateGlob(StringBuilder builder, Glob glob) {
            String regex = glob.getRegularExpression().pattern();
            List welcomeFiles = (List)glob.getProperty(AppYamlTranslator.WELCOME_FILES, RESOLVER);
            if (welcomeFiles != null) {
                for (String welcomeFile : welcomeFiles) {
                    builder.append("- url: (" + regex + ")\n");
                    builder.append("  static_files: __static__" + this.root + "\\1" + welcomeFile + "\n");
                    builder.append("  upload: __static__" + this.rootRegex + regex + welcomeFile + "\n");
                    builder.append("  require_matching_file: True\n");
                    this.translateHandlerOptions(builder, glob);
                    this.translateAdditionalStaticOptions(builder, glob);
                }
            } else {
                Boolean isStatic = (Boolean)glob.getProperty(AppYamlTranslator.STATIC_PROPERTY, RESOLVER);
                if (isStatic != null && isStatic.booleanValue()) {
                    builder.append("- url: (" + regex + ")\n");
                    builder.append("  static_files: __static__" + this.root + "\\1\n");
                    builder.append("  upload: __static__" + this.rootRegex + regex + "\n");
                    builder.append("  require_matching_file: True\n");
                    this.translateHandlerOptions(builder, glob);
                    this.translateAdditionalStaticOptions(builder, glob);
                }
            }
        }

        private void translateAdditionalStaticOptions(StringBuilder builder, Glob glob) {
            String expiration = (String)glob.getProperty(AppYamlTranslator.EXPIRATION_PROPERTY, RESOLVER);
            if (expiration != null) {
                builder.append("  expiration: " + expiration + "\n");
            }
        }
    }
}

